/*
 * Decompiled with CFR 0.152.
 */
package com.kii.cloud.analytics;

import android.app.AlarmManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.kii.cloud.analytics.EventUploadService;
import com.kii.cloud.analytics.KiiAnalyticsException;
import com.kii.cloud.analytics.KiiEvent;
import com.kii.cloud.analytics.aggregationresult.GroupedResult;
import com.kii.cloud.analytics.aggregationresult.GroupedResultFactory;
import com.kii.cloud.analytics.aggregationresult.ResultQuery;
import com.kii.cloud.analytics.aggregationresult.ResultQueryUtil;
import com.kii.cloud.analytics.callback.KiiResultCallback;
import com.kii.cloud.analytics.impl.ApiResponse;
import com.kii.cloud.analytics.impl.Config;
import com.kii.cloud.analytics.impl.KiiAnalyticsEngine;
import com.kii.cloud.analytics.impl.Log;
import com.kii.cloud.analytics.impl.SDKClientInfo;
import com.kii.cloud.analytics.impl.Utils;
import com.kii.cloud.analytics.impl.async.AnalyticsResultTask;
import com.kii.cloud.analytics.impl.async.KiiTaskExecutor;
import com.kii.cloud.storage.Kii;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class KiiAnalytics {
    private static final String TAG = "KiiAnalytics";
    static String mAppId;
    static String mAppKey;
    static String mServerUrl;
    static Context mContext;
    static Site mSite;

    private KiiAnalytics() {
    }

    static void initialize(Context context, String appId, String appKey, String serverUrl) {
        if (context == null) {
            throw new IllegalArgumentException("Context must not be null.");
        }
        mContext = context.getApplicationContext();
        if (TextUtils.isEmpty((CharSequence)appId) || TextUtils.isEmpty((CharSequence)appKey) || TextUtils.isEmpty((CharSequence)serverUrl)) {
            throw new IllegalArgumentException("appId, appKey, serverUrl must not empty or null!");
        }
        mAppId = appId;
        mAppKey = appKey;
        mServerUrl = serverUrl;
        Intent service = new Intent(mContext, EventUploadService.class);
        service.putExtra("appId", mAppId);
        service.putExtra("appKey", mAppKey);
        service.putExtra("sdkClientInfo", SDKClientInfo.getSDKClientInfo());
        service.putExtra("serverUrl", mServerUrl);
        mContext.startService(service);
        long repeatTime = Config.getEventUploadRepeatTime(mContext);
        if (repeatTime < 0L) {
            repeatTime = 3600000L;
        }
        Log.v(TAG, "KiiAnalyticsInit, repeatTime :" + repeatTime);
        if (repeatTime > 0L) {
            KiiAnalytics.setAlarm(service, repeatTime);
        }
    }

    static synchronized void initialize(Context context, String appId, String appKey, Site site) {
        if (site == null) {
            throw new IllegalArgumentException("site must not null!");
        }
        mSite = site;
        String serverUrl = site.getBaseUri();
        KiiAnalytics.initialize(context, appId, appKey, serverUrl);
    }

    @NonNull
    public static KiiEvent event(@NonNull String type) {
        return new KiiEvent(type);
    }

    @NonNull
    public static GroupedResult getResult(@NonNull String ruleId, @Nullable ResultQuery query) throws KiiAnalyticsException {
        KiiAnalytics.checkInitialize();
        if (TextUtils.isEmpty((CharSequence)ruleId)) {
            throw new IllegalArgumentException("Rule Id must not be null or empty.");
        }
        String url = Utils.path(KiiAnalytics.getBaseUrl(), "apps", KiiAnalytics.getAppId(), "analytics", ruleId, "data");
        if (query != null) {
            url = ResultQueryUtil.addQueryParams(url, query);
        }
        HttpGet request = new HttpGet(url);
        request.setHeader("X-Kii-AppID", KiiAnalytics.getAppId());
        request.setHeader("X-Kii-AppKey", KiiAnalytics.getAppKey());
        request.setHeader("X-Kii-SDK", SDKClientInfo.getSDKClientInfo());
        request.setHeader("Accept", "application/vnd.kii.GroupedAnalyticResult+json");
        ApiResponse resp = KiiAnalyticsEngine.httpRequest2((HttpUriRequest)request);
        try {
            JSONObject respObj = new JSONObject(resp.body);
            JSONArray snapshots = respObj.getJSONArray("snapshots");
            return GroupedResultFactory.createFromSnapshots(snapshots);
        }
        catch (JSONException e) {
            throw new KiiAnalyticsException("Group result parse error", e);
        }
    }

    public static void getResult(@NonNull String ruleId, @Nullable ResultQuery query, @NonNull KiiResultCallback callback) {
        AnalyticsResultTask task = new AnalyticsResultTask(AnalyticsResultTask.ResultType.GROUPED, ruleId, query, callback);
        KiiTaskExecutor.getInstance().execute(task);
    }

    @Deprecated
    static String getSDKVersion() {
        return Kii.getSDKVersion();
    }

    static String getBaseUrl() {
        return mServerUrl;
    }

    static String getAppKey() {
        return mAppKey;
    }

    static String getAppId() {
        return mAppId;
    }

    static Context getContext() {
        return mContext;
    }

    private static void setAlarm(Intent intent, long repeatTime) {
        Log.v(TAG, "Starting alarmmanager with repeatTime :" + repeatTime);
        AlarmManager am = (AlarmManager)mContext.getSystemService("alarm");
        PendingIntent pi = PendingIntent.getService((Context)mContext, (int)0, (Intent)intent, (int)0x10000000);
        am.setInexactRepeating(1, System.currentTimeMillis(), repeatTime, pi);
    }

    static boolean isInitialized() {
        return mContext != null && mAppId != null && mAppKey != null && mServerUrl != null;
    }

    static void checkInitialize() {
        if (!KiiAnalytics.isInitialized()) {
            throw new IllegalStateException("KiiAnalytics SDK is not initialized");
        }
    }

    public static enum Site {
        JP("https://api-jp.kii.com/api"),
        US("https://api.kii.com/api"),
        CN("https://api-cn2.kii.com/api"),
        SG("https://api-sg.kii.com/api"),
        CN3("https://api-cn3.kii.com/api"),
        EU("https://api-eu.kii.com/api");

        private String mBaseUri = null;

        private Site(String baseUri) {
            this.mBaseUri = baseUri;
        }

        private String getBaseUri() {
            return this.mBaseUri;
        }
    }
}

