/*
 * Decompiled with CFR 0.152.
 */
package com.kii.cloud.abtesting;

import android.content.Context;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.kii.cloud.abtesting.ConversionEvent;
import com.kii.cloud.abtesting.KiiExperiment;
import com.kii.cloud.analytics.KiiAnalytics;
import com.kii.cloud.analytics.KiiEvent;
import com.kii.cloud.storage.Kii;
import org.json.JSONException;
import org.json.JSONObject;

public class Variation
implements Parcelable {
    private String name;
    private int percentage;
    private JSONObject variableSet;
    private String parentExperimentID;
    private int parentExperimentVersion;
    private ConversionEvent[] parentExperimentConversionEvents;
    public static final Parcelable.Creator<Variation> CREATOR = new Parcelable.Creator<Variation>(){

        public Variation createFromParcel(Parcel in) {
            return new Variation(in);
        }

        public Variation[] newArray(int size) {
            return new Variation[size];
        }
    };

    Variation(KiiExperiment parentExperiment, String name, int percentage, JSONObject variableSet) {
        this.parentExperimentID = parentExperiment.getID();
        this.parentExperimentVersion = parentExperiment.getVersion();
        this.parentExperimentConversionEvents = parentExperiment.getConversionEvents();
        this.name = name;
        this.percentage = percentage;
        this.variableSet = variableSet;
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    public int getPercentage() {
        return this.percentage;
    }

    @Nullable
    public JSONObject getVariableSet() {
        return this.variableSet;
    }

    @NonNull
    public KiiEvent eventForConversion(@Nullable Context context, @NonNull ConversionEvent conversionEvent) {
        if (conversionEvent == null) {
            throw new IllegalArgumentException("conversionEvent is null");
        }
        if (!Kii.getAnalyticsEnabled()) {
            throw new IllegalStateException("KiiAnalytics is not enabled");
        }
        KiiEvent evt = KiiAnalytics.event(this.parentExperimentID);
        evt.set("variationName", this.name);
        evt.set("conversionEvent", conversionEvent.getName());
        evt.set("version", this.parentExperimentVersion);
        return evt;
    }

    @NonNull
    public KiiEvent eventForConversion(@Nullable Context context, int conversionEventIndex) {
        ConversionEvent conversionEvent = this.parentExperimentConversionEvents[conversionEventIndex];
        if (!Kii.getAnalyticsEnabled()) {
            throw new IllegalStateException("KiiAnalytics is not enabled");
        }
        KiiEvent evt = KiiAnalytics.event(this.parentExperimentID);
        evt.set("variationName", this.name);
        evt.set("conversionEvent", conversionEvent.getName());
        evt.set("version", this.parentExperimentVersion);
        return evt;
    }

    @NonNull
    public KiiEvent eventForConversion(@Nullable Context context, @Nullable String conversionEventName) {
        ConversionEvent conversionEvent = ConversionEvent.getConversionEventByName(conversionEventName, this.parentExperimentConversionEvents);
        if (conversionEvent == null) {
            throw new IllegalArgumentException("Event having specified name does not exist.");
        }
        if (!Kii.getAnalyticsEnabled()) {
            throw new IllegalStateException("KiiAnalytics is not enabled");
        }
        KiiEvent evt = KiiAnalytics.event(this.parentExperimentID);
        evt.set("variationName", this.name);
        evt.set("conversionEvent", conversionEvent.getName());
        evt.set("version", this.parentExperimentVersion);
        return evt;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.name);
        dest.writeInt(this.parentExperimentConversionEvents.length);
        dest.writeTypedArray((Parcelable[])this.parentExperimentConversionEvents, 0);
        dest.writeString(this.parentExperimentID);
        dest.writeInt(this.parentExperimentVersion);
        dest.writeInt(this.percentage);
        dest.writeString(this.variableSet.toString());
    }

    public Variation(Parcel in) {
        this.name = in.readString();
        int size = in.readInt();
        Object[] ces = new ConversionEvent[size];
        in.readTypedArray(ces, ConversionEvent.CREATOR);
        this.parentExperimentConversionEvents = ces;
        this.parentExperimentID = in.readString();
        this.parentExperimentVersion = in.readInt();
        this.percentage = in.readInt();
        try {
            this.variableSet = new JSONObject(in.readString());
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }
}

