/*
 * Decompiled with CFR 0.152.
 */
package com.kii.cloud.abtesting;

import android.support.annotation.NonNull;
import com.kii.cloud.abtesting.ExperimentNotAppliedException;
import com.kii.cloud.abtesting.KiiExperiment;
import com.kii.cloud.abtesting.Variation;
import com.kii.cloud.abtesting.VariationSampler;
import java.util.Random;

public class RandomVariationSampler
implements VariationSampler {
    private final Random randomGenerator = new Random(System.currentTimeMillis());

    @Override
    @NonNull
    public Variation chooseVariation(@NonNull KiiExperiment experiment) throws ExperimentNotAppliedException {
        if (experiment == null) {
            throw new IllegalArgumentException("experiment must not be null.");
        }
        switch (experiment.getStatus()) {
            case RUNNING: {
                return this.chooseVariation(experiment.getVariations());
            }
            case TERMINATED: {
                Variation retval = experiment.getChosenVariation();
                if (retval == null) {
                    throw new ExperimentNotAppliedException("This experiment is terminated and variation is not chosen", ExperimentNotAppliedException.Reason.EXPERIMENT_TERMINATED_WITH_NO_VARIATION);
                }
                return retval;
            }
            case DRAFT: {
                throw new ExperimentNotAppliedException("This experiment is draft", ExperimentNotAppliedException.Reason.EXPERIMENT_DRAFT);
            }
            case PAUSED: {
                throw new ExperimentNotAppliedException("This experiment is paused", ExperimentNotAppliedException.Reason.EXPERIMENT_PAUSED);
            }
        }
        throw new RuntimeException(String.format("Unknown KiiExperimentStatus: %s", experiment.getStatus().name()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Variation chooseVariation(Variation[] variations) {
        if (RandomVariationSampler.isNullOrEmpty(variations)) {
            throw new RuntimeException("variations must not be null and empty.");
        }
        int random = 0;
        int total = RandomVariationSampler.amountOfPercentage(variations);
        RandomVariationSampler randomVariationSampler = this;
        synchronized (randomVariationSampler) {
            random = this.randomGenerator.nextInt(total);
        }
        int accumulated = 0;
        for (Variation variation : variations) {
            if (random >= (accumulated += variation.getPercentage())) continue;
            return variation;
        }
        throw new RuntimeException("random must equal or be lower than accumulation of percentage of variations.");
    }

    private static int amountOfPercentage(Variation[] variations) {
        if (RandomVariationSampler.isNullOrEmpty(variations)) {
            throw new RuntimeException("variations must not be null and empty.");
        }
        int retval = 0;
        for (Variation variation : variations) {
            retval += variation.getPercentage();
        }
        return retval;
    }

    private static boolean isNullOrEmpty(Variation[] variations) {
        if (variations == null) {
            return true;
        }
        return variations.length <= 0;
    }
}

