/*
 * Decompiled with CFR 0.152.
 */
package com.kii.cloud.abtesting;

import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import android.text.TextUtils;
import com.kii.cloud.abtesting.ConversionEvent;
import com.kii.cloud.abtesting.ExperimentNotAppliedException;
import com.kii.cloud.abtesting.KiiExperimentCallback;
import com.kii.cloud.abtesting.KiiExperimentStatus;
import com.kii.cloud.abtesting.Variation;
import com.kii.cloud.abtesting.VariationSampler;
import com.kii.cloud.abtesting.VariationSamplerByKiiUser;
import com.kii.cloud.async.executor.KiiExperimentTask;
import com.kii.cloud.async.executor.KiiTaskExecutor;
import com.kii.cloud.storage.Kii;
import com.kii.cloud.storage.KiiUser;
import com.kii.cloud.storage.engine.ApiResponse;
import com.kii.cloud.storage.engine.KiiCloudEngine;
import com.kii.cloud.storage.exception.IllegalKiiBaseObjectFormatException;
import com.kii.cloud.storage.exception.app.BadRequestException;
import com.kii.cloud.storage.exception.app.ConflictException;
import com.kii.cloud.storage.exception.app.ForbiddenException;
import com.kii.cloud.storage.exception.app.NotFoundException;
import com.kii.cloud.storage.exception.app.UnauthorizedException;
import com.kii.cloud.storage.exception.app.UndefinedException;
import com.kii.cloud.storage.utils.Utils;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.regex.Pattern;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class KiiExperiment
implements Parcelable {
    private static final Pattern EXP_ID_PATTERN = Pattern.compile("^[a-zA-Z0-9-_\\.]{2,100}$");
    private int version;
    private String id;
    private Variation[] variations;
    private ConversionEvent[] conversionEvents;
    private String description;
    private KiiExperimentStatus status;
    private Variation chosenVariation;
    public static final Parcelable.Creator<KiiExperiment> CREATOR = new Parcelable.Creator<KiiExperiment>(){

        public KiiExperiment createFromParcel(Parcel in) {
            return new KiiExperiment(in);
        }

        public KiiExperiment[] newArray(int size) {
            return new KiiExperiment[size];
        }
    };

    private KiiExperiment() {
    }

    @WorkerThread
    @NonNull
    public static KiiExperiment getByID(@NonNull String experimentID) throws BadRequestException, UnauthorizedException, ForbiddenException, ConflictException, NotFoundException, UndefinedException, IOException {
        if (!KiiExperiment.isValidExperimentID(experimentID)) {
            throw new IllegalArgumentException("Experiment id is invalid");
        }
        String getUrl = Utils.path(Kii.getBaseURL(), "apps", Kii.getAppId(), "buckets", "_experiments", "objects", experimentID);
        HttpGet request = new HttpGet(getUrl);
        KiiCloudEngine.setAuthBearer((HttpUriRequest)request);
        request.setHeader("X-Kii-AppID", Kii.getAppId());
        request.setHeader("X-Kii-AppKey", Kii.getAppKey());
        ApiResponse res = KiiCloudEngine.getInstance().httpRequest((HttpUriRequest)request);
        KiiExperiment exp = null;
        try {
            JSONObject json = new JSONObject(res.body);
            exp = new KiiExperiment();
            exp.id = json.getString("_id");
            exp.description = json.optString("description", null);
            exp.version = json.getInt("version");
            exp.status = KiiExperiment.parseStatus(json);
            JSONArray conversionEventsJson = json.getJSONArray("conversionEvents");
            ArrayList<ConversionEvent> conversionEventList = new ArrayList<ConversionEvent>();
            for (int i = 0; i < conversionEventsJson.length(); ++i) {
                JSONObject conversionEventJson = (JSONObject)conversionEventsJson.get(i);
                String conversionEventName = conversionEventJson.getString("name");
                conversionEventList.add(new ConversionEvent(conversionEventName));
            }
            exp.conversionEvents = conversionEventList.toArray(new ConversionEvent[conversionEventList.size()]);
            JSONArray variationsJson = json.getJSONArray("variations");
            ArrayList<Variation> variationList = new ArrayList<Variation>();
            for (int i = 0; i < variationsJson.length(); ++i) {
                JSONObject variationJson = (JSONObject)variationsJson.get(i);
                String varName = variationJson.getString("name");
                int percentage = variationJson.getInt("percentage");
                JSONObject test = variationJson.getJSONObject("variableSet");
                Variation variation = new Variation(exp, varName, percentage, test);
                variationList.add(variation);
            }
            exp.variations = variationList.toArray(new Variation[variationList.size()]);
            String chosenVariationName = json.optString("chosenVariation", null);
            if (!TextUtils.isEmpty((CharSequence)chosenVariationName)) {
                exp.chosenVariation = exp.getVariationByName(chosenVariationName);
            }
        }
        catch (JSONException e) {
            throw new IllegalKiiBaseObjectFormatException(e.getMessage());
        }
        catch (ParseException e) {
            throw new UndefinedException(res.status, res.body);
        }
        return exp;
    }

    public static void getByID(@NonNull String experimentID, @Nullable KiiExperimentCallback callback) {
        if (!KiiExperiment.isValidExperimentID(experimentID)) {
            throw new IllegalArgumentException("Experiment id is invalid");
        }
        KiiExperimentTask task = new KiiExperimentTask(KiiExperimentTask.TaskType.GET_EXPERIMENT, experimentID, callback);
        KiiTaskExecutor.getInstance().execute(task);
    }

    @NonNull
    public Variation[] getVariations() {
        return this.variations;
    }

    @Nullable
    public Variation getVariationByName(@Nullable String name) {
        for (Variation v : this.variations) {
            if (!v.getName().equals(name)) continue;
            return v;
        }
        return null;
    }

    @NonNull
    public ConversionEvent[] getConversionEvents() {
        return this.conversionEvents;
    }

    @NonNull
    public ConversionEvent getConversionEvent(int index) {
        return this.conversionEvents[index];
    }

    @Nullable
    public ConversionEvent getConversionEventByName(@Nullable String name) {
        return ConversionEvent.getConversionEventByName(name, this.conversionEvents);
    }

    public int getVersion() {
        return this.version;
    }

    @NonNull
    public String getID() {
        return this.id;
    }

    @Nullable
    public Variation getAppliedVariation() throws ExperimentNotAppliedException {
        if (KiiUser.getCurrentUser() == null) {
            throw new IllegalStateException("User is not logged-in");
        }
        return this.getAppliedVariation(new VariationSamplerByKiiUser());
    }

    @Nullable
    public Variation getAppliedVariation(@NonNull VariationSampler sampler) throws ExperimentNotAppliedException {
        if (sampler == null) {
            throw new IllegalArgumentException("sampler can not be null");
        }
        return sampler.chooseVariation(this);
    }

    @Nullable
    public Variation getAppliedVariation(@Nullable Variation fallback, @Nullable VariationSampler sampler) {
        if (sampler == null) {
            return fallback;
        }
        try {
            return sampler.chooseVariation(this);
        }
        catch (ExperimentNotAppliedException e) {
            return fallback;
        }
        catch (RuntimeException e) {
            return fallback;
        }
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    @NonNull
    public KiiExperimentStatus getStatus() {
        return this.status;
    }

    @Nullable
    public Variation getChosenVariation() {
        return this.chosenVariation;
    }

    static boolean isValidExperimentID(String experimentID) {
        if (TextUtils.isEmpty((CharSequence)experimentID)) {
            return false;
        }
        return EXP_ID_PATTERN.matcher(experimentID).matches();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeParcelable((Parcelable)this.chosenVariation, 0);
        dest.writeInt(this.conversionEvents.length);
        dest.writeTypedArray((Parcelable[])this.conversionEvents, 0);
        dest.writeString(this.description);
        dest.writeString(this.id);
        dest.writeString(this.status.toString());
        dest.writeInt(this.variations.length);
        dest.writeTypedArray((Parcelable[])this.variations, 0);
        dest.writeInt(this.version);
    }

    KiiExperiment(Parcel in) {
        this.chosenVariation = (Variation)in.readParcelable(this.getClass().getClassLoader());
        int size = in.readInt();
        Object[] ces = new ConversionEvent[size];
        in.readTypedArray(ces, ConversionEvent.CREATOR);
        this.conversionEvents = ces;
        this.description = in.readString();
        this.id = in.readString();
        this.status = KiiExperimentStatus.valueOf(in.readString());
        size = in.readInt();
        Object[] vrs = new Variation[size];
        in.readTypedArray(vrs, Variation.CREATOR);
        this.variations = vrs;
        this.version = in.readInt();
    }

    private static KiiExperimentStatus parseStatus(JSONObject json) throws ParseException {
        int status = 0;
        try {
            status = json.getInt("status");
            return KiiExperimentStatus.getStatus(status);
        }
        catch (JSONException e) {
            throw new ParseException("status does not exist", 0);
        }
        catch (IllegalArgumentException e) {
            throw new ParseException(String.format("unkown status: %d", status), 0);
        }
    }
}

