/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.omid;

import android.os.Handler;
import android.os.Looper;
import android.os.SystemClock;
import com.kidoz.sdk.api.general.utils.SDKLogger;

public class TimerGuard {
    public static final String TAG = TimerGuard.class.getSimpleName();
    private long lockTill = 0L;

    public void lock(long timeMillis) {
        this.lockTill = SystemClock.elapsedRealtime() + timeMillis;
        SDKLogger.printDebugLog(TAG, "TimerGuard: lock till: " + this.lockTill);
    }

    public void postWhenReleased(Runnable runnable) {
        long currentTime = SystemClock.elapsedRealtime();
        long delayMillis = currentTime < this.lockTill ? this.lockTill - currentTime : 0L;
        SDKLogger.printDebugLog(TAG, "TimerGuard: wait for: " + delayMillis);
        Looper looper = Looper.getMainLooper();
        Handler handler = new Handler(looper);
        handler.postDelayed(runnable, delayMillis);
    }
}

