/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.omid;

import com.kidoz.sdk.api.general.utils.SDKLogger;
import com.kidoz.sdk.omid.OMSessionAdapter;

public class OMSessionAdapterSafeStateDecorator
implements OMSessionAdapter {
    public static final String TAG = OMSessionAdapterSafeStateDecorator.class.getSimpleName();
    private OMSessionAdapter adSession;
    private SessionState sessionState = SessionState.notStarted;

    OMSessionAdapterSafeStateDecorator(OMSessionAdapter adSession) {
        this.adSession = adSession;
    }

    @Override
    public void start() {
        if (this.sessionState == SessionState.notStarted) {
            SDKLogger.printDebugLog(TAG, "OMSDK implementation: OMSessionAdapter.start() invoked");
            this.adSession.start();
            SDKLogger.printDebugLog(TAG, "OMSDK implementation: OMSessionAdapter.start() complete");
            this.sessionState = SessionState.started;
        } else {
            SDKLogger.printWarningLog(TAG, "OMSDK implementation: OMSessionAdapter.start() is called, while session state is " + this.sessionState.name() + ", ignoring");
        }
    }

    @Override
    public void finish() {
        if (this.sessionState == SessionState.started) {
            SDKLogger.printDebugLog(TAG, "OMSDK implementation: OMSessionAdapter.finish() invoked");
            this.adSession.finish();
            SDKLogger.printDebugLog(TAG, "OMSDK implementation: OMSessionAdapter.finish() complete");
            this.sessionState = SessionState.finished;
        } else {
            SDKLogger.printDebugLog(TAG, "OMSDK implementation: OMSessionAdapter.finish() is called, while session state is " + this.sessionState.name() + ", ignoring");
        }
    }

    private static enum SessionState {
        notStarted,
        started,
        finished;

    }
}

