/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.omid;

import android.view.View;
import android.webkit.WebView;
import com.iab.omid.library.kidoznet.Omid;
import com.iab.omid.library.kidoznet.adsession.AdSession;
import com.iab.omid.library.kidoznet.adsession.AdSessionConfiguration;
import com.iab.omid.library.kidoznet.adsession.AdSessionContext;
import com.iab.omid.library.kidoznet.adsession.CreativeType;
import com.iab.omid.library.kidoznet.adsession.ImpressionType;
import com.iab.omid.library.kidoznet.adsession.Owner;
import com.iab.omid.library.kidoznet.adsession.Partner;
import com.kidoz.sdk.api.general.utils.SDKLogger;
import com.kidoz.sdk.omid.OMService;
import com.kidoz.sdk.omid.OMSessionAdapter;
import com.kidoz.sdk.omid.OMSessionAdapterImpl;
import com.kidoz.sdk.omid.OMSessionAdapterNoopImpl;
import com.kidoz.sdk.omid.OMSessionAdapterSafeStateDecorator;

public class OMServiceImpl
implements OMService {
    public static final String PARTNER_NAME = "kidoznet";
    public static final String TAG = OMServiceImpl.class.getSimpleName();
    public static final OMService instance = new OMServiceImpl();

    @Override
    public OMSessionAdapter createSession(WebView webView) {
        try {
            Omid.activate(webView.getContext().getApplicationContext());
            if (!Omid.isActive()) {
                SDKLogger.printErrorLog(TAG, "Could not activate Omid SDK, silently ignoring further calls for this omid session");
                return new OMSessionAdapterNoopImpl();
            }
            String customReferenceData = "";
            AdSessionConfiguration adSessionConfiguration = AdSessionConfiguration.createAdSessionConfiguration(CreativeType.DEFINED_BY_JAVASCRIPT, ImpressionType.DEFINED_BY_JAVASCRIPT, Owner.JAVASCRIPT, Owner.JAVASCRIPT, false);
            Partner partner = Partner.createPartner(PARTNER_NAME, "8.9.1");
            AdSessionContext context = AdSessionContext.createHtmlAdSessionContext(partner, webView, null, customReferenceData);
            AdSession adSession = AdSession.createAdSession(adSessionConfiguration, context);
            adSession.registerAdView((View)webView);
            return new OMSessionAdapterSafeStateDecorator(new OMSessionAdapterImpl(adSession));
        }
        catch (Throwable e2) {
            SDKLogger.printErrorLog(TAG, "OMService.createSession failed");
            e2.printStackTrace();
            return new OMSessionAdapterNoopImpl();
        }
    }
}

