/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.api.ui_views.parental_lock;

import android.content.Context;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.widget.FrameLayout;
import android.widget.ImageView;
import com.kidoz.sdk.api.general.utils.SDKLogger;
import com.kidoz.sdk.api.general.utils.Utils;
import com.kidoz.sdk.api.gif.views.GifDecoderView;
import com.kidoz.sdk.api.picasso_related.PicassoOk;
import com.squareup.imagelib.Callback;
import com.squareup.imagelib.RequestCreator;
import com.squareup.imagelib.Transformation;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;

public class AssetView
extends FrameLayout {
    private boolean mIsAssetLoaded;
    private ArrayList<Transformation> mTransformations = new ArrayList();
    private GifDecoderView mAnimatedGifDrawable = null;
    private FrameLayout mGifViewContainer;
    private ImageView mImageView;
    private MyWebView mWebPwebView;

    public AssetView(Context context) {
        super(context);
        this.initView();
    }

    public AssetView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView();
    }

    public AssetView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initView();
    }

    private void initView() {
        this.setDrawingCacheBackgroundColor(0);
        this.setId(Utils.generateViewId());
        this.mImageView = new ImageView(this.getContext());
        this.mImageView.setScaleType(ImageView.ScaleType.FIT_XY);
        this.setLayerType(2, null);
        this.addView((View)this.mImageView, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
    }

    public void loadAsset(File file, IOnAssetLoadedListener loadedListener) {
        this.loadCorrectAsset(file, null, loadedListener);
    }

    public void loadAsset(File file, Drawable defaultImage, IOnAssetLoadedListener loadedListener) {
        this.loadCorrectAsset(file, defaultImage, loadedListener);
    }

    public void loadAsset(final String url, final IOnAssetLoadedListener loadedListener) {
        RequestCreator requestCreator = PicassoOk.getPicasso(this.getContext()).load(url);
        if (this.mImageView != null && this.mImageView.getWidth() != 0 && this.mImageView.getHeight() != 0) {
            requestCreator.resize(this.mImageView.getWidth(), this.mImageView.getHeight());
            requestCreator.onlyScaleDown();
            requestCreator.centerCrop();
        }
        requestCreator.noFade();
        requestCreator.transform(this.mTransformations);
        requestCreator.fetch(new Callback(){

            @Override
            public void onSuccess() {
                RequestCreator requestCreator = PicassoOk.getPicasso(AssetView.this.getContext()).load(url);
                if (AssetView.this.mImageView != null && AssetView.this.mImageView.getWidth() != 0 && AssetView.this.mImageView.getHeight() != 0) {
                    requestCreator.resize(AssetView.this.mImageView.getWidth(), AssetView.this.mImageView.getHeight());
                    requestCreator.onlyScaleDown();
                    requestCreator.centerCrop();
                }
                requestCreator.noFade();
                requestCreator.transform(AssetView.this.mTransformations);
                requestCreator.into(AssetView.this.mImageView);
                AssetView.this.mIsAssetLoaded = true;
                if (loadedListener != null) {
                    loadedListener.onAssetLoaded(AssetView.this.mIsAssetLoaded);
                }
            }

            @Override
            public void onError() {
                AssetView.this.mIsAssetLoaded = false;
                if (loadedListener != null) {
                    loadedListener.onAssetLoaded(AssetView.this.mIsAssetLoaded);
                }
            }
        });
    }

    public void prefetchAsset(String url, final IOnAssetLoadedListener loadedListener) {
        RequestCreator requestCreator = PicassoOk.getPicasso(this.getContext()).load(url);
        if (this.mImageView.getWidth() != 0 && this.mImageView.getHeight() != 0) {
            requestCreator.resize(this.mImageView.getWidth(), this.mImageView.getHeight());
            requestCreator.onlyScaleDown();
            requestCreator.centerCrop();
        }
        requestCreator.noFade();
        requestCreator.transform(this.mTransformations);
        requestCreator.fetch(new Callback(){

            @Override
            public void onSuccess() {
                if (loadedListener != null) {
                    loadedListener.onAssetLoaded(true);
                }
            }

            @Override
            public void onError() {
                if (loadedListener != null) {
                    loadedListener.onAssetLoaded(false);
                }
            }
        });
    }

    public void loadCorrectAsset(File file, Drawable defaultImage, IOnAssetLoadedListener loadedListener) {
        this.mIsAssetLoaded = false;
        if (defaultImage != null) {
            this.setAssetBackgroundDrawable(defaultImage);
        }
        if (file != null) {
            if (file.exists()) {
                String path = file.getPath();
                if (path.contains(".png") || path.contains(".PNG") || path.contains(".jpg") || path.contains(".JPG")) {
                    this.handlePngResource(file, loadedListener);
                } else if (path.contains(".gif") || path.contains(".GIF")) {
                    this.handleGifResource(file, defaultImage, loadedListener, path);
                } else if (path.contains(".webp") || path.contains(".WEBP") || path.contains(".webP")) {
                    this.handleWebpResource(defaultImage, loadedListener, path);
                } else {
                    this.handleOtherResource(defaultImage, loadedListener);
                }
            } else {
                this.mIsAssetLoaded = false;
                this.setAssetBackgroundDrawable(defaultImage);
                if (loadedListener != null) {
                    loadedListener.onAssetLoaded(this.mIsAssetLoaded);
                }
            }
        } else {
            this.mIsAssetLoaded = false;
            if (loadedListener != null) {
                loadedListener.onAssetLoaded(this.mIsAssetLoaded);
            }
        }
    }

    private void handleOtherResource(Drawable defaultImage, IOnAssetLoadedListener loadedListener) {
        this.mIsAssetLoaded = false;
        this.setAssetBackgroundDrawable(defaultImage);
        if (loadedListener != null) {
            loadedListener.onAssetLoaded(this.mIsAssetLoaded);
        }
    }

    private void handlePngResource(File file, final IOnAssetLoadedListener loadedListener) {
        RequestCreator requestCreator = PicassoOk.getPicasso(this.getContext()).load(file);
        if (this.mImageView.getWidth() != 0 && this.mImageView.getHeight() != 0) {
            requestCreator.resize(this.mImageView.getWidth(), this.mImageView.getHeight());
            requestCreator.onlyScaleDown();
            requestCreator.centerCrop();
        }
        requestCreator.transform(this.mTransformations);
        requestCreator.into(this.mImageView, new Callback(){

            @Override
            public void onSuccess() {
                AssetView.this.setAssetBackgroundDrawable(null);
                AssetView.this.mIsAssetLoaded = true;
                if (loadedListener != null) {
                    loadedListener.onAssetLoaded(AssetView.this.mIsAssetLoaded);
                }
            }

            @Override
            public void onError() {
                AssetView.this.mIsAssetLoaded = false;
                if (loadedListener != null) {
                    loadedListener.onAssetLoaded(AssetView.this.mIsAssetLoaded);
                }
            }
        });
    }

    private void handleWebpResource(Drawable defaultImage, IOnAssetLoadedListener loadedListener, String path) {
        if (Build.VERSION.SDK_INT >= 17) {
            if (Utils.isWebViewSupportWebP()) {
                this.mWebPwebView = this.generateWebPAnimatableWebView();
                this.addView((View)this.mWebPwebView, 0, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
                this.loadImageToWebPwebView("file://" + path);
                this.mIsAssetLoaded = true;
            }
            if (!this.mIsAssetLoaded) {
                this.setAssetBackgroundDrawable(defaultImage);
            }
            if (loadedListener != null) {
                loadedListener.onAssetLoaded(this.mIsAssetLoaded);
            }
        }
    }

    private void handleGifResource(File file, Drawable defaultImage, IOnAssetLoadedListener loadedListener, String path) {
        HandleGifResource handleGifResource = new HandleGifResource(file, defaultImage, loadedListener, path);
    }

    private void addGifContainer() {
        this.mGifViewContainer = new FrameLayout(this.getContext());
        this.addView((View)this.mGifViewContainer, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
    }

    private void setAssetBackgroundDrawable(Drawable defaultImage) {
        if (Build.VERSION.SDK_INT >= 16) {
            this.mImageView.setBackground(defaultImage);
        } else {
            this.mImageView.setBackgroundDrawable(defaultImage);
        }
    }

    public boolean getIsAssetLoaded() {
        return this.mIsAssetLoaded;
    }

    private MyWebView generateWebPAnimatableWebView() {
        MyWebView kidozWebView = new MyWebView(this.getContext());
        kidozWebView.setBackgroundColor(0);
        kidozWebView.setClipToPadding(false);
        kidozWebView.setDrawingCacheBackgroundColor(0);
        kidozWebView.getSettings().setLayoutAlgorithm(WebSettings.LayoutAlgorithm.SINGLE_COLUMN);
        kidozWebView.setScrollBarStyle(0);
        kidozWebView.setScrollbarFadingEnabled(true);
        kidozWebView.getSettings().setAppCacheEnabled(false);
        kidozWebView.getSettings().setCacheMode(2);
        kidozWebView.getSettings().setDisplayZoomControls(false);
        kidozWebView.getSettings().setAllowContentAccess(true);
        kidozWebView.getSettings().setAllowFileAccess(true);
        kidozWebView.getSettings().setSupportZoom(false);
        kidozWebView.getSettings().setSupportMultipleWindows(false);
        kidozWebView.setVerticalScrollBarEnabled(false);
        kidozWebView.setHorizontalScrollBarEnabled(false);
        kidozWebView.setScrollContainer(false);
        kidozWebView.setPadding(0, 0, 0, 0);
        kidozWebView.setLayerType(2, null);
        if (Build.VERSION.SDK_INT >= 21) {
            kidozWebView.getSettings().setMixedContentMode(0);
        }
        return kidozWebView;
    }

    private void loadImageToWebPwebView(String path) {
        if (this.mWebPwebView != null) {
            String s = "<html><head><style type='text/css'> img {max-width: 100%;height:initial;} margin: 0; padding: 0 </style></head><body style='margin:0;padding:0;' ><img src=\"" + path + "\"/></body>" + "</html>";
            this.mWebPwebView.loadDataWithBaseURL("", s, "text/html", "utf-8", null);
        }
    }

    protected void onFocusChanged(boolean gainFocus, int direction, Rect previouslyFocusedRect) {
        super.onFocusChanged(gainFocus, direction, previouslyFocusedRect);
        if (gainFocus && this.mAnimatedGifDrawable != null && this.mAnimatedGifDrawable.isVisible() && !this.mAnimatedGifDrawable.isPlaying()) {
            this.mAnimatedGifDrawable.start();
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.cleanGifFromMemory();
        this.cleanWebpFromMemory();
    }

    private void cleanGifFromMemory() {
        if (this.mAnimatedGifDrawable != null) {
            this.mAnimatedGifDrawable.stop();
            this.mAnimatedGifDrawable.clean();
            this.mAnimatedGifDrawable = null;
        }
        if (this.mGifViewContainer != null) {
            ViewGroup viewParent = (ViewGroup)this.mGifViewContainer.getParent();
            viewParent.removeView((View)this.mGifViewContainer);
            this.mGifViewContainer = null;
        }
    }

    private void cleanWebpFromMemory() {
        if (this.mWebPwebView != null) {
            this.mWebPwebView.clearHistory();
            this.mWebPwebView.clearCache(true);
            this.mWebPwebView.loadUrl("about:blank");
            this.mWebPwebView.pauseTimers();
            this.mWebPwebView = null;
        }
    }

    protected void onVisibilityChanged(View changedView, int visibility) {
        super.onVisibilityChanged(changedView, visibility);
        if (this.mAnimatedGifDrawable != null) {
            if (visibility == 0) {
                if (!this.mAnimatedGifDrawable.isPlaying()) {
                    this.mAnimatedGifDrawable.start();
                }
            } else {
                this.mAnimatedGifDrawable.stop();
            }
        }
    }

    public void addTransformation(Transformation transformation) {
        if (this.mTransformations != null) {
            this.mTransformations.add(transformation);
        }
    }

    private void clearTrasnformations() {
        this.mTransformations.clear();
    }

    public void startGifAnim() {
        if (this.mAnimatedGifDrawable != null && !this.mAnimatedGifDrawable.isPlaying()) {
            this.mAnimatedGifDrawable.start();
        }
    }

    public void stopGifAnim() {
        if (this.mAnimatedGifDrawable != null) {
            this.mAnimatedGifDrawable.stop();
        }
    }

    public void pauseGifAnim() {
        if (this.mAnimatedGifDrawable != null) {
            this.mAnimatedGifDrawable.pause();
        }
    }

    public void resumeGifAnim() {
        if (this.mAnimatedGifDrawable != null) {
            this.mAnimatedGifDrawable.resume();
        }
    }

    public void setScaleType(ImageView.ScaleType scaleType) {
        this.mImageView.setScaleType(scaleType);
    }

    class MyWebView
    extends WebView {
        public MyWebView(Context context) {
            super(context);
            if (Build.VERSION.SDK_INT >= 21) {
                this.getSettings().setMixedContentMode(0);
            }
        }

        public boolean onInterceptTouchEvent(MotionEvent ev) {
            return false;
        }

        public boolean onTouchEvent(MotionEvent event) {
            return false;
        }
    }

    public static interface IOnAssetLoadedListener {
        public void onAssetLoaded(boolean var1);
    }

    class HandleGifResource
    implements GifDecoderView.IGifDecoderViewCallback {
        File mFile;
        Drawable mDefaultImage;
        IOnAssetLoadedListener mLoadedListener;
        String mPath;

        public HandleGifResource(File file, Drawable defaultImage, IOnAssetLoadedListener loadedListener, String path) {
            this.mFile = file;
            this.mDefaultImage = defaultImage;
            this.mLoadedListener = loadedListener;
            this.mPath = path;
            this.run();
        }

        public void run() {
            block4: {
                try {
                    AssetView.this.cleanGifFromMemory();
                    AssetView.this.addGifContainer();
                    FileInputStream fis = new FileInputStream(this.mFile);
                    AssetView.this.mAnimatedGifDrawable = new GifDecoderView(AssetView.this.getContext(), fis, this);
                }
                catch (IOException e2) {
                    if (e2 != null) {
                        SDKLogger.printErrorLog(e2.getMessage() + "   path: " + this.mPath);
                    }
                    AssetView.this.mIsAssetLoaded = false;
                    if (this.mDefaultImage != null) {
                        AssetView.this.setAssetBackgroundDrawable(this.mDefaultImage);
                    }
                    if (this.mLoadedListener == null) break block4;
                    this.mLoadedListener.onAssetLoaded(AssetView.this.mIsAssetLoaded);
                }
            }
        }

        @Override
        public void gifDecoderViewReady() {
            if (AssetView.this.mAnimatedGifDrawable != null) {
                AssetView.this.mGifViewContainer.addView((View)AssetView.this.mAnimatedGifDrawable);
                AssetView.this.setAssetBackgroundDrawable(null);
                AssetView.this.mAnimatedGifDrawable.start();
            }
            AssetView.this.mIsAssetLoaded = true;
            if (this.mLoadedListener != null) {
                this.mLoadedListener.onAssetLoaded(AssetView.this.mIsAssetLoaded);
            }
        }
    }
}

