/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.api.ui_views.panel_view;

import android.animation.Animator;
import android.app.Activity;
import android.content.Context;
import android.content.SharedPreferences;
import android.graphics.Color;
import android.graphics.Point;
import android.os.Looper;
import android.text.TextUtils;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.kidoz.events.Event;
import com.kidoz.events.EventManager;
import com.kidoz.sdk.api.KidozInterstitial;
import com.kidoz.sdk.api.KidozSDK;
import com.kidoz.sdk.api.dialogs.AboutKidozDialog;
import com.kidoz.sdk.api.dialogs.ParentalLockDialog;
import com.kidoz.sdk.api.general.ContentLogicLoader;
import com.kidoz.sdk.api.general.animations.GenAnimator;
import com.kidoz.sdk.api.general.assets_handling.AssetUtil;
import com.kidoz.sdk.api.general.enums.WidgetType;
import com.kidoz.sdk.api.general.utils.SDKLogger;
import com.kidoz.sdk.api.general.utils.ScreenUtils;
import com.kidoz.sdk.api.general.utils.SdkCookieManager;
import com.kidoz.sdk.api.general.utils.StorageLife;
import com.kidoz.sdk.api.general.utils.Utils;
import com.kidoz.sdk.api.interfaces.IOnPanelViewEventListener;
import com.kidoz.sdk.api.structure.ContentData;
import com.kidoz.sdk.api.structure.ContentItem;
import com.kidoz.sdk.api.ui_views.custom_drawables.ShadowView;
import com.kidoz.sdk.api.ui_views.interstitial.LocalIntrst;
import com.kidoz.sdk.api.ui_views.one_item_view.OneItemFamilyView;
import com.kidoz.sdk.api.ui_views.panel_view.HANDLE_POSITION;
import com.kidoz.sdk.api.ui_views.panel_view.LocalAssetHelper;
import com.kidoz.sdk.api.ui_views.panel_view.PANEL_TYPE;
import com.kidoz.sdk.api.ui_views.panel_view.PanelHandle;
import com.kidoz.sdk.api.ui_views.parental_lock.AssetView;
import java.util.ArrayList;
import org.json.JSONObject;

public abstract class AbstractPanelView
extends RelativeLayout {
    private static final String TAG = AbstractPanelView.class.getSimpleName();
    private static final String PANEL_SHARED_PREFERENCES = "panel_shared_pref";
    private static final String FIRST_TIME_LAST_LAUNCH_KEY = "fistTimeLastLounch";
    private static final int TIME_MULT_FACTOR = 3600000;
    protected PANEL_TYPE mPanelType = PANEL_TYPE.BOTTOM;
    protected HANDLE_POSITION mHandlePosition = HANDLE_POSITION.START;
    protected RelativeLayout mContainer;
    protected RelativeLayout mInnerContainer;
    protected ContentLogicLoader mContentLogicLoader;
    protected ArrayList<ContentItem> mContentItems = new ArrayList();
    public AssetView mParentalLockButton;
    public AssetView mAboutKidozButton;
    public PanelHandle mPanelHandle;
    protected TextView mPoweredByTextView;
    protected RelativeLayout mBottomBarContainer;
    public OneItemFamilyView mOneItemFamilyView;
    protected IOnPanelViewEventListener mIOnPanelViewEventListener;
    protected PanelViewState mPanelState = PanelViewState.CLOSED;
    protected boolean mIsAnimationRunning;
    protected boolean mIsClicksBlocked;
    protected boolean mAllowClickHandling = true;
    protected boolean mIsPanelPrepared = false;
    private long mLastInterceptTS = 0L;
    protected ShadowView mShadowView;
    protected JSONObject mWidgetProperties;
    protected String mLegacyBtnCloseUrl = null;
    protected String mLegacyBtnOpenUrl = null;
    protected String mLegacyBtnOpenSponsoredUrl = null;
    protected String mBtnCloseBgUrl = null;
    protected String mBtnCloseFrgUrl = null;
    protected String mBtnOpenBgUrl = null;
    protected String mBtnOpenFrgUrl = null;
    protected float mBtnScaleSize = 0.15f;
    protected int mPanelBgColor = -1;
    protected String mLabelText = "";
    protected int mLabelColor = -16777216;
    protected float mFirstLaunchOpenPeriod = -1.0f;
    protected float mFirstLaunchOpenRepeatTimeFarme = -1.0f;
    protected float mFirstLaunchStartDelay = -1.0f;
    protected Utils.StaticHandler mStaticHandler;
    protected SharedPreferences mSharedPreferences;
    protected LocalIntrst mInterstitial;
    protected String mStyleId = null;

    public AbstractPanelView(Context context, JSONObject jsonObject) {
        super(context);
        this.mWidgetProperties = jsonObject;
        this.prepareProperties();
        this.initView();
    }

    protected void prepareProperties() {
        this.mStyleId = this.mWidgetProperties.optString("style_id", null);
        this.mLegacyBtnCloseUrl = this.mWidgetProperties.optString("btnClosedUrl", null);
        this.mLegacyBtnOpenUrl = this.mWidgetProperties.optString("btnOpenedUrl", null);
        this.mLegacyBtnOpenSponsoredUrl = this.mWidgetProperties.optString("btnOpenDefaultSponsoredUrl", null);
        this.mBtnScaleSize = (float)this.mWidgetProperties.optDouble("btnScaleSize", (double)0.15f);
        this.mLabelText = this.mWidgetProperties.optString("labelText", "");
        this.mFirstLaunchOpenPeriod = (float)this.mWidgetProperties.optDouble("flOpenPeriodSec", -1.0);
        this.mFirstLaunchStartDelay = (float)this.mWidgetProperties.optDouble("flOpenStartDelaySec", -1.0);
        this.mFirstLaunchOpenRepeatTimeFarme = (float)this.mWidgetProperties.optDouble("flOpenEveryXhoursTF", -1.0);
        this.mBtnCloseBgUrl = this.mWidgetProperties.optString("panelCloseButtonBgImageURL", null);
        this.mBtnCloseFrgUrl = this.mWidgetProperties.optString("panelCloseButtonFrgImageURL", null);
        this.mBtnOpenBgUrl = this.mWidgetProperties.optString("panelOpenButtonBgImageURL", null);
        this.mBtnOpenFrgUrl = this.mWidgetProperties.optString("panelOpenButtonFrgImageURL", null);
        try {
            this.mPanelBgColor = Color.parseColor((String)this.mWidgetProperties.optString("panelBgClr", "#FFFFFF"));
        }
        catch (Exception e2) {
            this.mPanelBgColor = -1;
        }
        try {
            this.mLabelColor = Color.parseColor((String)this.mWidgetProperties.optString("labelColor", "#000000"));
        }
        catch (Exception e3) {
            this.mLabelColor = -16777216;
        }
        this.mSharedPreferences = this.getContext().getSharedPreferences(PANEL_SHARED_PREFERENCES, 0);
        if (this.mWidgetProperties.optInt("lounchInterstitialOnOpen", 0) == 1) {
            Context context = this.getContext();
            if (context == null || !(context instanceof Activity)) {
                SDKLogger.printErrorLog("Context is null or not an Activity");
                return;
            }
            if (this.mInterstitial == null) {
                this.mInterstitial = new LocalIntrst((Activity)context, KidozInterstitial.AD_TYPE.INTERSTITIAL);
            }
        }
    }

    protected void initView() {
        this.initPanelContainer();
        this.initPanelHandleBtn();
        this.initInnerPanelView();
        this.initBottomBar();
        this.initPanelViewsRules();
        this.initContentLogicLoader();
        this.preparePanel();
    }

    protected abstract void initInnerPanelView();

    protected abstract void initPanelViewsRules();

    protected abstract void initShadowView();

    protected abstract void setContentAndRefresh(ArrayList<ContentItem> var1);

    protected abstract void onContentDataLoadStarted();

    protected abstract void onContentDataLoadEnded();

    protected abstract void onContentDataLoadFailed();

    protected abstract void onNoOffers();

    protected abstract void clearPanelContent();

    protected abstract void onCollapsePanelAnimationEnded();

    protected abstract void onExpandPanelAnimationStarted();

    public abstract void setPanelEnabled(boolean var1);

    private void initPanelContainer() {
        this.mContainer = new RelativeLayout(this.getContext());
        this.mContainer.setBackgroundColor(0);
        this.mContainer.setId(Utils.generateViewId());
        this.setLayoutParams((ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-2, -2));
        this.initShadowView();
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-2, -2);
        this.addView((View)this.mContainer, (ViewGroup.LayoutParams)params);
        this.mInnerContainer = new RelativeLayout(this.getContext());
        this.mInnerContainer.setId(Utils.generateViewId());
        this.mInnerContainer.setBackgroundColor(-1);
        params = new RelativeLayout.LayoutParams(-2, -2);
        this.mContainer.addView((View)this.mInnerContainer, (ViewGroup.LayoutParams)params);
        this.mInnerContainer.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
            }
        });
        this.mInnerContainer.setSoundEffectsEnabled(false);
    }

    private void initPanelHandleBtn() {
        Point point = Utils.getScreenSize(this.getContext());
        int size = (int)((float)Math.min(point.x, point.y) * this.mBtnScaleSize);
        this.mPanelHandle = new PanelHandle(this.getContext(), this.mPanelType, size, new PanelHandle.IOnPanelHandleClickListener(){

            @Override
            public void onHandleClick() {
                AbstractPanelView.this.toggleAnimation();
                if (AbstractPanelView.this.mPanelState == PanelViewState.CLOSED && AbstractPanelView.this.mWidgetProperties != null && AbstractPanelView.this.mWidgetProperties.optInt("lounchInterstitialOnOpen", 0) == 1 && AbstractPanelView.this.mInterstitial != null) {
                    AbstractPanelView.this.mInterstitial.loadAd();
                }
            }
        });
        if (this.mBtnScaleSize == 0.0f) {
            this.mPanelHandle.setVisibility(8);
        }
        this.mPanelHandle.setId(Utils.generateViewId());
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-2, -2);
        this.mContainer.addView((View)this.mPanelHandle, (ViewGroup.LayoutParams)params);
    }

    protected void initBottomBar() {
        this.mBottomBarContainer = new RelativeLayout(this.getContext());
        this.mBottomBarContainer.setId(Utils.generateViewId());
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-1, -2);
        int margin = Utils.dpTOpx(this.getContext(), 3.0f);
        params.setMargins(margin, 0, margin, margin);
        this.mInnerContainer.addView((View)this.mBottomBarContainer, (ViewGroup.LayoutParams)params);
        this.initParentalLockButton();
        this.initAboutKidozButton();
        int size = (int)(70.0f * ScreenUtils.getScaleFactor(this.getContext()));
        RelativeLayout.LayoutParams parentalLockParams = (RelativeLayout.LayoutParams)this.mParentalLockButton.getLayoutParams();
        parentalLockParams.width = size;
        parentalLockParams.height = size;
        RelativeLayout.LayoutParams aboutKidozParams = (RelativeLayout.LayoutParams)this.mAboutKidozButton.getLayoutParams();
        aboutKidozParams.width = size;
        aboutKidozParams.height = size;
        this.mPoweredByTextView = new TextView(this.getContext());
        this.mPoweredByTextView.setText((CharSequence)this.mLabelText);
        this.mPoweredByTextView.setTextColor(this.mLabelColor);
        this.mPoweredByTextView.setTextSize(2, 12.0f);
        this.mPoweredByTextView.setLines(1);
        this.mPoweredByTextView.setEllipsize(TextUtils.TruncateAt.END);
        this.mPoweredByTextView.setGravity(83);
        this.mPoweredByTextView.setShadowLayer(3.0f, 2.0f, 2.0f, Color.parseColor((String)"#44000000"));
        params = new RelativeLayout.LayoutParams(-2, -2);
        params.addRule(8, this.mAboutKidozButton.getId());
        params.addRule(0, this.mParentalLockButton.getId());
        params.addRule(1, this.mAboutKidozButton.getId());
        params.setMargins(Utils.dpTOpx(this.getContext(), 3.0f), 0, Utils.dpTOpx(this.getContext(), 4.0f), 0);
        this.mBottomBarContainer.addView((View)this.mPoweredByTextView, (ViewGroup.LayoutParams)params);
    }

    private void initParentalLockButton() {
        this.mParentalLockButton = new AssetView(this.getContext());
        this.mParentalLockButton.setId(Utils.generateViewId());
        this.mParentalLockButton.setScaleType(ImageView.ScaleType.FIT_CENTER);
        this.mParentalLockButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (!AbstractPanelView.this.mIsClicksBlocked) {
                    GenAnimator.clickItemAnimation(v, 80, new GenAnimator.ViewAnimationListener(){

                        @Override
                        public void onAnimationEnd() {
                            AbstractPanelView.this.mIsClicksBlocked = true;
                            ParentalLockDialog.startParentalDialog(AbstractPanelView.this.getContext(), false, 0.5f, 0.5f, new ParentalLockDialog.IOnParentalDialogListener(){

                                @Override
                                public void onCloseDialog() {
                                    boolean isLockActive = ParentalLockDialog.isParentalLockActive(AbstractPanelView.this.getContext());
                                    AbstractPanelView.this.setParentalLocIConkState(isLockActive);
                                    AbstractPanelView.this.mIsClicksBlocked = false;
                                }

                                @Override
                                public void onInputPass(boolean isCorrectPass) {
                                    boolean isLockActive = ParentalLockDialog.isParentalLockActive(AbstractPanelView.this.getContext());
                                    AbstractPanelView.this.setParentalLocIConkState(isLockActive);
                                }
                            });
                        }

                        @Override
                        public void onAnimationStart() {
                        }
                    });
                }
            }
        });
        this.mParentalLockButton.setId(Utils.generateViewId());
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-2, -2);
        params.addRule(11);
        params.addRule(15);
        this.mBottomBarContainer.addView((View)this.mParentalLockButton, (ViewGroup.LayoutParams)params);
        boolean isLockActive = ParentalLockDialog.isParentalLockActive(this.getContext());
        this.setParentalLocIConkState(isLockActive);
    }

    private void initAboutKidozButton() {
        this.mAboutKidozButton = new AssetView(this.getContext());
        this.mAboutKidozButton.setId(Utils.generateViewId());
        this.mAboutKidozButton.setScaleType(ImageView.ScaleType.FIT_CENTER);
        this.mAboutKidozButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                GenAnimator.clickItemAnimation(v, 80, new GenAnimator.ViewAnimationListener(){

                    @Override
                    public void onAnimationEnd() {
                        int[] popLocation = new int[]{(int)((float)ScreenUtils.getScreenSize(AbstractPanelView.this.getContext(), true) * 0.5f), (int)((float)ScreenUtils.getScreenSize(AbstractPanelView.this.getContext(), false) * 0.5f)};
                        AboutKidozDialog aboutKidozDialog = new AboutKidozDialog(AbstractPanelView.this.getContext(), popLocation);
                        aboutKidozDialog.openDialog();
                    }

                    @Override
                    public void onAnimationStart() {
                    }
                });
            }
        });
        this.mAboutKidozButton.setId(Utils.generateViewId());
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-2, -2);
        params.addRule(15);
        params.setMargins(Utils.dpTOpx(this.getContext(), 1.0f), 0, 0, 0);
        this.mBottomBarContainer.addView((View)this.mAboutKidozButton, (ViewGroup.LayoutParams)params);
        this.mAboutKidozButton.loadAsset(AssetUtil.getAssetFile(this.getContext(), this.mWidgetProperties.optString("kidozIcon")), null);
    }

    protected void initContentLogicLoader() {
        this.mContentLogicLoader = new ContentLogicLoader(new ContentLogicLoader.IOnContentDataReadyCallback(){

            @Override
            public void onDataReady(ContentData contentData) {
                AbstractPanelView.this.onContentDataLoadEnded();
                if (contentData != null && contentData.isHasContentToShow()) {
                    SdkCookieManager.resetStorage(AbstractPanelView.this.getContext(), WidgetType.WIDGET_TYPE_PANEL.getStringValue(), StorageLife.WIDGET);
                    AbstractPanelView.this.mContentItems.clear();
                    AbstractPanelView.this.clearPanelContent();
                    AbstractPanelView.this.mContentItems.addAll(contentData.getContentDataItems());
                    AbstractPanelView.this.setContentAndRefresh(AbstractPanelView.this.mContentItems);
                    if (!AbstractPanelView.this.mIsPanelPrepared) {
                        AbstractPanelView.this.prepareHandle(null);
                    }
                }
            }

            @Override
            public void onLoadContentFailed() {
                AbstractPanelView.this.onContentDataLoadFailed();
            }

            @Override
            public void onNoContentOffers() {
                AbstractPanelView.this.onNoOffers();
            }
        });
    }

    private void setParentalLocIConkState(boolean isLockActive) {
        if (isLockActive) {
            this.mParentalLockButton.loadAsset(AssetUtil.getAssetFile(this.getContext(), this.mWidgetProperties.optString("btnLockUrl")), null);
        } else {
            this.mParentalLockButton.loadAsset(AssetUtil.getAssetFile(this.getContext(), this.mWidgetProperties.optString("btnUnlockUrl")), null);
        }
    }

    public void setPanelColor(int color) {
        if (color != 0) {
            this.mPanelBgColor = color;
        }
        if (this.mInnerContainer != null) {
            this.mInnerContainer.setBackgroundColor(this.mPanelBgColor);
        }
        if (this.mPanelHandle != null) {
            this.mPanelHandle.setBaseColor(this.mPanelBgColor);
        }
    }

    private void toggleAnimation() {
        if (this.mPanelState == PanelViewState.OPEN) {
            this.collapsePanelView();
        } else {
            this.expandPanelViewInternal(true);
        }
    }

    public void collapsePanelView() {
        if (KidozSDK.isInitialised() && !this.mIsAnimationRunning && this.mPanelState == PanelViewState.OPEN && this.mContainer != null) {
            GenAnimator.closePanelView((View)this.mContainer, 200L, (View)this.mInnerContainer, this.mPanelType, new Animator.AnimatorListener(){

                public void onAnimationStart(Animator animation) {
                    GenAnimator.animateHandleClose((View)AbstractPanelView.this.mPanelHandle, null);
                    AbstractPanelView.this.onContentDataLoadStarted();
                    AbstractPanelView.this.mContentLogicLoader.loadContent(AbstractPanelView.this.getContext(), WidgetType.WIDGET_TYPE_PANEL.getStringValue(), AbstractPanelView.this.mStyleId);
                }

                public void onAnimationEnd(Animator animation) {
                    AbstractPanelView.this.mPanelHandle.setPanelButtonState(PanelHandle.PANEL_HANDLE_VIEW_STATE.CLOSED);
                    AbstractPanelView.this.mIsAnimationRunning = false;
                    AbstractPanelView.this.onCollapsePanelAnimationEnded();
                    AbstractPanelView.this.mPanelState = PanelViewState.CLOSED;
                    if (AbstractPanelView.this.mIOnPanelViewEventListener != null) {
                        AbstractPanelView.this.mIOnPanelViewEventListener.onPanelViewCollapsed();
                    }
                }

                public void onAnimationCancel(Animator animation) {
                }

                public void onAnimationRepeat(Animator animation) {
                }
            });
        }
    }

    public void expandPanelView() {
        if (KidozSDK.isInitialised()) {
            this.expandPanelViewInternal(true);
        }
    }

    private void expandPanelViewInternal(boolean byUserAction) {
        if (!this.mIsAnimationRunning && this.mPanelState == PanelViewState.CLOSED && this.getVisibility() == 0) {
            Event event = new Event();
            if (byUserAction) {
                event.addParameterToJsonObject("Open Type", "1");
            } else {
                event.addParameterToJsonObject("Open Type", "0");
            }
            event.addParameterToJsonObject("Panel Type", this.mPanelType.ordinal());
            EventManager.getInstance(this.getContext()).logEvent(this.getContext(), WidgetType.WIDGET_TYPE_PANEL.getStringValue(), this.mStyleId, EventManager.LOG_CRITICAL_LEVEL, event, "Sponsored Content", "Widget View", "Panel View");
            boolean isLockActive = ParentalLockDialog.isParentalLockActive(this.getContext());
            this.setParentalLocIConkState(isLockActive);
            if (this.mContainer != null) {
                GenAnimator.openPanelView((View)this.mContainer, (View)this.mInnerContainer, this.mPanelType, new Animator.AnimatorListener(){

                    public void onAnimationStart(Animator animation) {
                        AbstractPanelView.this.mPanelHandle.setPanelButtonState(PanelHandle.PANEL_HANDLE_VIEW_STATE.OPENED);
                        GenAnimator.animateHandleOpen((View)AbstractPanelView.this.mPanelHandle, null);
                        AbstractPanelView.this.onExpandPanelAnimationStarted();
                    }

                    public void onAnimationEnd(Animator animation) {
                        AbstractPanelView.this.mIsAnimationRunning = false;
                        AbstractPanelView.this.mPanelState = PanelViewState.OPEN;
                        if (AbstractPanelView.this.mIOnPanelViewEventListener != null) {
                            AbstractPanelView.this.mIOnPanelViewEventListener.onPanelViewExpanded();
                        }
                    }

                    public void onAnimationCancel(Animator animation) {
                    }

                    public void onAnimationRepeat(Animator animation) {
                    }
                });
            }
        }
    }

    public void setPanelConfiguration(PANEL_TYPE panelType, HANDLE_POSITION handlePosition) {
        if (KidozSDK.isInitialised()) {
            this.mPanelType = panelType;
            this.mHandlePosition = handlePosition;
            this.mPanelHandle.setPanelType(this.mPanelType);
            this.resetPanelState();
            if (this.mHandlePosition == HANDLE_POSITION.NONE) {
                this.mPanelHandle.setVisibility(4);
            } else if (this.mBtnScaleSize != 0.0f) {
                this.mPanelHandle.setVisibility(0);
            }
        }
    }

    private void resetPanelState() {
        this.initPanelViewsRules();
        if (this.mIsPanelPrepared && this.mPanelState == PanelViewState.CLOSED) {
            GenAnimator.closePanelView((View)this.mContainer, 0L, (View)this.mInnerContainer, this.mPanelType, null);
            this.requestFocus();
            this.bringToFront();
        }
    }

    public void setOnPanelViewEventListener(IOnPanelViewEventListener iOnPanelViewEventListener) {
        this.mIOnPanelViewEventListener = iOnPanelViewEventListener;
    }

    public PanelViewState getPanelViewState() {
        return this.mPanelState;
    }

    protected void onDetachedFromWindow() {
        this.getStaticHandler().removeCallbacksAndMessages(null);
        super.onDetachedFromWindow();
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
    }

    protected void onVisibilityChanged(View changedView, int visibility) {
        super.onVisibilityChanged(changedView, visibility);
        if (KidozSDK.isInitialised() && visibility != 0 && !this.isInEditMode() && (visibility == 8 || visibility == 4)) {
            this.getStaticHandler().removeCallbacksAndMessages(null);
        }
        this.mAllowClickHandling = true;
    }

    public void onWindowFocusChanged(boolean hasWindowFocus) {
        super.onWindowFocusChanged(hasWindowFocus);
        this.mAllowClickHandling = hasWindowFocus;
    }

    private void prepareHandle(String url) {
        LocalAssetHelper localAssetHelper = new LocalAssetHelper();
        localAssetHelper.legacyBtnCloseAsset = AssetUtil.getAssetFile(this.getContext(), this.mLegacyBtnCloseUrl);
        localAssetHelper.legacyBtnOpenAsset = AssetUtil.getAssetFile(this.getContext(), this.mLegacyBtnOpenUrl);
        localAssetHelper.legacyBtnDefaultOpenSponsoredAsset = AssetUtil.getAssetFile(this.getContext(), this.mLegacyBtnOpenSponsoredUrl);
        localAssetHelper.openBtnAssetBg = AssetUtil.getAssetFile(this.getContext(), this.mBtnOpenBgUrl);
        localAssetHelper.openBtnAssetFrg = AssetUtil.getAssetFile(this.getContext(), this.mBtnOpenFrgUrl);
        localAssetHelper.closeBtnAssetBg = AssetUtil.getAssetFile(this.getContext(), this.mBtnCloseBgUrl);
        localAssetHelper.closeBtnAssetFrg = AssetUtil.getAssetFile(this.getContext(), this.mBtnCloseFrgUrl);
        this.mPanelHandle.loadAssets(localAssetHelper, new PanelHandle.IonPanelHandlePreparedListener(){

            @Override
            public void onPanelPrepared() {
                AbstractPanelView.this.mIsPanelPrepared = true;
                GenAnimator.playGrowAnimation((View)AbstractPanelView.this.mPanelHandle, 350L, 0L, null, new Animator.AnimatorListener(){

                    public void onAnimationStart(Animator animation) {
                        AbstractPanelView.this.mPanelHandle.setPanelButtonState(PanelHandle.PANEL_HANDLE_VIEW_STATE.CLOSED);
                        AbstractPanelView.this.requestFocus();
                        AbstractPanelView.this.bringToFront();
                    }

                    public void onAnimationEnd(Animator animation) {
                        AbstractPanelView.this.mIsAnimationRunning = false;
                        AbstractPanelView.this.requestFocus();
                        AbstractPanelView.this.bringToFront();
                        AbstractPanelView.this.mPanelState = PanelViewState.CLOSED;
                        if (AbstractPanelView.this.getVisibility() == 0) {
                            AbstractPanelView.this.openPanelForDefinedAmountOfTime();
                        }
                        if (AbstractPanelView.this.mIOnPanelViewEventListener != null) {
                            AbstractPanelView.this.mIOnPanelViewEventListener.onPanelReady();
                        }
                        EventManager.getInstance(AbstractPanelView.this.getContext()).logEvent(AbstractPanelView.this.getContext(), WidgetType.WIDGET_TYPE_PANEL.getStringValue(), AbstractPanelView.this.mStyleId, EventManager.LOG_CRITICAL_LEVEL, "SDK", "Button View", "Panel Button View");
                    }

                    public void onAnimationCancel(Animator animation) {
                    }

                    public void onAnimationRepeat(Animator animation) {
                    }
                });
            }
        });
    }

    private void preparePanel() {
        this.setPanelColor(this.mPanelBgColor);
        this.mPanelState = PanelViewState.CLOSED;
        this.mIsAnimationRunning = true;
        Utils.setOnGlobalLayoutFinishListener((View)this, new Utils.OnGlobalLayoutFinishedListener(){

            @Override
            public void onLayoutFinished() {
                GenAnimator.closePanelView((View)AbstractPanelView.this.mContainer, 0L, (View)AbstractPanelView.this.mInnerContainer, AbstractPanelView.this.mPanelType, new Animator.AnimatorListener(){

                    public void onAnimationStart(Animator animation) {
                        GenAnimator.animateHandleClose((View)AbstractPanelView.this.mPanelHandle, null);
                        AbstractPanelView.this.requestFocus();
                        AbstractPanelView.this.bringToFront();
                    }

                    public void onAnimationEnd(Animator animation) {
                        AbstractPanelView.this.clearPanelContent();
                        AbstractPanelView.this.onContentDataLoadStarted();
                        AbstractPanelView.this.mContentLogicLoader.loadContent(AbstractPanelView.this.getContext(), WidgetType.WIDGET_TYPE_PANEL.getStringValue(), AbstractPanelView.this.mStyleId);
                    }

                    public void onAnimationCancel(Animator animation) {
                    }

                    public void onAnimationRepeat(Animator animation) {
                    }
                });
            }
        });
    }

    private void openPanelForDefinedAmountOfTime() {
        final long lastLaunchTime = this.mSharedPreferences.getLong(FIRST_TIME_LAST_LAUNCH_KEY, -1L);
        if (this.mFirstLaunchStartDelay >= 0.0f && this.getVisibility() == 0) {
            this.getStaticHandler().postDelayed(new Runnable(){

                @Override
                public void run() {
                    if (AbstractPanelView.this.mFirstLaunchOpenRepeatTimeFarme == -1.0f || lastLaunchTime == -1L || (float)lastLaunchTime + AbstractPanelView.this.mFirstLaunchOpenRepeatTimeFarme * 3600000.0f > (float)System.currentTimeMillis()) {
                        AbstractPanelView.this.expandPanelViewInternal(false);
                        SharedPreferences.Editor editor = AbstractPanelView.this.mSharedPreferences.edit();
                        editor.putLong(AbstractPanelView.FIRST_TIME_LAST_LAUNCH_KEY, System.currentTimeMillis());
                        editor.apply();
                        if (AbstractPanelView.this.mFirstLaunchOpenPeriod > 0.0f) {
                            AbstractPanelView.this.getStaticHandler().postDelayed(new Runnable(){

                                @Override
                                public void run() {
                                    AbstractPanelView.this.collapsePanelView();
                                }
                            }, (long)(AbstractPanelView.this.mFirstLaunchOpenPeriod * 1000.0f));
                        }
                    }
                }
            }, (long)(this.mFirstLaunchStartDelay * 1000.0f));
        }
    }

    protected Utils.StaticHandler getStaticHandler() {
        if (this.mStaticHandler == null) {
            this.mStaticHandler = new Utils.StaticHandler(Looper.getMainLooper());
        }
        return this.mStaticHandler;
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        if (System.currentTimeMillis() - this.mLastInterceptTS > 1000L) {
            this.mLastInterceptTS = System.currentTimeMillis();
            this.getStaticHandler().removeCallbacksAndMessages(null);
        }
        return super.onInterceptTouchEvent(ev);
    }

    public static enum PanelViewState {
        OPEN,
        CLOSED;

    }
}

