/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.api.ui_views.interstitial;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import com.kidoz.sdk.api.KidozInterstitial;
import com.kidoz.sdk.api.general.EventMessage;
import com.kidoz.sdk.api.general.WidgetEventMessage;
import com.kidoz.sdk.api.general.enums.WidgetType;
import com.kidoz.sdk.api.ui_views.html_view.HtmlManager;
import com.kidoz.sdk.api.ui_views.html_view.HtmlViewWrapper;
import org.greenrobot.eventbus.EventBus;
import org.greenrobot.eventbus.Subscribe;

public class KidozAdActivity
extends Activity {
    public static final String STYLE_ID_KEY = "styleId";
    public static final String DISABLE_BACK_KEY = "disableBack";
    protected HtmlViewWrapper mWebView;
    protected RelativeLayout mInnerContainer;
    protected int mBgColor = -16777216;
    private boolean mIsImmersive = true;
    private boolean mIsFirstLaunch = true;
    private boolean mIsBackDisabled = false;
    private Handler mHandler;
    private int mPreviousOrientation;
    public static final String UNIQUE_PLACEMENT_ID_KEY = "unique_placement_id_key";
    public static final String AD_TYPE_KEY = "ad_type_key";
    private String mUniquePlacementId = "-1";

    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        if (Build.VERSION.SDK_INT < 18) {
            this.mWebView.setVisibility(4);
            this.mHandler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    KidozAdActivity.this.mWebView.setVisibility(0);
                    KidozAdActivity.this.mWebView.bringToFront();
                }
            }, 500L);
        }
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        try {
            if (!EventBus.getDefault().isRegistered((Object)this)) {
                EventBus.getDefault().register((Object)this);
            }
            this.setTheme(0x1030011);
            this.setRequestedOrientation(4);
            this.getWindow().setFlags(0x1000000, 0x1000000);
            this.mHandler = new Handler(this.getMainLooper());
            Intent intent = this.getIntent();
            if (intent != null) {
                this.mUniquePlacementId = intent.getStringExtra(UNIQUE_PLACEMENT_ID_KEY);
                String styleId = intent.getStringExtra(STYLE_ID_KEY);
                this.mIsBackDisabled = intent.getBooleanExtra(DISABLE_BACK_KEY, false);
                KidozInterstitial.AD_TYPE adType = (KidozInterstitial.AD_TYPE)((Object)intent.getSerializableExtra(AD_TYPE_KEY));
                if (adType != null) {
                    this.mWebView = HtmlManager.getIntrstDefaultHtmlView((Context)this, adType);
                } else {
                    this.finish();
                }
                if (this.mWebView != null) {
                    if (this.mWebView.getWidgetType() != null && this.mWebView.getWidgetType().equals(WidgetType.WIDGET_TYPE_INTERSTITIAL_REWARDED.getStringValue())) {
                        this.mWebView.setWidgetType(WidgetType.WIDGET_TYPE_INTERSTITIAL_REWARDED.getStringValue());
                    } else {
                        this.mWebView.setWidgetType(WidgetType.WIDGET_TYPE_INTERSTITIAL.getStringValue());
                    }
                    this.mWebView.setStyleID(styleId);
                    this.mWebView.setInFocusActivityContext((Context)this);
                    if (Build.VERSION.SDK_INT < 16) {
                        this.mWebView.setLayerType(0, null);
                    }
                    this.mInnerContainer = new RelativeLayout((Context)this);
                    this.mInnerContainer.setBackgroundColor(this.mBgColor);
                    this.mInnerContainer.addView((View)this.mWebView, (ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-1, -1));
                    this.setContentView((View)this.mInnerContainer, new ViewGroup.LayoutParams(-1, -1));
                } else {
                    this.finish();
                }
            } else {
                this.finish();
            }
        }
        catch (Exception e2) {
            this.finish();
        }
    }

    public void onWindowFocusChanged(boolean hasFocus) {
        super.onWindowFocusChanged(hasFocus);
        if (hasFocus && this.mIsImmersive) {
            this.applyImmersiveMode();
        }
    }

    private void applyImmersiveMode() {
        if (Build.VERSION.SDK_INT < 16) {
            this.getWindow().setFlags(1024, 1024);
        } else if (Build.VERSION.SDK_INT < 18) {
            View decorView = this.getWindow().getDecorView();
            int uiOptions = 4;
            decorView.setSystemUiVisibility(uiOptions);
        } else {
            final View decorView = this.getWindow().getDecorView();
            decorView.setSystemUiVisibility(5894);
            decorView.setOnSystemUiVisibilityChangeListener(new View.OnSystemUiVisibilityChangeListener(){

                public void onSystemUiVisibilityChange(int visibility) {
                    if ((visibility & 4) == 0) {
                        decorView.setSystemUiVisibility(5894);
                    }
                }
            });
        }
    }

    protected void onResume() {
        super.onResume();
        this.mPreviousOrientation = this.getRequestedOrientation();
        if (this.mWebView != null) {
            if (this.mIsFirstLaunch) {
                this.mIsFirstLaunch = false;
                this.mHandler.postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        KidozAdActivity.this.mWebView.startAd();
                    }
                }, 100L);
            } else {
                this.mWebView.resumeVastAd();
            }
            if (Build.VERSION.SDK_INT < 18) {
                this.mWebView.setVisibility(4);
                this.mHandler.postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        KidozAdActivity.this.mWebView.setVisibility(0);
                        KidozAdActivity.this.mWebView.bringToFront();
                    }
                }, 500L);
            } else {
                this.mHandler.postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        KidozAdActivity.this.mWebView.bringToFront();
                    }
                }, 200L);
            }
        }
    }

    protected void onPause() {
        this.mHandler.removeCallbacksAndMessages(null);
        if (this.mWebView != null) {
            try {
                this.mWebView.pauseVastAd();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        super.onPause();
    }

    protected void onDestroy() {
        if (this.mWebView != null) {
            try {
                this.mWebView.stopVastAd();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.mUniquePlacementId != "-1") {
            EventMessage eventMessage = new EventMessage(EventMessage.MessageType.INTERSTITIAL_AD_CLOSE);
            eventMessage.setAdditionalParam(this.mUniquePlacementId);
            EventBus.getDefault().post((Object)eventMessage);
        }
        if (EventBus.getDefault().isRegistered((Object)this)) {
            EventBus.getDefault().unregister((Object)this);
        }
        this.setRequestedOrientation(this.mPreviousOrientation);
        super.onDestroy();
    }

    @Subscribe
    public void onHandleEvent(WidgetEventMessage event) {
        if (event.getMessageType() == EventMessage.MessageType.INTERSTITIAL_AD_CLOSE) {
            this.mHandler.removeCallbacksAndMessages(null);
            if (!this.isFinishing()) {
                this.finish();
            }
        } else if (event.getMessageType() == EventMessage.MessageType.PARENTAL_DIALOG_CLOSE) {
            this.onResume();
        }
    }

    public void onBackPressed() {
        if (!this.mIsBackDisabled) {
            super.onBackPressed();
        }
    }
}

