/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.api.ui_views.interstitial;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Handler;
import android.view.View;
import android.view.ViewGroup;
import com.kidoz.sdk.api.KidozInterstitial;
import com.kidoz.sdk.api.KidozSDK;
import com.kidoz.sdk.api.general.ContentLogicLoader;
import com.kidoz.sdk.api.general.EventMessage;
import com.kidoz.sdk.api.general.UniquePlacement.UniqueInterstitialListener;
import com.kidoz.sdk.api.general.UniquePlacement.UniquePlacementHelper;
import com.kidoz.sdk.api.general.WidgetEventMessage;
import com.kidoz.sdk.api.general.assets_handling.AssetUtil;
import com.kidoz.sdk.api.general.database.ServerConfigStorage;
import com.kidoz.sdk.api.general.enums.WidgetType;
import com.kidoz.sdk.api.general.utils.PropertiesObj;
import com.kidoz.sdk.api.general.utils.SDKLogger;
import com.kidoz.sdk.api.general.utils.SdkCookieManager;
import com.kidoz.sdk.api.general.utils.StorageLife;
import com.kidoz.sdk.api.structure.ContentData;
import com.kidoz.sdk.api.structure.ContentItem;
import com.kidoz.sdk.api.ui_views.html_view.HtmlManager;
import com.kidoz.sdk.api.ui_views.html_view.HtmlViewWrapper;
import com.kidoz.sdk.api.ui_views.html_view.IOnHtmlWebViewInterface;
import com.kidoz.sdk.api.ui_views.interstitial.KidozAdActivity;
import com.kidoz.sdk.omid.OMServiceImpl;
import com.kidoz.sdk.omid.OMSessionAdapter;
import com.kidoz.sdk.omid.TimerGuard;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.greenrobot.eventbus.EventBus;
import org.greenrobot.eventbus.Subscribe;
import org.json.JSONObject;

public class IntrstWrapper {
    protected static final int REQUEST_FILTER_TIMEOUT = 5000;
    private ArrayList<ContentItem> mContentList = new ArrayList();
    private OMSessionAdapter omSessionAdapter;
    private LastError error;
    private VIEW_STATE mViewState;
    protected static IntrstWrapper mInstance = null;
    protected Activity mActivity;
    protected HtmlViewWrapper webView;
    protected ContentLogicLoader mContentLogicLoader;
    protected ContentData mContentData;
    protected String mStyleId;
    protected boolean mIsInitializationFinished = false;
    protected boolean mIsLoaded = false;
    protected boolean mIsShowRequested = false;
    protected boolean mIsLoadRequested = false;
    protected long mLoadRequestTM = 0L;
    protected boolean mIsLoadRequestedWhileNotReady;
    protected JSONObject mProperties;
    protected Lock mLaunchLock;
    protected InnerHelperInterface mInnerHelperInterface;
    protected KidozInterstitial.AD_TYPE mAdRequestType = KidozInterstitial.AD_TYPE.INTERSTITIAL;
    protected Lock raceConditionLock = new ReentrantLock();
    protected JSONObject mAdProperties;
    private int mCurrentIndex;
    private boolean mIsLocal = false;
    private UniquePlacementHelper mUniquePlacementHelper;
    private int MAX_TIME_TO_BLOCK = 30;
    private long lastTryRequestTimeStamp = 0L;
    private long requestTryNum = 0L;
    private TimerGuard omSessionTimerGuard = new TimerGuard();

    private long getTimeStamp() {
        return TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis());
    }

    private void sendErrorResponse(final LastError error) {
        new Handler().postDelayed(new Runnable(){

            @Override
            public void run() {
                if (error != null) {
                    switch (error) {
                        case LOAD_FAILED: {
                            IntrstWrapper.this.sendEventToEventBus(EventMessage.MessageType.LOAD_FAILED);
                            SDKLogger.printWarningLog("blocking waterfall LOAD_FAILED try = " + IntrstWrapper.this.requestTryNum);
                            break;
                        }
                        case NO_OFFERS: {
                            IntrstWrapper.this.sendEventToEventBus(EventMessage.MessageType.NO_OFFERS);
                            SDKLogger.printWarningLog("blocking waterfall NO_OFFERS try = " + IntrstWrapper.this.requestTryNum);
                            break;
                        }
                        default: {
                            IntrstWrapper.this.sendEventToEventBus(EventMessage.MessageType.LOAD_FAILED);
                            SDKLogger.printWarningLog("blocking waterfall LOAD_FAILED try = " + IntrstWrapper.this.requestTryNum);
                            break;
                        }
                    }
                } else {
                    IntrstWrapper.this.sendEventToEventBus(EventMessage.MessageType.LOAD_FAILED);
                    SDKLogger.printWarningLog("blocking waterfall LOAD_FAILED try = " + IntrstWrapper.this.requestTryNum);
                }
            }
        }, 500L);
    }

    private synchronized boolean canBlockCall() {
        this.MAX_TIME_TO_BLOCK = this.getMaxThrottleTime();
        if (this.MAX_TIME_TO_BLOCK > 0) {
            try {
                if (this.requestTryNum == 0L || this.lastTryRequestTimeStamp == 0L) {
                    SDKLogger.printWarningLog("not blocking waterfall");
                    return false;
                }
                long currentTimeStamp = this.getTimeStamp();
                long timeLapsed = currentTimeStamp - this.lastTryRequestTimeStamp;
                long timeToBlock = (long)Math.pow(2.0, this.requestTryNum);
                if (timeToBlock > (long)this.MAX_TIME_TO_BLOCK) {
                    timeToBlock = this.MAX_TIME_TO_BLOCK;
                }
                if (timeLapsed < timeToBlock) {
                    this.sendErrorResponse(this.error);
                    return true;
                }
            }
            catch (Exception e2) {
                this.requestTryNum = 0L;
                this.lastTryRequestTimeStamp = 0L;
                SDKLogger.printWarningLog(e2.toString());
            }
            return false;
        }
        return false;
    }

    private synchronized void setNegativeResponse(LastError error) {
        ++this.requestTryNum;
        this.lastTryRequestTimeStamp = this.getTimeStamp();
        this.error = error;
    }

    private synchronized void setPositiveResponse() {
        this.requestTryNum = 0L;
        this.lastTryRequestTimeStamp = 0L;
    }

    public IntrstWrapper(Activity activity) {
        this.setStateClosed();
        this.mActivity = activity;
        this.mUniquePlacementHelper = new UniquePlacementHelper();
        this.mUniquePlacementHelper.setInternalInterstitialListener(new UniqueInterstitialListener(){

            @Override
            public void onInterstitialClose() {
                ViewGroup group;
                IntrstWrapper.this.safeFinishOMSession();
                IntrstWrapper.this.setStateClosed();
                if (IntrstWrapper.this.mInnerHelperInterface != null) {
                    IntrstWrapper.this.mInnerHelperInterface.onAdClose();
                }
                if ((group = (ViewGroup)IntrstWrapper.this.webView.getParent()) != null) {
                    group.removeView((View)IntrstWrapper.this.webView);
                }
                ViewGroup.LayoutParams layoutParams = new ViewGroup.LayoutParams(0, 0);
                IntrstWrapper.this.mActivity.addContentView((View)IntrstWrapper.this.webView, layoutParams);
            }
        });
        if (!EventBus.getDefault().isRegistered((Object)this)) {
            EventBus.getDefault().register((Object)this);
        }
        this.mLaunchLock = new ReentrantLock();
        if (KidozSDK.isInitialised()) {
            this.validateLayoutAndAssets();
        }
        this.mInnerHelperInterface = new InnerHelperInterface(){

            @Override
            public void onAdOpen() {
                if (!IntrstWrapper.this.mIsLocal) {
                    IntrstWrapper.this.sendEventToEventBus(EventMessage.MessageType.OPENED);
                }
            }

            @Override
            public void onAdClose() {
                if (!IntrstWrapper.this.mIsLocal) {
                    IntrstWrapper.this.sendEventToEventBus(EventMessage.MessageType.CLOSED);
                }
                IntrstWrapper.this.mIsShowRequested = false;
                IntrstWrapper.this.mIsLoaded = false;
                if (IntrstWrapper.this.mAdRequestType != null && IntrstWrapper.this.mAdRequestType == KidozInterstitial.AD_TYPE.REWARDED_VIDEO) {
                    SdkCookieManager.resetStorage((Context)IntrstWrapper.this.mActivity, WidgetType.WIDGET_TYPE_INTERSTITIAL_REWARDED.getStringValue(), StorageLife.WIDGET);
                } else {
                    SdkCookieManager.resetStorage((Context)IntrstWrapper.this.mActivity, WidgetType.WIDGET_TYPE_INTERSTITIAL.getStringValue(), StorageLife.WIDGET);
                }
            }
        };
        this.mContentLogicLoader = new ContentLogicLoader(new ContentLogicLoader.IOnContentDataReadyCallback(){

            @Override
            public void onDataReady(ContentData contentData) {
                IntrstWrapper.this.mContentData = contentData;
                IntrstWrapper.this.mContentList = new ArrayList();
                IntrstWrapper.this.mContentList.addAll(contentData.getContentDataItems());
                if (IntrstWrapper.this.mContentList.size() > 0) {
                    IntrstWrapper.this.mCurrentIndex = 0;
                    ContentItem contentItem = (ContentItem)IntrstWrapper.this.mContentList.get(IntrstWrapper.this.mCurrentIndex);
                    String urlToLoad = IntrstWrapper.this.getUrlFromContent(contentItem);
                    PropertiesObj appConfig = ServerConfigStorage.getInstance().loadAppProperties();
                    if (urlToLoad == null && appConfig != null) {
                        urlToLoad = appConfig.getInterstitialHtmlLink();
                    }
                    if (urlToLoad != null) {
                        IntrstWrapper.this.prepareWebViewWithLink(urlToLoad);
                    }
                }
            }

            @Override
            public void onLoadContentFailed() {
                IntrstWrapper.this.setNegativeResponse(LastError.LOAD_FAILED);
                IntrstWrapper.this.sendEventToEventBus(EventMessage.MessageType.LOAD_FAILED);
                IntrstWrapper.this.setStateClosed();
            }

            @Override
            public void onNoContentOffers() {
                IntrstWrapper.this.setNegativeResponse(LastError.NO_OFFERS);
                IntrstWrapper.this.sendEventToEventBus(EventMessage.MessageType.NO_OFFERS);
                IntrstWrapper.this.setStateClosed();
            }
        });
    }

    private int getMaxThrottleTime() {
        int result = 30;
        if (this.mActivity == null) {
            return result;
        }
        PropertiesObj appConfig = ServerConfigStorage.getInstance().loadAppProperties();
        if (appConfig != null) {
            result = appConfig.getMaxThrottleTime();
        }
        return result;
    }

    public InnerHelperInterface getHelperInterface() {
        return this.mInnerHelperInterface;
    }

    private void validateLayoutAndAssets() {
        if (this.raceConditionLock.tryLock()) {
            try {
                AssetUtil.parseStyleAsync((Context)this.mActivity, AssetUtil.ParserAsyncTask.StyleType.INTERSTITIAL_STYLE, new AssetUtil.ParserAsyncTask.IOnStyleParseListener(){

                    @Override
                    public void onParseFinished(boolean success) {
                        if (success) {
                            IntrstWrapper.this.mProperties = ServerConfigStorage.getInstance().loadProperties(KidozInterstitial.TAG);
                            if (IntrstWrapper.this.mProperties != null) {
                                IntrstWrapper.this.mStyleId = IntrstWrapper.this.mProperties.optString("style_id");
                            }
                        } else {
                            IntrstWrapper.this.setNegativeResponse(LastError.LOAD_FAILED);
                            IntrstWrapper.this.sendEventToEventBus(EventMessage.MessageType.LOAD_FAILED);
                        }
                    }
                });
            }
            finally {
                this.raceConditionLock.unlock();
            }
        }
    }

    protected void generateHtmlView() {
        this.webView = HtmlManager.initIntrstDefaultHtmlView((Context)this.mActivity, this.mAdRequestType);
    }

    private synchronized void prepareWebViewWithLink(final String url) {
        if (this.webView == null) {
            this.generateHtmlView();
            this.webView.setHtmlWebViewListener(new IOnHtmlWebViewInterface(){

                @Override
                public void onHtmlFinishedLoading() {
                    IntrstWrapper.this.safeStartOMSession();
                    super.onHtmlFinishedLoading();
                }

                @Override
                public void onNotifyVastReady(boolean isVastReady, JSONObject vast_properties) {
                    super.onNotifyVastReady(isVastReady, vast_properties);
                    IntrstWrapper.this.mAdProperties = vast_properties;
                    IntrstWrapper.this.mIsLoadRequested = false;
                    if (isVastReady) {
                        IntrstWrapper.this.setStateLoaded();
                        if (!IntrstWrapper.this.mIsLocal) {
                            IntrstWrapper.this.setPositiveResponse();
                            IntrstWrapper.this.sendEventToEventBus(EventMessage.MessageType.READY);
                        } else {
                            IntrstWrapper.this.show();
                        }
                    } else {
                        IntrstWrapper.this.safeFinishOMSession();
                        if (IntrstWrapper.this.hasAnotherInterstitial()) {
                            IntrstWrapper.this.loadNextInterstitial();
                        } else {
                            IntrstWrapper.this.mIsLoaded = false;
                            if (!IntrstWrapper.this.mIsLocal) {
                                IntrstWrapper.this.setNegativeResponse(LastError.LOAD_FAILED);
                                IntrstWrapper.this.sendEventToEventBus(EventMessage.MessageType.LOAD_FAILED);
                                IntrstWrapper.this.setStateClosed();
                            }
                        }
                    }
                    if (IntrstWrapper.this.mAdRequestType != null && IntrstWrapper.this.mAdRequestType == KidozInterstitial.AD_TYPE.REWARDED_VIDEO) {
                        IntrstWrapper.this.webView.setWidgetType(WidgetType.WIDGET_TYPE_INTERSTITIAL_REWARDED.getStringValue());
                    } else {
                        IntrstWrapper.this.webView.setWidgetType(WidgetType.WIDGET_TYPE_INTERSTITIAL.getStringValue());
                    }
                }

                @Override
                public void onViewReady() {
                    super.onViewReady();
                    if (IntrstWrapper.this.mContentList.size() > IntrstWrapper.this.mCurrentIndex) {
                        ContentItem contentItem = (ContentItem)IntrstWrapper.this.mContentList.get(IntrstWrapper.this.mCurrentIndex);
                        HashMap<String, Integer> keysMap = IntrstWrapper.this.mContentData.getmKeysMap();
                        String item = contentItem.getJSONitem().toString();
                        String map = new JSONObject(keysMap).toString();
                        IntrstWrapper.this.webView.loadContent(map, item);
                    }
                    IntrstWrapper.this.mIsInitializationFinished = true;
                }

                @Override
                public void onClose() {
                    IntrstWrapper.this.safeFinishOMSession();
                    super.onClose();
                    WidgetEventMessage eventMessage = null;
                    eventMessage = IntrstWrapper.this.mAdRequestType != null && IntrstWrapper.this.mAdRequestType == KidozInterstitial.AD_TYPE.REWARDED_VIDEO ? new WidgetEventMessage(EventMessage.MessageType.INTERSTITIAL_AD_CLOSE, WidgetType.WIDGET_TYPE_INTERSTITIAL_REWARDED) : new WidgetEventMessage(EventMessage.MessageType.INTERSTITIAL_AD_CLOSE, WidgetType.WIDGET_TYPE_INTERSTITIAL);
                    IntrstWrapper.this.setStateClosed();
                    EventBus.getDefault().post((Object)eventMessage);
                }

                @Override
                public void onRewarded() {
                    super.onRewarded();
                    IntrstWrapper.this.sendEventToEventBus(EventMessage.MessageType.REWARDED);
                }

                @Override
                public void onRewardedVideoStarted() {
                    super.onRewardedVideoStarted();
                    IntrstWrapper.this.sendEventToEventBus(EventMessage.MessageType.REWARDED_VIDEO_STARTED);
                }

                @Override
                public void onNotifyAdReady(boolean isAdReady, JSONObject adProperties) {
                    super.onNotifyAdReady(isAdReady, adProperties);
                    IntrstWrapper.this.mAdProperties = adProperties;
                    IntrstWrapper.this.mIsLoadRequested = false;
                    if (isAdReady) {
                        IntrstWrapper.this.mIsLoaded = true;
                        if (!IntrstWrapper.this.mIsLocal) {
                            IntrstWrapper.this.setPositiveResponse();
                            IntrstWrapper.this.sendEventToEventBus(EventMessage.MessageType.READY);
                        } else {
                            IntrstWrapper.this.show();
                        }
                    } else {
                        IntrstWrapper.this.mIsLoaded = false;
                        if (!IntrstWrapper.this.mIsLocal) {
                            IntrstWrapper.this.setNegativeResponse(LastError.LOAD_FAILED);
                            IntrstWrapper.this.sendEventToEventBus(EventMessage.MessageType.LOAD_FAILED);
                            IntrstWrapper.this.setStateClosed();
                        }
                    }
                    if (IntrstWrapper.this.mAdRequestType != null && IntrstWrapper.this.mAdRequestType == KidozInterstitial.AD_TYPE.REWARDED_VIDEO) {
                        IntrstWrapper.this.webView.setWidgetType(WidgetType.WIDGET_TYPE_INTERSTITIAL_REWARDED.getStringValue());
                    } else {
                        IntrstWrapper.this.webView.setWidgetType(WidgetType.WIDGET_TYPE_INTERSTITIAL.getStringValue());
                    }
                }
            });
        }
        if (this.mAdRequestType != null && this.mAdRequestType == KidozInterstitial.AD_TYPE.REWARDED_VIDEO) {
            this.webView.setWidgetType(WidgetType.WIDGET_TYPE_INTERSTITIAL_REWARDED.getStringValue());
        } else {
            this.webView.setWidgetType(WidgetType.WIDGET_TYPE_INTERSTITIAL.getStringValue());
        }
        if (this.omSessionAdapter != null) {
            SDKLogger.printErrorLog("KidozInterstitial", "OMSDK implementation: safeFinishOMSession is not called before a call to prepareWebViewWithLink, ");
            this.safeFinishOMSession();
        }
        SDKLogger.printDebugLog("omSessionTimerGuard.postWhenReleased");
        this.omSessionTimerGuard.postWhenReleased(new Runnable(){

            @Override
            public void run() {
                if (IntrstWrapper.this.webView != null) {
                    SDKLogger.printDebugLog("omSessionTimerGuard.complete: webView.loadHtml(url)");
                    IntrstWrapper.this.webView.loadHtml(url);
                } else {
                    SDKLogger.printErrorLog("omSessionTimerGuard.complete: webView == null, skipping");
                }
            }
        });
    }

    private void sendEventToEventBus(EventMessage.MessageType messageType) {
        EventMessage eventMessage = new EventMessage(messageType);
        eventMessage.setAdditionalParam(this.getPlacementHelper().getUniqueId());
        EventBus.getDefault().post((Object)eventMessage);
    }

    private void loadNextInterstitial() {
        ++this.mCurrentIndex;
        ContentItem contentItem = this.mContentList.get(this.mCurrentIndex);
        String urlToLoad = this.getUrlFromContent(contentItem);
        PropertiesObj appConfig = ServerConfigStorage.getInstance().loadAppProperties();
        if (urlToLoad == null && appConfig != null) {
            urlToLoad = appConfig.getInterstitialHtmlLink();
        }
        if (urlToLoad != null) {
            this.prepareWebViewWithLink(urlToLoad);
        }
    }

    private boolean hasAnotherInterstitial() {
        return this.mCurrentIndex < this.mContentList.size() - 1;
    }

    public void setAdType(KidozInterstitial.AD_TYPE adType) {
        this.mAdRequestType = adType;
    }

    public KidozInterstitial.AD_TYPE getAdType() {
        return this.mAdRequestType;
    }

    public synchronized void load(KidozInterstitial.AD_TYPE ad_type) {
        if (this.isStateShowing()) {
            return;
        }
        if (this.isStateLoading()) {
            return;
        }
        if (this.isStateLoaded()) {
            return;
        }
        if (!this.canBlockCall()) {
            this.mIsShowRequested = false;
            this.mAdRequestType = ad_type;
            if (this.mAdRequestType == KidozInterstitial.AD_TYPE.INTERSTITIAL) {
                this.mContentLogicLoader.loadWaterfall((Context)this.mActivity, WidgetType.WIDGET_TYPE_INTERSTITIAL.getStringValue(), this.mStyleId, "0");
            } else {
                this.mContentLogicLoader.loadWaterfall((Context)this.mActivity, WidgetType.WIDGET_TYPE_INTERSTITIAL_REWARDED.getStringValue(), this.mStyleId, "1");
            }
            this.mCurrentIndex = 0;
            this.setStateLoading();
        }
    }

    private boolean isStateLoaded() {
        if (this.mViewState == VIEW_STATE.LOADED) {
            SDKLogger.printWarningLog("KidozInterstitial", "isStateLoaded = true");
            return true;
        }
        SDKLogger.printWarningLog("KidozInterstitial", "isStateLoaded = false");
        return false;
    }

    private boolean isStateLoading() {
        if (this.mViewState == VIEW_STATE.LOADING) {
            SDKLogger.printWarningLog("KidozInterstitial", "isStateLoading = true");
            return true;
        }
        SDKLogger.printWarningLog("KidozInterstitial", "isStateLoading = false");
        return false;
    }

    private boolean isStateShowing() {
        if (this.mViewState == VIEW_STATE.SHOWING) {
            SDKLogger.printWarningLog("KidozInterstitial", "isStateShowing = true");
            return true;
        }
        SDKLogger.printWarningLog("KidozInterstitial", "isStateShowing = false");
        return false;
    }

    private boolean isStateClosed() {
        if (this.mViewState == VIEW_STATE.CLOSED) {
            SDKLogger.printWarningLog("KidozInterstitial", "isStateClosed = true");
            return true;
        }
        SDKLogger.printWarningLog("KidozInterstitial", "isStateClosed = false");
        return false;
    }

    private void setStateClosed() {
        SDKLogger.printWarningLog("KidozInterstitial", "setStateClosed");
        this.mViewState = VIEW_STATE.CLOSED;
    }

    private void setStateShowing() {
        SDKLogger.printWarningLog("KidozInterstitial", "setStateShowing");
        this.mViewState = VIEW_STATE.SHOWING;
    }

    private void setStateLoaded() {
        SDKLogger.printWarningLog("KidozInterstitial", "setStateLoaded");
        this.mViewState = VIEW_STATE.LOADED;
    }

    private void setStateLoading() {
        SDKLogger.printWarningLog("KidozInterstitial", "setStateLoading");
        this.mViewState = VIEW_STATE.LOADING;
    }

    public synchronized void show() {
        if (this.isStateLoaded()) {
            if (!this.mIsShowRequested) {
                this.mIsShowRequested = true;
                this.openView();
            }
        } else {
            SDKLogger.printWarningLog("KidozInterstitial", "Interstitial Ad is not loaded! Please call loadAd() first.");
        }
    }

    public boolean isInterstitialLoaded() {
        return this.isStateLoaded();
    }

    protected synchronized void openView() {
        if (this.mLaunchLock.tryLock()) {
            try {
                Intent intent = new Intent((Context)this.mActivity, KidozAdActivity.class);
                intent.putExtra("styleId", this.mStyleId);
                intent.putExtra("unique_placement_id_key", this.mUniquePlacementHelper.getUniqueId());
                intent.putExtra("ad_type_key", (Serializable)((Object)this.mAdRequestType));
                if (this.mAdProperties != null) {
                    intent.putExtra("disableBack", this.mAdProperties.optBoolean("interstitial_lock", false));
                }
                intent.addFlags(0x30020000);
                if (this.mInnerHelperInterface != null) {
                    this.mInnerHelperInterface.onAdOpen();
                }
                this.mActivity.startActivity(intent);
                this.setStateShowing();
            }
            catch (Exception e2) {
                this.setStateClosed();
            }
            finally {
                this.mLaunchLock.unlock();
            }
        }
    }

    @Subscribe
    public void onHandleEvent(EventMessage event) {
        if (event.getMessageType() == EventMessage.MessageType.INIT_SDK) {
            this.validateLayoutAndAssets();
        }
    }

    public void validateIfPrepared() {
        PropertiesObj appConfig;
        if (!EventBus.getDefault().isRegistered((Object)this)) {
            EventBus.getDefault().register((Object)this);
        }
        if (!this.mIsInitializationFinished && (appConfig = ServerConfigStorage.getInstance().loadAppProperties()) != null) {
            this.prepareWebViewWithLink(appConfig.getInterstitialHtmlLink());
        }
    }

    private String getUrlFromContent(ContentItem item) {
        String url = null;
        try {
            PropertiesObj appConfig = ServerConfigStorage.getInstance().loadAppProperties();
            url = item.getHTMLUrl();
            if (url == null && appConfig != null) {
                switch (item.getHtmlType()) {
                    case NONE: {
                        break;
                    }
                    case VAST: {
                        url = appConfig.getInterstitialDefaultLinkForType("vast");
                        break;
                    }
                    case MRAID: {
                        url = appConfig.getInterstitialDefaultLinkForType("mraid");
                        break;
                    }
                    case DOUBLE_CLICK: {
                        url = appConfig.getInterstitialDefaultLinkForType("double_click");
                        break;
                    }
                    case SUPER_AWESOME: {
                        url = appConfig.getInterstitialDefaultLinkForType("super_awesome");
                        break;
                    }
                    case JAVASCRIPT: {
                        url = appConfig.getInterstitialDefaultLinkForType("javascript");
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return url;
    }

    public void setIsLocalRequest(boolean local) {
        this.mIsLocal = local;
    }

    public boolean getIsLocal() {
        return this.mIsLocal;
    }

    public UniquePlacementHelper getPlacementHelper() {
        return this.mUniquePlacementHelper;
    }

    private void safeStartOMSession() {
        if (this.omSessionAdapter != null) {
            SDKLogger.printErrorLog("KidozInterstitial", "OMSDK implementation: safeStartOMSession() called twice without safeFinishOMSession(), ignoring the call");
            return;
        }
        this.omSessionAdapter = OMServiceImpl.instance.createSession(this.webView.mWebView);
        if (this.omSessionAdapter != null) {
            this.omSessionAdapter.start();
        }
    }

    private void safeFinishOMSession() {
        if (this.omSessionAdapter != null) {
            this.omSessionAdapter.finish();
            this.omSessionTimerGuard.lock(1000L);
            this.omSessionAdapter = null;
        }
    }

    public static interface InnerHelperInterface {
        public void onAdOpen();

        public void onAdClose();
    }

    public static enum VIEW_STATE {
        CLOSED,
        LOADING,
        LOADED,
        SHOWING;

    }

    private static enum LastError {
        LOAD_FAILED,
        NO_OFFERS;

    }
}

