/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.api.ui_views.custom_drawables;

import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import android.os.Build;

public class KidozLogoDrawable
extends Drawable {
    private static final float CIRCLE_RADIUS_SIZE_RATIO = 0.16f;
    private static final float CIRCLE_FIRST_LEVEL_VERTICAL_RATIO = 0.35f;
    private static final float CIRCLE_SECOND_LEVEL_VERTICAL_RATIO = 0.45f;
    private static final float CIRCLE_SECOND_LEVEL_HORIZONTAL_RATIO = 0.3f;
    private static final float CIRCLE_THIRD_LEVEL_VERTICAL_RATIO = 0.62f;
    private static final float CIRCLE_THIRD_LEVEL_HORIZONTAL_RATIO = 0.31f;
    private static final float CIRCLE_FOURTH_LEVEL_VETICAL_RATIO = 0.58f;
    private Paint mLogoPaint = new Paint(1);
    private RectF mRectF = new RectF();
    private int mWidth;
    private int mHeight;
    private float mDefaultBgRadius;
    private int mDefaultBgColor = -1;

    public KidozLogoDrawable() {
        this.initRectF();
    }

    private void initRectF() {
        this.mLogoPaint.setDither(true);
    }

    public void draw(Canvas canvas) {
        this.mLogoPaint.setColor(Color.parseColor((String)"#ffffff"));
        if (Build.VERSION.SDK_INT >= 21) {
            canvas.drawRoundRect(0.0f, 0.0f, (float)this.mWidth, (float)this.mHeight, this.mDefaultBgRadius, this.mDefaultBgRadius, this.mLogoPaint);
        } else {
            canvas.drawRoundRect(this.mRectF, this.mDefaultBgRadius, this.mDefaultBgRadius, this.mLogoPaint);
        }
        float radius = 0.16f * (float)this.mWidth;
        this.mLogoPaint.setColor(Color.parseColor((String)"#f8de46"));
        canvas.drawCircle((float)(this.mWidth / 2), 0.35f * (float)this.mHeight, radius, this.mLogoPaint);
        this.mLogoPaint.setColor(Color.parseColor((String)"#e13333"));
        canvas.drawCircle(0.31f * (float)this.mWidth, 0.62f * (float)this.mHeight, radius, this.mLogoPaint);
        this.mLogoPaint.setColor(Color.parseColor((String)"#4aaed3"));
        canvas.drawCircle((float)this.mWidth - 0.31f * (float)this.mWidth, 0.62f * (float)this.mHeight, radius, this.mLogoPaint);
        this.mLogoPaint.setColor(Color.parseColor((String)"#f5f8a850"));
        canvas.drawCircle(0.3f * (float)this.mWidth, 0.45f * (float)this.mHeight, radius, this.mLogoPaint);
        this.mLogoPaint.setColor(Color.parseColor((String)"#f5b0d63a"));
        canvas.drawCircle((float)this.mWidth - 0.3f * (float)this.mWidth, 0.45f * (float)this.mHeight, radius, this.mLogoPaint);
        this.mLogoPaint.setColor(Color.parseColor((String)"#ffffff"));
        canvas.drawCircle((float)(this.mWidth / 2), 0.58f * (float)this.mHeight, radius, this.mLogoPaint);
    }

    public void setAlpha(int alpha) {
        this.mLogoPaint.setAlpha(alpha);
    }

    public void setColorFilter(ColorFilter cf) {
        this.mLogoPaint.setColorFilter(cf);
    }

    public int getOpacity() {
        return -3;
    }

    protected void onBoundsChange(Rect bounds) {
        super.onBoundsChange(bounds);
        this.mWidth = bounds.width();
        this.mHeight = bounds.height();
        this.mRectF = new RectF(0.0f, 0.0f, (float)this.mWidth, (float)this.mHeight);
        this.mDefaultBgRadius = 0.1f * (float)this.mWidth;
    }
}

