/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.api.general.utils;

import android.annotation.SuppressLint;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ResolveInfo;
import android.content.res.Configuration;
import android.database.Cursor;
import android.graphics.Point;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Build;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.Display;
import android.view.WindowManager;
import com.kidoz.sdk.api.KidozSDK;
import com.kidoz.sdk.api.general.utils.CustomAdvertisingIdClient;
import com.kidoz.sdk.api.general.utils.SDKLogger;
import com.kidoz.sdk.api.general.utils.SharedPreferencesUtils;
import java.io.File;
import java.net.NetworkInterface;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Locale;

public class SdkDeviceUtils {
    private static final String TAG = SdkDeviceUtils.class.getSimpleName();
    private static final String STOP_STATE_FLAG_SHARED_PREFERENCES = "STOP_STATE_FLAG_SHARED_PREFERENCES";

    public static String getDeviceReferral(Context context) {
        String publisherID = SharedPreferencesUtils.loadSharedPreferencesData(context, "PUBLISHER_ID");
        String result = "SDK_";
        if (context != null) {
            result = result + (KidozSDK.getAppId() != null ? KidozSDK.getAppId() : context.getPackageName());
            result = result + "_";
            if (publisherID != null) {
                result = result + publisherID;
            }
        }
        SDKLogger.printDebugLog(TAG, "Device Referral>> " + result);
        return result;
    }

    public static String getCurrentDefaultLauncherPackageName(Context context) {
        String result = null;
        Intent intent = new Intent("android.intent.action.MAIN");
        intent.addCategory("android.intent.category.HOME");
        ResolveInfo resolveInfo = context.getPackageManager().resolveActivity(intent, 65536);
        if (resolveInfo != null && (result = resolveInfo.activityInfo.packageName).equals("android")) {
            result = null;
        }
        return result;
    }

    public static void setDeviceLanguage(Context context, String languageCode) {
        if (context != null && languageCode != null) {
            String[] selectedLocale = languageCode.split("_");
            Locale locale = null;
            if (selectedLocale != null && selectedLocale.length > 1) {
                locale = new Locale(selectedLocale[0], selectedLocale[1]);
            } else if (selectedLocale != null && selectedLocale.length > 0) {
                locale = new Locale(selectedLocale[0]);
            } else {
                return;
            }
            Locale.setDefault(locale);
            Configuration config = context.getResources().getConfiguration();
            config.locale = locale;
            if (context != null) {
                context.getResources().updateConfiguration(config, context.getResources().getDisplayMetrics());
            }
        }
    }

    @SuppressLint(value={"NewApi"})
    public static int getScreenSize(Context context, boolean isWidth) {
        int result = 0;
        WindowManager windowManager = (WindowManager)context.getSystemService("window");
        Display display = windowManager.getDefaultDisplay();
        if (isWidth) {
            if (Build.VERSION.SDK_INT >= 19) {
                Point point = new Point();
                display.getRealSize(point);
                result = point.x;
            } else {
                result = display.getWidth();
            }
        } else if (Build.VERSION.SDK_INT >= 19) {
            Point point = new Point();
            display.getRealSize(point);
            result = point.y;
        } else {
            result = display.getHeight();
        }
        return result;
    }

    @SuppressLint(value={"NewApi"})
    public static Point getScreenSize(Context context) {
        Point size = new Point();
        WindowManager windowManager = (WindowManager)context.getSystemService("window");
        Display display = windowManager.getDefaultDisplay();
        if (Build.VERSION.SDK_INT >= 19) {
            display.getRealSize(size);
        } else {
            size.x = display.getWidth();
            size.y = display.getHeight();
        }
        return size;
    }

    public static String getMACAddress(String interfaceName) {
        String result = null;
        try {
            ArrayList<NetworkInterface> interfaces = Collections.list(NetworkInterface.getNetworkInterfaces());
            for (NetworkInterface intf : interfaces) {
                byte[] mac;
                if (interfaceName != null && !intf.getName().equalsIgnoreCase(interfaceName) || (mac = intf.getHardwareAddress()) == null) continue;
                StringBuilder buf = new StringBuilder();
                for (byte aMac : mac) {
                    buf.append(String.format("%02X:", aMac));
                }
                if (buf.length() > 0) {
                    buf.deleteCharAt(buf.length() - 1);
                }
                result = buf.toString();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public static int getDeviceDefaultOrientation(Context context) {
        WindowManager windowManager = (WindowManager)context.getSystemService("window");
        Configuration config = context.getResources().getConfiguration();
        int rotation = windowManager.getDefaultDisplay().getRotation();
        if ((rotation == 0 || rotation == 2) && config.orientation == 2 || (rotation == 1 || rotation == 3) && config.orientation == 1) {
            return 2;
        }
        return 1;
    }

    public static String getPicturePathFromUri(Context context, Uri pictureUri) {
        String result = null;
        if (pictureUri != null) {
            String[] proj = new String[]{"_data"};
            ContentResolver contentResolver = context.getContentResolver();
            Cursor cursor = contentResolver.query(pictureUri, proj, null, null, null);
            int column_index = cursor.getColumnIndexOrThrow("_data");
            cursor.moveToFirst();
            result = cursor.getString(column_index);
            cursor.close();
        }
        return result;
    }

    public static double getDeviceDPIFactor(Context context) {
        double result = 1.0;
        WindowManager windowManager = (WindowManager)context.getSystemService("window");
        DisplayMetrics metrics = new DisplayMetrics();
        windowManager.getDefaultDisplay().getMetrics(metrics);
        switch (metrics.densityDpi) {
            case 120: {
                result = 0.75;
                break;
            }
            case 160: {
                result = 1.0;
                break;
            }
            case 240: {
                result = 1.5;
                break;
            }
            case 320: {
                result = 2.0;
                break;
            }
            case 480: {
                result = 3.0;
                break;
            }
            case 640: {
                result = 4.0;
            }
        }
        return result;
    }

    public static String getGoogleAdvertisingID(Context context) {
        String GOOGLE_ADVERTISING_ID_KEY = "GOOGLE_ADVERTISING_ID_KEY";
        String result = SharedPreferencesUtils.loadSharedPreferencesData(context, GOOGLE_ADVERTISING_ID_KEY);
        if (result == null || result.equals("")) {
            SdkDeviceUtils.generateGoogleAdvertisingIDInBackground(context);
        }
        SDKLogger.printDebugLog(TAG, ">>>>Google advertising ID = " + result);
        return result;
    }

    public static synchronized void generateGoogleAdvertisingIDInBackground(final Context context) {
        if (context != null) {
            AsyncTask<Void, Void, Void> registerInBackground = new AsyncTask<Void, Void, Void>(){

                protected Void doInBackground(Void ... params) {
                    String GOOGLE_ADVERTISING_ID_KEY = "GOOGLE_ADVERTISING_ID_KEY";
                    try {
                        String googleAdvertisingID = CustomAdvertisingIdClient.getAdvertisingIdInfo(context).getId();
                        SharedPreferencesUtils.saveSharedPreferencesData(context, GOOGLE_ADVERTISING_ID_KEY, googleAdvertisingID);
                    }
                    catch (Exception ex) {
                        SDKLogger.printErrorLog(TAG, "Error when trying to get google advertising ID: " + ex.getMessage());
                    }
                    return null;
                }
            };
            registerInBackground.execute((Object[])new Void[]{null, null, null});
        }
    }

    public static File getInnerStoragePathIfPosible(Context context) {
        File filePath = null;
        try {
            File files = context.getFilesDir();
            filePath = new File(files.getAbsolutePath() + File.separator + "KsdkTemp");
            if (!filePath.exists()) {
                filePath.mkdirs();
            }
        }
        catch (Exception e2) {
            Log.d((String)"ahmed", (String)("assetFile | getInnerStoragePathIfPosible execption | " + e2.getLocalizedMessage()));
            SDKLogger.printErrorLog("Problem initiating storage location: \n\n" + e2.getMessage());
        }
        return filePath;
    }
}

