/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.api.general.utils;

import android.content.Context;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import com.kidoz.sdk.api.general.utils.SDKLogger;

public class OnSwipeTouchListener
implements View.OnTouchListener {
    private final GestureDetector gestureDetector;

    public OnSwipeTouchListener(Context context) {
        this.gestureDetector = new GestureDetector(context, (GestureDetector.OnGestureListener)new GestureListener());
    }

    public void onSwipeLeft() {
    }

    public void onSwipeRight() {
    }

    public boolean onTouch(View v, MotionEvent event) {
        this.gestureDetector.onTouchEvent(event);
        return false;
    }

    private final class GestureListener
    extends GestureDetector.SimpleOnGestureListener {
        private static final int SWIPE_DISTANCE_THRESHOLD = 90;
        private static final int SWIPE_VELOCITY_THRESHOLD = 80;

        private GestureListener() {
        }

        public boolean onDown(MotionEvent e2) {
            return true;
        }

        public boolean onFling(MotionEvent e1, MotionEvent e2, float velocityX, float velocityY) {
            SDKLogger.printWarningLog("FLING");
            float distanceX = e2.getX() - e1.getX();
            float distanceY = e2.getY() - e1.getY();
            if (Math.abs(distanceX) > Math.abs(distanceY) && Math.abs(distanceX) > 90.0f && Math.abs(velocityX) > 80.0f) {
                if (distanceX > 0.0f) {
                    OnSwipeTouchListener.this.onSwipeRight();
                } else {
                    OnSwipeTouchListener.this.onSwipeLeft();
                }
                return true;
            }
            return false;
        }
    }
}

