/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.api.general.utils;

import com.kidoz.sdk.api.general.utils.SDKLogger;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class EncoderUtils {
    public static final String TAG = EncoderUtils.class.getSimpleName();
    private static final int BYTE_MSK = 255;
    private static final int HEX_DIGIT_MASK = 15;
    private static final int HEX_DIGIT_BITS = 4;
    private static final String HEX_DIGITS = "0123456789ABCDEF";

    public static String SHA1(String text) {
        String result = null;
        try {
            result = EncoderUtils.computeSha1OfByteArray(text.getBytes("UTF-8"));
        }
        catch (Exception ex) {
            SDKLogger.printErrorLog(TAG, "Error when trying to convert string to SHA1: " + ex.getMessage());
        }
        return result;
    }

    private static String computeSha1OfByteArray(byte[] message) throws UnsupportedOperationException {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            md.update(message);
            byte[] res = md.digest();
            return EncoderUtils.toHexString(res);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new UnsupportedOperationException(ex);
        }
    }

    private static String toHexString(byte[] byteArray) {
        StringBuilder sb = new StringBuilder(byteArray.length * 2);
        for (byte aByteArray : byteArray) {
            int b2 = aByteArray & 0xFF;
            sb.append(HEX_DIGITS.charAt(b2 >>> 4)).append(HEX_DIGITS.charAt(b2 & 0xF));
        }
        return sb.toString();
    }

    public static String toMD5(String text) {
        String result = null;
        if (text != null) {
            try {
                MessageDigest messageDigest = MessageDigest.getInstance("MD5");
                messageDigest.reset();
                messageDigest.update(text.getBytes());
                byte[] resultBytes = messageDigest.digest();
                BigInteger number = new BigInteger(1, resultBytes);
                String encriptedResult = number.toString(16);
                while (encriptedResult.length() < 32) {
                    encriptedResult = "0" + encriptedResult;
                }
                result = encriptedResult;
            }
            catch (Exception ex) {
                SDKLogger.printErrorLog(TAG, "Can't create MD5: " + ex.getMessage());
            }
        }
        return result;
    }

    public static String encryptWithMD5(String text) {
        String result = null;
        if (text != null) {
            try {
                MessageDigest messageDigest = MessageDigest.getInstance("MD5");
                messageDigest.reset();
                messageDigest.update(text.getBytes());
                byte[] resultBytes = messageDigest.digest();
                BigInteger number = new BigInteger(1, resultBytes);
                String encriptedResult = number.toString(16);
                while (encriptedResult.length() < 32) {
                    encriptedResult = "0" + encriptedResult;
                }
                result = encriptedResult;
            }
            catch (Exception ex) {
                SDKLogger.printErrorLog("Can't create MD5: " + ex.getMessage());
            }
        }
        return result;
    }
}

