/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.api.general.cache;

import android.os.Handler;
import android.os.Looper;

public abstract class CustomAsyncExecutor<S, T> {
    private Looper looper;
    private Handler handler;
    private Thread thread;
    private Runnable currentThreadRunnable;
    private Runnable workerThreadRunnable;
    private S input = null;
    private T result = null;

    public abstract T executeAsync(S var1);

    public abstract void postExecute(T var1);

    public void execute(S input) {
        this.input = input;
        this.execute();
    }

    public void execute() {
        this.init();
        this.thread.start();
    }

    private void init() {
        this.looper = Looper.getMainLooper();
        this.handler = new Handler(this.looper);
        this.currentThreadRunnable = new Runnable(){

            @Override
            public void run() {
                CustomAsyncExecutor.this.postExecute(CustomAsyncExecutor.this.result);
            }
        };
        this.workerThreadRunnable = new Runnable(){

            @Override
            public void run() {
                CustomAsyncExecutor.this.result = CustomAsyncExecutor.this.executeAsync(CustomAsyncExecutor.this.input);
                Thread currentThread = CustomAsyncExecutor.this.handler.getLooper().getThread();
                if (currentThread != null && currentThread.isAlive()) {
                    CustomAsyncExecutor.this.handler.post(CustomAsyncExecutor.this.currentThreadRunnable);
                }
            }
        };
        this.thread = new Thread(this.workerThreadRunnable);
    }
}

