/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.api.general.cache;

import android.content.ContentValues;
import android.net.Uri;
import com.kidoz.sdk.api.general.cache.CustomAsyncExecutor;
import com.kidoz.sdk.api.general.cache.DataRequestResult;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Iterator;
import java.util.Set;

public abstract class BaseDataRequest<T> {
    private String mUrl;
    private ContentValues mContentValues;
    private static final int IO_BUFFER_SIZE = 4096;

    public BaseDataRequest(String url, ContentValues contentValues) {
        this.mUrl = url;
        this.mContentValues = contentValues;
    }

    public BaseDataRequest(String url) {
        this.mUrl = url;
        this.mContentValues = null;
    }

    protected void setUrl(String url) {
        this.mUrl = url;
    }

    protected String getUrl() {
        return this.mUrl;
    }

    protected void setContentValues(ContentValues contentValues) {
        this.mContentValues = contentValues;
    }

    protected abstract T parseDataResult(String var1);

    protected T executePrivate() {
        String resultStr = this.makeGetConnection(this.mUrl, this.mContentValues);
        T object = null;
        if (resultStr != null) {
            object = this.parseDataResult(resultStr);
        }
        return object;
    }

    public T executeRequest() {
        return this.executePrivate();
    }

    public void executeRequestAsync(final DataRequestResult<T> result) {
        CustomAsyncExecutor customAsyncExecutor = new CustomAsyncExecutor<Void, T>(){

            @Override
            public T executeAsync(Void input) {
                return BaseDataRequest.this.executeRequest();
            }

            @Override
            public void postExecute(T resultData) {
                if (result != null) {
                    result.onResult(resultData);
                }
            }
        };
        customAsyncExecutor.execute(null);
    }

    protected String makeGetConnection(String url, ContentValues contentValues) {
        String response = null;
        StringBuilder sb = new StringBuilder(url);
        if (contentValues != null && contentValues.size() > 0) {
            String val;
            sb.append("?");
            Set set = contentValues.keySet();
            Iterator iter = set.iterator();
            if (iter.hasNext()) {
                val = (String)iter.next();
                sb.append(val).append("=").append(Uri.encode((String)contentValues.getAsString(val)));
            }
            while (iter.hasNext()) {
                val = (String)iter.next();
                sb.append("&");
                sb.append(val).append("=").append(Uri.encode((String)contentValues.getAsString(val)));
            }
        }
        try {
            URL mUrl = new URL(sb.toString());
            HttpURLConnection httpConnection = (HttpURLConnection)mUrl.openConnection();
            httpConnection.setRequestMethod("GET");
            httpConnection.setRequestProperty("Content-length", "0");
            httpConnection.setChunkedStreamingMode(0);
            httpConnection.setUseCaches(false);
            httpConnection.setAllowUserInteraction(false);
            httpConnection.setConnectTimeout(10000);
            httpConnection.setReadTimeout(10000);
            httpConnection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            httpConnection.connect();
            int responseCode = httpConnection.getResponseCode();
            if (responseCode == 200) {
                response = this.readStream(new BufferedInputStream(httpConnection.getInputStream()));
            }
            httpConnection.disconnect();
        }
        catch (IOException e2) {
            response = null;
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readStream(BufferedInputStream is) {
        ByteArrayOutputStream bo = null;
        boolean isCanceled = false;
        try {
            byte[] buffer = new byte[4096];
            bo = new ByteArrayOutputStream(is.available());
            int i = is.read(buffer);
            while (i > 0) {
                bo.write(buffer, 0, i);
                i = is.read(buffer);
            }
            if (isCanceled) {
                String string = null;
                return string;
            }
            String string = bo.toString();
            return string;
        }
        catch (IOException e2) {
            String string = null;
            return string;
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
                if (bo != null) {
                    bo.close();
                }
            }
            catch (IOException iOException) {}
        }
    }
}

