/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.api.general;

import android.app.Activity;
import android.graphics.Rect;
import android.os.Build;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import com.kidoz.sdk.api.general.IViewCoveredListener;
import com.kidoz.sdk.api.general.IViewVisibilityEventListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ViewVisibilityEventListener {
    private View mView;
    private ViewTreeObserver mViewTreeObserver;
    private IViewVisibilityEventListener mIViewVisibilityEventListener;
    private IViewCoveredListener mIViewCoveredListener;
    private ViewTreeObserver.OnWindowAttachListener mOnWindowAttachListener;
    private ViewTreeObserver.OnWindowFocusChangeListener mOnWindowFocusChangeListener;
    private ViewTreeObserver.OnGlobalLayoutListener mOnGlobalLayoutListener;
    private ViewState mViewState = ViewState.UNKNOWN;

    private void initOnGlobalLayoutListener(ViewTreeObserver viewTreeObserver) {
        this.mOnGlobalLayoutListener = null;
        this.mOnGlobalLayoutListener = new ViewTreeObserver.OnGlobalLayoutListener(){

            public void onGlobalLayout() {
                try {
                    if (ViewVisibilityEventListener.this.mView.isShown()) {
                        View view;
                        View decorView = ((Activity)ViewVisibilityEventListener.this.mView.getContext()).getWindow().getDecorView();
                        List viewList = ViewVisibilityEventListener.this.getAllChildren(decorView);
                        boolean isBlocked = false;
                        Iterator iterator = viewList.iterator();
                        while (!(!iterator.hasNext() || (view = (View)iterator.next()).hashCode() != ViewVisibilityEventListener.this.mView.hashCode() && view.isShown() && (double)view.getAlpha() > 0.0 && ViewVisibilityEventListener.this.isViewOverlapping(view, ViewVisibilityEventListener.this.mView) && (isBlocked = ViewVisibilityEventListener.this.isViewBlocked(ViewVisibilityEventListener.this.mView, view)))) {
                        }
                        if (ViewVisibilityEventListener.this.mIViewCoveredListener != null) {
                            if (isBlocked) {
                                ViewVisibilityEventListener.this.mIViewCoveredListener.onViewCovered(true);
                            } else {
                                ViewVisibilityEventListener.this.mIViewCoveredListener.onViewCovered(false);
                            }
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        viewTreeObserver.addOnGlobalLayoutListener(this.mOnGlobalLayoutListener);
    }

    private boolean isViewOverlapping(View firstView, View secondView) {
        int[] location = new int[2];
        firstView.getLocationInWindow(location);
        Rect rect1 = new Rect(location[0], location[1], location[0] + firstView.getWidth(), location[1] + firstView.getHeight());
        secondView.getLocationInWindow(location);
        Rect rect2 = new Rect(location[0], location[1], location[0] + secondView.getWidth(), location[1] + secondView.getHeight());
        return rect1.intersect(rect2);
    }

    private boolean isViewVisible(View view) {
        boolean isVisible = false;
        if (view.isShown()) {
            if (view.getBackground() != null) {
                if (view.getBackground().getOpacity() > 0) {
                    isVisible = true;
                }
                if (Build.VERSION.SDK_INT >= 19 && (float)view.getBackground().getAlpha() * view.getAlpha() > 0.0f) {
                    isVisible = true;
                }
            } else if (view.getAlpha() > 0.0f) {
                isVisible = true;
            }
        }
        return isVisible;
    }

    private boolean isViewBlocked(View firstView, View secondView) {
        while (firstView.getParent() != null && firstView.getParent() instanceof ViewGroup) {
            View tempView = secondView;
            while (tempView.getParent() != null && tempView.getParent() instanceof ViewGroup) {
                int secondIndex;
                int firstIndex;
                if (tempView.hashCode() != firstView.hashCode() && tempView.getParent().hashCode() == firstView.getParent().hashCode() && (firstIndex = ((ViewGroup)firstView.getParent()).indexOfChild(firstView)) < (secondIndex = ((ViewGroup)firstView.getParent()).indexOfChild(tempView)) && this.isViewVisible(tempView)) {
                    return true;
                }
                tempView = (View)tempView.getParent();
            }
            firstView = (View)firstView.getParent();
        }
        return false;
    }

    private List<View> getAllChildren(View v) {
        if (!(v instanceof ViewGroup)) {
            ArrayList<View> viewArrayList = new ArrayList<View>();
            viewArrayList.add(v);
            return viewArrayList;
        }
        ArrayList<View> result = new ArrayList<View>();
        ViewGroup viewGroup = (ViewGroup)v;
        for (int i = 0; i < viewGroup.getChildCount(); ++i) {
            View child = viewGroup.getChildAt(i);
            result.add(child);
            result.addAll(this.getAllChildren(child));
        }
        return result;
    }

    private void initOnWindowAttachListener(ViewTreeObserver viewTreeObserver) {
        if (Build.VERSION.SDK_INT >= 18) {
            this.mOnWindowAttachListener = null;
            this.mOnWindowAttachListener = new ViewTreeObserver.OnWindowAttachListener(){

                public void onWindowAttached() {
                    if (ViewVisibilityEventListener.this.mViewState == ViewState.UNKNOWN || ViewVisibilityEventListener.this.mViewState == ViewState.NOT_VISIBLE) {
                        ViewVisibilityEventListener.this.mViewState = ViewState.VISIBLE;
                        if (ViewVisibilityEventListener.this.mIViewVisibilityEventListener != null) {
                            ViewVisibilityEventListener.this.mIViewVisibilityEventListener.onViewBecameVisible(true);
                        }
                    }
                }

                public void onWindowDetached() {
                    if (ViewVisibilityEventListener.this.mViewState == ViewState.UNKNOWN || ViewVisibilityEventListener.this.mViewState == ViewState.VISIBLE) {
                        ViewVisibilityEventListener.this.mViewState = ViewState.NOT_VISIBLE;
                        if (ViewVisibilityEventListener.this.mIViewVisibilityEventListener != null) {
                            ViewVisibilityEventListener.this.mIViewVisibilityEventListener.onViewBecameVisible(false);
                        }
                    }
                }
            };
            viewTreeObserver.addOnWindowAttachListener(this.mOnWindowAttachListener);
        }
    }

    private void initOnWindowFocusChangeListener(ViewTreeObserver viewTreeObserver) {
        if (Build.VERSION.SDK_INT >= 18) {
            this.mOnWindowFocusChangeListener = null;
            this.mOnWindowFocusChangeListener = new ViewTreeObserver.OnWindowFocusChangeListener(){

                public void onWindowFocusChanged(boolean hasFocus) {
                    if (!hasFocus) {
                        if (ViewVisibilityEventListener.this.mViewState == ViewState.UNKNOWN || ViewVisibilityEventListener.this.mViewState == ViewState.VISIBLE) {
                            ViewVisibilityEventListener.this.mViewState = ViewState.NOT_VISIBLE;
                            if (ViewVisibilityEventListener.this.mIViewVisibilityEventListener != null) {
                                ViewVisibilityEventListener.this.mIViewVisibilityEventListener.onViewBecameVisible(false);
                            }
                        }
                    } else if (ViewVisibilityEventListener.this.mViewState == ViewState.UNKNOWN || ViewVisibilityEventListener.this.mViewState == ViewState.NOT_VISIBLE) {
                        ViewVisibilityEventListener.this.mViewState = ViewState.VISIBLE;
                        if (ViewVisibilityEventListener.this.mIViewVisibilityEventListener != null) {
                            ViewVisibilityEventListener.this.mIViewVisibilityEventListener.onViewBecameVisible(true);
                        }
                    }
                }
            };
            viewTreeObserver.addOnWindowFocusChangeListener(this.mOnWindowFocusChangeListener);
        }
    }

    public ViewVisibilityEventListener(View view) {
        this.mView = view;
        this.mViewTreeObserver = view.getViewTreeObserver();
        this.initialiseListeners();
    }

    public void setViewVisibilityEventListener(IViewVisibilityEventListener iViewVisibilityEventListener) {
        this.mIViewVisibilityEventListener = iViewVisibilityEventListener;
    }

    public void setViewCoveredListener(IViewCoveredListener iViewCoveredListener) {
        this.mIViewCoveredListener = iViewCoveredListener;
        this.initOnGlobalLayoutListener(this.mViewTreeObserver);
    }

    private void initWithViewTreeObserver(ViewTreeObserver viewTreeObserver) {
        this.initOnWindowFocusChangeListener(viewTreeObserver);
        this.initOnWindowAttachListener(viewTreeObserver);
    }

    private void removeViewTreeObserver(ViewTreeObserver viewTreeObserver) {
        if (Build.VERSION.SDK_INT >= 18) {
            if (this.mOnWindowAttachListener != null) {
                viewTreeObserver.removeOnWindowAttachListener(this.mOnWindowAttachListener);
            }
            if (this.mOnWindowFocusChangeListener != null) {
                viewTreeObserver.removeOnWindowFocusChangeListener(this.mOnWindowFocusChangeListener);
            }
        }
    }

    private void initialiseListeners() {
        if (Build.VERSION.SDK_INT >= 18) {
            this.mView.addOnAttachStateChangeListener(new View.OnAttachStateChangeListener(){

                public void onViewAttachedToWindow(View v) {
                    ViewVisibilityEventListener.this.mViewTreeObserver = ViewVisibilityEventListener.this.mView.getViewTreeObserver();
                    ViewVisibilityEventListener.this.initWithViewTreeObserver(ViewVisibilityEventListener.this.mViewTreeObserver);
                    if (ViewVisibilityEventListener.this.mViewState == ViewState.UNKNOWN || ViewVisibilityEventListener.this.mViewState == ViewState.NOT_VISIBLE) {
                        ViewVisibilityEventListener.this.mViewState = ViewState.VISIBLE;
                        if (ViewVisibilityEventListener.this.mIViewVisibilityEventListener != null) {
                            ViewVisibilityEventListener.this.mIViewVisibilityEventListener.onViewBecameVisible(true);
                        }
                    }
                }

                public void onViewDetachedFromWindow(View v) {
                    if (ViewVisibilityEventListener.this.mViewState == ViewState.UNKNOWN || ViewVisibilityEventListener.this.mViewState == ViewState.VISIBLE) {
                        ViewVisibilityEventListener.this.mViewState = ViewState.NOT_VISIBLE;
                        if (ViewVisibilityEventListener.this.mIViewVisibilityEventListener != null) {
                            ViewVisibilityEventListener.this.mIViewVisibilityEventListener.onViewBecameVisible(false);
                        }
                    }
                    ViewVisibilityEventListener.this.removeViewTreeObserver(ViewVisibilityEventListener.this.mViewTreeObserver);
                }
            });
        }
    }

    public static enum ViewState {
        UNKNOWN,
        NOT_VISIBLE,
        VISIBLE;

    }
}

