/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.api.ui_views.new_kidoz_banner;

import android.app.Activity;
import android.content.Context;
import android.os.Handler;
import android.text.TextUtils;
import android.view.View;
import com.kidoz.sdk.api.KidozSDK;
import com.kidoz.sdk.api.general.EventMessage;
import com.kidoz.sdk.api.general.assets_handling.AssetUtil;
import com.kidoz.sdk.api.general.database.DatabaseManager;
import com.kidoz.sdk.api.general.enums.WidgetType;
import com.kidoz.sdk.api.general.utils.SDKLogger;
import com.kidoz.sdk.api.ui_views.html_view.HtmlViewWrapper;
import com.kidoz.sdk.api.ui_views.html_view.IOnHtmlWebViewInterface;
import com.kidoz.sdk.api.ui_views.kidoz_banner.KidozBannerListener;
import com.kidoz.sdk.api.ui_views.new_kidoz_banner.KidozBannerView;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.greenrobot.eventbus.EventBus;
import org.greenrobot.eventbus.Subscribe;
import org.json.JSONObject;

public class KidozBannerPresenter {
    public static final String TAG = "KidozBannerPresenter";
    private static final String BANNER_LOAD_FAILED_EMPTY_URL = "KidozBanner | Kidoz cannot load banner content. Configuration url is empty.";
    private static final String BANNER_LOAD_FAILED_STYLE_ERROR = "KidozBanner | Kidoz cannot load banner content. Style parsing failed.";
    private static final String VIEW_ALREADY_LOADING = "KidozBanner | Kidoz banner already loading, please wait.";
    private static final String VIEW_ALREADY_LOADED = "KidozBanner | Kidoz banner already loaded, no need to load again.";
    private static final String VIEW_NOT_LOADED_PLEASE_LOAD = "KidozBanner | Kidoz banner not loaded, please load before showing.";
    private static final String VIEW_STILL_LOADING_PLEASE_WAIT = "KidozBanner | Kidoz banner is still loading, please wait for load to finish.";
    private static final String VIEW_ALREADY_SHOWING = "KidozBanner | Kidoz banner is showing, please close banner before loading another one.";
    private static final String SDK_NOT_INIT = "KidozBanner | Kidoz banner not loaded, please call method only after sdk init.";
    private static final String VIEW_NOTHING_TO_HIDE = "KidozBanner | Kidoz banner not shown, there is nothing to hide.";
    private static final String VIEW_IN_ERROR_STATE_CANNOT_SHOW = "Cannot show banner, banner is in ERROR state.";
    private KidozBannerView mKidozBannerView;
    private Activity mActivity;
    protected Lock raceConditionLock = new ReentrantLock();
    private JSONObject mProperties;
    private String mStyleId;
    private String mBannerHtmlUrl;
    private IOnHtmlWebViewInterface mHtmlWebViewListener;
    private KidozBannerListener mKidozBannerListener;
    private InternalLoadWaitForConditionsListener mBannerInternalListener;
    private VIEW_STATE mViewState = VIEW_STATE.CLOSED;
    private static final long WEBVIEW_ALIVE_RETRY_INTERVAL_MILLIS = 2000L;
    private static final int WEBVIEW_ALIVE_RETRY_MAX = 5;
    private boolean mDidGetCallbackAliveSignal;
    private boolean mDidGetOnViewReady;
    private int mWebViewAliveRetry;

    public KidozBannerPresenter(KidozBannerView kidozBannerView) {
        this.mKidozBannerView = kidozBannerView;
        this.mKidozBannerView.setOnFocusChangeListener(new View.OnFocusChangeListener(){

            public void onFocusChange(View v, boolean hasFocus) {
                SDKLogger.printDebugLog("TAG", "********************************");
            }
        });
        this.mActivity = this.mKidozBannerView.getActivity();
        this.mDidGetOnViewReady = false;
        this.mDidGetCallbackAliveSignal = false;
        this.mWebViewAliveRetry = 0;
    }

    public boolean isShowing() {
        return this.mViewState == VIEW_STATE.SHOWING;
    }

    public void init() {
        this.mViewState = VIEW_STATE.CLOSED;
        SDKLogger.printDebugLog("KidozBannerPresenter | banner init()");
        if (!KidozSDK.isInitialised()) {
            SDKLogger.printDebugLog("KidozBannerPresenter | sdk not init yet, registering event.");
            if (!EventBus.getDefault().isRegistered((Object)this)) {
                EventBus.getDefault().register((Object)this);
            }
            return;
        }
        this.validateSDKAndStartBannerWebLogic();
    }

    private void validateSDKAndStartBannerWebLogic() {
        this.validateAndLoadAssets(new BannerStyleListener(){

            @Override
            public void onStyleSuccess() {
                KidozBannerPresenter.this.extractParamsFromConfig();
                if (TextUtils.isEmpty((CharSequence)KidozBannerPresenter.this.mBannerHtmlUrl)) {
                    SDKLogger.printErrorLog(KidozBannerPresenter.BANNER_LOAD_FAILED_EMPTY_URL);
                    KidozBannerPresenter.this.mViewState = VIEW_STATE.ERROR;
                    return;
                }
                KidozBannerPresenter.this.waitForWebViewOk();
                this.startBannerWebLogic();
            }

            private void startBannerWebLogic() {
                String finalUrl = KidozBannerPresenter.this.mBannerHtmlUrl;
                SDKLogger.printDebugLog(KidozBannerPresenter.TAG, "view.load(" + finalUrl + ")");
                KidozBannerPresenter.this.mKidozBannerView.startBannerWebLogic(finalUrl);
            }

            @Override
            public void onStyleError() {
                SDKLogger.printErrorLog(KidozBannerPresenter.BANNER_LOAD_FAILED_STYLE_ERROR);
                KidozBannerPresenter.this.mViewState = VIEW_STATE.ERROR;
                if (KidozBannerPresenter.this.mBannerInternalListener != null) {
                    KidozBannerPresenter.this.mBannerInternalListener.onConditionsFail();
                    KidozBannerPresenter.this.mBannerInternalListener = null;
                }
            }
        });
    }

    private void waitForWebViewOk() {
        new Handler().postDelayed(new Runnable(){

            @Override
            public void run() {
                if (!KidozBannerPresenter.this.mDidGetCallbackAliveSignal && KidozBannerPresenter.this.mWebViewAliveRetry < 5) {
                    SDKLogger.printDebugLog("KidozBannerPresenter | calling check, try no. " + KidozBannerPresenter.this.mWebViewAliveRetry);
                    KidozBannerPresenter.this.mKidozBannerView.invokeUrlInWebView("check()", new HtmlViewWrapper.BannerInvokeUrlInterface(){

                        @Override
                        public void onResponse(String response) {
                            if (!TextUtils.isEmpty((CharSequence)response)) {
                                SDKLogger.printDebugLog("KidozBannerPresenter | mDidGetCallbackAliveSignal = true");
                                KidozBannerPresenter.this.mDidGetCallbackAliveSignal = true;
                                KidozBannerPresenter.this.checkConditionsForBannerReady();
                            }
                        }
                    });
                    KidozBannerPresenter.this.mWebViewAliveRetry++;
                    KidozBannerPresenter.this.waitForWebViewOk();
                }
            }
        }, 2000L);
    }

    private void checkConditionsForBannerReady() {
        SDKLogger.printDebugLog("KidozBannerPresenter | checkConditionsForBannerReady..");
        if (this.mDidGetCallbackAliveSignal && this.mDidGetOnViewReady) {
            SDKLogger.printDebugLog("KidozBannerPresenter | checkConditionsForBannerReady 1");
            if (this.mBannerInternalListener != null) {
                SDKLogger.printDebugLog("KidozBannerPresenter | checkConditionsForBannerReady 2");
                this.mBannerInternalListener.onConditionsSuccess();
                this.mBannerInternalListener = null;
            }
        }
    }

    public void load(final HtmlViewWrapper htmlViewWrapper) {
        SDKLogger.printDebugLog("KidozBannerPresenter | Load 3");
        if (!KidozSDK.isInitialised()) {
            SDKLogger.printDebugLog(SDK_NOT_INIT);
            return;
        }
        SDKLogger.printDebugLog("KidozBannerPresenter | Load 4");
        if (this.mViewState == VIEW_STATE.SHOWING) {
            SDKLogger.printDebugLog(VIEW_ALREADY_SHOWING);
            return;
        }
        SDKLogger.printDebugLog("KidozBannerPresenter | Load 5");
        if (this.mViewState == VIEW_STATE.LOADING) {
            SDKLogger.printDebugLog(VIEW_ALREADY_LOADING);
            return;
        }
        SDKLogger.printDebugLog("KidozBannerPresenter | Load 6");
        if (this.mViewState == VIEW_STATE.LOADED) {
            SDKLogger.printDebugLog(VIEW_ALREADY_LOADED);
            return;
        }
        SDKLogger.printDebugLog("KidozBannerPresenter | Load 0");
        this.mBannerInternalListener = new InternalLoadWaitForConditionsListener(){

            @Override
            public void onConditionsSuccess() {
                SDKLogger.printDebugLog("KidozBannerPresenter | Load 1");
                KidozBannerPresenter.this.internalLoad(htmlViewWrapper);
            }

            @Override
            public void onConditionsFail() {
                SDKLogger.printDebugLog("KidozBannerPresenter | Load 2");
                if (KidozBannerPresenter.this.mKidozBannerListener != null) {
                    KidozBannerPresenter.this.mKidozBannerListener.onBannerError(KidozBannerPresenter.BANNER_LOAD_FAILED_STYLE_ERROR);
                }
            }
        };
        SDKLogger.printDebugLog("KidozBannerPresenter | Load 7");
        this.internalLoad(htmlViewWrapper);
    }

    private boolean isSDKConfigRelevantParsingDone() {
        return this.mProperties != null;
    }

    public void show(final HtmlViewWrapper htmlViewWrapper) {
        SDKLogger.printDebugLog("KidozBannerPresenter | Show 0");
        if (!KidozSDK.isInitialised()) {
            SDKLogger.printDebugLog(SDK_NOT_INIT);
            return;
        }
        SDKLogger.printDebugLog("KidozBannerPresenter | Show 1");
        if (this.mViewState == VIEW_STATE.ERROR) {
            SDKLogger.printDebugLog(VIEW_IN_ERROR_STATE_CANNOT_SHOW);
            return;
        }
        SDKLogger.printDebugLog("KidozBannerPresenter | Show 2");
        if (this.mViewState == VIEW_STATE.CLOSED) {
            SDKLogger.printDebugLog(VIEW_NOT_LOADED_PLEASE_LOAD);
            return;
        }
        SDKLogger.printDebugLog("KidozBannerPresenter | Show 3");
        if (this.mViewState == VIEW_STATE.LOADING) {
            SDKLogger.printDebugLog(VIEW_STILL_LOADING_PLEASE_WAIT);
            return;
        }
        SDKLogger.printDebugLog("KidozBannerPresenter | Show 4");
        if (this.mViewState == VIEW_STATE.SHOWING) {
            SDKLogger.printDebugLog(VIEW_ALREADY_SHOWING);
            return;
        }
        SDKLogger.printDebugLog("KidozBannerPresenter | Show 5");
        htmlViewWrapper.showBanner(new HtmlViewWrapper.BannerShowJSInterface(){

            @Override
            public void onSuccess() {
                SDKLogger.printDebugLog("KidozBannerPresenter | Show onSuccess()");
                htmlViewWrapper.requestWidgetOpen(WidgetType.WIDGET_TYPE_BANNER.getStringValue());
                KidozBannerPresenter.this.mViewState = VIEW_STATE.SHOWING;
                KidozBannerPresenter.this.mKidozBannerView.nativeShow();
            }

            @Override
            public void onError(String errorMsg) {
                SDKLogger.printErrorLog("KidozBannerPresenter | Show onError: " + errorMsg);
                KidozBannerPresenter.this.mViewState = VIEW_STATE.ERROR;
            }
        });
    }

    public void developerCalledHide(HtmlViewWrapper htmlViewWrapper) {
        if (!KidozSDK.isInitialised()) {
            SDKLogger.printDebugLog(SDK_NOT_INIT);
            return;
        }
        if (this.mViewState != VIEW_STATE.SHOWING) {
            SDKLogger.printDebugLog(VIEW_NOTHING_TO_HIDE);
            return;
        }
        htmlViewWrapper.requestWidgetClose(WidgetType.WIDGET_TYPE_BANNER.getStringValue());
        htmlViewWrapper.hideBanner();
    }

    private void internalLoad(HtmlViewWrapper htmlViewWrapper) {
        this.mViewState = VIEW_STATE.LOADING;
        SDKLogger.printDebugLog(TAG, "internalLoad() | calling html.loadBanner, mProperties = " + this.mProperties);
        htmlViewWrapper.loadBanner(this.mProperties, new HtmlViewWrapper.BannerLoadJSInterface(){

            @Override
            public void onSuccess() {
                SDKLogger.printDebugLog(KidozBannerPresenter.TAG, "internalLoad() | onSuccess()");
                KidozBannerPresenter.this.mViewState = VIEW_STATE.LOADED;
                if (KidozBannerPresenter.this.mKidozBannerListener != null) {
                    KidozBannerPresenter.this.mKidozBannerListener.onBannerReady();
                }
            }

            @Override
            public void onError(String errorMsg) {
                SDKLogger.printErrorLog(KidozBannerPresenter.TAG, "internalLoad() | error: = " + errorMsg);
                KidozBannerPresenter.this.mViewState = VIEW_STATE.ERROR;
                if (KidozBannerPresenter.this.mKidozBannerListener != null) {
                    KidozBannerPresenter.this.mKidozBannerListener.onBannerError(errorMsg);
                }
            }

            @Override
            public void onNoOffers() {
                SDKLogger.printErrorLog(KidozBannerPresenter.TAG, "internalLoad() | error: = onNoOffers");
                KidozBannerPresenter.this.mViewState = VIEW_STATE.ERROR;
                if (KidozBannerPresenter.this.mKidozBannerListener != null) {
                    KidozBannerPresenter.this.mKidozBannerListener.onBannerNoOffers();
                }
            }
        });
    }

    private void validateAndLoadAssets(final BannerStyleListener bannerStyleListener) {
        SDKLogger.printDebugLog(TAG, "validateAndLoadAssets() | start");
        if (this.raceConditionLock.tryLock()) {
            try {
                AssetUtil.parseStyleAsync((Context)this.mActivity, AssetUtil.ParserAsyncTask.StyleType.BANNER_STYLE, new AssetUtil.ParserAsyncTask.IOnStyleParseListener(){

                    @Override
                    public void onParseFinished(boolean success) {
                        if (success) {
                            KidozBannerPresenter.this.mProperties = DatabaseManager.getInstance((Context)KidozBannerPresenter.this.mActivity).getConfigTable().loadProperties(KidozBannerPresenter.TAG);
                            SDKLogger.printDebugLog("KidozBannerPresenter | mProperties = " + KidozBannerPresenter.this.mProperties.toString());
                            SDKLogger.printDebugLog(KidozBannerPresenter.TAG, "validateAndLoadAssets() | parse success");
                            if (bannerStyleListener != null) {
                                bannerStyleListener.onStyleSuccess();
                            }
                        } else {
                            SDKLogger.printDebugLog(KidozBannerPresenter.TAG, "validateAndLoadAssets() | parse failed");
                            if (bannerStyleListener != null) {
                                bannerStyleListener.onStyleError();
                            }
                        }
                    }
                });
            }
            finally {
                this.raceConditionLock.unlock();
            }
        }
    }

    private void extractParamsFromConfig() {
        if (this.mProperties != null) {
            this.mStyleId = this.mProperties.optString("style_id");
            this.mBannerHtmlUrl = this.mProperties.optString("html_url");
        }
    }

    protected void notifyViewAdded() {
        if (this.mKidozBannerListener != null) {
            this.mKidozBannerListener.onBannerViewAdded();
        }
    }

    public IOnHtmlWebViewInterface getHtmlWebViewInterface() {
        if (this.mHtmlWebViewListener == null) {
            this.mHtmlWebViewListener = new IOnHtmlWebViewInterface(){

                @Override
                public void onHtmlFinishedLoading() {
                    super.onHtmlFinishedLoading();
                    SDKLogger.printDebugLog("KidozBanner | IOnHtmlWebViewInterface | onHtmlFinishedLoading()");
                }

                @Override
                public void onViewReady() {
                    super.onViewReady();
                    SDKLogger.printDebugLog("KidozBanner | IOnHtmlWebViewInterface | onViewReady()");
                    KidozBannerPresenter.this.mDidGetOnViewReady = true;
                    KidozBannerPresenter.this.checkConditionsForBannerReady();
                }

                @Override
                public void onErrorReceived() {
                    super.onErrorReceived();
                    KidozBannerPresenter.this.mViewState = VIEW_STATE.ERROR;
                    if (KidozBannerPresenter.this.mKidozBannerListener != null) {
                        KidozBannerPresenter.this.mKidozBannerListener.onBannerError("Unknown JS Error.");
                    }
                    SDKLogger.printDebugLog("KidozBanner | IOnHtmlWebViewInterface | onErrorReceived()");
                }

                @Override
                public void onClose() {
                    super.onClose();
                    KidozBannerPresenter.this.mViewState = VIEW_STATE.CLOSED;
                    KidozBannerPresenter.this.mKidozBannerView.hideInternal();
                    if (KidozBannerPresenter.this.mKidozBannerListener != null) {
                        KidozBannerPresenter.this.mKidozBannerListener.onBannerClose();
                    }
                }
            };
        }
        return this.mHtmlWebViewListener;
    }

    public void setBannerListener(KidozBannerListener bannerListener) {
        this.mKidozBannerListener = bannerListener;
    }

    @Subscribe
    public void onHandleEvent(EventMessage event) {
        if (event.getMessageType() == EventMessage.MessageType.INIT_SDK) {
            if (EventBus.getDefault().isRegistered((Object)this)) {
                EventBus.getDefault().unregister((Object)this);
            }
            SDKLogger.printDebugLog("KidozBanner | Kidoz wasn't init when presenter was built. calling init() from eventbus after sdk init");
            this.init();
        }
    }

    private static interface BannerStyleListener {
        public void onStyleSuccess();

        public void onStyleError();
    }

    private static interface InternalLoadWaitForConditionsListener {
        public void onConditionsSuccess();

        public void onConditionsFail();
    }

    public static enum VIEW_STATE {
        LOADING,
        LOADED,
        SHOWING,
        CLOSED,
        ERROR,
        HIDDEN;

    }
}

