/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.api.ui_views.html_view;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.Point;
import android.net.Uri;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.JavascriptInterface;
import android.webkit.ValueCallback;
import android.webkit.WebResourceResponse;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.RelativeLayout;
import com.kidoz.events.Event;
import com.kidoz.events.EventManager;
import com.kidoz.sdk.api.KidozSDK;
import com.kidoz.sdk.api.dialogs.AboutKidozDialog;
import com.kidoz.sdk.api.dialogs.ParentalLockDialog;
import com.kidoz.sdk.api.general.ContentExecutionHandler;
import com.kidoz.sdk.api.general.EventMessage;
import com.kidoz.sdk.api.general.WidgetEventMessage;
import com.kidoz.sdk.api.general.cache.CacheWebViewFactory;
import com.kidoz.sdk.api.general.database.DatabaseManager;
import com.kidoz.sdk.api.general.enums.ContentType;
import com.kidoz.sdk.api.general.enums.WidgetType;
import com.kidoz.sdk.api.general.utils.ConstantDef;
import com.kidoz.sdk.api.general.utils.KidozParams;
import com.kidoz.sdk.api.general.utils.SDKLogger;
import com.kidoz.sdk.api.general.utils.ScreenUtils;
import com.kidoz.sdk.api.general.utils.SdkCookieManager;
import com.kidoz.sdk.api.general.utils.SdkDeviceUtils;
import com.kidoz.sdk.api.general.utils.StorageLife;
import com.kidoz.sdk.api.general.utils.Utils;
import com.kidoz.sdk.api.players.web_player.WebViewVisibilityListener;
import com.kidoz.sdk.api.server_connect.SdkAPIManager;
import com.kidoz.sdk.api.structure.ContentItem;
import com.kidoz.sdk.api.structure.IsEventRecord;
import com.kidoz.sdk.api.ui_views.html_view.HtmlFiveWebView;
import com.kidoz.sdk.api.ui_views.html_view.HtmlJavaScriptInterafce;
import com.kidoz.sdk.api.ui_views.html_view.IOnHtmlWebViewInterface;
import com.kidoz.sdk.api.ui_views.loading_progress_view.LoadingProgressView;
import com.kidoz.sdk.api.ui_views.one_item_view.ItemViewPagerAdapter;
import com.kidoz.sdk.api.ui_views.web_view_clients.KidozWebChromeClient;
import java.lang.ref.SoftReference;
import java.net.URLDecoder;
import java.util.LinkedHashMap;
import java.util.Locale;
import org.greenrobot.eventbus.EventBus;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class HtmlViewWrapper
extends RelativeLayout
implements HtmlJavaScriptInterafce {
    private static final String JS_OBJECT_NAME = "KidozAndroid";
    protected static final float LOADING_PROGRESS_DEFAULT_RATIO = 0.35f;
    protected static final int ON_LOAD_FINISHED = 0;
    protected static final int ON_LOAD_STARTED = 1;
    protected static final int ON_VIEW_READY = 2;
    protected static final int ON_VIEW_READY_2 = 10;
    protected static final int ON_CLOSE = 3;
    protected static final int ON_RECEIVED_ERROR = 4;
    protected static final int ON_NOTIFY_VAST_AD_READY = 5;
    protected static final int ON_REWARDED = 6;
    protected static final int ON_REWARDED_STARTED = 7;
    protected static final int ON_AD_STATE_CHANGE = 8;
    protected static final int ON_NOTIFY_AD_READY = 9;
    protected static final String TAG = HtmlViewWrapper.class.getSimpleName();
    public HtmlFiveWebView mWebView;
    protected String mStyleId;
    protected String mWidgetType = "";
    protected boolean mAllowClickHandling = true;
    protected ContentItem mContentItem;
    protected String mHtmlPageUrl;
    private String mLastOverloadUrl = "";
    protected IOnHtmlWebViewInterface mHtmlWeViewListener;
    protected IOnInitFinishedListener mSdkInitListener;
    protected boolean mIsShowClose = true;
    protected LoadingProgressView mLoadingProgressView;
    protected Handler mEventHandler;
    protected ItemViewPagerAdapter.ViewPagerItemClickListener mViewPagerItemClickListener;
    protected Handler mExecutionHandler;
    protected SoftReference<Context> mInFocusActivityContext;
    protected AdState mAdState = AdState.AD_STOPED;
    private int mPreviousOrientation;
    private boolean mAllowJSResize = false;
    private BannerLoadJSInterface mBannerLoadJSInterface;
    private BannerShowJSInterface mBannerShowJSInterface;
    private BannerInvokeUrlInterface mBannerInvokeUrlInterface;

    public void pauseWebView() {
        if (this.mWebView != null) {
            this.mWebView.onPause();
        }
    }

    public void resumeWebView() {
        if (this.mWebView != null) {
            this.mWebView.onResume();
        }
    }

    public HtmlViewWrapper(Context context, boolean clearCache) {
        super(context);
        this.mExecutionHandler = new Handler(Looper.getMainLooper());
        this.initView(clearCache);
    }

    public void setWidgetType(String widgetType) {
        this.mWidgetType = widgetType;
    }

    public String getWidgetType() {
        return this.mWidgetType;
    }

    public void setStyleID(String styleID) {
        this.mStyleId = styleID;
    }

    public void setData(ContentItem contentItem) {
        this.mContentItem = contentItem;
        this.mHtmlPageUrl = contentItem.getData();
        this.setAndApplyExternalProperties(contentItem.getExtraParameters());
    }

    public void setInFocusActivityContext(Context context) {
        try {
            if (context != null && context instanceof Activity) {
                this.mPreviousOrientation = ((Activity)context).getRequestedOrientation();
                this.mInFocusActivityContext = new SoftReference<Context>(context);
            }
        }
        catch (Exception e) {
            Log.d((String)TAG, (String)("setInFocusActivityContext | exception: " + e.getLocalizedMessage()));
        }
    }

    private void setAndApplyExternalProperties(JSONObject jsonObject) {
        if (jsonObject != null) {
            JSONObject mwbViewPropertiesMap;
            if (jsonObject.has("webview_properties") && !jsonObject.isNull("webview_properties") && (mwbViewPropertiesMap = jsonObject.optJSONObject("webview_properties")) != null) {
                this.mWebView.applyProperties(mwbViewPropertiesMap);
            }
            this.mIsShowClose = jsonObject.optBoolean("showClose", false);
        }
    }

    public void reloadHtml() {
        this.loadHtml(this.mHtmlPageUrl);
    }

    public void loadHtml(String link) {
        CacheWebViewFactory cacheWebViewFactory = CacheWebViewFactory.getInstance();
        if (!cacheWebViewFactory.hasCache(link)) {
            cacheWebViewFactory.addCacheAsync(link, link, null);
            this.mLastOverloadUrl = "";
            this.mHtmlPageUrl = link;
            if (link.startsWith("http://")) {
                return;
            }
            if (this.mHtmlPageUrl != null) {
                Context context = this.getContext();
                Point screenSize = ScreenUtils.getScreenSize(context);
                String mainUrl = this.mHtmlPageUrl;
                mainUrl = !mainUrl.contains("?") ? mainUrl + "?" : mainUrl + "&";
                this.mWebView.loadUrl(link);
            }
        } else {
            this.mWebView.loadDataWithBaseURL(cacheWebViewFactory.getCache(link).getBaseURL(), cacheWebViewFactory.getCache(link).getWebViewContent(), "text/html", "utf-8", null);
        }
    }

    private void initView(boolean clearCache) {
        this.initHandler();
        this.initWebView(clearCache);
        this.initProgressLoadingView();
    }

    private void initHandler() {
        this.mEventHandler = new Handler(Looper.getMainLooper()){

            public void handleMessage(Message msg) {
                super.handleMessage(msg);
                HtmlViewWrapper.this.onHandleLocalUiThreadedEvents(msg);
            }
        };
    }

    protected void onHandleLocalUiThreadedEvents(Message msg) {
        switch (msg.what) {
            case 1: {
                if (this.mHtmlWeViewListener == null) break;
                this.mHtmlWeViewListener.onHtmlStartLoading();
                break;
            }
            case 0: {
                if (this.mHtmlWeViewListener != null) {
                    this.mHtmlWeViewListener.onHtmlFinishedLoading();
                }
                if (this.mSdkInitListener == null) break;
                this.mSdkInitListener.onInitFinished();
                this.mSdkInitListener = null;
                break;
            }
            case 2: {
                if (this.mHtmlWeViewListener == null) break;
                this.mHtmlWeViewListener.onViewReady();
                break;
            }
            case 10: {
                if (this.mHtmlWeViewListener == null) break;
                this.mHtmlWeViewListener.onViewReady2();
                break;
            }
            case 3: {
                if (this.mHtmlWeViewListener != null) {
                    this.mHtmlWeViewListener.onClose();
                }
                WidgetEventMessage eventMessage = null;
                if (this.mWidgetType != null && this.mWidgetType.equals(WidgetType.WIDGET_TYPE_INTERSTITIAL_REWARDED.getStringValue())) {
                    eventMessage = new WidgetEventMessage(EventMessage.MessageType.INTERSTITIAL_AD_CLOSE, WidgetType.WIDGET_TYPE_INTERSTITIAL_REWARDED);
                } else if (this.mWidgetType != null && this.mWidgetType.equals(WidgetType.WIDGET_TYPE_INTERSTITIAL.getStringValue())) {
                    eventMessage = new WidgetEventMessage(EventMessage.MessageType.INTERSTITIAL_AD_CLOSE, WidgetType.WIDGET_TYPE_INTERSTITIAL);
                }
                if (eventMessage != null) {
                    EventBus.getDefault().post(eventMessage);
                }
                this.clearCache();
                break;
            }
            case 4: {
                if (this.mHtmlWeViewListener == null) break;
                this.mHtmlWeViewListener.onErrorReceived();
                break;
            }
            case 5: {
                if (this.mHtmlWeViewListener == null) break;
                JSONObject jsonObject = null;
                if (msg.obj != null && msg.obj instanceof String) {
                    try {
                        jsonObject = new JSONObject((String)msg.obj);
                    }
                    catch (JSONException e) {
                        SDKLogger.printErrorLog(HtmlViewWrapper.class.getCanonicalName(), "Error parsing vast properties!");
                    }
                }
                if (msg.arg1 == 1) {
                    this.mHtmlWeViewListener.onNotifyVastReady(true, jsonObject);
                    break;
                }
                this.mHtmlWeViewListener.onNotifyVastReady(false, jsonObject);
                break;
            }
            case 9: {
                if (this.mHtmlWeViewListener == null) break;
                JSONObject jsonObject = null;
                if (msg.obj != null && msg.obj instanceof String) {
                    try {
                        jsonObject = new JSONObject((String)msg.obj);
                    }
                    catch (JSONException e) {
                        SDKLogger.printErrorLog(HtmlViewWrapper.class.getCanonicalName(), "Error parsing vast properties!");
                    }
                }
                if (msg.arg1 == 1) {
                    this.mHtmlWeViewListener.onNotifyAdReady(true, jsonObject);
                    break;
                }
                this.mHtmlWeViewListener.onNotifyAdReady(false, jsonObject);
                break;
            }
            case 6: {
                if (this.mHtmlWeViewListener == null) break;
                this.mHtmlWeViewListener.onRewarded();
                break;
            }
            case 7: {
                if (this.mHtmlWeViewListener == null) break;
                this.mHtmlWeViewListener.onRewardedVideoStarted();
                break;
            }
            case 8: {
                try {
                    this.mAdState = AdState.values()[msg.arg1];
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (this.mHtmlWeViewListener == null) break;
                this.mHtmlWeViewListener.onAdStateChanged(this.mAdState);
            }
        }
    }

    private void initWebView(boolean clearCache) {
        this.mWebView = new HtmlFiveWebView(this.getContext());
        if (clearCache) {
            this.clearCache();
        }
        this.mWebView.setWebViewVisibilityListener(new WebViewVisibilityListener(){

            @Override
            public void onWebViewBecameVisible(boolean isVisible) {
                if (isVisible) {
                    HtmlViewWrapper.this.invokeJSfunction("javascript:focus()");
                } else {
                    HtmlViewWrapper.this.invokeJSfunction("javascript:blur()");
                }
            }
        });
        this.applyJavaScriptInterfaces();
        this.mWebView.setWebViewClient(new WebViewClient(){

            public void onLoadResource(WebView view, String url) {
            }

            public WebResourceResponse shouldInterceptRequest(WebView view, String url) {
                if (url.startsWith("http://")) {
                    return new WebResourceResponse(null, null, null);
                }
                return super.shouldInterceptRequest(view, url);
            }

            public void onPageStarted(WebView view, String url, Bitmap favicon) {
                super.onPageStarted(view, url, favicon);
                HtmlViewWrapper.this.mEventHandler.sendEmptyMessage(1);
            }

            public void onPageFinished(WebView view, String url) {
                super.onPageFinished(view, url);
                HtmlViewWrapper.this.mEventHandler.sendEmptyMessage(0);
                if (HtmlViewWrapper.this.mAllowJSResize) {
                    SDKLogger.printDebugLog("KidozBannerPresenter | onPageFinished | calling js.resize");
                    HtmlViewWrapper.this.mWebView.loadUrl("javascript:KidozAndroid.resize(document.body.getBoundingClientRect().width, document.body.getBoundingClientRect().height)");
                }
            }

            public boolean shouldOverrideUrlLoading(WebView view, String url) {
                if (url.startsWith("http://")) {
                    return true;
                }
                HtmlViewWrapper.this.mLastOverloadUrl = url;
                SDKLogger.printDebugLog("KidozBannerPresenter | shouldOverrideUrlLoading | url: " + url);
                if (HtmlViewWrapper.this.mContentItem != null && HtmlViewWrapper.this.mContentItem.getContentType() != null && HtmlViewWrapper.this.mContentItem.getContentType() == ContentType.ROVIO_ITEM) {
                    return super.shouldOverrideUrlLoading(view, url);
                }
                return HtmlViewWrapper.this.handleOverrideUrlLoading(view, url);
            }

            public void onReceivedError(WebView view, int errorCode, String description, String failingUrl) {
                SDKLogger.printDebugLog("KidozBannerPresenter | onReceivedError: " + errorCode + ", description: " + description);
                Event event = new Event();
                if (HtmlViewWrapper.this.mContentItem != null) {
                    event.addParameterToJsonObject("ItemID", HtmlViewWrapper.this.mContentItem.getId());
                    event.addParameterToJsonObject("AdvertiserID", HtmlViewWrapper.this.mContentItem.getAdvertiserID());
                }
                EventManager.getInstance(HtmlViewWrapper.this.getContext()).logEvent(HtmlViewWrapper.this.getContext(), HtmlViewWrapper.this.mWidgetType, HtmlViewWrapper.this.mStyleId, EventManager.LOG_CRITICAL_LEVEL, event, "WebView Error", String.valueOf(errorCode).concat(": ").concat(description), failingUrl);
            }
        });
        this.mWebView.setWebChromeClient(new KidozWebChromeClient());
        this.addView((View)this.mWebView, (ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-1, -1));
    }

    @SuppressLint(value={"JavascriptInterface"})
    protected void applyJavaScriptInterfaces() {
        this.mWebView.addJavascriptInterface(this, JS_OBJECT_NAME);
    }

    protected boolean handleOverrideUrlLoading(WebView view, String url) {
        this.openGooglePlayStore(url);
        return true;
    }

    protected void openGooglePlayStore(String url) {
        try {
            if (this.mContentItem != null && this.mContentItem.getContentType() != null) {
                switch (this.mContentItem.getContentType()) {
                    case PROMOTED_PLAY_APPLICATION: {
                        this.openGooglePlayInBackground(url);
                        break;
                    }
                    case HTML: {
                        if (this.mContentItem.getJSONitem() != null) {
                            try {
                                JSONArray jsonArray = this.mContentItem.getJSONitem();
                                JSONObject extraJsonObject = jsonArray.getJSONObject(11);
                                if (extraJsonObject.optBoolean("cpi_play", false)) {
                                    this.openGooglePlayInBackground(url);
                                    break;
                                }
                                this.openGooglePlayInForground(url);
                            }
                            catch (Exception ex) {
                                this.openGooglePlayInForground(url);
                            }
                            break;
                        }
                        this.openGooglePlayInForground(url);
                        break;
                    }
                    default: {
                        this.openGooglePlayInForground(url);
                        break;
                    }
                }
            } else {
                this.openGooglePlayInForground(url);
            }
        }
        catch (Exception ex) {
            SDKLogger.printErrorLog(TAG, "Error when trying to open google start for promoted app: \n" + ex.getMessage());
        }
    }

    protected void openGooglePlayInForground(final String url) {
        Context context = this.mInFocusActivityContext.get();
        if (context == null) {
            context = this.getContext();
        }
        final Context finalContext = context;
        String id = null;
        String host = null;
        Uri uri = Uri.parse((String)url);
        host = uri.getHost();
        if (host != null && host.equals("play.google.com")) {
            try {
                id = URLDecoder.decode(uri.getQueryParameter("id"), "UTF-8");
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            if (id != null && !id.equals("")) {
                IsEventRecord isEventRecord = new IsEventRecord();
                isEventRecord.setPackageName(id);
                isEventRecord.setContentType(ContentType.PROMOTED_PLAY_APPLICATION.toString());
                isEventRecord.setName("");
                isEventRecord.setTimeStamp(System.currentTimeMillis() + "");
                isEventRecord.setWidgetType(this.mWidgetType);
                isEventRecord.setStyleId(this.mStyleId);
                DatabaseManager.getInstance(context).getIsEventTable().insertRecord(isEventRecord);
            }
        }
        ContentExecutionHandler.checkForParentalLock(context, new ContentExecutionHandler.IOnParentalLockStatusListener(){

            @Override
            public void onLockActive(boolean isPasswordCorrect) {
                if (isPasswordCorrect) {
                    Intent intent = new Intent("android.intent.action.VIEW");
                    intent.setData(Uri.parse((String)url));
                    if (finalContext != null) {
                        intent.addFlags(0x10000000);
                        finalContext.startActivity(intent);
                    }
                } else {
                    EventManager.getInstance(finalContext).logEvent(finalContext, HtmlViewWrapper.this.mWidgetType, HtmlViewWrapper.this.mStyleId, EventManager.LOG_NORMAL_LEVEL, null, "Sponsored Content", "Incorrect Password", "");
                }
            }

            @Override
            public void onLockNotActive() {
                Intent intent = new Intent("android.intent.action.VIEW");
                intent.setData(Uri.parse((String)url));
                if (finalContext != null) {
                    intent.addFlags(0x10000000);
                    finalContext.startActivity(intent);
                }
            }
        });
    }

    protected void openGooglePlayInBackground(String url) {
        Context context = this.mInFocusActivityContext.get();
        if (context == null) {
            context = this.getContext();
        }
        ContentItem contentItem = new ContentItem();
        contentItem.setContentType(ContentType.PROMOTED_PLAY_APPLICATION);
        contentItem.setData(url);
        contentItem.setId(this.mContentItem.getId());
        ContentExecutionHandler.handleContentItemClick(context, contentItem, this.mWidgetType, this.mStyleId, 0, false, null);
    }

    private void initProgressLoadingView() {
        this.mLoadingProgressView = new LoadingProgressView(this.getContext());
        Point point = Utils.getScreenSize(this.getContext());
        int size = (int)((float)Math.min(point.x, point.y) * 0.35f);
        RelativeLayout.LayoutParams prParams = new RelativeLayout.LayoutParams(size, size);
        prParams.addRule(13);
        this.addView(this.mLoadingProgressView, (ViewGroup.LayoutParams)prParams);
    }

    protected void invokeOnImpressionServed(final String item_id, final String item_name, final String ad_id, final String view_index) {
        this.mExecutionHandler.post(new Runnable(){

            @Override
            public void run() {
                int positionIndexAsInteger = 0;
                try {
                    positionIndexAsInteger = Integer.parseInt(view_index);
                }
                catch (Exception ex) {
                    SDKLogger.printErrorLog(TAG, "Error when trying to parse positionIndex: " + ex.getMessage());
                }
                EventManager.getInstance(HtmlViewWrapper.this.getContext()).logSponsoredContentImpressionEvent(HtmlViewWrapper.this.getContext(), HtmlViewWrapper.this.mWidgetType, HtmlViewWrapper.this.mStyleId, "Impression", item_name, ad_id, item_id, positionIndexAsInteger);
            }
        });
    }

    protected void invokeOnSimulateClick(final String json, final int positionIndex) {
        if (json != null) {
            this.mExecutionHandler.post(new Runnable(){

                @Override
                public void run() {
                    ContentItem item;
                    block8: {
                        item = null;
                        try {
                            JSONArray jsonArray = new JSONArray(json);
                            if (jsonArray != null && jsonArray.length() > 1) {
                                JSONArray keysArray = jsonArray.getJSONArray(0);
                                LinkedHashMap<String, Integer> keysMap = new LinkedHashMap<String, Integer>();
                                if (keysArray != null && keysArray.length() > 0) {
                                    for (int i = 0; i < keysArray.length(); ++i) {
                                        keysMap.put(keysArray.getString(i), i);
                                    }
                                }
                                if (!keysMap.isEmpty() && jsonArray.getJSONArray(1) != null) {
                                    item = new ContentItem(jsonArray.getJSONArray(1), keysMap);
                                }
                            }
                        }
                        catch (JSONException e) {
                            String errorMsg = e.getLocalizedMessage();
                            if (e == null || TextUtils.isEmpty((CharSequence)errorMsg)) break block8;
                            SDKLogger.printErrorLog(errorMsg);
                        }
                    }
                    if (item != null && HtmlViewWrapper.this.mAllowClickHandling) {
                        HtmlViewWrapper.this.mAllowClickHandling = false;
                        if (HtmlViewWrapper.this.mInFocusActivityContext != null && HtmlViewWrapper.this.mInFocusActivityContext.get() != null) {
                            ContentExecutionHandler.handleContentItemClick(HtmlViewWrapper.this.mInFocusActivityContext.get(), item, HtmlViewWrapper.this.mWidgetType, HtmlViewWrapper.this.mStyleId, positionIndex, true, new ContentExecutionHandler.IOnHandleClickListener(){

                                @Override
                                public void onRestoreClick() {
                                    HtmlViewWrapper.this.mAllowClickHandling = true;
                                }
                            });
                        }
                    }
                }
            });
        }
    }

    protected void invokeAboutClick() {
        this.mExecutionHandler.post(new Runnable(){

            @Override
            public void run() {
                HtmlViewWrapper.this.startAboutKidozDialog();
            }
        });
    }

    protected void invokeParentalClick() {
        this.mExecutionHandler.post(new Runnable(){

            @Override
            public void run() {
                HtmlViewWrapper.this.startParentalLockDialog();
            }
        });
    }

    protected void invokeMaximizedClick() {
        this.mExecutionHandler.post(new Runnable(){

            @Override
            public void run() {
                if (HtmlViewWrapper.this.mHtmlWeViewListener != null) {
                    HtmlViewWrapper.this.mHtmlWeViewListener.onOpenMaximized();
                }
            }
        });
    }

    protected void invokeInitiateWebViewProperties(final String properties) {
        this.mExecutionHandler.post(new Runnable(){

            @Override
            public void run() {
                try {
                    HtmlViewWrapper.this.mWebView.applyProperties(new JSONObject(properties));
                }
                catch (JSONException jSONException) {
                    // empty catch block
                }
            }
        });
    }

    protected void onInvokeConversionServed(final String item_id, final String item_name, final String ad_id, final String view_index, final String rewardKey, final String rewardValue) {
        this.mExecutionHandler.post(new Runnable(){

            @Override
            public void run() {
                int positionIndexAsInteger = 0;
                int rewardKeyAsInteger = 0;
                int rewardValueAsInteger = 0;
                try {
                    positionIndexAsInteger = Integer.parseInt(view_index);
                }
                catch (Exception ex) {
                    SDKLogger.printErrorLog(TAG, "Error when trying to parse positionIndex: " + ex.getMessage());
                }
                try {
                    rewardKeyAsInteger = Integer.parseInt(rewardKey);
                }
                catch (Exception ex) {
                    SDKLogger.printErrorLog(TAG, "Error when trying to parse rewardKey: " + ex.getMessage());
                }
                try {
                    rewardValueAsInteger = Integer.parseInt(rewardValue);
                }
                catch (Exception ex) {
                    SDKLogger.printErrorLog(TAG, "Error when trying to parse rewardValue: " + ex.getMessage());
                }
                Event event = new Event();
                EventManager.getInstance(HtmlViewWrapper.this.getContext()).logSponsoredConversionEvent(HtmlViewWrapper.this.getContext(), HtmlViewWrapper.this.mWidgetType, HtmlViewWrapper.this.mStyleId, event, item_name, ad_id, item_id, positionIndexAsInteger, rewardKeyAsInteger, rewardValueAsInteger);
            }
        });
    }

    protected void onRequestStoreLocalParam(final String key, final String value, final String scope_type) {
        this.mExecutionHandler.post(new Runnable(){

            @Override
            public void run() {
                SdkCookieManager.saveData(HtmlViewWrapper.this.getContext(), HtmlViewWrapper.this.mWidgetType, HtmlViewWrapper.this.mHtmlPageUrl, key, value, StorageLife.valueOf(scope_type));
            }
        });
    }

    protected void onGetLocalParam(String function, final String key) {
        final String value = SdkCookieManager.loadData(this.getContext(), this.mWidgetType, this.mHtmlPageUrl, key);
        String defaultName = "kidozReturnedValue";
        if (function != null) {
            defaultName = function;
        }
        final String finalDefaultName = defaultName;
        this.mEventHandler.post(new Runnable(){

            @Override
            public void run() {
                HtmlViewWrapper.this.invokeJSfunction("javascript:" + finalDefaultName + "('" + key + "','" + value + "'  );");
            }
        });
    }

    private void onGetDonePlayback() {
        this.mExecutionHandler.post(new Runnable(){

            @Override
            public void run() {
                if (HtmlViewWrapper.this.mHtmlWeViewListener != null) {
                    HtmlViewWrapper.this.mHtmlWeViewListener.onDonePlayBack();
                }
            }
        });
    }

    private void onGetParentalLockState(final String function) {
        if (function != null) {
            final boolean isLockActive = ParentalLockDialog.isParentalLockActive(this.getContext());
            this.mExecutionHandler.post(new Runnable(){

                @Override
                public void run() {
                    HtmlViewWrapper.this.invokeJSfunction("javascript:" + function + "('" + isLockActive + "');");
                }
            });
        }
    }

    protected void onForwardToGooglePlay(final String advertiserID, final String appID, final String googlePlayLink, final String widgetType, final String styleID, final String itemIndex) {
        if (googlePlayLink.startsWith("http://")) {
            return;
        }
        this.mExecutionHandler.post(new Runnable(){

            @Override
            public void run() {
                int itemIndexAsInteger = 0;
                try {
                    itemIndexAsInteger = Integer.parseInt(itemIndex);
                }
                catch (Exception ex) {
                    SDKLogger.printErrorLog(TAG, "Error when trying to parse item index: " + ex.getMessage());
                }
                ContentItem contentItem = new ContentItem();
                contentItem.setId(appID);
                contentItem.setName("");
                contentItem.setData(googlePlayLink);
                contentItem.setContentType(ContentType.PROMOTED_PLAY_APPLICATION);
                contentItem.setAdvertiserID(advertiserID);
                contentItem.setIsPromoted(true);
                if (HtmlViewWrapper.this.mViewPagerItemClickListener != null) {
                    HtmlViewWrapper.this.mViewPagerItemClickListener.onClickEnd(contentItem, itemIndexAsInteger);
                } else if (HtmlViewWrapper.this.mInFocusActivityContext != null && HtmlViewWrapper.this.mInFocusActivityContext.get() != null) {
                    ContentExecutionHandler.handleContentItemClick(HtmlViewWrapper.this.mInFocusActivityContext.get(), contentItem, widgetType, styleID, itemIndexAsInteger, false, null);
                }
            }
        });
    }

    protected void invokeSetDeviceOrientation(final int orientation) {
        if (this.mInFocusActivityContext != null && this.mInFocusActivityContext.get() != null && this.mInFocusActivityContext.get() instanceof Activity) {
            this.mExecutionHandler.post(new Runnable(){

                @Override
                public void run() {
                    int mOrientation = orientation;
                    if (mOrientation == 0) {
                        mOrientation = 6;
                    }
                    ((Activity)HtmlViewWrapper.this.mInFocusActivityContext.get()).setRequestedOrientation(mOrientation);
                }
            });
        }
    }

    protected void onInvokeSendEvent(final String type, final String category, final String action, final String label, final String jsonData) {
        if (category != null && action != null) {
            this.mExecutionHandler.post(new Runnable(){

                @Override
                public void run() {
                    SDKLogger.printDebugLog("RONY", "type = " + type);
                    SDKLogger.printDebugLog("RONY", "category = " + category);
                    SDKLogger.printDebugLog("RONY", "action = " + action);
                    SDKLogger.printDebugLog("RONY", "label = " + label);
                    SDKLogger.printDebugLog("RONY", "jsonData = " + jsonData);
                    SDKLogger.printDebugLog("RONY", "mStyleId = " + HtmlViewWrapper.this.mStyleId);
                    SDKLogger.printDebugLog("RONY", "mWidgetType = " + HtmlViewWrapper.this.mWidgetType);
                    Event event = new Event();
                    event.setLogLevel(EventManager.LOG_NORMAL_LEVEL);
                    if (jsonData != null) {
                        event.addParameterToJsonObject(jsonData);
                    }
                    EventManager.getInstance(HtmlViewWrapper.this.getContext()).logEvent(HtmlViewWrapper.this.getContext(), HtmlViewWrapper.this.mWidgetType, HtmlViewWrapper.this.mStyleId, EventManager.LOG_NORMAL_LEVEL, event, category, action, label);
                }
            });
        }
    }

    protected void onToggleLoadingState(final boolean isLoading) {
        if (this.mLoadingProgressView != null) {
            this.mExecutionHandler.post(new Runnable(){

                @Override
                public void run() {
                    if (isLoading) {
                        HtmlViewWrapper.this.mLoadingProgressView.startLoadingAnimation();
                    } else {
                        HtmlViewWrapper.this.mLoadingProgressView.stopLoadingAnimation();
                    }
                }
            });
        }
    }

    protected void onNotifyIsVastAdReady(boolean isVastReady, String vastSettings) {
        Message message = Message.obtain();
        message.what = 5;
        message.arg1 = isVastReady ? 1 : 0;
        if (vastSettings != null) {
            message.obj = vastSettings;
        }
        this.mEventHandler.sendMessage(message);
    }

    protected void onNotifyAdReady(boolean isAdReady, String adSettings) {
        Message message = Message.obtain();
        message.what = 9;
        message.arg1 = isAdReady ? 1 : 0;
        if (adSettings != null) {
            message.obj = adSettings;
        }
        this.mEventHandler.sendMessage(message);
    }

    protected void onNotifyIsVastAdReady(boolean isVastReady) {
        Message message = Message.obtain();
        message.what = 5;
        message.arg1 = isVastReady ? 1 : 0;
        this.mEventHandler.sendMessage(message);
    }

    protected void setParentalLockState(boolean locked) {
        this.invokeJSfunction("javascript:kidozOnParentalLockStateChanged('" + locked + "');");
    }

    protected void startParentalLockDialog() {
        if (this.mInFocusActivityContext != null && this.mInFocusActivityContext.get() != null) {
            ParentalLockDialog.startParentalDialog(this.mInFocusActivityContext.get(), false, 0.5f, 0.5f, new ParentalLockDialog.IOnParentalDialogListener(){

                @Override
                public void onCloseDialog() {
                    HtmlViewWrapper.this.updateLockIcon();
                }

                @Override
                public void onInputPass(boolean isCorrectPass) {
                    HtmlViewWrapper.this.updateLockIcon();
                }
            });
            this.updateLockIcon();
        }
    }

    protected void startAboutKidozDialog() {
        int[] popLocation = new int[]{(int)((float)ScreenUtils.getScreenSize(this.getContext(), true) * 0.5f), (int)((float)ScreenUtils.getScreenSize(this.getContext(), false) * 0.5f)};
        if (this.mInFocusActivityContext != null && this.mInFocusActivityContext.get() != null) {
            AboutKidozDialog aboutKidozDialog = new AboutKidozDialog(this.mInFocusActivityContext.get(), popLocation);
            aboutKidozDialog.openDialog();
        }
    }

    protected void updateLockIcon() {
        try {
            boolean isLockActive = ParentalLockDialog.isParentalLockActive(this.getContext());
            if (isLockActive) {
                this.setParentalLockState(true);
            } else {
                this.setParentalLockState(false);
            }
        }
        catch (Exception ex) {
            SDKLogger.printErrorLog(TAG, "Error when trying to load parental lock image: " + ex.getMessage());
        }
    }

    public void requestFocusOn(boolean isFullScreen) {
        this.invokeJSfunction("javascript:toonsWebApi.appForeground()");
        if (this.mContentItem != null) {
            JSONArray jSONArray = this.mContentItem.getJSONitem();
            try {
                String itemName = jSONArray.getString(1);
                itemName = itemName.replace("\"", "");
                jSONArray.put(1, (Object)itemName);
            }
            catch (Exception itemName) {
                // empty catch block
            }
            String json = jSONArray.toString();
            String func = "javascript:kidozOnFocusOn('" + this.mContentItem.getId() + "','" + json + "','" + isFullScreen + "','" + this.mWidgetType + "','" + this.mContentItem.getRealViewIndex() + "');";
            this.invokeJSfunction(func);
        }
    }

    public void requestFocusOff() {
        this.invokeJSfunction("javascript:toonsWebApi.appBackground()");
        if (this.mContentItem != null) {
            this.invokeJSfunction("javascript:kidozOnFocusOff('" + this.mContentItem.getId() + "');");
        }
    }

    public void requestMaximize() {
        String func = "javascript:kidozOnMaximize();";
        this.invokeJSfunction(func);
    }

    public void requestMinimize() {
        this.invokeJSfunction("javascript:kidozOnMinimize();");
    }

    public void requestWidgetOpen(String widgetType) {
        if (widgetType != null) {
            this.invokeJSfunction("javascript:kidozOnWidgetOpen('" + widgetType + "');");
        }
    }

    public void requestWidgetClose(String widgetType) {
        if (widgetType != null) {
            this.invokeJSfunction("javascript:kidozOnWidgetClose('" + widgetType + "');");
        }
    }

    public void requestVastAds(int adType) {
        this.invokeJSfunction("javascript:requestAds('" + adType + "');");
    }

    public void startVastAd() {
        this.invokeJSfunction("javascript:startVastAd();");
    }

    public void startAd() {
        this.invokeJSfunction("javascript:startAd();");
    }

    public void stopVastAd() {
        this.invokeJSfunction("javascript:stopVastAd();");
    }

    public void stopAd() {
        this.invokeJSfunction("javascript:stopAd();");
    }

    public void pauseVastAd() {
        this.invokeJSfunction("javascript:pauseVastAd();");
    }

    public void pauseAd() {
        this.invokeJSfunction("javascript:pauseAd();");
    }

    public void resumeVastAd() {
        this.invokeJSfunction("javascript:resumeVastAd();");
    }

    public void loadContent(String map, String content) {
        this.invokeJSfunction("javascript:loadContent('" + map + "','" + content + "');");
    }

    public void clearHtmlView() {
        this.mWebView.loadUrl("");
    }

    public void destroy() {
        try {
            this.removeView((View)this.mWebView);
            this.mWebView.destroy();
        }
        catch (Exception exception) {
        }
        finally {
            this.mWebView = null;
        }
    }

    public void setHtmlWebViewListener(IOnHtmlWebViewInterface htmlWeViewListener) {
        this.mHtmlWeViewListener = htmlWeViewListener;
    }

    public void setSdkInitListener(IOnInitFinishedListener listener) {
        this.mSdkInitListener = listener;
    }

    public void loadBanner(JSONObject properties, BannerLoadJSInterface bannerJSInterface) {
        this.mBannerLoadJSInterface = bannerJSInterface;
        this.invokeJSfunction("javascript:loadBanner(" + properties + ");");
    }

    public void showBanner(BannerShowJSInterface bannerJSInterface) {
        this.mBannerShowJSInterface = bannerJSInterface;
        this.invokeJSfunction("javascript:showBanner();");
    }

    public void hideBanner() {
        this.invokeJSfunction("javascript:hideBanner();");
    }

    @JavascriptInterface
    public void invokeJavaBannerLoad(boolean success, String errorMsg) {
        this.onJSBannerLoad(success, errorMsg);
    }

    private void onJSBannerLoad(boolean success, final String errorMsg) {
        if (this.mBannerLoadJSInterface == null) {
            SDKLogger.printErrorLog("JS called banner load on Java but the load listener was empty.");
            return;
        }
        Log.d((String)"kidozbanner", (String)("onJSBannerLoad called from JS. success = " + success));
        if (success) {
            this.mExecutionHandler.post(new Runnable(){

                @Override
                public void run() {
                    HtmlViewWrapper.this.mBannerLoadJSInterface.onSuccess();
                }
            });
        } else {
            this.mExecutionHandler.post(new Runnable(){

                @Override
                public void run() {
                    HtmlViewWrapper.this.mBannerLoadJSInterface.onError(errorMsg);
                    HtmlViewWrapper.this.mBannerLoadJSInterface.onNoOffers();
                }
            });
        }
    }

    @JavascriptInterface
    public void invokeJavaBannerShow(boolean success, String errorMsg) {
        this.onJSBannerShow(success, errorMsg);
    }

    private void onJSBannerShow(boolean success, final String errorMsg) {
        if (this.mBannerShowJSInterface == null) {
            SDKLogger.printErrorLog("JS called banner show on Java but the load listener was empty.");
            return;
        }
        if (success) {
            this.mExecutionHandler.post(new Runnable(){

                @Override
                public void run() {
                    HtmlViewWrapper.this.mBannerShowJSInterface.onSuccess();
                }
            });
        } else {
            this.mExecutionHandler.post(new Runnable(){

                @Override
                public void run() {
                    HtmlViewWrapper.this.mBannerShowJSInterface.onError(errorMsg);
                }
            });
        }
    }

    public void invokeUrl(String url, BannerInvokeUrlInterface bannerInvokeUrlInterface) {
        this.mBannerInvokeUrlInterface = bannerInvokeUrlInterface;
        this.invokeJSfunction("javascript:" + url);
    }

    @JavascriptInterface
    public void onInvokeUrlResponse(String response) {
        if (this.mBannerInvokeUrlInterface != null) {
            this.mBannerInvokeUrlInterface.onResponse(response);
        }
    }

    public void invokeJSfunction(final String function) {
        block2: {
            try {
                this.mExecutionHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        block6: {
                            try {
                                if (Build.VERSION.SDK_INT >= 19) {
                                    if (HtmlViewWrapper.this.mWebView != null) {
                                        HtmlViewWrapper.this.mWebView.evaluateJavascript(function, (ValueCallback)new ValueCallback<String>(){

                                            public void onReceiveValue(String value) {
                                                SDKLogger.printDebugLog("KidozBannerPresenter invokeJSfunction (" + function + ") | evaluateJS return value = " + value);
                                            }
                                        });
                                    }
                                } else if (HtmlViewWrapper.this.mWebView != null) {
                                    HtmlViewWrapper.this.mWebView.loadUrl(function);
                                }
                            }
                            catch (Exception e) {
                                if (HtmlViewWrapper.this.mWebView == null) break block6;
                                HtmlViewWrapper.this.mWebView.loadUrl(function);
                            }
                        }
                    }
                });
            }
            catch (Exception ex) {
                if (ex == null) break block2;
                SDKLogger.printDebugLog("HtmlViewWrapper | invokeJS exception: " + ex.getLocalizedMessage());
            }
        }
    }

    public boolean isShowClose() {
        return this.mIsShowClose;
    }

    public void showLoadingProgressView() {
        if (this.mLoadingProgressView != null) {
            this.mLoadingProgressView.startLoadingAnimation();
        }
    }

    public void hideLoadingProgressView() {
        if (this.mLoadingProgressView != null) {
            this.mLoadingProgressView.stopLoadingAnimation();
        }
    }

    public void stopAndReleaseWebView() {
        if (this.mWebView != null) {
            this.mWebView.stopAndReleaseWebView();
        }
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        int size = (int)((float)Math.min(w, h) * 0.35f);
        if (this.mLoadingProgressView != null) {
            this.mLoadingProgressView.getLayoutParams().height = size;
            this.mLoadingProgressView.getLayoutParams().width = size;
            this.mLoadingProgressView.setCircleWidthRelativeToSize(size);
        }
    }

    public void setViewPagerItemClickListener(ItemViewPagerAdapter.ViewPagerItemClickListener viewPagerItemClickListener) {
        this.mViewPagerItemClickListener = viewPagerItemClickListener;
    }

    public void clearCache() {
        if (this.mWebView != null) {
            this.mWebView.clearCache(true);
            this.mWebView.clearHistory();
        }
    }

    public String getLastOverloadUrl() {
        return this.mLastOverloadUrl;
    }

    @JavascriptInterface
    public String getParams() {
        Context context = this.getContext();
        Point screenSize = ScreenUtils.getScreenSize(context);
        KidozParams.ParamBuilder KidozParamsBuilder = new KidozParams.ParamBuilder();
        KidozParamsBuilder.setPublisherId(KidozSDK.getPublisherID()).setAuthToken(KidozSDK.getAuthToken()).setPackageId(KidozSDK.getAppId() != null ? KidozSDK.getAppId() : context.getPackageName()).setSdkVersion("4").setActualSdkVersion("0.8.8.7").setOsVersion(Build.VERSION.SDK_INT).setOsType("android").setExtensionType(ConstantDef.SDK_EXTENSION_TYPE).setAppVersionCode(Utils.getAppVersionCode(context)).setAppVersionName(Utils.getAppVersionName(context)).setDeviceType(Utils.getDeviceType(context)).setDeviceLang(Locale.getDefault().getLanguage()).setDeviceHash(Utils.generateUniqeDeviceID(KidozSDK.getAppId() != null ? KidozSDK.getAppId() : context.getPackageName(), KidozSDK.getPublisherID())).setGid(SdkDeviceUtils.getGoogleAdvertisingID(context)).setManufacturer(Build.MANUFACTURER).setModel(Build.MODEL).setWebviewVersion(Utils.getWebViewVersion()).setScreenSize(ScreenUtils.getDeviceScreenSizeInInches(context)).setDpi(ScreenUtils.getScreenDpi(context)).setScreenCategory(ScreenUtils.getScreenCategory(context)).setWifiMode(Utils.getWifiOn(context)).setCarrierName(Utils.getCarrierName(context)).setNetworkType(Utils.getNetworkType(context)).setResolutionHeight(screenSize.y).setResolutionWidth(screenSize.x);
        KidozParamsBuilder.setWidgetType(this.mWidgetType).setCacheBuster(Utils.getCacheBuster());
        KidozParams kidozParams = KidozParamsBuilder.build();
        return kidozParams.toString();
    }

    @Override
    @JavascriptInterface
    public void onViewReady() {
        this.mEventHandler.sendEmptyMessage(2);
    }

    @Override
    @JavascriptInterface
    public void onViewReady2() {
        this.mEventHandler.sendEmptyMessage(10);
    }

    @Override
    @JavascriptInterface
    public void simulateClick(String contentItemJson, int positionIndex) {
        block2: {
            try {
                this.invokeOnSimulateClick(contentItemJson, positionIndex);
            }
            catch (Exception e) {
                String errorMsg = e.getLocalizedMessage();
                if (e == null || TextUtils.isEmpty((CharSequence)errorMsg)) break block2;
                SDKLogger.printErrorLog(errorMsg);
            }
        }
    }

    @Override
    @JavascriptInterface
    public void onSendImpressionEvent(String item_id, String item_name, String ad_id, String view_index) {
        block2: {
            try {
                this.invokeOnImpressionServed(item_id, item_name, ad_id, view_index);
            }
            catch (Exception e) {
                if (e == null || TextUtils.isEmpty((CharSequence)e.getLocalizedMessage())) break block2;
                String errorMsg = e.getLocalizedMessage();
                SDKLogger.printErrorLog("onSendImpressionEvent: " + errorMsg);
            }
        }
    }

    @Override
    @JavascriptInterface
    public void onInvokeAboutClick() {
        this.invokeAboutClick();
    }

    @Override
    @JavascriptInterface
    public void onInvokeParentalClick() {
        this.invokeParentalClick();
    }

    @Override
    @JavascriptInterface
    public void onInvokeCloseClick() {
        this.mEventHandler.sendEmptyMessage(3);
    }

    @Override
    @JavascriptInterface
    public void toggleWidgetState(final boolean isEnabled) {
        this.mEventHandler.postDelayed(new Runnable(){

            @Override
            public void run() {
                if (HtmlViewWrapper.this.mHtmlWeViewListener != null) {
                    HtmlViewWrapper.this.mHtmlWeViewListener.toggleWidgetState(isEnabled);
                }
            }
        }, 0L);
    }

    @Override
    @JavascriptInterface
    public void onInvokeMaximize() {
        this.invokeMaximizedClick();
    }

    @Override
    @JavascriptInterface
    public void onInitWebViewWithProperties(String properties) {
        block2: {
            try {
                this.invokeInitiateWebViewProperties(properties);
            }
            catch (Exception e) {
                if (e == null || TextUtils.isEmpty((CharSequence)e.getLocalizedMessage())) break block2;
                String errorMsg = e.getLocalizedMessage();
                SDKLogger.printErrorLog("onInitWebViewWithProperties error: " + errorMsg);
            }
        }
    }

    @Override
    @JavascriptInterface
    public void onSendConversionEvent(String item_id, String item_name, String ad_id, String view_index, String rewardKey, String rewardValue) {
        try {
            this.onInvokeConversionServed(item_id, item_name, ad_id, view_index, rewardKey, rewardValue);
        }
        catch (Exception e) {
            Log.d((String)TAG, (String)("HtmlViewWrapper | onStoreLocalParameter | error: " + e.getLocalizedMessage()));
        }
    }

    @Override
    @JavascriptInterface
    public void onStoreLocalParameter(String key, String value, String scope_type) {
        try {
            this.onRequestStoreLocalParam(key, value, scope_type);
        }
        catch (Exception e) {
            Log.d((String)TAG, (String)("HtmlViewWrapper | onStoreLocalParameter | error: " + e.getLocalizedMessage()));
        }
    }

    @Override
    @JavascriptInterface
    public void getLocalParameter(String function, String key) {
        try {
            this.onGetLocalParam(function, key);
        }
        catch (Exception e) {
            Log.d((String)TAG, (String)("HtmlViewWrapper | onStoreLocalParameter | error: " + e.getLocalizedMessage()));
        }
    }

    @Override
    @JavascriptInterface
    public void onDone() {
        try {
            this.onGetDonePlayback();
        }
        catch (Exception e) {
            Log.d((String)TAG, (String)("HtmlViewWrapper | onStoreLocalParameter | error: " + e.getLocalizedMessage()));
        }
    }

    @Override
    @JavascriptInterface
    public void getParentalLockStatus(String function) {
        try {
            this.onGetParentalLockState(function);
        }
        catch (Exception e) {
            Log.d((String)TAG, (String)("HtmlViewWrapper | onStoreLocalParameter | error: " + e.getLocalizedMessage()));
        }
    }

    @Override
    @JavascriptInterface
    public void forwardToGooglePlay(String advertiserID, String appID, String googlePlayLink, String widjetType, String styleID, String itemIndex) {
        this.onForwardToGooglePlay(advertiserID, appID, googlePlayLink, widjetType, styleID, itemIndex);
    }

    @Override
    @JavascriptInterface
    public void sendEvent(String type, String category, String action, String label, String jsonData) {
        this.onInvokeSendEvent(type, category, action, label, jsonData);
    }

    @Override
    @JavascriptInterface
    public void toggleLoadingState(String isLoading) {
        try {
            boolean isLoadingAsBoolean = Boolean.parseBoolean(isLoading);
            this.onToggleLoadingState(isLoadingAsBoolean);
        }
        catch (Exception ex) {
            SDKLogger.printErrorLog(TAG, "Error when trying to parse isLoading parameter: " + ex.getMessage());
        }
    }

    @Override
    @JavascriptInterface
    public void notifyIsVastAdReady(boolean isVastReady, String vastSettings) {
        this.onNotifyIsVastAdReady(isVastReady, vastSettings);
    }

    @Override
    @JavascriptInterface
    public void notifyIsAdReady(boolean isAdReady, String adSettings) {
        this.onNotifyAdReady(isAdReady, adSettings);
    }

    @Override
    @JavascriptInterface
    public void notifyIsVastAdReady(boolean isVastReady) {
        this.onNotifyIsVastAdReady(isVastReady);
    }

    @Override
    @JavascriptInterface
    public void onRewarded() {
        Message message = Message.obtain();
        message.what = 6;
        this.mEventHandler.sendMessage(message);
    }

    @Override
    @JavascriptInterface
    public void onRewardedVideoStarted() {
        Message message = Message.obtain();
        message.what = 7;
        this.mEventHandler.sendMessage(message);
    }

    @Override
    @JavascriptInterface
    public void onAdStateChanged(int state) {
        Message message = Message.obtain();
        message.what = 8;
        message.arg1 = state;
        this.mEventHandler.sendMessage(message);
    }

    @Override
    @JavascriptInterface
    public void setDeviceOrientation(int orientation) {
        this.invokeSetDeviceOrientation(orientation);
    }

    @Override
    @JavascriptInterface
    public void sendURLEvent(String eventUrl) {
        SdkAPIManager.getSdkApiInstance(this.mInFocusActivityContext.get()).callGetURL(this.mInFocusActivityContext.get(), eventUrl, null);
    }

    @Override
    @JavascriptInterface
    public void playVideo(String url) {
        final String tUrl = url;
        this.mExecutionHandler.post(new Runnable(){

            @Override
            public void run() {
                if (HtmlViewWrapper.this.mInFocusActivityContext != null && HtmlViewWrapper.this.mInFocusActivityContext.get() != null) {
                    Intent playVideo = new Intent("android.intent.action.VIEW");
                    playVideo.setDataAndType(Uri.parse((String)tUrl), "video/mp4");
                    HtmlViewWrapper.this.mInFocusActivityContext.get().startActivity(playVideo);
                }
            }
        });
    }

    @JavascriptInterface
    public void resize(final float width, final float height) {
        this.mExecutionHandler.post(new Runnable(){

            @Override
            public void run() {
                SDKLogger.printDebugLog("HtmlViewWrapper", "resize: w= " + width + ", h= " + height);
                if (width == 0.0f || height == 0.0f) {
                    HtmlViewWrapper.this.mHtmlWeViewListener.onErrorReceived();
                    SDKLogger.printErrorLog(TAG, "JS called resize with width = " + width + ", height = " + height);
                    return;
                }
                ViewGroup.LayoutParams params = HtmlViewWrapper.this.getLayoutParams();
                params.width = (int)ScreenUtils.convertDpToPixel(width);
                params.height = (int)ScreenUtils.convertDpToPixel(height);
                HtmlViewWrapper.this.setLayoutParams(params);
                HtmlViewWrapper.this.postInvalidate();
            }
        });
    }

    public void setAllowJSResize(boolean allowJSResize) {
        this.mAllowJSResize = allowJSResize;
    }

    public static interface IOnInitFinishedListener {
        public void onInitFinished();
    }

    public static interface BannerInvokeUrlInterface {
        public void onResponse(String var1);
    }

    public static interface BannerShowJSInterface {
        public void onSuccess();

        public void onError(String var1);
    }

    public static interface BannerLoadJSInterface {
        public void onSuccess();

        public void onError(String var1);

        public void onNoOffers();
    }

    public static enum AdState {
        AD_PLAYING,
        AD_STOPED;

    }
}

