/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.api.ui_views.custom_drawables;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;

public class XViewDrawable
extends Drawable {
    private Paint mXPaint = new Paint(1);
    private int mWidth;
    private int mHeight;
    private int mDefaultColor = -1;

    public XViewDrawable(Context context, int color) {
        this.mDefaultColor = color;
        this.init(context);
    }

    private void init(Context context) {
        this.mXPaint.setDither(true);
        this.mXPaint = new Paint(1);
        this.mXPaint.setColor(this.mDefaultColor);
        this.mXPaint.setStrokeWidth((float)XViewDrawable.getStrokeSizeByScreenLayout(context));
        this.mXPaint.setStrokeCap(Paint.Cap.ROUND);
        this.mXPaint.setDither(true);
    }

    public void draw(Canvas canvas) {
        canvas.drawLine(0.0f, (float)this.mHeight, (float)this.mWidth, 0.0f, this.mXPaint);
        canvas.drawLine(0.0f, 0.0f, (float)this.mWidth, (float)this.mHeight, this.mXPaint);
    }

    public void setAlpha(int alpha) {
        this.mXPaint.setAlpha(alpha);
    }

    public void setColorFilter(ColorFilter cf) {
        this.mXPaint.setColorFilter(cf);
    }

    public int getOpacity() {
        return -3;
    }

    protected void onBoundsChange(Rect bounds) {
        super.onBoundsChange(bounds);
        this.mWidth = bounds.width();
        this.mHeight = bounds.height();
    }

    private static int getStrokeSizeByScreenLayout(Context context) {
        int size = 9;
        int screenLayout = context.getResources().getConfiguration().screenLayout;
        switch (screenLayout &= 0xF) {
            case 1: {
                size = 5;
                break;
            }
            case 2: {
                size = 8;
                break;
            }
            case 3: {
                size = 5;
                break;
            }
            case 4: {
                size = 5;
            }
        }
        return size;
    }
}

