/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.api.gif.views;

import android.content.Context;
import android.graphics.Bitmap;
import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import android.widget.ImageView;
import com.kidoz.sdk.api.general.utils.SDKLogger;
import com.kidoz.sdk.api.gif.decoder.GifDecoder;
import java.io.InputStream;
import java.util.UUID;

public class GifDecoderView
extends ImageView {
    private static final int BACKGROUND_COLOR = 0;
    private GifDecoder mGifDecoder;
    private Handler mHandler;
    private Runnable mUpdateResults;
    private Bitmap mTmpBitmap;
    private Context mContext;
    private AnimationThread mLastAnimationThread;
    private boolean mIsPaused = false;

    public GifDecoderView(Context context, InputStream stream, IGifDecoderViewCallback iGifDecoderViewCallback) {
        super(context);
        this.mContext = context;
        this.setBackgroundColor(0);
        new Thread(new InitGifDecoderRunnable(iGifDecoderViewCallback, stream)).start();
    }

    public GifDecoderView(Context context, InputStream stream) {
        super(context);
        this.setBackgroundColor(0);
        this.initGifDecoder(stream);
        this.initUiUpdateMechanism();
    }

    private void initUiUpdateMechanism() {
        this.mHandler = new Handler();
        this.mUpdateResults = new Runnable(){

            @Override
            public void run() {
                if (GifDecoderView.this.mTmpBitmap != null && !GifDecoderView.this.mTmpBitmap.isRecycled()) {
                    GifDecoderView.this.setImageBitmap(GifDecoderView.this.mTmpBitmap);
                }
            }
        };
    }

    private void initGifDecoder(InputStream stream) {
        this.mGifDecoder = new GifDecoder();
        this.mGifDecoder.read(stream);
    }

    public synchronized void start() {
        if (this.mGifDecoder != null) {
            if (this.mLastAnimationThread != null) {
                this.mLastAnimationThread.requestStop();
            }
            this.mLastAnimationThread = new AnimationThread();
            this.mLastAnimationThread.start();
        }
    }

    public synchronized void stop() {
        if (this.mLastAnimationThread != null) {
            this.mLastAnimationThread.requestStop();
        }
    }

    public synchronized void pause() {
        Log.d((String)"", (String)"GifDecoderView | pause");
        this.mIsPaused = true;
    }

    public synchronized void resume() {
        Log.d((String)"", (String)"GifDecoderView | resume");
        this.mIsPaused = false;
    }

    public synchronized void clean() {
        Log.d((String)"", (String)"GifDecoderView | clean");
        if (this.mLastAnimationThread != null) {
            this.mLastAnimationThread.requestStop();
        }
        if (this.mHandler != null) {
            this.mHandler.removeCallbacks(this.mUpdateResults);
        }
        if (this.mTmpBitmap != null) {
            this.mTmpBitmap.recycle();
        }
    }

    public synchronized boolean isPlaying() {
        if (this.mLastAnimationThread != null) {
            return !this.mLastAnimationThread.mRequestStop;
        }
        return false;
    }

    public synchronized boolean isVisible() {
        return this.getVisibility() == 0;
    }

    class AnimationThread
    extends Thread {
        private boolean mRequestStop;

        public AnimationThread() {
            super(new Runnable(){

                @Override
                public void run() {
                    int n = GifDecoderView.this.mGifDecoder.getFrameCount();
                    int ntimes = GifDecoderView.this.mGifDecoder.getLoopCount();
                    int repetitionCounter = 0;
                    String mThreadInstanceId = UUID.randomUUID().toString();
                    do {
                        if (GifDecoderView.this.mIsPaused) continue;
                        for (int i = 0; i < n; ++i) {
                            try {
                                GifDecoderView.this.mTmpBitmap = GifDecoderView.this.mGifDecoder.getFrame(i);
                            }
                            catch (ArrayIndexOutOfBoundsException e) {
                                Log.d((String)"", (String)("GifDecoderView | exception " + e.getLocalizedMessage()));
                                SDKLogger.printErrorLog(e.getLocalizedMessage());
                            }
                            int t = GifDecoderView.this.mGifDecoder.getDelay(i);
                            if (GifDecoderView.this.mHandler != null && GifDecoderView.this.mUpdateResults != null) {
                                GifDecoderView.this.mHandler.post(GifDecoderView.this.mUpdateResults);
                            }
                            try {
                                Thread.sleep(t);
                                continue;
                            }
                            catch (InterruptedException e) {
                                Log.d((String)"", (String)("GifDecoderView | exception " + e.getLocalizedMessage()));
                                SDKLogger.printErrorLog(e.getLocalizedMessage());
                            }
                        }
                        if (ntimes == 0) continue;
                        ++repetitionCounter;
                    } while (!((AnimationThread)Thread.currentThread()).mRequestStop && repetitionCounter <= ntimes);
                }
            });
            this.mRequestStop = false;
        }

        public void requestStop() {
            this.mRequestStop = true;
        }
    }

    class InitGifDecoderRunnable
    implements Runnable {
        private IGifDecoderViewCallback mIGifDecoderViewCallback;
        private InputStream mInputStream;

        public InitGifDecoderRunnable(IGifDecoderViewCallback iGifDecoderViewCallback, InputStream inputStream) {
            this.mIGifDecoderViewCallback = iGifDecoderViewCallback;
            this.mInputStream = inputStream;
        }

        @Override
        public void run() {
            GifDecoderView.this.initGifDecoder(this.mInputStream);
            new Handler(Looper.getMainLooper()).post(new Runnable(){

                @Override
                public void run() {
                    GifDecoderView.this.initUiUpdateMechanism();
                    InitGifDecoderRunnable.this.mIGifDecoderViewCallback.gifDecoderViewReady();
                }
            });
        }
    }

    public static interface IGifDecoderViewCallback {
        public void gifDecoderViewReady();
    }
}

