/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.api.general.utils;

import java.util.HashMap;
import java.util.Map;
import org.json.JSONObject;

public class KidozParams {
    private static final String PUBLISHER_ID = "publisher_id";
    private static final String AUTH_TOKEN = "auth_token";
    private static final String PACKAGE_ID = "package_id";
    private static final String SDK_VERSION = "sdk_version";
    private static final String ACTUAL_SDK_VERSION = "actual_sdk_version";
    private static final String OS_VERSION = "os_version";
    private static final String OS_TYPE = "os_type";
    private static final String EXTENSION_TYPE = "extension_type";
    private static final String APP_VERSION_CODE = "app_version_code";
    private static final String APP_VERSION_NAME = "app_version_name";
    private static final String DEVICE_TYPE = "device_type";
    private static final String DEVICE_LANG = "device_lang";
    private static final String WEBVIEW_VERSION = "webview_version";
    private static final String DEVICE_HASH = "device_hash";
    private static final String GID = "gid";
    private static final String RESOLUTION_HEIGHT = "resolution_height";
    private static final String RESOLUTION_WIDTH = "resolution_width";
    private static final String SCREEN_SIZE = "screen_size";
    private static final String DPI = "dpi";
    private static final String SCREEN_CATEGORY = "screen_category";
    private static final String MANUFACTURER = "manufacturer";
    private static final String MODEL = "model";
    private static final String WIFI_MODE = "wifi_mode";
    private static final String CARRIER_NAME = "carrier_name";
    private static final String NETWORK_TYPE = "network_type";
    private static final String WIDGET_TYPE = "widget_type";
    private static final String CACHE_BUSTER = "cb";
    private static final String STYLE_ID = "style_id";
    private static final String APP_SESSION_ID = "appSessionID";
    private String mPublisherId;
    private String mAuthToken;
    private String mPackageId;
    private String mSdkVersion;
    private String mActualSdkVersion;
    private String mOsVersion;
    private String mOsType;
    private String mExtensionType;
    private String mAppVersionCode;
    private String mAppVersionName;
    private String mDeviceType;
    private String mDeviceLang;
    private String mWebviewVersion;
    private String mDeviceHash;
    private String mGid;
    private String mResolutionHeight;
    private String mResolutionWidth;
    private String mScreenSize;
    private String mDpi;
    private String mScreenCategory;
    private String mManufacturer;
    private String mModel;
    private String mWifiMode;
    private String mCarrierName;
    private String mNetworkType;
    private String mWidgetType;
    private String mCachBuster;
    private String mStyleId;
    private String mAppSessionId;
    private Map<String, String> mParamsMap;

    private KidozParams(ParamBuilder builder) {
        this.mPublisherId = builder.mPublisherId;
        this.mAuthToken = builder.mAuthToken;
        this.mPackageId = builder.mPackageId;
        this.mSdkVersion = builder.mSdkVersion;
        this.mActualSdkVersion = builder.mActualSdkVersion;
        this.mOsVersion = builder.mOsVersion;
        this.mOsType = builder.mOsType;
        this.mExtensionType = builder.mExtensionType;
        this.mAppVersionCode = builder.mAppVersionCode;
        this.mAppVersionName = builder.mAppVersionName;
        this.mDeviceType = builder.mDeviceType;
        this.mDeviceLang = builder.mDeviceLang;
        this.mWebviewVersion = builder.mWebviewVersion;
        this.mDeviceHash = builder.mDeviceHash;
        this.mGid = builder.mGid;
        this.mResolutionHeight = builder.mResolutionHeight;
        this.mResolutionWidth = builder.mResolutionWidth;
        this.mScreenSize = builder.mScreenSize;
        this.mDpi = builder.mDpi;
        this.mScreenCategory = builder.mScreenCategory;
        this.mManufacturer = builder.mManufacturer;
        this.mModel = builder.mModel;
        this.mWifiMode = builder.mWifiMode;
        this.mCarrierName = builder.mCarrierName;
        this.mNetworkType = builder.mNetworkType;
        this.mWidgetType = builder.mWidgetType;
        this.mCachBuster = builder.mCachBuster;
        this.mStyleId = builder.mStyleId;
        this.mAppSessionId = builder.mAppSessionId;
        this.buildParamsMap();
    }

    private void buildParamsMap() {
        this.mParamsMap = new HashMap<String, String>();
        this.mParamsMap.put(PUBLISHER_ID, this.mPublisherId);
        this.mParamsMap.put(AUTH_TOKEN, this.mAuthToken);
        this.mParamsMap.put(PACKAGE_ID, this.mPackageId);
        this.mParamsMap.put(SDK_VERSION, this.mSdkVersion);
        this.mParamsMap.put(ACTUAL_SDK_VERSION, this.mActualSdkVersion);
        this.mParamsMap.put(OS_VERSION, this.mOsVersion);
        this.mParamsMap.put(OS_TYPE, this.mOsType);
        this.mParamsMap.put(EXTENSION_TYPE, this.mExtensionType);
        this.mParamsMap.put(APP_VERSION_CODE, this.mAppVersionCode);
        this.mParamsMap.put(APP_VERSION_NAME, this.mAppVersionName);
        this.mParamsMap.put(DEVICE_TYPE, this.mDeviceType);
        this.mParamsMap.put(DEVICE_LANG, this.mDeviceLang);
        this.mParamsMap.put(WEBVIEW_VERSION, this.mWebviewVersion);
        this.mParamsMap.put(DEVICE_HASH, this.mDeviceHash);
        this.mParamsMap.put(GID, this.mGid);
        this.mParamsMap.put(RESOLUTION_HEIGHT, this.mResolutionHeight);
        this.mParamsMap.put(RESOLUTION_WIDTH, this.mResolutionWidth);
        this.mParamsMap.put(SCREEN_SIZE, this.mScreenSize);
        this.mParamsMap.put(DPI, this.mDpi);
        this.mParamsMap.put(SCREEN_CATEGORY, this.mScreenCategory);
        this.mParamsMap.put(MANUFACTURER, this.mManufacturer);
        this.mParamsMap.put(MODEL, this.mModel);
        this.mParamsMap.put(WIFI_MODE, this.mWifiMode);
        this.mParamsMap.put(CARRIER_NAME, this.mCarrierName);
        this.mParamsMap.put(NETWORK_TYPE, this.mNetworkType);
        this.mParamsMap.put(WIDGET_TYPE, this.mWidgetType);
        this.mParamsMap.put(CACHE_BUSTER, this.mCachBuster);
        this.mParamsMap.put(STYLE_ID, this.mStyleId);
        this.mParamsMap.put(APP_SESSION_ID, this.mAppSessionId);
    }

    public Map<String, String> getParams() {
        return this.mParamsMap;
    }

    public String toString() {
        return new JSONObject(this.mParamsMap).toString();
    }

    public static class ParamBuilder {
        private String mPublisherId;
        private String mAuthToken;
        private String mPackageId;
        private String mSdkVersion;
        private String mActualSdkVersion;
        private String mOsVersion;
        private String mOsType;
        private String mExtensionType;
        private String mAppVersionCode;
        private String mAppVersionName;
        private String mDeviceType;
        private String mDeviceLang;
        private String mWebviewVersion;
        private String mDeviceHash;
        private String mGid;
        private String mResolutionHeight;
        private String mResolutionWidth;
        private String mScreenSize;
        private String mDpi;
        private String mScreenCategory;
        private String mManufacturer;
        private String mModel;
        private String mWifiMode;
        private String mCarrierName;
        private String mNetworkType;
        private String mWidgetType;
        private String mCachBuster;
        private String mStyleId;
        private String mAppSessionId;

        public ParamBuilder setPublisherId(String publisherId) {
            this.mPublisherId = publisherId;
            return this;
        }

        public ParamBuilder setAuthToken(String authToken) {
            this.mAuthToken = authToken;
            return this;
        }

        public ParamBuilder setPackageId(String packageId) {
            this.mPackageId = packageId;
            return this;
        }

        public ParamBuilder setSdkVersion(String sdkVersion) {
            this.mSdkVersion = sdkVersion;
            return this;
        }

        public ParamBuilder setActualSdkVersion(String actualSdkVersion) {
            this.mActualSdkVersion = actualSdkVersion;
            return this;
        }

        public ParamBuilder setOsVersion(int osVersion) {
            this.mOsVersion = String.valueOf(osVersion);
            return this;
        }

        public ParamBuilder setOsType(String osType) {
            this.mOsType = osType;
            return this;
        }

        public ParamBuilder setExtensionType(int extensionType) {
            this.mExtensionType = String.valueOf(extensionType);
            return this;
        }

        public ParamBuilder setAppVersionCode(String appVersionCode) {
            this.mAppVersionCode = appVersionCode;
            return this;
        }

        public ParamBuilder setAppVersionName(String appVersionName) {
            this.mAppVersionName = appVersionName;
            return this;
        }

        public ParamBuilder setDeviceType(String deviceType) {
            this.mDeviceType = deviceType;
            return this;
        }

        public ParamBuilder setDeviceLang(String deviceLang) {
            this.mDeviceLang = deviceLang;
            return this;
        }

        public ParamBuilder setWebviewVersion(String webviewVersion) {
            this.mWebviewVersion = webviewVersion;
            return this;
        }

        public ParamBuilder setDeviceHash(String deviceHash) {
            this.mDeviceHash = deviceHash;
            return this;
        }

        public ParamBuilder setGid(String gid) {
            this.mGid = gid;
            return this;
        }

        public ParamBuilder setResolutionHeight(int resolutionHeight) {
            this.mResolutionHeight = String.valueOf(resolutionHeight);
            return this;
        }

        public ParamBuilder setResolutionWidth(int resolutionWidth) {
            this.mResolutionWidth = String.valueOf(resolutionWidth);
            return this;
        }

        public ParamBuilder setScreenSize(double screenSize) {
            this.mScreenSize = String.valueOf(screenSize);
            return this;
        }

        public ParamBuilder setDpi(float dpi) {
            this.mDpi = String.valueOf(dpi);
            return this;
        }

        public ParamBuilder setScreenCategory(int screenCategory) {
            this.mScreenCategory = String.valueOf(screenCategory);
            return this;
        }

        public ParamBuilder setManufacturer(String manufacturer) {
            this.mManufacturer = manufacturer;
            return this;
        }

        public ParamBuilder setModel(String model) {
            this.mModel = model;
            return this;
        }

        public ParamBuilder setWifiMode(String wifiMode) {
            this.mWifiMode = wifiMode;
            return this;
        }

        public ParamBuilder setCarrierName(String carrierName) {
            this.mCarrierName = carrierName;
            return this;
        }

        public ParamBuilder setNetworkType(String networkType) {
            this.mNetworkType = networkType;
            return this;
        }

        public ParamBuilder setWidgetType(String widgetType) {
            this.mWidgetType = widgetType;
            return this;
        }

        public ParamBuilder setCacheBuster(String cacheBuster) {
            this.mCachBuster = cacheBuster;
            return this;
        }

        public ParamBuilder setStyleId(int styleId) {
            this.mStyleId = String.valueOf(styleId);
            return this;
        }

        public ParamBuilder setAppSessionId(long appSessionId) {
            this.mAppSessionId = String.valueOf(appSessionId);
            return this;
        }

        public KidozParams build() {
            return new KidozParams(this);
        }
    }
}

