/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.api.general.enums;

import java.util.HashMap;
import java.util.Map;

public enum ContentType {
    NONE,
    GOOGLE_PLAY_APPLICATION,
    PROMOTED_PLAY_APPLICATION,
    WEB_GAME_URL,
    WEBSITE_URL,
    STREAMING_VIDEO,
    VIMEO_VIDEO,
    EXTERNAL_BROWSER_URL,
    HTML,
    ROVIO_ITEM;

    private static final Map<ContentType, Integer> lookup;
    private static final Map<Integer, ContentType> reverseLookup;

    public static int getValueFromType(ContentType inVal) {
        return lookup.get((Object)inVal);
    }

    public static ContentType getTypeByValue(int val) {
        return reverseLookup.get(val);
    }

    static {
        lookup = new HashMap<ContentType, Integer>();
        reverseLookup = new HashMap<Integer, ContentType>();
        lookup.put(NONE, -1);
        lookup.put(GOOGLE_PLAY_APPLICATION, 1);
        lookup.put(PROMOTED_PLAY_APPLICATION, 2);
        lookup.put(WEB_GAME_URL, 3);
        lookup.put(WEBSITE_URL, 4);
        lookup.put(STREAMING_VIDEO, 5);
        lookup.put(VIMEO_VIDEO, 6);
        lookup.put(EXTERNAL_BROWSER_URL, 7);
        lookup.put(HTML, 10);
        lookup.put(ROVIO_ITEM, 11);
        reverseLookup.put(-1, NONE);
        reverseLookup.put(1, GOOGLE_PLAY_APPLICATION);
        reverseLookup.put(2, PROMOTED_PLAY_APPLICATION);
        reverseLookup.put(3, WEB_GAME_URL);
        reverseLookup.put(4, WEBSITE_URL);
        reverseLookup.put(5, STREAMING_VIDEO);
        reverseLookup.put(6, VIMEO_VIDEO);
        reverseLookup.put(7, EXTERNAL_BROWSER_URL);
        reverseLookup.put(10, HTML);
        reverseLookup.put(11, ROVIO_ITEM);
    }
}

