/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.api.general.cache;

import com.kidoz.sdk.api.general.cache.CustomAsyncExecutor;
import com.kidoz.sdk.api.general.cache.WebViewData;
import com.kidoz.sdk.api.general.cache.WebViewDataRequest;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

public class CacheWebViewFactory {
    private static CacheWebViewFactory single_instance = null;
    private static final Object lock = new Object();
    private Map<String, String> playersUrl;
    private Map<String, WebViewData> concurrentHashMapObject = new HashMap<String, WebViewData>();
    private ExecutorService executorService = Executors.newCachedThreadPool();

    private CacheWebViewFactory() {
        this.playersUrl = new HashMap<String, String>();
    }

    public static synchronized CacheWebViewFactory getInstance() {
        if (single_instance == null) {
            single_instance = new CacheWebViewFactory();
        }
        return single_instance;
    }

    public void addCacheAsync(final String key, final String url, final CacheWebViewFactoryCallBack playerFactoryCallback) {
        CustomAsyncExecutor<Void, Boolean> customAsyncExecutor = new CustomAsyncExecutor<Void, Boolean>(){

            @Override
            public Boolean executeAsync(Void input) {
                return CacheWebViewFactory.this.addCache(key, url);
            }

            @Override
            public void postExecute(Boolean result) {
                if (playerFactoryCallback != null) {
                    playerFactoryCallback.onReady(result);
                }
            }
        };
        customAsyncExecutor.execute(null);
    }

    public boolean addCache(String key, String url) {
        if (this.hasCache(key)) {
            return true;
        }
        if (url.toLowerCase().startsWith("https://") || url.toLowerCase().startsWith("http://")) {
            CacheWebViewFactoryRunnable cacheWebViewFactoryRunnable = new CacheWebViewFactoryRunnable(key, url);
            this.executorService.execute(cacheWebViewFactoryRunnable);
        }
        try {
            return this.executorService.awaitTermination(1L, TimeUnit.MINUTES);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean start() {
        boolean isReady;
        for (Map.Entry<String, String> entry : this.playersUrl.entrySet()) {
            if (!entry.getValue().toLowerCase().startsWith("https://") && !entry.getValue().toLowerCase().startsWith("http://")) continue;
            CacheWebViewFactoryRunnable cacheWebViewFactoryRunnable = new CacheWebViewFactoryRunnable(entry.getKey(), entry.getValue());
            this.executorService.execute(cacheWebViewFactoryRunnable);
        }
        this.executorService.shutdown();
        try {
            isReady = this.executorService.awaitTermination(1L, TimeUnit.MINUTES);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            isReady = false;
        }
        return isReady;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WebViewData getCache(String key) {
        if (this.hasCache(key)) {
            Object object = lock;
            synchronized (object) {
                if (this.concurrentHashMapObject != null && key != null && !key.equals("")) {
                    WebViewData webViewData = this.concurrentHashMapObject.get(key);
                    return webViewData;
                }
            }
        }
        return null;
    }

    public void startAsync(final CacheWebViewFactoryCallBack callback) {
        CustomAsyncExecutor<Void, Boolean> customAsyncExecutor = new CustomAsyncExecutor<Void, Boolean>(){

            @Override
            public Boolean executeAsync(Void input) {
                return CacheWebViewFactory.this.start();
            }

            @Override
            public void postExecute(Boolean result) {
                callback.onReady(result);
            }
        };
        customAsyncExecutor.execute(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasCache(String key) {
        Object object = lock;
        synchronized (object) {
            WebViewData webViewData;
            if (this.concurrentHashMapObject != null && key != null && !key.equals("") && this.concurrentHashMapObject.containsKey(key) && (webViewData = this.concurrentHashMapObject.get(key)) != null) {
                return webViewData.hasData();
            }
        }
        return false;
    }

    class CacheWebViewFactoryRunnable
    implements Runnable {
        private String PlayerName;
        private String PlayerUrl;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            WebViewDataRequest webViewDataRequest = new WebViewDataRequest(this.PlayerUrl);
            WebViewData webViewData = (WebViewData)webViewDataRequest.executeRequest();
            Object object = lock;
            synchronized (object) {
                if (CacheWebViewFactory.this.concurrentHashMapObject != null) {
                    CacheWebViewFactory.this.concurrentHashMapObject.put(this.PlayerName, webViewData);
                }
            }
        }

        public CacheWebViewFactoryRunnable(String PlayerName, String PlayerUrl) {
            this.PlayerName = PlayerName;
            this.PlayerUrl = PlayerUrl;
        }
    }

    public static interface CacheWebViewFactoryCallBack {
        public void onReady(boolean var1);

        public void onError(String var1);
    }
}

