/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.api.anr_handler;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public abstract class ANRBuster<T, V> {
    Callable<Boolean> mCallable;
    private ExecutorService executorService = Executors.newSingleThreadExecutor();
    private int ANR_TIMEOUT = 5000;
    private int TIMEOUT_MARGIN = 1500;
    private T mParam;
    private V mResult;

    public abstract V onStart(T var1);

    public abstract void onANRDetected();

    public abstract void onSuccess();

    public ANRBuster() {
        this.mCallable = new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                ANRBuster.this.mResult = ANRBuster.this.onStart(ANRBuster.this.mParam);
                return true;
            }
        };
    }

    public V start() {
        this.execute();
        return this.mResult;
    }

    private void execute() {
        try {
            this.executorService.submit(this.mCallable).get(this.ANR_TIMEOUT - this.TIMEOUT_MARGIN, TimeUnit.MILLISECONDS);
            this.onSuccess();
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
        catch (TimeoutException e) {
            this.onANRDetected();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public V start(T param) {
        this.mParam = param;
        this.execute();
        return this.mResult;
    }
}

