/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.api.ui_views.panel_view;

import android.animation.Animator;
import android.content.Context;
import android.graphics.Point;
import android.os.Looper;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import com.kidoz.sdk.api.general.animations.GenAnimator;
import com.kidoz.sdk.api.general.utils.Utils;
import com.kidoz.sdk.api.ui_views.custom_drawables.DefaultPanelDrawable;
import com.kidoz.sdk.api.ui_views.panel_view.LocalAssetHelper;
import com.kidoz.sdk.api.ui_views.panel_view.PANEL_TYPE;
import com.kidoz.sdk.api.ui_views.parental_lock.AssetView;

public class PanelHandle
extends RelativeLayout {
    private static final float DEFAULT_HANDLE_SCALE_SIZE = 0.15f;
    private AssetView mOpenAssetBgView;
    private AssetView mOpenAssetFrgView;
    private AssetView mCloseAssetBgView;
    private AssetView mCloseAssetFrgView;
    private RelativeLayout.LayoutParams mInnerOpenBtnLayParams;
    private RelativeLayout.LayoutParams mInnerCloseBtnLayParams;
    private DefaultPanelDrawable mLegacyOpenDefaultDrawable;
    private DefaultPanelDrawable mLegacyCloseDefaultDrawable;
    private DefaultPanelDrawable mOpenDefaultDrawable;
    private DefaultPanelDrawable mCloseDefaultDrawable;
    private int mHandleSize = 0;
    private PANEL_TYPE mPanelType;
    private int mColor = -1;
    private IOnPanelHandleClickListener mClickListener;
    private Utils.StaticHandler mHandler = new Utils.StaticHandler(Looper.getMainLooper());
    private boolean mIsLegacyAssets = true;

    public PanelHandle(Context context, PANEL_TYPE panelType, int size, IOnPanelHandleClickListener handleClickListener) {
        super(context);
        this.mHandleSize = size;
        this.mPanelType = panelType;
        this.mClickListener = handleClickListener;
        this.initHandle();
    }

    private void initHandle() {
        if (this.mHandleSize == 0) {
            Point point = Utils.getScreenSize(this.getContext());
            this.mHandleSize = (int)((float)Math.min(point.x, point.y) * 0.15f);
        }
        this.mInnerOpenBtnLayParams = new RelativeLayout.LayoutParams(this.mHandleSize, this.mHandleSize);
        this.mInnerOpenBtnLayParams.addRule(13);
        this.mInnerCloseBtnLayParams = new RelativeLayout.LayoutParams(this.mHandleSize, this.mHandleSize);
        this.mInnerCloseBtnLayParams.addRule(13);
        this.mOpenAssetBgView = new AssetView(this.getContext());
        this.mOpenAssetBgView.setVisibility(4);
        this.mOpenAssetFrgView = new AssetView(this.getContext());
        this.mOpenAssetFrgView.setVisibility(4);
        this.mCloseAssetBgView = new AssetView(this.getContext());
        this.mCloseAssetBgView.setVisibility(4);
        this.mCloseAssetFrgView = new AssetView(this.getContext());
        this.mCloseAssetFrgView.setVisibility(4);
        this.addView((View)this.mCloseAssetBgView, (ViewGroup.LayoutParams)this.mInnerCloseBtnLayParams);
        this.addView((View)this.mCloseAssetFrgView, (ViewGroup.LayoutParams)this.mInnerCloseBtnLayParams);
        this.addView((View)this.mOpenAssetBgView, (ViewGroup.LayoutParams)this.mInnerOpenBtnLayParams);
        this.addView((View)this.mOpenAssetFrgView, (ViewGroup.LayoutParams)this.mInnerOpenBtnLayParams);
        this.setOnClickListener(new View.OnClickListener(){

            public void onClick(final View v) {
                PanelHandle.this.mHandler.postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        PanelHandle.this.playHandleClickAnimation(v);
                    }
                }, 180L);
            }
        });
    }

    public void loadAssets(LocalAssetHelper helper, IonPanelHandlePreparedListener listener) {
        this.mIsLegacyAssets = helper.isLegacyParams();
        if (this.mIsLegacyAssets) {
            this.loadHandleLegacyAssets(helper, listener);
        } else {
            this.loadHandleAssets(helper, listener);
        }
        this.setCorrectRotation();
    }

    private void loadHandleLegacyAssets(final LocalAssetHelper helper, final IonPanelHandlePreparedListener listener) {
        this.mLegacyOpenDefaultDrawable = new DefaultPanelDrawable(this.getContext(), this.mPanelType, DefaultPanelDrawable.PanelDrawableType.OPEN_VIEW);
        this.mLegacyOpenDefaultDrawable.setBaseColor(this.mColor);
        this.mLegacyCloseDefaultDrawable = new DefaultPanelDrawable(this.getContext(), this.mPanelType, DefaultPanelDrawable.PanelDrawableType.CLOSE_VIEW);
        this.mLegacyCloseDefaultDrawable.setBaseColor(this.mColor);
        this.mOpenAssetBgView.setVisibility(8);
        this.mCloseAssetBgView.setVisibility(4);
        this.mOpenAssetFrgView.setVisibility(4);
        this.mCloseAssetFrgView.setVisibility(4);
        this.mOpenAssetBgView.loadAsset(helper.legacyBtnOpenAsset, this.mLegacyOpenDefaultDrawable, new AssetView.IOnAssetLoadedListener(){

            @Override
            public void onAssetLoaded(boolean successfull) {
                if (!successfull) {
                    PanelHandle.this.mOpenAssetFrgView.loadAsset(helper.legacyBtnDefaultOpenSponsoredAsset, null, new AssetView.IOnAssetLoadedListener(){

                        @Override
                        public void onAssetLoaded(boolean successfull) {
                            if (successfull) {
                                PanelHandle.this.mLegacyOpenDefaultDrawable.setDrawSign(false);
                            } else {
                                PanelHandle.this.mOpenAssetFrgView.setVisibility(4);
                            }
                            PanelHandle.this.mCloseAssetFrgView.loadAsset(helper.legacyBtnCloseAsset, PanelHandle.this.mLegacyCloseDefaultDrawable, new AssetView.IOnAssetLoadedListener(){

                                @Override
                                public void onAssetLoaded(boolean successfull) {
                                    if (listener != null) {
                                        listener.onPanelPrepared();
                                    }
                                }
                            });
                        }
                    });
                } else {
                    PanelHandle.this.mCloseAssetFrgView.loadAsset(helper.legacyBtnCloseAsset, PanelHandle.this.mLegacyCloseDefaultDrawable, new AssetView.IOnAssetLoadedListener(){

                        @Override
                        public void onAssetLoaded(boolean successfull) {
                            if (listener != null) {
                                listener.onPanelPrepared();
                            }
                        }
                    });
                }
            }
        });
    }

    private void loadHandleAssets(final LocalAssetHelper helper, final IonPanelHandlePreparedListener listener) {
        this.mOpenDefaultDrawable = new DefaultPanelDrawable(this.getContext(), PANEL_TYPE.BOTTOM, DefaultPanelDrawable.PanelDrawableType.OPEN_VIEW);
        this.mOpenDefaultDrawable.setBaseColor(this.mColor);
        this.mOpenDefaultDrawable.setDrawSign(false);
        this.mCloseDefaultDrawable = new DefaultPanelDrawable(this.getContext(), PANEL_TYPE.BOTTOM, DefaultPanelDrawable.PanelDrawableType.CLOSE_VIEW);
        this.mCloseDefaultDrawable.setBaseColor(this.mColor);
        this.mCloseDefaultDrawable.setDrawSign(false);
        this.mOpenAssetFrgView.loadAsset(helper.openBtnAssetFrg, null, new AssetView.IOnAssetLoadedListener(){

            @Override
            public void onAssetLoaded(boolean successfull) {
                if (!successfull) {
                    PanelHandle.this.mOpenDefaultDrawable.setDrawSign(true);
                } else {
                    PanelHandle.this.mOpenDefaultDrawable.setDrawSign(false);
                }
                PanelHandle.this.mOpenAssetBgView.loadAsset(helper.openBtnAssetBg, PanelHandle.this.mOpenDefaultDrawable, new AssetView.IOnAssetLoadedListener(){

                    @Override
                    public void onAssetLoaded(boolean successfull) {
                        PanelHandle.this.mCloseAssetFrgView.loadAsset(helper.closeBtnAssetFrg, null, new AssetView.IOnAssetLoadedListener(){

                            @Override
                            public void onAssetLoaded(boolean successfull) {
                                if (!successfull) {
                                    PanelHandle.this.mCloseDefaultDrawable.setDrawSign(true);
                                } else {
                                    PanelHandle.this.mCloseDefaultDrawable.setDrawSign(false);
                                }
                                PanelHandle.this.mCloseAssetBgView.loadAsset(helper.closeBtnAssetBg, PanelHandle.this.mCloseDefaultDrawable, new AssetView.IOnAssetLoadedListener(){

                                    @Override
                                    public void onAssetLoaded(boolean successfull) {
                                        if (listener != null) {
                                            listener.onPanelPrepared();
                                        }
                                    }
                                });
                            }
                        });
                    }
                });
            }
        });
    }

    public void setBaseColor(int baseColor) {
        this.mColor = baseColor;
        if (this.mOpenDefaultDrawable != null && this.mCloseDefaultDrawable != null) {
            this.mOpenDefaultDrawable.setBaseColor(baseColor);
            this.mCloseDefaultDrawable.setBaseColor(baseColor);
        }
        if (this.mLegacyCloseDefaultDrawable != null && this.mLegacyOpenDefaultDrawable != null) {
            this.mLegacyCloseDefaultDrawable.setBaseColor(baseColor);
            this.mLegacyOpenDefaultDrawable.setBaseColor(baseColor);
        }
        this.postInvalidate();
    }

    public void setPanelType(PANEL_TYPE panelType) {
        this.mPanelType = panelType;
        if (this.mLegacyOpenDefaultDrawable != null && this.mLegacyCloseDefaultDrawable != null) {
            this.mLegacyCloseDefaultDrawable.setPanelType(this.mPanelType);
            this.mLegacyOpenDefaultDrawable.setPanelType(this.mPanelType);
        }
        this.setCorrectRotation();
    }

    private void setCorrectRotation() {
        if (!this.mIsLegacyAssets) {
            switch (this.mPanelType) {
                case BOTTOM: {
                    this.mOpenAssetBgView.setRotation(0.0f);
                    this.mCloseAssetBgView.setRotation(0.0f);
                    break;
                }
                case TOP: {
                    this.mOpenAssetBgView.setRotation(180.0f);
                    this.mCloseAssetBgView.setRotation(180.0f);
                }
            }
        }
        this.postInvalidate();
    }

    private void postInvalidateLayers() {
        this.mOpenAssetBgView.postInvalidate();
        this.mOpenAssetFrgView.postInvalidate();
        this.mCloseAssetBgView.postInvalidate();
        this.mCloseAssetFrgView.postInvalidate();
    }

    public void setPanelButtonState(PANEL_HANDLE_VIEW_STATE panelHandleState) {
        switch (panelHandleState) {
            case CLOSED: {
                if (this.mIsLegacyAssets) {
                    this.mOpenAssetBgView.setVisibility(0);
                    this.mOpenAssetFrgView.setVisibility(0);
                    this.mCloseAssetFrgView.setVisibility(4);
                    break;
                }
                this.mOpenAssetBgView.setVisibility(0);
                this.mOpenAssetFrgView.setVisibility(0);
                this.mCloseAssetBgView.setVisibility(4);
                this.mCloseAssetFrgView.setVisibility(4);
                break;
            }
            case OPENED: {
                if (this.mIsLegacyAssets) {
                    this.mOpenAssetBgView.setVisibility(4);
                    this.mOpenAssetFrgView.setVisibility(4);
                    this.mCloseAssetFrgView.setVisibility(0);
                    break;
                }
                this.mOpenAssetBgView.setVisibility(4);
                this.mOpenAssetFrgView.setVisibility(4);
                this.mCloseAssetBgView.setVisibility(0);
                this.mCloseAssetFrgView.setVisibility(0);
            }
        }
        this.postInvalidate();
    }

    private void playHandleClickAnimation(View v) {
        GenAnimator.playPanelButtonClickAnimation(v, this.mPanelType, new Animator.AnimatorListener(){

            public void onAnimationStart(Animator animation) {
            }

            public void onAnimationEnd(Animator animation) {
                if (PanelHandle.this.mClickListener != null) {
                    PanelHandle.this.mClickListener.onHandleClick();
                }
            }

            public void onAnimationCancel(Animator animation) {
            }

            public void onAnimationRepeat(Animator animation) {
            }
        });
    }

    public static interface IonPanelHandlePreparedListener {
        public void onPanelPrepared();
    }

    public static interface IOnPanelHandleClickListener {
        public void onHandleClick();
    }

    public static enum PANEL_HANDLE_VIEW_STATE {
        OPENED,
        CLOSED;

    }
}

