/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.api.players.web_player;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Rect;
import android.net.Uri;
import android.os.Build;
import android.os.Looper;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.webkit.WebResourceResponse;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import com.kidoz.events.Event;
import com.kidoz.events.EventManager;
import com.kidoz.sdk.api.general.ContentExecutionHandler;
import com.kidoz.sdk.api.general.IViewVisibilityEventListener;
import com.kidoz.sdk.api.general.ViewVisibilityEventListener;
import com.kidoz.sdk.api.general.enums.ContentType;
import com.kidoz.sdk.api.general.enums.WidgetType;
import com.kidoz.sdk.api.general.utils.ConstantDef;
import com.kidoz.sdk.api.general.utils.SDKLogger;
import com.kidoz.sdk.api.general.utils.Utils;
import com.kidoz.sdk.api.players.web_player.WebPlayerType;
import com.kidoz.sdk.api.players.web_player.WebViewVisibilityListener;
import com.kidoz.sdk.api.structure.ContentItem;
import com.kidoz.sdk.api.ui_views.web_view_clients.KidozWebChromeClient;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;

public class KidozWebView
extends WebView {
    protected static final String HTTP = "http://";
    protected static final String HTTPS = "https://";
    protected static final String WWW = "www.";
    protected static final String WWW2 = "www2.";
    protected static final String KIDOZ_DOMAIN = "kidoz";
    protected static final List<String> PREFIXES_TO_REMOVE = new LinkedList<String>();
    private Utils.StaticHandler staticHandler;
    private ContentItem mContentItem;
    private ViewVisibilityEventListener mViewVisibilityEventListener;
    private String mLastOverloadUrl = "";
    private WebViewVisibilityListener mWebViewIVisibilityListener;
    private final String TAG = KidozWebView.class.getSimpleName();
    private static int API;
    private Context mContext;
    private ArrayList<String> mAllowedSitesKeyWords = new ArrayList();
    private IOnLounchExternalAppFromRedirectListener onLounchExternalAppFromRedirectListener;
    private WebPlayerType mWebPlayerType = WebPlayerType.WEB_BROWSER;
    private String mGooglePlayAppId = null;

    public void setWebViewVisibilityListener(WebViewVisibilityListener webViewIVisibilityListener) {
        this.mWebViewIVisibilityListener = webViewIVisibilityListener;
    }

    public KidozWebView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.mContext = context;
        this.initWebView();
        this.initForTarget(this.mWebPlayerType);
    }

    public KidozWebView(Context context) {
        super(context);
        this.mContext = context;
        this.initWebView();
        this.initForTarget(this.mWebPlayerType);
    }

    public KidozWebView(Context context, WebPlayerType webPlayerType) {
        super(context);
        this.mContext = context;
        this.mWebPlayerType = webPlayerType;
        this.initWebView();
        this.initForTarget(webPlayerType);
    }

    public void setContentItem(ContentItem contentItem) {
        this.mContentItem = contentItem;
    }

    public void initForTarget(WebPlayerType webPlayerType) {
        if (webPlayerType != null) {
            switch (webPlayerType) {
                case ONLINE_GAME: {
                    this.initAWorkingSettingsForVideoInWebView();
                    break;
                }
                case WEB_BROWSER: {
                    this.initAWorkingSettingsForVideoInWebView();
                    break;
                }
                case EXTERNAL_LINK: {
                    this.initializeGeneralSettingsState(this.getContext());
                    break;
                }
                case ROVIO: {
                    this.initAWorkingSettingsForVideoInWebView();
                }
            }
        }
    }

    @SuppressLint(value={"SetJavaScriptEnabled", "NewApi"})
    public void initializeGeneralSettingsState(Context context) {
        if (API < 18) {
            this.getSettings().setAppCacheMaxSize(Long.MAX_VALUE);
        }
        if (API < 17) {
            this.getSettings().setEnableSmoothTransition(true);
        }
        if (API >= 17) {
            this.getSettings().setMediaPlaybackRequiresUserGesture(false);
        }
        if (API >= 19) {
            KidozWebView.setWebContentsDebuggingEnabled((boolean)ConstantDef.DGM);
        }
        if (API < 19) {
            this.getSettings().setDatabasePath(context.getCacheDir() + "/databases");
        }
        this.getSettings().setDomStorageEnabled(true);
        this.getSettings().setAppCacheEnabled(true);
        this.getSettings().setAppCachePath(context.getCacheDir().toString());
        this.getSettings().setCacheMode(-1);
        this.getSettings().setGeolocationDatabasePath(context.getFilesDir().toString());
        this.getSettings().setAllowFileAccess(true);
        this.getSettings().setDatabaseEnabled(true);
        this.getSettings().setSupportZoom(true);
        this.getSettings().setBuiltInZoomControls(true);
        this.getSettings().setDisplayZoomControls(false);
        this.getSettings().setAllowContentAccess(true);
        this.getSettings().setDefaultTextEncodingName("utf-8");
        if (API >= 16) {
            this.getSettings().setAllowFileAccessFromFileURLs(false);
            this.getSettings().setAllowUniversalAccessFromFileURLs(false);
        }
        SharedPreferences mPreferences = context.getSharedPreferences("settings", 0);
        this.getSettings().setGeolocationEnabled(mPreferences.getBoolean("location", false));
        if (API < 19) {
            switch (mPreferences.getInt("enableflash", 0)) {
                case 0: {
                    this.getSettings().setPluginState(WebSettings.PluginState.OFF);
                    break;
                }
                case 1: {
                    this.getSettings().setPluginState(WebSettings.PluginState.ON_DEMAND);
                    break;
                }
                case 2: {
                    this.getSettings().setPluginState(WebSettings.PluginState.ON);
                    break;
                }
            }
        }
        if (mPreferences.getBoolean("passwords", false)) {
            if (API < 18) {
                this.getSettings().setSavePassword(true);
            }
            this.getSettings().setSaveFormData(true);
        }
        if (mPreferences.getBoolean("java", true)) {
            this.getSettings().setJavaScriptEnabled(true);
            this.getSettings().setJavaScriptCanOpenWindowsAutomatically(true);
        }
        if (mPreferences.getBoolean("textreflow", false)) {
            this.getSettings().setLayoutAlgorithm(WebSettings.LayoutAlgorithm.NARROW_COLUMNS);
        } else if (API >= 19) {
            try {
                this.getSettings().setLayoutAlgorithm(WebSettings.LayoutAlgorithm.TEXT_AUTOSIZING);
            }
            catch (Exception ex) {
                this.getSettings().setLayoutAlgorithm(WebSettings.LayoutAlgorithm.NORMAL);
                SDKLogger.printErrorLog(this.TAG, "Error when trying to set layout algorithm: " + ex.getMessage());
            }
        } else {
            this.getSettings().setLayoutAlgorithm(WebSettings.LayoutAlgorithm.NORMAL);
        }
        this.getSettings().setBlockNetworkImage(mPreferences.getBoolean("blockimages", false));
        this.getSettings().setSupportMultipleWindows(mPreferences.getBoolean("newwindows", true));
        this.getSettings().setUseWideViewPort(mPreferences.getBoolean("wideviewport", true));
        this.getSettings().setLoadWithOverviewMode(mPreferences.getBoolean("overviewmode", true));
        switch (mPreferences.getInt("textsize", 3)) {
            case 1: {
                this.getSettings().setTextZoom(200);
                break;
            }
            case 2: {
                this.getSettings().setTextZoom(150);
                break;
            }
            case 3: {
                this.getSettings().setTextZoom(100);
                break;
            }
            case 4: {
                this.getSettings().setTextZoom(75);
                break;
            }
            case 5: {
                this.getSettings().setTextZoom(50);
            }
        }
        if (Build.VERSION.SDK_INT > 22) {
            this.setLayerType(2, null);
        } else {
            this.setLayerType(1, null);
        }
        if (Build.VERSION.SDK_INT >= 21) {
            this.getSettings().setMixedContentMode(0);
        }
    }

    @TargetApi(value=19)
    public synchronized void initOnlineGameSettings(Context context) {
        if (API < 18) {
            this.getSettings().setAppCacheMaxSize(Long.MAX_VALUE);
        }
        if (API < 17) {
            this.getSettings().setEnableSmoothTransition(true);
        }
        if (API >= 17) {
            this.getSettings().setMediaPlaybackRequiresUserGesture(true);
        }
        if (API >= 19) {
            KidozWebView.setWebContentsDebuggingEnabled((boolean)ConstantDef.DGM);
        }
        if (API < 19) {
            this.getSettings().setDatabasePath(context.getCacheDir() + "/databases");
        }
        this.getSettings().setJavaScriptEnabled(true);
        this.getSettings().setLoadWithOverviewMode(true);
        this.getSettings().setAllowContentAccess(true);
        this.getSettings().setUseWideViewPort(false);
        if (Build.VERSION.SDK_INT < 18) {
            this.getSettings().setPluginState(WebSettings.PluginState.ON);
        }
        this.getSettings().setDomStorageEnabled(true);
        this.getSettings().setAllowFileAccess(true);
        this.clearHistory();
        this.clearFormData();
        if (API >= 19) {
            try {
                this.getSettings().setLayoutAlgorithm(WebSettings.LayoutAlgorithm.TEXT_AUTOSIZING);
            }
            catch (Exception ex) {
                this.getSettings().setLayoutAlgorithm(WebSettings.LayoutAlgorithm.NORMAL);
                SDKLogger.printErrorLog(this.TAG, "Error when trying to set layout algorithm: " + ex.getMessage());
            }
        } else {
            this.getSettings().setLayoutAlgorithm(WebSettings.LayoutAlgorithm.NORMAL);
        }
        if (Build.VERSION.SDK_INT > 22) {
            this.setLayerType(2, null);
        } else {
            this.setLayerType(1, null);
        }
    }

    @SuppressLint(value={"NewApi"})
    private void initWebView() {
        if (this.mViewVisibilityEventListener == null) {
            this.mViewVisibilityEventListener = new ViewVisibilityEventListener((View)this);
            this.mViewVisibilityEventListener.setViewVisibilityEventListener(new IViewVisibilityEventListener(){

                @Override
                public void onViewBecameVisible(boolean isVisible) {
                    if (KidozWebView.this.mWebViewIVisibilityListener != null) {
                        KidozWebView.this.mWebViewIVisibilityListener.onWebViewBecameVisible(isVisible);
                    }
                }
            });
        }
        this.staticHandler = new Utils.StaticHandler(Looper.getMainLooper());
        this.staticHandler.removeCallbacksAndMessages(null);
        this.setDrawingCacheBackgroundColor(0);
        this.setFocusableInTouchMode(true);
        this.setFocusable(true);
        this.setAnimationCacheEnabled(true);
        this.setDrawingCacheEnabled(true);
        if (API > 15) {
            this.setBackground(null);
            this.getRootView().setBackground(null);
        } else {
            this.getRootView().setBackgroundDrawable(null);
        }
        this.setWillNotCacheDrawing(false);
        this.setAlwaysDrawnWithCacheEnabled(true);
        this.setScrollbarFadingEnabled(true);
        this.setSaveEnabled(true);
        this.setWebChromeClient(new KidozWebChromeClient());
        this.initWebChromeClient();
        if (Build.VERSION.SDK_INT >= 21) {
            this.getSettings().setMixedContentMode(0);
        }
        this.setOnFocusChangeListener(new View.OnFocusChangeListener(){

            public void onFocusChange(View v, boolean hasFocus) {
                if (!hasFocus) {
                    SDKLogger.printErrorLog(KidozWebView.this.TAG, "focus off \n");
                } else {
                    SDKLogger.printErrorLog(KidozWebView.this.TAG, "focus on \n");
                }
            }
        });
    }

    protected void onVisibilityChanged(View changedView, int visibility) {
        super.onVisibilityChanged(changedView, visibility);
    }

    public void invalidate() {
        super.invalidate();
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
    }

    protected void onFocusChanged(boolean focused, int direction, Rect previouslyFocusedRect) {
        super.onFocusChanged(focused, direction, previouslyFocusedRect);
    }

    private void initWebChromeClient() {
        this.setWebViewClient(new WebViewClient(){

            public void onPageStarted(WebView view, String url, Bitmap favicon) {
                super.onPageStarted(view, url, favicon);
                Log.e((String)"LEV", (String)("KIDOZ_LOG  - onPageStarted " + url));
            }

            public void onReceivedError(WebView view, int errorCode, String description, String failingUrl) {
                Event event = new Event();
                if (KidozWebView.this.mContentItem != null) {
                    event.addParameterToJsonObject("ItemID", KidozWebView.this.mContentItem.getId());
                    event.addParameterToJsonObject("AdvertiserID", KidozWebView.this.mContentItem.getAdvertiserID());
                }
                EventManager.getInstance(KidozWebView.this.getContext()).logEvent(KidozWebView.this.getContext(), "0", "", EventManager.LOG_CRITICAL_LEVEL, event, "WebView Error", String.valueOf(errorCode).concat(": ").concat(description), failingUrl);
            }

            public void onPageFinished(WebView view, String url) {
                super.onPageFinished(view, url);
            }

            public WebResourceResponse shouldInterceptRequest(WebView view, String url) {
                if (url.startsWith(KidozWebView.HTTP)) {
                    return new WebResourceResponse(null, null, null);
                }
                return super.shouldInterceptRequest(view, url);
            }

            public boolean shouldOverrideUrlLoading(WebView view, String url) {
                Log.e((String)"LEV", (String)("KIDOZ_LOG  - shouldOverrideUrlLoading " + url));
                if (url.startsWith(KidozWebView.HTTP)) {
                    return true;
                }
                KidozWebView.this.mLastOverloadUrl = url;
                SDKLogger.printDebugLog(KidozWebView.this.TAG, "shouldOverrideUrlLoading: url= " + url);
                boolean result = true;
                if (KidozWebView.this.mWebPlayerType == WebPlayerType.ROVIO) {
                    return super.shouldOverrideUrlLoading(view, url);
                }
                if (KidozWebView.this.mWebPlayerType == WebPlayerType.ONLINE_GAME || KidozWebView.this.mWebPlayerType == WebPlayerType.WEB_BROWSER) {
                    boolean bl = result = !KidozWebView.this.checkIfSafeUrl(url);
                    if (result) {
                        ContentItem contentItem = new ContentItem();
                        contentItem.setContentType(ContentType.EXTERNAL_BROWSER_URL);
                        contentItem.setIsPromoted(true);
                        contentItem.setData(url);
                        ContentExecutionHandler.handleContentItemClick(KidozWebView.this.getContext(), contentItem, WidgetType.WIDGET_TYPE_NONE.getStringValue(), "0", 0, false, null);
                    }
                } else if (KidozWebView.this.mWebPlayerType == WebPlayerType.EXTERNAL_LINK) {
                    if (url.contains("market://") || url.contains("start.google.com") || url.contains("play.google.com") && KidozWebView.this.mGooglePlayAppId != null) {
                        try {
                            String googlePlayMarketURL = "market://details?id=" + KidozWebView.this.mGooglePlayAppId;
                            String[] urlPazzel = url.split(KidozWebView.this.mGooglePlayAppId);
                            if (urlPazzel != null && urlPazzel.length > 1) {
                                googlePlayMarketURL = googlePlayMarketURL + urlPazzel[1];
                            }
                            Intent intent = new Intent("android.intent.action.VIEW");
                            intent.setData(Uri.parse((String)googlePlayMarketURL));
                            if (KidozWebView.this.onLounchExternalAppFromRedirectListener != null) {
                                KidozWebView.this.onLounchExternalAppFromRedirectListener.onLounch();
                            }
                            intent.addFlags(0x10000000);
                            KidozWebView.this.mContext.startActivity(intent);
                        }
                        catch (Exception ex) {
                            SDKLogger.printErrorLog(KidozWebView.this.TAG, "Error when trying to open google start for promoted app: \n" + ex.getMessage());
                        }
                        result = true;
                    } else {
                        view.loadUrl(url);
                        result = true;
                    }
                } else {
                    view.loadUrl(url);
                    result = true;
                }
                return result;
            }
        });
    }

    public String getLastOverloadUrl() {
        return this.mLastOverloadUrl;
    }

    private void initAWorkingSettingsForVideoInWebView() {
        this.getSettings().setJavaScriptEnabled(true);
        if (Build.VERSION.SDK_INT >= 21) {
            this.getSettings().setMixedContentMode(0);
        }
        this.setDrawingCacheBackgroundColor(0);
        this.setBackgroundColor(Color.argb((int)1, (int)0, (int)0, (int)0));
        this.setFocusableInTouchMode(true);
        this.setFocusable(true);
        this.setAnimationCacheEnabled(true);
        this.setDrawingCacheEnabled(true);
        if (Build.VERSION.SDK_INT < 19) {
            this.getSettings().setDatabasePath(this.getContext().getCacheDir() + "/databases");
        }
        this.getSettings().setAppCacheEnabled(true);
        this.getSettings().setDatabaseEnabled(true);
        if (Build.VERSION.SDK_INT < 18) {
            this.getSettings().setAppCacheMaxSize(Long.MAX_VALUE);
        }
        if (Build.VERSION.SDK_INT < 17) {
            this.getSettings().setEnableSmoothTransition(true);
        }
        if (Build.VERSION.SDK_INT < 18) {
            this.getSettings().setRenderPriority(WebSettings.RenderPriority.HIGH);
        }
        this.getSettings().setBuiltInZoomControls(false);
        this.getSettings().setDisplayZoomControls(false);
        this.getSettings().setGeolocationDatabasePath(this.getContext().getFilesDir().toString());
        this.getSettings().setAppCachePath(this.getContext().getCacheDir().toString());
        this.getSettings().setAllowContentAccess(false);
        this.getSettings().setDefaultTextEncodingName("utf-8");
        this.getSettings().setGeolocationEnabled(true);
        this.getSettings().setSupportMultipleWindows(false);
        this.getSettings().setJavaScriptEnabled(true);
        this.getSettings().setJavaScriptCanOpenWindowsAutomatically(true);
        this.getSettings().setBlockNetworkImage(false);
        this.getSettings().setPluginState(WebSettings.PluginState.ON);
        if (Build.VERSION.SDK_INT < 18) {
            this.getSettings().setSavePassword(false);
        }
        if (Build.VERSION.SDK_INT >= 17) {
            this.getSettings().setMediaPlaybackRequiresUserGesture(false);
        }
        this.getSettings().setDomStorageEnabled(true);
        this.getSettings().setAllowFileAccess(true);
        this.getSettings().setSupportZoom(false);
        if (Build.VERSION.SDK_INT >= 16) {
            this.getSettings().setAllowFileAccessFromFileURLs(true);
            this.getSettings().setAllowUniversalAccessFromFileURLs(true);
        }
        this.getSettings().setSaveFormData(false);
        this.getSettings().setLoadWithOverviewMode(false);
        this.getSettings().setUseWideViewPort(false);
        this.getSettings().setCacheMode(2);
        if (Build.VERSION.SDK_INT >= 16) {
            this.setLayerType(2, null);
        }
        if (Build.VERSION.SDK_INT >= 21) {
            this.getSettings().setMixedContentMode(0);
        }
        this.getSettings().setLayoutAlgorithm(WebSettings.LayoutAlgorithm.NORMAL);
        if (Build.VERSION.SDK_INT >= 19) {
            KidozWebView.setWebContentsDebuggingEnabled((boolean)ConstantDef.DGM);
        }
        if (Build.VERSION.SDK_INT >= 17) {
            this.getSettings().setMediaPlaybackRequiresUserGesture(false);
        }
    }

    public void loadWebUrl(String url, String googlePlayAppID) {
        this.mAllowedSitesKeyWords.clear();
        this.mAllowedSitesKeyWords.add(this.getDomain(url));
        this.mAllowedSitesKeyWords.add(url);
        this.mGooglePlayAppId = googlePlayAppID;
        this.loadUrl(url);
    }

    public void loadWebUrl(String[] allowedDomains, String url, String googlePlayAppID) {
        if (url.startsWith(HTTP)) {
            return;
        }
        this.mLastOverloadUrl = "";
        this.mAllowedSitesKeyWords.clear();
        if (allowedDomains != null) {
            this.mAllowedSitesKeyWords.addAll(Arrays.asList(allowedDomains));
        }
        this.mAllowedSitesKeyWords.add(this.getDomain(url));
        this.mAllowedSitesKeyWords.add(url);
        this.mGooglePlayAppId = googlePlayAppID;
        String s = "<html><head><style type='text/css'> img {max-width: 100%;height:initial;} margin: 0; padding: 0 </style></head><body style='margin:0;padding:0;' ><img src=\"16842794\"/></body></html>";
        String test = "<!DOCTYPE html><html lang=\"en\"><head> <meta charset=\"UTF-8\"> <title>KIDOZ</title> <link rel=\"shortcut icon\" href=\"data:image/x-icon;,\" type=\"image/x-icon\"> <meta http-equiv=\"Cache-Control\" content=\"public\"> <meta http-equiv=\"imagetoolbar\" content=\"no\"> <meta http-equiv=\"imagetoolbar\" content=\"false\"> <meta name=\"ROBOTS\" content=\"NOINDEX\"> <meta name=\"ROBOTS\" content=\"NOFOLLOW\"> <meta name=\"ROBOTS\" content=\"NOARCHIVE\"> <meta name=\"ROBOTS\" content=\"NOSNIPPET\"> <meta name=\"ROBOTS\" content=\"NOODP \"> <meta name=\"viewport\" content=\"user-scalable=no, initial-scale=1, maximum-scale=1, minimum-scale=1, width=device-width\"> <style>html, body{font-family: Arial, Helvetica, sans-serif; margin: 0; padding: 0; min-height: 100%; height: 100%; background: #000;}.frame__game{display: block; border: 0; width: 100%; height: 100%; z-index: 1000;}h1{display: none; color: #fff; position: absolute; top: 50%; left: 50%; -webkit-transform: translate(-50%, -50%); -ms-transform: translate(-50%, -50%); transform: translate(-50%, -50%);}</style></head><body> <h1>Not Found!</h1> <script type=\"text/javascript\">(function (win, doc){//Global game methods var METHODS=[ '__ctlArcadeShareEvent', '__ctlArcadeSaveScore', '__ctlArcadeEndLevel', '__ctlArcadeRestartLevel', '__ctlArcadeStartLevel', '__ctlArcadeEndSession', '__ctlArcadeStartSession', '__ctlArcadeShowInterlevelAD']; //Define methods for (var i=0; i < METHODS.length; i++){(function (name){win[name]=function (){console.log(name + ' not implemented');};})(METHODS[i]);}var url=getParamValue('gameUrl'); if (!url){(document.getElementsByTagName('h1')[0]).style.display=\"block\"; return;}url=decodeURIComponent(url); url +=url.indexOf('?')==-1 ? '?' : '&'; url +='ctl-arcade=true'; var game=_game(url); var interstitial=_interstitial(); game.onready=function (){interstitial.load();}interstitial.onready=function (){interstitial.load();}interstitial.onstarted=function (){if (isInFullScreen()){_resetFullScreen();}if (game.window && typeof game.window.ctlArcadePause==='function'){game.window.ctlArcadePause();}}interstitial.onclosed=function (error){if (game.window && typeof game.window.ctlArcadeResume==='function'){game.window.ctlArcadeResume();}if (error){return;}interstitial.load();}win.__ctlArcadeShowInterlevelAD=function (){if (interstitial.state.LOADED){interstitial.show();}else{interstitial.load();}}function onVisibilityChanged(){if ((interstitial && interstitial.state.STARTED) || document.hidden || document.mozHidden || document.webkitHidden || document.msHidden){setTimeout(function (){if (game.window && typeof game.window.ctlArcadePause==='function'){game.window.ctlArcadePause();}});}}; document.addEventListener(\"visibilitychange\", onVisibilityChanged, false); document.addEventListener(\"mozvisibilitychange\", onVisibilityChanged, false); document.addEventListener(\"webkitvisibilitychange\", onVisibilityChanged, false); document.addEventListener(\"msvisibilitychange\", onVisibilityChanged, false); function createIframe(URI){const iframe=document.createElement('iframe'); if (URL){iframe.setAttribute('src', URI);}iframe.setAttribute('width', '100%'); iframe.setAttribute('height', '100%'); iframe.setAttribute('frameborder', '0'); iframe.setAttribute('scrolling', 'no'); iframe.setAttribute('allowfullscreen', 'true'); iframe.setAttribute('allowtransparency', 'true'); return iframe;}function getParamValue(paramName){var url=window.location.search.substring(1); var qArray=url.split('&'); for (var i=0; i < qArray.length; i++){var pArr=qArray[i].split('='); if (pArr[0]==paramName) return pArr[1];}}function game(URI){var gameFrame=createIframe(URI); var result={onready: null, window: null, frame: gameFrame}gameFrame.className='frame__game'; gameFrame.addEventListener('load', function (){result.window=gameFrame.contentWindow; if (typeof result.onready==='function'){result.onready(result.window);}}); doc.body.appendChild(gameFrame); return result;}function interstitial(){var instance; var STATE={READY: false, LOADED: false, STARTED: false}; var result={state: STATE, onready: null, onloaded: null, onstarted: null, onclosed: null, load: function (){if (!instance || !STATE.READY){return;}instance.load();}, show: function (){if (!instance || !STATE.LOADED){return;}instance.show();}}win.KidozInterstitialAsyncInit=function (){instance=KidozInterstitial.init({publisherID: 13313, accessToken: '92e3GB3Sir66rfhrvHSCXxvMbdsZk3IH'})(); instance.addEventListener('ready', function (){STATE.READY=true; if (typeof result.onready==='function'){result.onready();}}); instance.addEventListener('loaded', function (){STATE.LOADED=true; if (typeof result.onloaded==='function'){result.onloaded();}}); instance.addEventListener('started', function (){STATE.STARTED=true; if (typeof result.onstarted==='function'){result.onstarted();}}); instance.addEventListener('closed', function (error){STATE.LOADED=STATE.STARTED=false; if (typeof result.onclosed==='function'){result.onclosed(error);}});}return result;}function isInFullScreen(){return (document.fullscreenElement && document.fullscreenElement !==null) || (document.webkitFullscreenElement && document.webkitFullscreenElement !==null) || (document.mozFullScreenElement && document.mozFullScreenElement !==null) || (document.msFullscreenElement && document.msFullscreenElement !==null);}function _resetFullScreen(){if (document.exitFullscreen){document.exitFullscreen();}else if (document.webkitExitFullscreen){document.webkitExitFullscreen();}else if (document.mozCancelFullScreen){document.mozCancelFullScreen();}else if (document.msExitFullscreen){document.msExitFullscreen();}}})(window, document); </script> <script src=\"https://cdn.kidoz.net/core/interstitial/web2.0.0.js\" async type=\"text/javascript\"></script></body></html>";
        String test3 = "<script>\nwindow.addEventListener('focus', function () {\n  window.alert('FOCUS')\n})\n\nwindow.addEventListener('blur', function () {\n  window.confirm('BLUR')\n})\n</script>\nHere is a dummy test";
        this.loadUrl(url);
    }

    public void onResume() {
        super.onResume();
    }

    public void onPause() {
        this.stopLoading();
        super.onPause();
    }

    public synchronized void onDestroy() {
        this.stopLoading();
        this.clearHistory();
        this.removeAllViews();
        this.destroyDrawingCache();
    }

    private boolean checkIfSafeUrl(String url) {
        boolean result = false;
        if (url != null) {
            if (url.contains(KIDOZ_DOMAIN)) {
                result = true;
            } else {
                String urlStringWithoutPrefix = KidozWebView.removePrefix(url);
                String fixedUrlString = urlStringWithoutPrefix != null ? urlStringWithoutPrefix.toLowerCase(Locale.US) : null;
                SDKLogger.printDebugLog(this.TAG, "checkIfSafeUrl: fixedUrlString = " + fixedUrlString);
                if (this.mAllowedSitesKeyWords != null) {
                    for (int i = 0; i < this.mAllowedSitesKeyWords.size(); ++i) {
                        String originalUrl = KidozWebView.removePrefix(this.mAllowedSitesKeyWords.get(i));
                        SDKLogger.printDebugLog(this.TAG, "checkIfSafeUrl: originalUrl = " + originalUrl);
                        if (!fixedUrlString.contains(originalUrl != null ? originalUrl.toLowerCase(Locale.US) : null)) continue;
                        SDKLogger.printDebugLog(this.TAG, "********************************");
                        SDKLogger.printDebugLog(this.TAG, "checkIfSafeUrl: found a match:fixedUrlString = " + fixedUrlString);
                        SDKLogger.printDebugLog(this.TAG, "checkIfSafeUrl: found a match:originalUrl = " + originalUrl);
                        SDKLogger.printDebugLog(this.TAG, "********************************");
                        result = true;
                        break;
                    }
                } else {
                    SDKLogger.printDebugLog(this.TAG, "Web Player  Not allowed link!");
                }
            }
        }
        return result;
    }

    private String getDomain(String url) {
        SDKLogger.printDebugLog(this.TAG, "getDomain: URL = " + url);
        String result = null;
        if (url != null) {
            String urlStringWithoutPrefix = KidozWebView.removePrefix(url);
            SDKLogger.printDebugLog(this.TAG, "getDomain: urlStringWithoutPrefix = " + urlStringWithoutPrefix);
            String[] domainPartsArray = urlStringWithoutPrefix.split("/");
            if (domainPartsArray != null) {
                result = domainPartsArray[0];
                SDKLogger.printDebugLog(this.TAG, "getDomain: result = " + result);
            } else {
                SDKLogger.printDebugLog(this.TAG, "getDomain: domainPartsArray = null");
            }
        }
        return result;
    }

    private static String removePrefix(String urlString) {
        try {
            String modifiedString = urlString.toLowerCase();
            for (String prefixToRemove : PREFIXES_TO_REMOVE) {
                if (!modifiedString.startsWith(prefixToRemove)) continue;
                int lenght = modifiedString.length();
                modifiedString = modifiedString.substring(prefixToRemove.length(), lenght);
            }
            return modifiedString;
        }
        catch (Exception e) {
            return null;
        }
    }

    public synchronized void stopAndReleaseWebView() {
        this.loadUrl("");
        this.stopLoading();
        this.clearHistory();
        this.removeAllViews();
        this.destroyDrawingCache();
    }

    public void setOnLounchExternalAppFromRedirect(IOnLounchExternalAppFromRedirectListener listener) {
        this.onLounchExternalAppFromRedirectListener = listener;
    }

    static {
        PREFIXES_TO_REMOVE.add(HTTP);
        PREFIXES_TO_REMOVE.add(HTTPS);
        PREFIXES_TO_REMOVE.add(WWW);
        PREFIXES_TO_REMOVE.add(WWW2);
        API = Build.VERSION.SDK_INT;
    }

    public static interface IOnLounchExternalAppFromRedirectListener {
        public void onLounch();
    }
}

