/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.api.general.custom_views.CustomCardView;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import android.view.View;
import com.kidoz.sdk.api.general.custom_views.CustomCardView.KidozCardViewDelegate;
import com.kidoz.sdk.api.general.custom_views.CustomCardView.KidozCardViewImpl;
import com.kidoz.sdk.api.general.custom_views.CustomCardView.KidozRoundRectDrawableWithShadow;

class KidozCardViewEclairMr1
implements KidozCardViewImpl {
    final RectF sCornerRect = new RectF();

    KidozCardViewEclairMr1() {
    }

    @Override
    public void initStatic() {
        KidozRoundRectDrawableWithShadow.sRoundRectHelper = new KidozRoundRectDrawableWithShadow.RoundRectHelper(){

            @Override
            public void drawRoundRect(Canvas canvas, RectF bounds, float cornerRadius, Paint paint) {
                float twoRadius = cornerRadius * 2.0f;
                float innerWidth = bounds.width() - twoRadius - 1.0f;
                float innerHeight = bounds.height() - twoRadius - 1.0f;
                if (cornerRadius >= 1.0f) {
                    KidozCardViewEclairMr1.this.sCornerRect.set(-(cornerRadius += 0.5f), -cornerRadius, cornerRadius, cornerRadius);
                    int saved = canvas.save();
                    canvas.translate(bounds.left + cornerRadius, bounds.top + cornerRadius);
                    canvas.drawArc(KidozCardViewEclairMr1.this.sCornerRect, 180.0f, 90.0f, true, paint);
                    canvas.translate(innerWidth, 0.0f);
                    canvas.rotate(90.0f);
                    canvas.drawArc(KidozCardViewEclairMr1.this.sCornerRect, 180.0f, 90.0f, true, paint);
                    canvas.translate(innerHeight, 0.0f);
                    canvas.rotate(90.0f);
                    canvas.drawArc(KidozCardViewEclairMr1.this.sCornerRect, 180.0f, 90.0f, true, paint);
                    canvas.translate(innerWidth, 0.0f);
                    canvas.rotate(90.0f);
                    canvas.drawArc(KidozCardViewEclairMr1.this.sCornerRect, 180.0f, 90.0f, true, paint);
                    canvas.restoreToCount(saved);
                    canvas.drawRect(bounds.left + cornerRadius - 1.0f, bounds.top, bounds.right - cornerRadius + 1.0f, bounds.top + cornerRadius, paint);
                    canvas.drawRect(bounds.left + cornerRadius - 1.0f, bounds.bottom - cornerRadius + 1.0f, bounds.right - cornerRadius + 1.0f, bounds.bottom, paint);
                }
                canvas.drawRect(bounds.left, bounds.top + Math.max(0.0f, cornerRadius - 1.0f), bounds.right, bounds.bottom - cornerRadius + 1.0f, paint);
            }
        };
    }

    @Override
    public void initialize(KidozCardViewDelegate cardView, Context context, int backgroundColor, float radius, float elevation, float maxElevation) {
        KidozRoundRectDrawableWithShadow background = this.createBackground(context, backgroundColor, radius, elevation, maxElevation);
        background.setAddPaddingForCorners(cardView.getPreventCornerOverlap());
        cardView.setBackgroundDrawable(background);
        this.updatePadding(cardView);
    }

    KidozRoundRectDrawableWithShadow createBackground(Context context, int backgroundColor, float radius, float elevation, float maxElevation) {
        return new KidozRoundRectDrawableWithShadow(context.getResources(), backgroundColor, radius, elevation, maxElevation);
    }

    @Override
    public void updatePadding(KidozCardViewDelegate cardView) {
        Rect shadowPadding = new Rect();
        this.getShadowBackground(cardView).getMaxShadowAndCornerPadding(shadowPadding);
        ((View)cardView).setMinimumHeight((int)Math.ceil(this.getMinHeight(cardView)));
        ((View)cardView).setMinimumWidth((int)Math.ceil(this.getMinWidth(cardView)));
        cardView.setShadowPadding(shadowPadding.left, shadowPadding.top, shadowPadding.right, shadowPadding.bottom);
    }

    @Override
    public void onCompatPaddingChanged(KidozCardViewDelegate cardView) {
    }

    @Override
    public void onPreventCornerOverlapChanged(KidozCardViewDelegate cardView) {
        this.getShadowBackground(cardView).setAddPaddingForCorners(cardView.getPreventCornerOverlap());
        this.updatePadding(cardView);
    }

    @Override
    public void setBackgroundColor(KidozCardViewDelegate cardView, int color) {
        this.getShadowBackground(cardView).setColor(color);
    }

    @Override
    public void setRadius(KidozCardViewDelegate cardView, float radius) {
        this.getShadowBackground(cardView).setCornerRadius(radius);
        this.updatePadding(cardView);
    }

    @Override
    public float getRadius(KidozCardViewDelegate cardView) {
        return this.getShadowBackground(cardView).getCornerRadius();
    }

    @Override
    public void setElevation(KidozCardViewDelegate cardView, float elevation) {
        this.getShadowBackground(cardView).setShadowSize(elevation);
    }

    @Override
    public float getElevation(KidozCardViewDelegate cardView) {
        return this.getShadowBackground(cardView).getShadowSize();
    }

    @Override
    public void setMaxElevation(KidozCardViewDelegate cardView, float maxElevation) {
        this.getShadowBackground(cardView).setMaxShadowSize(maxElevation);
        this.updatePadding(cardView);
    }

    @Override
    public float getMaxElevation(KidozCardViewDelegate cardView) {
        return this.getShadowBackground(cardView).getMaxShadowSize();
    }

    @Override
    public float getMinWidth(KidozCardViewDelegate cardView) {
        return this.getShadowBackground(cardView).getMinWidth();
    }

    @Override
    public float getMinHeight(KidozCardViewDelegate cardView) {
        return this.getShadowBackground(cardView).getMinHeight();
    }

    private KidozRoundRectDrawableWithShadow getShadowBackground(KidozCardViewDelegate cardView) {
        return (KidozRoundRectDrawableWithShadow)cardView.getBackground();
    }
}

