/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.api.general.custom_views.CustomCardView;

import android.content.Context;
import android.graphics.Rect;
import android.os.Build;
import android.util.AttributeSet;
import android.view.View;
import android.widget.FrameLayout;
import com.kidoz.sdk.api.general.custom_views.CustomCardView.KidozCardViewApi21;
import com.kidoz.sdk.api.general.custom_views.CustomCardView.KidozCardViewDelegate;
import com.kidoz.sdk.api.general.custom_views.CustomCardView.KidozCardViewEclairMr1;
import com.kidoz.sdk.api.general.custom_views.CustomCardView.KidozCardViewImpl;
import com.kidoz.sdk.api.general.custom_views.CustomCardView.KidozCardViewJellybeanMr1;

public class KidozCardView
extends FrameLayout
implements KidozCardViewDelegate {
    private static final KidozCardViewImpl IMPL = Build.VERSION.SDK_INT >= 21 ? new KidozCardViewApi21() : (Build.VERSION.SDK_INT >= 17 ? new KidozCardViewJellybeanMr1() : new KidozCardViewEclairMr1());
    private boolean mCompatPadding;
    private boolean mPreventCornerOverlap;
    private final Rect mContentPadding = new Rect();
    private final Rect mShadowBounds = new Rect();

    public KidozCardView(Context context) {
        super(context);
        this.initialize(context, null, 0);
    }

    public KidozCardView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initialize(context, attrs, 0);
    }

    public KidozCardView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initialize(context, attrs, defStyleAttr);
    }

    public void setPadding(int left, int top, int right, int bottom) {
    }

    public void setPaddingRelative(int start, int top, int end, int bottom) {
    }

    @Override
    public boolean getUseCompatPadding() {
        return this.mCompatPadding;
    }

    public void setUseCompatPadding(boolean useCompatPadding) {
        if (this.mCompatPadding == useCompatPadding) {
            return;
        }
        this.mCompatPadding = useCompatPadding;
        IMPL.onCompatPaddingChanged(this);
    }

    public void setContentPadding(int left, int top, int right, int bottom) {
        this.mContentPadding.set(left, top, right, bottom);
        IMPL.updatePadding(this);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        if (!(IMPL instanceof KidozCardViewApi21)) {
            int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
            switch (widthMode) {
                case -2147483648: 
                case 0x40000000: {
                    int minWidth = (int)Math.ceil(IMPL.getMinWidth(this));
                    widthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)Math.max(minWidth, View.MeasureSpec.getSize((int)widthMeasureSpec)), (int)widthMode);
                }
            }
            int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
            switch (heightMode) {
                case -2147483648: 
                case 0x40000000: {
                    int minHeight = (int)Math.ceil(IMPL.getMinHeight(this));
                    heightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)Math.max(minHeight, View.MeasureSpec.getSize((int)heightMeasureSpec)), (int)heightMode);
                }
            }
            super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        } else {
            super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        }
    }

    private void initialize(Context context, AttributeSet attrs, int defStyleAttr) {
        int defaultPadding;
        this.mCompatPadding = false;
        this.mPreventCornerOverlap = true;
        this.mContentPadding.left = defaultPadding = 0;
        this.mContentPadding.top = defaultPadding;
        this.mContentPadding.right = defaultPadding;
        this.mContentPadding.bottom = defaultPadding;
        IMPL.initialize(this, context, -1, 0.0f, 0.0f, 0.0f);
    }

    public void setCardBackgroundColor(int color) {
        IMPL.setBackgroundColor(this, color);
    }

    public int getContentPaddingLeft() {
        return this.mContentPadding.left;
    }

    public int getContentPaddingRight() {
        return this.mContentPadding.right;
    }

    public int getContentPaddingTop() {
        return this.mContentPadding.top;
    }

    public int getContentPaddingBottom() {
        return this.mContentPadding.bottom;
    }

    public void setRadius(float radius) {
        IMPL.setRadius(this, radius);
    }

    @Override
    public float getRadius() {
        return IMPL.getRadius(this);
    }

    @Override
    public void setShadowPadding(int left, int top, int right, int bottom) {
        this.mShadowBounds.set(left, top, right, bottom);
        super.setPadding(left + this.mContentPadding.left, top + this.mContentPadding.top, right + this.mContentPadding.right, bottom + this.mContentPadding.bottom);
    }

    public void setCardElevation(float radius) {
        IMPL.setElevation(this, radius);
    }

    public float getCardElevation() {
        return IMPL.getElevation(this);
    }

    public void setMaxCardElevation(float radius) {
        IMPL.setMaxElevation(this, radius);
    }

    public float getMaxCardElevation() {
        return IMPL.getMaxElevation(this);
    }

    @Override
    public boolean getPreventCornerOverlap() {
        return this.mPreventCornerOverlap;
    }

    public void setPreventCornerOverlap(boolean preventCornerOverlap) {
        if (preventCornerOverlap == this.mPreventCornerOverlap) {
            return;
        }
        this.mPreventCornerOverlap = preventCornerOverlap;
        IMPL.onPreventCornerOverlapChanged(this);
    }

    static {
        IMPL.initStatic();
    }
}

