/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.api;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import com.kidoz.sdk.api.KidozSDK;
import com.kidoz.sdk.api.general.EventMessage;
import com.kidoz.sdk.api.general.assets_handling.AssetUtil;
import com.kidoz.sdk.api.general.database.DatabaseManager;
import com.kidoz.sdk.api.general.enums.WidgetType;
import com.kidoz.sdk.api.interfaces.AnotherInterface;
import com.kidoz.sdk.api.interfaces.IOnPanelViewEventListener;
import com.kidoz.sdk.api.interfaces.KidozPlayerEventHelper;
import com.kidoz.sdk.api.interfaces.KidozPlayerListener;
import com.kidoz.sdk.api.ui_views.panel_view.AbstractPanelView;
import com.kidoz.sdk.api.ui_views.panel_view.FamilyPanelView;
import com.kidoz.sdk.api.ui_views.panel_view.HANDLE_POSITION;
import com.kidoz.sdk.api.ui_views.panel_view.PANEL_TYPE;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.greenrobot.eventbus.EventBus;
import org.greenrobot.eventbus.Subscribe;
import org.json.JSONObject;

public class PanelView
extends RelativeLayout {
    public static final String TAG = PanelView.class.getSimpleName();
    private AbstractPanelView mAbstractPanelView;
    private PANEL_TYPE mPanelType = PANEL_TYPE.BOTTOM;
    private HANDLE_POSITION mHandlePosition = HANDLE_POSITION.START;
    private IOnPanelViewEventListener mIOnPanelViewEventListener = null;
    private KidozPlayerEventHelper mKidozPlayerEventHelper;
    private KidozPlayerListener mKidozPlayerListener;
    private Lock raceConditionLock = new ReentrantLock();
    private boolean mVisibilityRequest = true;

    public PanelView(Context context) {
        super(context);
        this.initView();
    }

    public PanelView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView();
    }

    public PanelView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initView();
    }

    public void setKidozPlayerListener(KidozPlayerListener kidozPlayerListener) {
        this.mKidozPlayerListener = kidozPlayerListener;
    }

    private void initView() {
        if (!EventBus.getDefault().isRegistered((Object)this)) {
            EventBus.getDefault().register((Object)this);
        }
        this.setBackgroundColor(0);
        this.setLayoutParams((ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-1, -1));
        if (KidozSDK.isInitialised()) {
            this.validateLayoutAndAssets();
        }
        this.mKidozPlayerEventHelper = new KidozPlayerEventHelper(new KidozPlayerEventHelper.IPlayerListener(){

            @Override
            public void onOpen(boolean isMaximizedPlayer) {
                if (PanelView.this.mKidozPlayerListener != null) {
                    PanelView.this.mKidozPlayerListener.onPlayerOpen();
                }
                if (PanelView.this.mAbstractPanelView != null && PanelView.this.mAbstractPanelView instanceof FamilyPanelView) {
                    ((FamilyPanelView)PanelView.this.mAbstractPanelView).pauseAction(isMaximizedPlayer);
                }
            }

            @Override
            public void onClose(boolean isMaximizedPlayer) {
                if (PanelView.this.mKidozPlayerListener != null) {
                    PanelView.this.mKidozPlayerListener.onPlayerClose();
                }
                if (PanelView.this.mAbstractPanelView != null && PanelView.this.mAbstractPanelView instanceof FamilyPanelView) {
                    ((FamilyPanelView)PanelView.this.mAbstractPanelView).resumeAction(isMaximizedPlayer);
                }
            }
        }, WidgetType.WIDGET_TYPE_PANEL);
    }

    private void validateLayoutAndAssets() {
        if (EventBus.getDefault().isRegistered((Object)this)) {
            EventBus.getDefault().unregister((Object)this);
        }
        if (this.raceConditionLock.tryLock()) {
            try {
                AssetUtil.parseStyleAsync(this.getContext(), AssetUtil.ParserAsyncTask.StyleType.PANEL_STYLE, new AssetUtil.ParserAsyncTask.IOnStyleParseListener(){

                    @Override
                    public void onParseFinished(boolean success) {
                        if (success) {
                            PanelView.this.buildPanelView();
                        }
                    }
                });
            }
            finally {
                this.raceConditionLock.unlock();
            }
        }
    }

    private void buildPanelView() {
        JSONObject jsonObject = DatabaseManager.getInstance(this.getContext()).getConfigTable().loadProperties(TAG);
        if (jsonObject != null) {
            this.mAbstractPanelView = new FamilyPanelView(this.getContext(), jsonObject);
            if (this.mPanelType != null && this.mHandlePosition != null) {
                this.mAbstractPanelView.setPanelConfiguration(this.mPanelType, this.mHandlePosition);
            }
            if (this.mIOnPanelViewEventListener != null) {
                this.mAbstractPanelView.setOnPanelViewEventListener(this.mIOnPanelViewEventListener);
            }
            this.mAbstractPanelView.setPanelEnabled(this.mVisibilityRequest);
        }
        if (this.mKidozPlayerEventHelper != null) {
            this.mKidozPlayerEventHelper.register();
        }
        if (this.mAbstractPanelView != null) {
            this.addView((View)this.mAbstractPanelView);
            this.setAnotherInterface();
        }
    }

    private void setAnotherInterface() {
        try {
            this.mAbstractPanelView.mOneItemFamilyView.setAnotherInterface(new AnotherInterface(){

                @Override
                public void toggleWidgetState(boolean isEnabled) {
                    ((PanelView)PanelView.this).mAbstractPanelView.mAboutKidozButton.setClickable(isEnabled);
                    ((PanelView)PanelView.this).mAbstractPanelView.mParentalLockButton.setClickable(isEnabled);
                    ((FamilyPanelView)((PanelView)PanelView.this).mAbstractPanelView).mNextButton.setClickable(isEnabled);
                    ((PanelView)PanelView.this).mAbstractPanelView.mOneItemFamilyView.mViewPager.mIsBlocked = !isEnabled;
                    ((PanelView)PanelView.this).mAbstractPanelView.mPanelHandle.setEnabled(isEnabled);
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Subscribe
    public void onHandleEvent(EventMessage event) {
        if (event.getMessageType() == EventMessage.MessageType.INIT_SDK) {
            this.validateLayoutAndAssets();
        }
    }

    @Deprecated
    public void setPanelColor(int color) {
    }

    public void collapsePanelView() {
        if (this.mAbstractPanelView != null) {
            this.mAbstractPanelView.collapsePanelView();
        }
    }

    public void expandPanelView() {
        if (this.mAbstractPanelView != null) {
            this.mAbstractPanelView.expandPanelView();
        }
    }

    public void setPanelConfiguration(PANEL_TYPE panelType, HANDLE_POSITION handlePosition) {
        if (panelType == PANEL_TYPE.LEFT || panelType == PANEL_TYPE.RIGHT) {
            throw new RuntimeException("Please use PANEL_TYPE.TOP or PANEL_TYPE.BOTTOM (LEFT & RIGHT are deprecated)");
        }
        this.mPanelType = panelType;
        this.mHandlePosition = handlePosition;
        if (this.mAbstractPanelView != null && (panelType == PANEL_TYPE.TOP || panelType == PANEL_TYPE.BOTTOM)) {
            this.mAbstractPanelView.setPanelConfiguration(panelType, handlePosition);
        }
    }

    @Deprecated
    public void setPanelAutoExpand(float startDelay, float showPeriod) {
    }

    @Deprecated
    public void setPanelAutoExpand(float startDelay, float showPeriod, float repeatTimeFrame) {
    }

    public void setOnPanelViewEventListener(IOnPanelViewEventListener iOnPanelViewEventListener) {
        this.mIOnPanelViewEventListener = iOnPanelViewEventListener;
        if (this.mAbstractPanelView != null) {
            this.mAbstractPanelView.setOnPanelViewEventListener(iOnPanelViewEventListener);
        }
    }

    public boolean getIsPanelViewExpanded() {
        if (this.mAbstractPanelView != null) {
            return this.mAbstractPanelView.getPanelViewState() == AbstractPanelView.PanelViewState.OPEN;
        }
        return false;
    }

    protected void onDetachedFromWindow() {
        try {
            if (EventBus.getDefault().isRegistered((Object)this)) {
                EventBus.getDefault().unregister((Object)this);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.mKidozPlayerEventHelper != null) {
            this.mKidozPlayerEventHelper.unRegister();
        }
        super.onDetachedFromWindow();
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (this.mKidozPlayerEventHelper != null) {
            this.mKidozPlayerEventHelper.register();
        }
    }

    public void setVisibility(int visibility) {
        if (visibility == 8) {
            visibility = 4;
        }
        super.setVisibility(visibility);
        if (visibility == 4) {
            if (this.mAbstractPanelView != null) {
                this.mAbstractPanelView.setPanelEnabled(false);
                this.mVisibilityRequest = false;
            } else {
                this.mVisibilityRequest = false;
            }
        } else if (this.mAbstractPanelView != null) {
            this.mAbstractPanelView.setPanelEnabled(true);
        } else {
            this.mVisibilityRequest = true;
        }
    }
}

