/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.api;

import android.app.Activity;
import android.app.Application;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.Bundle;
import android.widget.Toast;
import com.kidoz.events.EventManager;
import com.kidoz.events.SDKGeneralEventSignObj;
import com.kidoz.sdk.api.general.EventMessage;
import com.kidoz.sdk.api.general.assets_handling.AssetUtil;
import com.kidoz.sdk.api.general.database.DatabaseManager;
import com.kidoz.sdk.api.general.utils.ConstantDef;
import com.kidoz.sdk.api.general.utils.PropertiesObj;
import com.kidoz.sdk.api.general.utils.SDKLogger;
import com.kidoz.sdk.api.general.utils.SdkCookieManager;
import com.kidoz.sdk.api.general.utils.SdkDeviceUtils;
import com.kidoz.sdk.api.general.utils.SharedPreferencesUtils;
import com.kidoz.sdk.api.general.utils.StorageLife;
import com.kidoz.sdk.api.general.utils.Utils;
import com.kidoz.sdk.api.interfaces.SDKEventListener;
import com.kidoz.sdk.api.receivers.SdkReceiver;
import com.kidoz.sdk.api.server_connect.ApiResultCallback;
import com.kidoz.sdk.api.server_connect.ResultData;
import com.kidoz.sdk.api.server_connect.SdkAPIManager;
import com.kidoz.sdk.api.server_connect.StreamToStringConverter;
import com.kidoz.sdk.api.ui_views.html_view.HtmlManager;
import com.kidoz.sdk.api.ui_views.html_view.HtmlViewWrapper;
import com.kidoz.sdk.api.ui_views.new_kidoz_banner.KidozBannerView;
import java.io.BufferedInputStream;
import java.io.InputStream;
import java.util.List;
import org.greenrobot.eventbus.EventBus;
import org.json.JSONObject;

public final class KidozSDK {
    public static final String TAG = KidozSDK.class.getSimpleName();
    private static SdkReceiver mSdkReceiver;
    private static boolean isInitialized;
    private static String mPublisherId;
    private static String mSecurityKey;
    private static Context mContext;
    private static boolean isDeveloperLoggingON;
    private static String mAppId;
    private static SDKGeneralEventSignObj sGeneralSDKEventObj;

    private static void registerPackageChangeReceiver(Context context) {
        if (Build.VERSION.SDK_INT >= 26) {
            try {
                String SdkReceiver2 = "com.kidoz.sdk.api.receivers.SdkReceiver";
                PackageManager pm = context.getPackageManager();
                Intent intent = new Intent();
                intent.setClassName(context, "com.kidoz.sdk.api.receivers.SdkReceiver");
                int flag = 0;
                flag = Build.VERSION.SDK_INT >= 24 ? 512 : 512;
                List receivers = context.getPackageManager().queryBroadcastReceivers(intent, 0x40 | flag);
                if (receivers != null && receivers.size() >= 1) {
                    ComponentName componentName = new ComponentName(context, "com.kidoz.sdk.api.receivers.SdkReceiver");
                    pm.setComponentEnabledSetting(componentName, 2, 1);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (mSdkReceiver == null) {
                mSdkReceiver = new SdkReceiver();
            }
            mSdkReceiver.register(context, mSdkReceiver.getIntentFilter());
        }
    }

    private static void unregisterPackageChangeReceiver() {
        if (Build.VERSION.SDK_INT >= 26 && mSdkReceiver != null && mContext != null) {
            mSdkReceiver.unRegister(mContext);
        }
    }

    private static void validateParameters(Context context, String publisher_id, String token) {
        SDKLogger.printDebugLog(TAG, "validateParameters");
        if (context == null) {
            throw new RuntimeException("Context can't be null!");
        }
        if (token == null || token.length() > 48) {
            throw new RuntimeException("Invalid Security Token! Please recheck you security token..");
        }
        if (publisher_id == null) {
            throw new RuntimeException("Invalid publisher id! Please check you publisher id..");
        }
        try {
            Long.parseLong(publisher_id);
        }
        catch (NumberFormatException e) {
            throw new RuntimeException("Invalid publisher id! Please check you publisher id..");
        }
    }

    private static void notifyUserUsingDemoPublisherID(final Context context, String publisher_id) {
        SDKLogger.printDebugLog(TAG, "notifyUserUsingDemoPublisherID");
        if (publisher_id.equals("5") || publisher_id.equals("7") || publisher_id.equals("8")) {
            if (context instanceof Activity) {
                ((Activity)context).runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        Toast.makeText((Context)context, (CharSequence)("Notice ! You are using Demo PUBLISHER ID ! " + (KidozSDK.getAppId() != null ? KidozSDK.getAppId() : context.getPackageName())), (int)1).show();
                    }
                });
            } else {
                SDKLogger.printErrorLog("Notice ! You are using Demo PUBLISHER ID ! , Package Name :" + (KidozSDK.getAppId() != null ? KidozSDK.getAppId() : context.getPackageName()));
            }
        }
    }

    public static void initialize(Activity activity, String publisher_id, String token) {
        KidozSDK.registerPackageChangeReceiver((Context)activity);
        mContext = activity;
        KidozSDK.registerActivityLifecycleCallbacks(activity);
        SharedPreferencesUtils.saveSharedPreferencesData((Context)activity, "PUBLISHER_ID", publisher_id);
        mPublisherId = publisher_id;
        mSecurityKey = token;
        SDKLogger.printDebugLog(TAG, "initialize : " + isInitialized);
        long startTime = System.currentTimeMillis();
        KidozSDK.validateParameters((Context)activity, publisher_id, token);
        SDKLogger.printDebugLog(TAG, "CT validateParameters time = " + (double)(System.currentTimeMillis() - startTime) / 1000.0 + " seconds");
        KidozSDK.notifyUserUsingDemoPublisherID((Context)activity, publisher_id);
        SDKLogger.printDebugLog(TAG, "CT notifyUserUsingDemoPublisherID time = " + (double)(System.currentTimeMillis() - startTime) / 1000.0 + " seconds");
        KidozSDK.checkManifestDeclarations((Context)activity);
        SDKLogger.printDebugLog(TAG, "CT checkManifestDeclarations time = " + (double)(System.currentTimeMillis() - startTime) / 1000.0 + " seconds");
        try {
            SdkDeviceUtils.getGoogleAdvertisingID((Context)activity);
            SDKLogger.printDebugLog(TAG, "CT getGoogleAdvertisingID time = " + (double)(System.currentTimeMillis() - startTime) / 1000.0 + " seconds");
            Utils.preInitiate((Context)activity);
            SDKLogger.printDebugLog(TAG, "CT preInitiate time = " + (double)(System.currentTimeMillis() - startTime) / 1000.0 + " seconds");
            SharedPreferences eventsPref = activity.getSharedPreferences("events_shared_preferences", 0);
            long sessionID = eventsPref.getLong("last_session_id", 0L);
            SharedPreferences.Editor editor = eventsPref.edit();
            editor.putLong("last_session_id", ++sessionID);
            editor.apply();
            SDKLogger.printDebugLog(TAG, "CT SharedPreferences time = " + (double)(System.currentTimeMillis() - startTime) / 1000.0 + " seconds");
            JSONObject eventParams = new JSONObject();
            eventParams.put("DeveloperID", (Object)publisher_id);
            eventParams.put("log_level", EventManager.LOG_NORMAL_LEVEL);
            eventParams.put("SessionID", sessionID);
            EventManager.getInstance((Context)activity).init((Context)activity, eventParams);
            EventManager.getInstance((Context)activity).logEvent((Context)activity, null, null, EventManager.LOG_CRITICAL_LEVEL, "Session", "Session Start", publisher_id);
            if (isInitialized) {
                EventManager.getInstance((Context)activity).logEvent((Context)activity, null, null, EventManager.LOG_CRITICAL_LEVEL, "SDK", "SDK Already Initiated", publisher_id);
            }
            SDKLogger.printDebugLog(TAG, "CT EventManager time = " + (double)(System.currentTimeMillis() - startTime) / 1000.0 + " seconds");
            SdkCookieManager.resetStorage((Context)activity, null, StorageLife.SESSION);
            SdkAPIManager.init((Context)activity, publisher_id, token, isDeveloperLoggingON);
            KidozSDK.validateSDK(activity, publisher_id);
            SDKLogger.printDebugLog(TAG, "CT initialize time = " + (double)(System.currentTimeMillis() - startTime) / 1000.0 + " seconds");
        }
        catch (Exception ex) {
            SDKLogger.printErrorLog(TAG, "Error when trying to init SDK: " + ex.getMessage());
        }
    }

    public static void initialize(Activity activity, String publisher_id, String token, String appId) {
        mAppId = appId;
        KidozSDK.initialize(activity, publisher_id, token);
    }

    public static void registerActivityLifecycleCallbacks(Activity activity) {
        activity.getApplication().registerActivityLifecycleCallbacks(new Application.ActivityLifecycleCallbacks(){

            public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
            }

            public void onActivityStarted(Activity activity) {
            }

            public void onActivityResumed(Activity activity) {
            }

            public void onActivityPaused(Activity activity) {
            }

            public void onActivityStopped(Activity activity) {
            }

            public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
            }

            public void onActivityDestroyed(Activity activity) {
                KidozSDK.unregisterPackageChangeReceiver();
            }
        });
    }

    public static void setAppId(String appId) {
        mAppId = appId;
    }

    public static String getAppId() {
        return mAppId;
    }

    private static void validateSDK(final Activity activity, final String publisher_id) {
        SDKLogger.printDebugLog(TAG, "validateSDK");
        final long startTime = System.currentTimeMillis();
        try {
            if (activity != null) {
                PropertiesObj appConfig = DatabaseManager.getInstance((Context)activity).getConfigTable().loadAppProperties();
                if (appConfig != null) {
                    EventManager.SDK_STYLE_VERSION_NUM = appConfig.getSdkStyleVersion();
                }
                KidozSDK.getApiManager((Context)activity).initSdk((Context)activity, new ApiResultCallback<PropertiesObj>(){

                    @Override
                    public void onServerResult(ResultData<?> result) {
                        if (result != null && result.getResponseStatus() != null && result.getResponseStatus().getIsSuccessful() && result.getData() != null && result.getData() instanceof PropertiesObj) {
                            PropertiesObj serverConfig = (PropertiesObj)result.getData();
                            ConstantDef.setDGM(serverConfig.getShouldEnableChromeDebug());
                            EventManager.SDK_STYLE_VERSION_NUM = serverConfig.getSdkStyleVersion();
                            SdkAPIManager.updateDomain(serverConfig.getGPSFeedApiDomain());
                            SdkAPIManager.updateWaterfallDomain(serverConfig.getWaterfallDomain());
                            PropertiesObj savedConfig = DatabaseManager.getInstance((Context)activity).getConfigTable().loadAppProperties();
                            boolean clearHtmlCache = true;
                            if (savedConfig != null) {
                                String savedUrl = savedConfig.getHtmlLoaderDefaultLink();
                                String newServerUrl = serverConfig.getHtmlLoaderDefaultLink();
                                if (savedConfig != null && savedUrl != null && savedUrl.equals(newServerUrl)) {
                                    clearHtmlCache = false;
                                }
                            }
                            clearHtmlCache = true;
                            KidozSDK.initHtmlWrapper(activity, serverConfig, clearHtmlCache);
                            DatabaseManager.getInstance((Context)activity).getConfigTable().insertAppProperties(serverConfig);
                            AssetUtil.parseStyleAsync((Context)activity, AssetUtil.ParserAsyncTask.StyleType.GLOBAL_PARAMS_STYLE, null);
                            isInitialized = true;
                            EventManager.getInstance((Context)activity).logEvent((Context)activity, null, null, EventManager.LOG_CRITICAL_LEVEL, "SDK", "SDK Init", publisher_id);
                            EventMessage eventMessage = new EventMessage(EventMessage.MessageType.INIT_SDK);
                            EventBus.getDefault().post((Object)eventMessage);
                            SDKLogger.printDebugLog(TAG, "CT validateSDK time = " + (double)(System.currentTimeMillis() - startTime) / 1000.0 + " seconds");
                            if (isDeveloperLoggingON) {
                                SDKLogger.printDebugLog("Kidoz SDK has been successfully Initialized !");
                            }
                        }
                    }

                    @Override
                    public void onFailed() {
                        EventMessage eventMessage = new EventMessage(EventMessage.MessageType.INIT_SDK_FAIL_NO_SERVER_RESULT);
                        EventBus.getDefault().post((Object)eventMessage);
                    }
                });
            }
        }
        catch (Exception ex) {
            SDKLogger.printErrorLog(TAG, "Error when trying to validateSDK: " + ex.getMessage());
            EventMessage eventMessage = new EventMessage(EventMessage.MessageType.INIT_SDK_FAIL_VALIDATION_EXCEPTION);
            EventBus.getDefault().post((Object)eventMessage);
        }
    }

    public static void setSDKListener(SDKEventListener listener) {
        if (!EventBus.getDefault().isRegistered((Object)sGeneralSDKEventObj)) {
            sGeneralSDKEventObj = new SDKGeneralEventSignObj();
            sGeneralSDKEventObj.setSDKListener(listener);
            EventBus.getDefault().register((Object)sGeneralSDKEventObj);
        }
    }

    private static void initHtmlWrapper(Activity activity, PropertiesObj serverConfig, boolean clearHtmlCache) {
        SDKLogger.printDebugLog(TAG, "initHtmlWrapper");
        final long startTime = System.currentTimeMillis();
        HtmlViewWrapper viewWrapper = HtmlManager.initDefaultHtmlView((Context)activity, clearHtmlCache);
        viewWrapper.setSdkInitListener(new HtmlViewWrapper.IOnInitFinishedListener(){

            @Override
            public void onInitFinished() {
                SDKLogger.printDebugLog(TAG, "CT initHtmlWrapper time = " + (double)(System.currentTimeMillis() - startTime) / 1000.0 + " seconds");
            }
        });
        viewWrapper.loadHtml(serverConfig.getHtmlLoaderDefaultLink());
    }

    private static SdkAPIManager getApiManager(Context context) {
        SdkAPIManager.init(context, mPublisherId, mSecurityKey, isDeveloperLoggingON);
        return SdkAPIManager.getSdkApiInstance(context);
    }

    public static boolean isInitialised() {
        return isInitialized;
    }

    private static void checkManifestDeclarations(Context context) {
        SDKLogger.printDebugLog(TAG, "checkManifestDeclarations");
        if (ConstantDef.SDK_EXTENSION_TYPE == ConstantDef.EXTENSION_TYPE_ANDROID || ConstantDef.SDK_EXTENSION_TYPE == ConstantDef.EXTENSION_TYPE_ECLIPSE || ConstantDef.SDK_EXTENSION_TYPE == ConstantDef.EXTENSION_TYPE_COCOS_DX) {
            boolean hasReceiver = false;
            try {
                PackageManager pm = context.getPackageManager();
                PackageInfo packageInfo = pm.getPackageInfo(context.getPackageName(), 2);
                ActivityInfo[] receivers = packageInfo.receivers;
                String receiverClassName = SdkReceiver.class.getName();
                if (receivers != null) {
                    for (ActivityInfo activityInfo : receivers) {
                        if (!activityInfo.name.equals(receiverClassName)) continue;
                        hasReceiver = true;
                    }
                }
            }
            catch (Exception e) {
                hasReceiver = false;
            }
            if (!hasReceiver) {
                SDKLogger.printErrorLog("KIDOZ SDK", "IMPORTANT !!! Missing Android Manifest declaration !!! \nPlease add the following lines to your Manifest.xml file..\n...\n\n<receiver android:name=\"com.kidoz.sdk.api.receivers.SdkReceiver\">\n    <intent-filter>\n         <action android:name=\"android.intent.action.PACKAGE_ADDED\" />\n         <data android:scheme=\"package\" />\n    </intent-filter>\n</receiver> \n...\n");
            }
        }
    }

    public static KidozBannerView getKidozBanner(Activity activity) {
        return new KidozBannerView((Context)activity);
    }

    public static void setLoggingEnabled(boolean enabled) {
        isDeveloperLoggingON = enabled;
    }

    public static String getPublisherID() {
        return mPublisherId;
    }

    public static String getAuthToken() {
        return mSecurityKey;
    }

    public static String getSDKVersion() {
        return "0.8.8.4";
    }

    static {
        isInitialized = false;
        mPublisherId = null;
        mSecurityKey = null;
        isDeveloperLoggingON = false;
        mAppId = null;
        try {
            InputStream is = KidozSDK.class.getClassLoader().getResourceAsStream("build_properties.txt");
            if (is != null) {
                String value = StreamToStringConverter.readStream(new BufferedInputStream(is), null, false);
                ConstantDef.SDK_EXTENSION_TYPE = Integer.parseInt(value);
            }
        }
        catch (Exception e) {
            ConstantDef.SDK_EXTENSION_TYPE = ConstantDef.EXTENSION_TYPE_ANDROID;
        }
    }
}

