/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.events;

import android.content.Context;
import android.content.SharedPreferences;
import android.content.pm.PackageInfo;
import android.os.AsyncTask;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.util.DisplayMetrics;
import android.util.SparseArray;
import android.view.WindowManager;
import com.kidoz.events.Event;
import com.kidoz.events.EventBulk;
import com.kidoz.events.EventParameters;
import com.kidoz.events.EventSyncAsyncTask;
import com.kidoz.sdk.api.KidozSDK;
import com.kidoz.sdk.api.general.utils.ConstantDef;
import com.kidoz.sdk.api.general.utils.SDKLogger;
import com.kidoz.sdk.api.general.utils.ScreenUtils;
import com.kidoz.sdk.api.general.utils.SdkDeviceUtils;
import com.kidoz.sdk.api.general.utils.Utils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Locale;
import java.util.concurrent.RejectedExecutionException;
import org.json.JSONObject;

public class EventManager {
    private static final String FAILED_SERVER_SYNC = "Failed server syncing event.";
    public static int LOG_CRITICAL_LEVEL = 0;
    public static int LOG_NORMAL_LEVEL = 1;
    private static final int NIGHT_TIME_HOUR_VALUE_START = 21;
    private static final int NIGHT_TIME_HOUR_VALUE_END = 8;
    private static final int DAY_TIME_AMOUNT = 10;
    private static final int NIGHT_TIME_AMOUNT_EXTRA = 50;
    private static final int THREE_G_CONNECTON_TYPE_AMOUNT = 10;
    private static final int WIFI_CONNECTON_TYPE_AMOUNT_EXTRA = 20;
    private static final int SCREEN_STATE_ON_AMOUNT = 10;
    private static final int SCREEN_STATE_OFF_AMOUNT_EXTRA = 20;
    private static final String OS_TYPE = "Android";
    public static final String EVENTS_SHARED_PREFERENCES_KEY = "events_shared_preferences";
    public static final String EVENTS_LAST_SESSION_ID_KEY = "last_session_id";
    public static final String LOG_LEVEL_KEY = "log_level";
    public static int SDK_STYLE_VERSION_NUM = 0;
    private static EventManager mEventManager;
    private int mLogLevel;
    private long mSessionID;
    private String mDeveloperID;
    private SparseArray<Event> mOpenedEventsSet = new SparseArray();
    private static Utils.StaticHandler mSyncEventHandler;
    private String mUserRefferal;

    private EventManager() {
    }

    public static EventManager getInstance(Context context) {
        if (mEventManager == null) {
            mEventManager = new EventManager();
            mEventManager.init(context, null);
        }
        return mEventManager;
    }

    public static EventManager getInstance(Context context, JSONObject params) {
        if (mEventManager == null) {
            mEventManager = new EventManager();
            mEventManager.init(context, params);
        }
        return mEventManager;
    }

    private Handler getMyHandler() {
        if (mSyncEventHandler == null) {
            mSyncEventHandler = new Utils.StaticHandler(Looper.getMainLooper()){

                @Override
                public void handleMessage(Message message) {
                }
            };
        }
        return mSyncEventHandler;
    }

    public void init(Context context, JSONObject params) {
        this.mUserRefferal = SdkDeviceUtils.getDeviceReferral(context);
        try {
            int resId = context.getResources().getIdentifier("PROPERTY_APPLICATION_REFFERAL", "string", KidozSDK.getAppId() != null ? KidozSDK.getAppId() : context.getPackageName());
            if (resId != 0) {
                this.mUserRefferal = context.getString(resId);
            }
        }
        catch (Exception resId) {
            // empty catch block
        }
        SharedPreferences eventsPref = context.getSharedPreferences(EVENTS_SHARED_PREFERENCES_KEY, 0);
        try {
            if (params != null) {
                this.mLogLevel = params.optInt(LOG_LEVEL_KEY, LOG_CRITICAL_LEVEL);
                this.mDeveloperID = params.optString("DeveloperID", "");
                this.mSessionID = params.optInt("SessionID", 0);
                SharedPreferences.Editor editor = eventsPref.edit();
                editor.putInt(LOG_LEVEL_KEY, this.mLogLevel);
                editor.putString("DeveloperID", this.mDeveloperID);
                editor.apply();
            } else {
                this.mLogLevel = eventsPref.getInt(LOG_LEVEL_KEY, LOG_CRITICAL_LEVEL);
                this.mDeveloperID = eventsPref.getString("DeveloperID", "");
                this.mSessionID = -1L;
            }
            SDKLogger.printInfoLog("init Event manager");
        }
        catch (Exception ex) {
            SDKLogger.printErrorLog("Error on EventManager init " + ex.getMessage());
        }
    }

    public int logClickEvent(Context context, String widgetType, String styleId, String action, String label, String itemID, int position) {
        Event event = new Event();
        event.addParameterToJsonObject("ItemID", itemID);
        event.addParameterToJsonObject("ItemIndex", position);
        this.internalLogEvent(context, widgetType, styleId, LOG_NORMAL_LEVEL, event, "Content Click", action, label);
        return 0;
    }

    public int logEvent(Context context, String widgetType, String styleId, int logLevel, String category, String action, String label) {
        this.internalLogEvent(context, widgetType, styleId, logLevel, null, category, action, label);
        return 0;
    }

    public int logEventWithDurationStart(String widgetType, String styleId, int logLevel, int resourceID, String category, String action, String label, String itemID) {
        try {
            Event openedEvent = new Event();
            this.fillBaseEventParameters(openedEvent, category, action, label, widgetType, styleId);
            openedEvent.addParameterToJsonObject("ItemID", itemID);
            openedEvent.setLogLevel(logLevel);
            this.mOpenedEventsSet.put(resourceID, (Object)openedEvent);
        }
        catch (Exception ex) {
            SDKLogger.printErrorLog("Error on EventManager logEventWithDuration " + ex.getMessage());
        }
        return 0;
    }

    public int logEventWithDurationEnd(Context context, String widgetType, String styleId, int resourceID) {
        try {
            Event openedEvent = (Event)this.mOpenedEventsSet.get(resourceID);
            if (openedEvent != null) {
                int duration = (int)(System.currentTimeMillis() - openedEvent.getEventCreationTime());
                openedEvent.addParameterToJsonObject("Duration", duration);
                this.internalLogEvent(context, widgetType, styleId, openedEvent.getLogLevel(), openedEvent, null, null, null);
                this.mOpenedEventsSet.remove(resourceID);
            }
            SDKLogger.printInfoLog("activity end event called");
        }
        catch (Exception ex) {
            SDKLogger.printErrorLog("Error on EventManager logEventWithDuration " + ex.getMessage());
        }
        return 0;
    }

    public int logSponsoredContentImpressionEvent(Context context, String widgetType, String styleId, String action, String label, String advertiserID, String itemID, int positionIndex) {
        try {
            Event event = new Event();
            event.addParameterToJsonObject("ItemID", itemID);
            event.addParameterToJsonObject("AdvertiserID", advertiserID);
            event.addParameterToJsonObject("ItemIndex", positionIndex);
            this.internalLogEvent(context, widgetType, styleId, LOG_CRITICAL_LEVEL, event, "Sponsored Content", action, label);
            return 0;
        }
        catch (Exception ex) {
            SDKLogger.printErrorLog("Error on EventManager logImpressionEvent " + ex.getMessage());
            return -1;
        }
    }

    public int logOrganicContentImpressionEvent(Context context, String widgetType, String styleId, String action, String label, String itemID, int positionIndex) {
        try {
            Event event = new Event();
            event.addParameterToJsonObject("ItemID", itemID);
            event.addParameterToJsonObject("ItemIndex", positionIndex);
            this.internalLogEvent(context, widgetType, styleId, LOG_CRITICAL_LEVEL, event, "Organic Content", action, label);
            return 0;
        }
        catch (Exception ex) {
            SDKLogger.printErrorLog("Error on EventManager logImpressionEvent " + ex.getMessage());
            return -1;
        }
    }

    public int logSponsoredContentClickEvent(Context context, String widgetType, String styleId, String label, String advertiserID, String itemID, int positionIndex) {
        try {
            Event event = new Event();
            event.addParameterToJsonObject("ItemID", itemID);
            event.addParameterToJsonObject("AdvertiserID", advertiserID);
            event.addParameterToJsonObject("ItemIndex", positionIndex);
            this.internalLogEvent(context, widgetType, styleId, LOG_CRITICAL_LEVEL, event, "Sponsored Content", "Click", label);
            return 0;
        }
        catch (Exception ex) {
            SDKLogger.printErrorLog("Error on EventManager logImpressionEvent " + ex.getMessage());
            return -1;
        }
    }

    public int logSponsoredConversionEvent(Context context, String widgetType, String styleId, Event event, String label, String advertiserID, String itemID, int positionIndex, int rewardKey, int rewardValue) {
        try {
            if (event == null) {
                event = new Event();
            }
            event.addParameterToJsonObject("ItemID", itemID);
            event.addParameterToJsonObject("AdvertiserID", advertiserID);
            event.addParameterToJsonObject("ItemIndex", positionIndex);
            event.addParameterToJsonObject("intField", rewardKey);
            event.addParameterToJsonObject("intField2", rewardValue);
            this.internalLogEvent(context, widgetType, styleId, LOG_CRITICAL_LEVEL, event, "Sponsored Content", "Conversion", label);
            return 0;
        }
        catch (Exception ex) {
            SDKLogger.printErrorLog("Error on EventManager logSponsoredConversionEvent " + ex.getMessage());
            return -1;
        }
    }

    public int logSponsoredContentInstallEvent(Context context, String widgetType, String styleId, String label, String advertiserID, String itemID, int positionIndex) {
        try {
            Event event = new Event();
            event.addParameterToJsonObject("ItemID", itemID);
            event.addParameterToJsonObject("AdvertiserID", advertiserID);
            event.addParameterToJsonObject("ItemIndex", positionIndex);
            this.internalLogEvent(context, widgetType, styleId, LOG_CRITICAL_LEVEL, event, "Sponsored Content", "Install Completed", label);
            return 0;
        }
        catch (Exception ex) {
            SDKLogger.printErrorLog("Error on EventManager logImpressionEvent " + ex.getMessage());
            return -1;
        }
    }

    public int LogEventWithIntField(Context context, String widgetType, String styleId, int logLevel, String category, String action, String label, int intField) {
        Event event = new Event();
        event.addParameterToJsonObject("intField", intField);
        return this.internalLogEvent(context, widgetType, styleId, logLevel, event, category, action, label);
    }

    public int logEvent(Context context, String widgetType, String styleId, int logLevel, Event event, String category, String action, String label) {
        return this.internalLogEvent(context, widgetType, styleId, logLevel, event, category, action, label);
    }

    private synchronized int internalLogEvent(Context context, String widgetType, String styleId, int logLevel, Event event, String category, String action, String label) {
        if (logLevel <= this.mLogLevel) {
            Event tempEvent = event == null ? new Event() : event;
            this.fillBaseEventParameters(tempEvent, category, action, label, widgetType, styleId);
            try {
                EventBulk result = new EventBulk();
                result.setDeviceParamsJSONObject(this.getBulkDeviceParamsJsonObject(context));
                result.setEventArrayList(new ArrayList<Event>(Collections.singletonList(tempEvent)));
                this.syncEventToServer(context, result);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return 0;
    }

    private int fillBaseEventParameters(Event event, String category, String action, String label, String widgetType, String styleId) {
        if (category != null) {
            event.addParameterToJsonObject("Category", category);
        }
        if (action != null) {
            event.addParameterToJsonObject("Action", action);
        }
        if (label != null) {
            event.addParameterToJsonObject("Label", label);
        }
        event.addParameterToJsonObject("SessionID", this.mSessionID);
        if (widgetType != null) {
            event.addParameterToJsonObject("WidgetType", widgetType);
        }
        if (styleId != null) {
            event.addParameterToJsonObject("StyleId", styleId);
        }
        event.addParameterToJsonObject("SdkVersion", "0.8.8.4");
        return 0;
    }

    private JSONObject getBulkDeviceParamsJsonObject(Context context) {
        JSONObject result = new JSONObject();
        if (context != null) {
            try {
                if (this.mDeveloperID == null) {
                    SharedPreferences eventsPref = context.getSharedPreferences(EVENTS_SHARED_PREFERENCES_KEY, 0);
                    this.mDeveloperID = eventsPref.getString("DeveloperID", "");
                }
                result.put("DeviceHash", (Object)Utils.generateUniqeDeviceID(KidozSDK.getAppId() != null ? KidozSDK.getAppId() : context.getPackageName(), this.mDeveloperID));
                result.put("UserRefferal", (Object)this.mUserRefferal);
                result.put("PackageID", (Object)(KidozSDK.getAppId() != null ? KidozSDK.getAppId() : context.getPackageName()));
                PackageInfo pInfo = context.getPackageManager().getPackageInfo(context.getPackageName(), 0);
                result.put("AppVersion", (Object)String.valueOf(pInfo.versionName));
                result.put("AppID", (Object)(KidozSDK.getAppId() != null ? KidozSDK.getAppId() : String.valueOf(pInfo.packageName)));
                result.put("DeveloperID", (Object)this.mDeveloperID);
                result.put("EventVersion", 0);
                result.put("DeviceType", (Object)String.valueOf(Build.DEVICE));
                result.put("DeviceBrand", (Object)String.valueOf(Build.MANUFACTURER));
                result.put("DeviceModel", (Object)String.valueOf(Build.MODEL));
                result.put("ScreenType", (Object)String.valueOf(context.getResources().getConfiguration().screenLayout & 0xF));
                result.put("ScreenSize", (Object)String.valueOf(ScreenUtils.getDeviceScreenSizeInInches(context)));
                WindowManager windowManager = (WindowManager)context.getSystemService("window");
                DisplayMetrics metrics = new DisplayMetrics();
                windowManager.getDefaultDisplay().getMetrics(metrics);
                result.put("DpiFactor", (Object)String.valueOf(metrics.densityDpi));
                result.put("ScreenW", (Object)String.valueOf(SdkDeviceUtils.getScreenSize(context, true)));
                result.put("ScreenH", (Object)String.valueOf(SdkDeviceUtils.getScreenSize(context, false)));
                result.put("OsType", (Object)String.valueOf(OS_TYPE));
                result.put("OsVersion", (Object)String.valueOf(Build.VERSION.SDK_INT));
                result.put("DeviceLang", (Object)String.valueOf(Locale.getDefault().getLanguage()));
                result.put("TimeZone", (Object)EventParameters.getCurrentTimezoneOffset());
                result.put("Country", (Object)String.valueOf(Locale.getDefault().getCountry()));
                result.put("EventType", (Object)"Device Info");
                result.put("SdkVersion", (Object)"0.8.8.4");
                result.put("ExtensionType", ConstantDef.SDK_EXTENSION_TYPE);
            }
            catch (Exception ex) {
                SDKLogger.printErrorLog("Error when trying to create device params: " + ex.getMessage());
            }
        }
        return result;
    }

    private void syncEventToServer(final Context context, final EventBulk eventBulk) {
        this.getMyHandler().post(new Runnable(){

            @Override
            public void run() {
                EventSyncAsyncTask mEventSyncAsyncTask = new EventSyncAsyncTask(context);
                try {
                    if (Build.VERSION.SDK_INT < 11) {
                        mEventSyncAsyncTask.execute(new EventBulk[0]);
                    } else {
                        mEventSyncAsyncTask.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new EventBulk[]{eventBulk});
                    }
                }
                catch (RejectedExecutionException ree) {
                    SDKLogger.printErrorLog(EventManager.FAILED_SERVER_SYNC);
                }
                catch (OutOfMemoryError e) {
                    SDKLogger.printErrorLog(EventManager.FAILED_SERVER_SYNC);
                }
                catch (Exception e) {
                    SDKLogger.printErrorLog(EventManager.FAILED_SERVER_SYNC);
                }
            }
        });
    }
}

