/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.api.ui_views.flexi_view;

import android.graphics.Bitmap;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Shader;
import android.media.ThumbnailUtils;
import com.squareup.imagelib.Transformation;

public class CircleTransformation
implements Transformation {
    private int mBorder = 0;
    private int mContainerSize = 0;
    private String mBorderColor;
    private String mFillColor;

    public CircleTransformation(int borderWith, String borderColor, String fillColor, int containerSize) {
        this.mBorder = borderWith;
        this.mBorderColor = borderColor;
        this.mContainerSize = containerSize;
        this.mFillColor = fillColor;
    }

    @Override
    public Bitmap transform(Bitmap source) {
        Bitmap squaredBitmap = ThumbnailUtils.extractThumbnail((Bitmap)source, (int)this.mContainerSize, (int)this.mContainerSize);
        source.recycle();
        Bitmap bitmap = Bitmap.createBitmap((int)squaredBitmap.getWidth(), (int)squaredBitmap.getHeight(), (Bitmap.Config)squaredBitmap.getConfig());
        float r = 0.0f;
        if (this.mBorder != 0) {
            r = (float)squaredBitmap.getWidth() / 2.0f - (float)(this.mBorder / 2);
        }
        Paint borderPaint = new Paint();
        try {
            borderPaint.setColor(Color.parseColor((String)this.mFillColor));
        }
        catch (Exception e) {
            borderPaint.setColor(-1);
        }
        borderPaint.setStyle(Paint.Style.FILL);
        borderPaint.setAntiAlias(true);
        borderPaint.setStrokeWidth((float)this.mBorder);
        Canvas canvas = new Canvas(bitmap);
        float mMargin = 0.0f;
        canvas.drawCircle((float)(squaredBitmap.getWidth() / 2) - mMargin, (float)(squaredBitmap.getHeight() / 2) - mMargin, r, borderPaint);
        Paint paint = new Paint();
        BitmapShader shader = new BitmapShader(squaredBitmap, Shader.TileMode.CLAMP, Shader.TileMode.CLAMP);
        paint.setShader((Shader)shader);
        paint.setAntiAlias(true);
        paint.setFilterBitmap(true);
        canvas.drawCircle(((float)squaredBitmap.getWidth() - mMargin) / 2.0f, ((float)squaredBitmap.getHeight() - mMargin) / 2.0f, r, paint);
        if (this.mBorder != 0) {
            try {
                borderPaint.setColor(Color.parseColor((String)this.mBorderColor));
            }
            catch (Exception e) {
                borderPaint.setColor(-1);
            }
            borderPaint.setStyle(Paint.Style.STROKE);
            canvas.drawCircle((float)(squaredBitmap.getWidth() / 2) - mMargin, (float)(squaredBitmap.getHeight() / 2) - mMargin, r, borderPaint);
        }
        if (!squaredBitmap.isRecycled()) {
            squaredBitmap.recycle();
        }
        if (!source.isRecycled()) {
            source.recycle();
        }
        return bitmap;
    }

    @Override
    public String key() {
        return "circleFlexiTransform";
    }
}

