/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.api.ui_views.new_panel_view;

import android.app.Activity;
import android.content.Context;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.kidoz.sdk.api.ui_views.new_panel_view.LogoView;
import com.kidoz.sdk.api.ui_views.new_panel_view.PanelShape;
import com.kidoz.sdk.api.ui_views.new_panel_view.PanelShapeHandle;
import com.kidoz.sdk.api.ui_views.new_panel_view.PanelShapeHandleDecoration;
import com.kidoz.sdk.api.ui_views.new_panel_view.ParentalLockView;

public class PanelViewWrapper
extends LinearLayout {
    private static final int DEFAULT_PANEL_COLOR = -5592355;
    private static final String DEFAULT_RECOMMENDED_BY_TEXT = "Recommended by KIDOZ";
    private static final int DEFAULT_RECOMMENDED_BY_TEXT_COLOR = -197380;
    private static final float RECCOMENDED_TEXT_SIZE_MULTIPLIER = 0.009f;
    private static final int PANEL_HANDLE_RIGHT_ID = 1001;
    private PanelShape mPanelShape;
    private PanelShapeHandle mPanelShapeHandle;
    private PanelShapeHandleDecoration mPanelShapeHandleDecoration;
    private LinearLayout mFooterLinearLayout;
    private ParentalLockView mParentalLockView;
    private TextView mRecommendedTV;
    private LogoView mLogoView;
    private int mViewWidth;
    private int mViewHeight;
    private boolean mLayoutOnce;

    public PanelViewWrapper(Context context) {
        super(context);
        this.init(context);
    }

    public PanelViewWrapper(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    public PanelViewWrapper(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context);
    }

    public PanelViewWrapper(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init(context);
    }

    private void init(Context context) {
        this.mLayoutOnce = false;
        this.setMainLayoutDefs();
        this.allowPanelTransparency();
    }

    private void setMainLayoutDefs() {
        this.setWeightSum(1.0f);
        this.setOrientation(1);
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        super.onLayout(changed, l, t, r, b);
        this.mViewWidth = this.getWidth();
        this.mViewHeight = this.getHeight();
        if (!this.mLayoutOnce && this.mViewWidth > 0 && this.mViewHeight > 0) {
            this.mLayoutOnce = true;
            this.layout(this.getContext());
        }
    }

    private void layout(Context context) {
        this.addMainPanelShape(context);
        this.addPanelFooter(context);
    }

    private void loadContent() {
    }

    private void addMainPanelShape(Context context) {
        RelativeLayout panelFrame = new RelativeLayout(this.getContext());
        LinearLayout.LayoutParams panelFrameLPs = new LinearLayout.LayoutParams(-1, 0);
        panelFrame.setLayoutParams((ViewGroup.LayoutParams)panelFrameLPs);
        panelFrameLPs.weight = 0.875f;
        this.addView((View)panelFrame);
        this.mPanelShape = new PanelShape(this.getContext(), -5592355);
        RelativeLayout.LayoutParams panelShapeLPs = new RelativeLayout.LayoutParams(-1, -1);
        this.mPanelShape.setLayoutParams((ViewGroup.LayoutParams)panelShapeLPs);
        panelFrame.addView((View)this.mPanelShape);
        int PANEL_HANDLE_EDGE = 200;
        this.mPanelShapeHandle = new PanelShapeHandle(this.getContext(), -5592355);
        RelativeLayout.LayoutParams panelShapeHandleLPs = new RelativeLayout.LayoutParams(200, 200);
        this.mPanelShapeHandle.setLayoutParams((ViewGroup.LayoutParams)panelShapeHandleLPs);
        panelShapeHandleLPs.addRule(12);
        panelShapeHandleLPs.addRule(9);
        this.mPanelShapeHandle.setId(1001);
        panelFrame.addView((View)this.mPanelShapeHandle);
        this.mPanelShapeHandleDecoration = new PanelShapeHandleDecoration(this.getContext(), -5033119);
        RelativeLayout.LayoutParams panelShapeHandleDecorationLPs = new RelativeLayout.LayoutParams(360, 360);
        this.mPanelShapeHandleDecoration.setLayoutParams((ViewGroup.LayoutParams)panelShapeHandleDecorationLPs);
        panelShapeHandleDecorationLPs.addRule(12);
        panelShapeHandleDecorationLPs.addRule(1, 1001);
        panelFrame.addView((View)this.mPanelShapeHandleDecoration);
    }

    private void addPanelFooter(Context context) {
        this.mFooterLinearLayout = new LinearLayout(context);
        LinearLayout.LayoutParams footerLinearLayoutLPs = new LinearLayout.LayoutParams(-1, 0);
        footerLinearLayoutLPs.weight = 0.125f;
        this.mFooterLinearLayout.setLayoutParams((ViewGroup.LayoutParams)footerLinearLayoutLPs);
        this.mFooterLinearLayout.setBackgroundColor(-5592355);
        this.mFooterLinearLayout.setOrientation(0);
        this.mFooterLinearLayout.setWeightSum(1.0f);
        this.addView((View)this.mFooterLinearLayout);
        this.addLogoView(context);
        this.addRecommendedByView(context);
        this.addParentalView(context);
    }

    private void addLogoView(Context context) {
        LinearLayout.LayoutParams localLinearLayoutLPs = new LinearLayout.LayoutParams(0, -1);
        localLinearLayoutLPs.weight = 0.1f;
        this.mLogoView = new LogoView(context);
        this.mLogoView.setLayoutParams((ViewGroup.LayoutParams)localLinearLayoutLPs);
        this.mLogoView.setBackgroundColor(-65536);
        this.mFooterLinearLayout.addView((View)this.mLogoView);
    }

    private void addRecommendedByView(Context context) {
        LinearLayout.LayoutParams localLinearLayoutLPs = new LinearLayout.LayoutParams(0, -1);
        localLinearLayoutLPs.weight = 0.7f;
        this.mRecommendedTV = new TextView(context);
        this.mRecommendedTV.setLayoutParams((ViewGroup.LayoutParams)localLinearLayoutLPs);
        this.mRecommendedTV.setText((CharSequence)DEFAULT_RECOMMENDED_BY_TEXT);
        this.mRecommendedTV.setTextColor(-197380);
        this.mRecommendedTV.setGravity(16);
        float textSize = (float)Math.min(this.mViewHeight, this.mViewWidth) * 0.009f;
        this.mRecommendedTV.setTextSize(textSize);
        this.mFooterLinearLayout.addView((View)this.mRecommendedTV);
    }

    private void addParentalView(Context context) {
        LinearLayout.LayoutParams localLinearLayoutLPs = new LinearLayout.LayoutParams(0, -1);
        localLinearLayoutLPs.weight = 0.2f;
        this.mParentalLockView = new ParentalLockView(context);
        this.mParentalLockView.setLayoutParams((ViewGroup.LayoutParams)localLinearLayoutLPs);
        this.mFooterLinearLayout.addView((View)this.mParentalLockView);
    }

    private void allowPanelTransparency() {
        this.setLayerType(2, null);
        this.setBackgroundColor(0);
    }

    protected void setPanelColor(int color) {
        this.mPanelShape.setPanelColor(color);
        this.mFooterLinearLayout.setBackgroundColor(color);
    }

    public void show(Activity activity) {
        FrameLayout.LayoutParams flps = new FrameLayout.LayoutParams(-1, 900);
        flps.gravity = 80;
        activity.addContentView((View)this, (ViewGroup.LayoutParams)flps);
    }
}

