/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.api.ui_views.new_panel_view;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Point;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.RectF;
import android.graphics.Xfermode;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.View;

public class PanelShape
extends View {
    private static final float TOP_CORNER_RADIUS = 140.0f;
    private static final float TOP_MARGIN_PERCENT = 0.2f;
    private static final int HOLLOW_PAINT_COLOR = 0x10000000;
    private Path mPointyCapPath;
    private Path mMainShapePath;
    private Path mInnerHollowPath;
    private Paint mPaint;
    private Paint mInnerHollowPaint;
    private int mPanelColor;
    private int mViewWidth;
    private int mViewHeight;

    public PanelShape(Context context, int panelColor) {
        super(context);
        this.mPanelColor = panelColor;
        this.init();
    }

    public PanelShape(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public PanelShape(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    public PanelShape(Context context, @Nullable AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init();
    }

    private void init() {
        this.setWillNotDraw(false);
        this.setLayerType(2, null);
    }

    private void layout() {
        this.initShapePaint();
        float topMargin = 0.2f * (float)this.mViewHeight;
        this.initMainShapePath(topMargin);
        this.initPointyCapShapePath(topMargin);
        this.hollowShape(topMargin);
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        this.mViewWidth = this.getWidth();
        this.mViewHeight = this.getHeight();
        this.layout();
    }

    private void initPointyCapShapePath(float topMargin) {
        Point startPoint = new Point(this.mViewWidth, (int)topMargin);
        Point bezier1 = new Point((int)((double)this.mViewWidth * 0.3), (int)topMargin);
        Point bezier2 = new Point((int)((double)this.mViewWidth * 0.15), 0);
        Point endPoint = new Point(47, (int)topMargin);
        this.mPointyCapPath = new Path();
        this.mPointyCapPath.moveTo((float)startPoint.x, (float)startPoint.y);
        this.mPointyCapPath.cubicTo((float)bezier1.x, (float)bezier1.y, (float)bezier2.x, (float)bezier2.y, (float)endPoint.x, (float)endPoint.y);
        this.mPointyCapPath.close();
    }

    private void initMainShapePath(float topMargin) {
        RectF topRightCornerRect = new RectF((float)this.mViewWidth - 140.0f, topMargin, (float)this.mViewWidth, 140.0f + topMargin);
        this.mMainShapePath = new Path();
        this.mMainShapePath.moveTo((float)this.mViewWidth, (float)this.mViewHeight);
        this.mMainShapePath.lineTo((float)this.mViewWidth, 140.0f + topMargin);
        this.mMainShapePath.arcTo(topRightCornerRect, 0.0f, -90.0f);
        Point bezier1 = new Point(70, (int)topMargin);
        Point bezier2 = new Point(-260, -60);
        Point endPoint = new Point(0, (int)(140.0f + topMargin * 5.0f));
        this.mMainShapePath.cubicTo((float)bezier1.x, (float)bezier1.y, (float)bezier2.x, (float)bezier2.y, (float)endPoint.x, (float)endPoint.y);
        this.mMainShapePath.lineTo(0.0f, (float)this.mViewHeight);
        this.mMainShapePath.lineTo((float)this.mViewWidth, (float)this.mViewHeight);
        this.mMainShapePath.close();
    }

    private void initShapePaint() {
        this.mPaint = new Paint();
        this.mPaint.setColor(this.mPanelColor);
        this.mInnerHollowPaint = new Paint();
        this.mInnerHollowPaint.setColor(0x10000000);
        this.mInnerHollowPaint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.CLEAR));
    }

    private void hollowShape(float topMargin) {
        float leftRightMargin = (float)((double)this.mViewWidth * 0.04);
        float top = (float)((double)topMargin + (double)this.mViewHeight * 0.1);
        float bottom = (float)((double)this.mViewHeight * 0.95);
        float R1top = (float)((double)this.mViewHeight * 0.8);
        float R1right = (float)this.mViewWidth - leftRightMargin * 1.25f;
        float R1left = (float)this.mViewWidth - leftRightMargin * 3.5f;
        float R1bottom = (float)this.mViewHeight * 0.9f;
        RectF bottomRightCornerRectBig = new RectF(R1left, R1top, R1right, R1bottom);
        float R2width = leftRightMargin * 4.0f;
        float R2top = (float)this.mViewHeight - ((float)this.mViewHeight - R1bottom) * 2.0f;
        float R2right = R1left;
        float R2left = R1left - R2width;
        float R2bottom = bottom;
        RectF bottomRightCornerRectSmall = new RectF(R2left, R2top, R2right, R2bottom);
        this.mInnerHollowPath = new Path();
        this.mInnerHollowPath.moveTo(leftRightMargin, top);
        this.mInnerHollowPath.lineTo((float)this.mViewWidth - leftRightMargin, top);
        this.mInnerHollowPath.lineTo((float)this.mViewWidth - leftRightMargin, R1top);
        this.mInnerHollowPath.lineTo(R1right, R1top);
        this.mInnerHollowPath.arcTo(bottomRightCornerRectBig, -90.0f, -90.0f);
        this.mInnerHollowPath.arcTo(bottomRightCornerRectSmall, 0.0f, 90.0f);
        this.mInnerHollowPath.lineTo(leftRightMargin, bottom);
        this.mInnerHollowPath.close();
    }

    protected void onDraw(Canvas canvas) {
        canvas.drawPath(this.mMainShapePath, this.mPaint);
        canvas.drawPath(this.mInnerHollowPath, this.mInnerHollowPaint);
        this.mInnerHollowPaint.setColor(-1127546934);
        this.mInnerHollowPaint.setStyle(Paint.Style.STROKE);
        this.mInnerHollowPaint.setStrokeWidth(5.0f);
        canvas.drawPath(this.mInnerHollowPath, this.mInnerHollowPaint);
        float bottom = (float)((double)this.mViewHeight * 0.95);
        super.onDraw(canvas);
    }

    public void setPanelColor(int panelColor) {
        if (this.mPaint != null) {
            this.mPaint.setColor(panelColor);
            this.postInvalidate();
        }
    }
}

