/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.api.ui_views;

import android.animation.Animator;
import android.content.Context;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.RectF;
import android.view.View;
import android.widget.ImageView;
import com.kidoz.sdk.api.general.animations.GenAnimator;
import com.kidoz.sdk.api.general.utils.ScreenUtils;
import com.kidoz.sdk.api.picasso_related.PicassoOk;
import java.io.File;

public class ParentalLockButton
extends ImageView {
    private boolean mIsLockActive;
    private boolean mIsImageFilesExist;
    private boolean mIsLockStateChanged;
    private File mLockActiveImageFile;
    private File mLockUnActiveImageFile;
    private int mWidth;
    private int mHeight;
    private int mAnimationType;
    private Paint mWhitePaint;
    private Paint mBluePaint;
    private Paint mOrangePaint;
    private RectF mRectF;
    private RectF mLockOpenRectF;
    private ParentalLockButtonListener mParentalLockButtonListener;

    public ParentalLockButton(Context context, File lockActiveImage, File lockUnActiveImage, ParentalLockButtonListener parentalLockButtonListener) {
        super(context);
        this.mParentalLockButtonListener = parentalLockButtonListener;
        this.mLockActiveImageFile = lockActiveImage;
        this.mLockUnActiveImageFile = lockUnActiveImage;
        this.setScaleType(ImageView.ScaleType.FIT_XY);
        this.initView();
    }

    private void initView() {
        this.mIsImageFilesExist = this.mLockActiveImageFile != null && this.mLockActiveImageFile.exists() && this.mLockUnActiveImageFile != null && this.mLockUnActiveImageFile.exists();
        this.initImageParameters();
        this.initPaints();
        this.initRectF();
        this.initOnClickAnimation();
    }

    private void initOnClickAnimation() {
        this.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (ParentalLockButton.this.mParentalLockButtonListener != null) {
                    ParentalLockButton.this.mParentalLockButtonListener.onClickStarted();
                }
                switch (ParentalLockButton.this.mAnimationType) {
                    case 1: {
                        GenAnimator.playStandUpAnimation(view, new Animator.AnimatorListener(){

                            public void onAnimationStart(Animator animation) {
                            }

                            public void onAnimationEnd(Animator animation) {
                                if (ParentalLockButton.this.mParentalLockButtonListener != null) {
                                    ParentalLockButton.this.mParentalLockButtonListener.onClickEnd();
                                }
                            }

                            public void onAnimationCancel(Animator animation) {
                            }

                            public void onAnimationRepeat(Animator animation) {
                            }
                        });
                    }
                }
            }
        });
    }

    private void loadImage() {
        if (this.getDrawable() == null || this.mIsLockStateChanged) {
            this.mIsLockStateChanged = false;
            if (this.mIsLockActive) {
                if (this.mLockActiveImageFile != null && this.mLockActiveImageFile.exists()) {
                    PicassoOk.getPicasso(this.getContext()).load(this.mLockActiveImageFile).into(this);
                }
            } else if (this.mLockUnActiveImageFile != null && this.mLockUnActiveImageFile.exists()) {
                PicassoOk.getPicasso(this.getContext()).load(this.mLockUnActiveImageFile).into(this);
            }
        }
    }

    private void initImageParameters() {
        float mScaleFactor = ScreenUtils.getScaleFactor(this.getContext());
        this.mWidth = 178;
        this.mHeight = 128;
        this.mAnimationType = 1;
        if (this.mIsImageFilesExist) {
            BitmapFactory.Options options = new BitmapFactory.Options();
            options.inJustDecodeBounds = true;
            BitmapFactory.decodeFile((String)this.mLockActiveImageFile.getAbsolutePath(), (BitmapFactory.Options)options);
            this.mWidth = options.outWidth;
            this.mHeight = options.outHeight;
        }
        this.mWidth = (int)((float)this.mWidth * mScaleFactor);
        this.mHeight = (int)((float)this.mHeight * mScaleFactor);
    }

    private void initPaints() {
        this.mWhitePaint = new Paint(1);
        this.mWhitePaint.setStyle(Paint.Style.FILL_AND_STROKE);
        this.mWhitePaint.setColor(Color.parseColor((String)"#ffffff"));
        this.mBluePaint = new Paint(1);
        this.mBluePaint.setStyle(Paint.Style.FILL_AND_STROKE);
        this.mBluePaint.setColor(Color.parseColor((String)"#04a0e1"));
        this.mOrangePaint = new Paint(1);
        this.mOrangePaint.setStyle(Paint.Style.FILL_AND_STROKE);
        this.mOrangePaint.setColor(Color.parseColor((String)"#e59024"));
        this.setLayerType(1, this.mWhitePaint);
    }

    private void initRectF() {
        float left = 0.3539326f * (float)this.mWidth;
        float top = 0.47058824f * (float)this.mHeight;
        float right = 0.5730337f * (float)this.mWidth;
        float bottom = 0.6838235f * (float)this.mHeight;
        this.mRectF = new RectF(left, top, right, bottom);
        left = 0.5168539f * (float)this.mWidth;
        top = 0.3897059f * (float)this.mHeight;
        right = 0.6011236f * (float)this.mWidth;
        bottom = 0.5f * (float)this.mHeight;
        this.mLockOpenRectF = new RectF(left, top, right, bottom);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        this.setMeasuredDimension(this.mWidth, this.mHeight);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (!this.mIsImageFilesExist) {
            float left = 0.10674157f * (float)this.mWidth;
            float top = 0.0f * (float)this.mHeight;
            float right = 0.11797753f * (float)this.mWidth;
            float bottom = 0.6397059f * (float)this.mHeight;
            canvas.drawRect(left, top, right, bottom, this.mWhitePaint);
            left = 0.83707863f * (float)this.mWidth;
            top = 0.0f * (float)this.mHeight;
            right = 0.8483146f * (float)this.mWidth;
            bottom = 0.45588234f * (float)this.mHeight;
            canvas.drawRect(left, top, right, bottom, this.mWhitePaint);
            float radius = 0.30882353f * (float)this.mHeight;
            float centerX = 0.76404494f * (float)this.mWidth;
            float centerY = 0.6911765f * (float)this.mHeight;
            canvas.drawCircle(centerX, centerY, radius, this.mWhitePaint);
            radius = 0.19117647f * (float)this.mHeight;
            centerX = 0.14606741f * (float)this.mWidth;
            centerY = 0.8088235f * (float)this.mHeight;
            canvas.drawCircle(centerX, centerY, radius, this.mWhitePaint);
            radius = 0.3632353f * (float)this.mHeight;
            centerX = 0.4241573f * (float)this.mWidth;
            centerY = 0.5477941f * (float)this.mHeight;
            canvas.drawCircle(centerX, centerY, radius, this.mWhitePaint);
            left = 0.16292135f * (float)this.mWidth;
            top = 0.8014706f * (float)this.mHeight;
            right = 0.78651685f * (float)this.mWidth;
            bottom = 1.0f * (float)this.mHeight;
            canvas.drawRect(left, top, right, bottom, this.mWhitePaint);
            this.mWhitePaint.setShadowLayer(2.0f, 0.0f, 3.0f, -8618884);
            radius = 0.30882353f * (float)this.mHeight;
            centerX = 0.46067417f * (float)this.mWidth;
            centerY = 0.5294118f * (float)this.mHeight;
            int saveCount = canvas.save();
            canvas.rotate(-45.0f, centerX, centerY);
            canvas.drawCircle(centerX, centerY, radius, this.mWhitePaint);
            this.mWhitePaint.setShadowLayer(0.0f, 0.0f, 0.0f, 0);
            canvas.restoreToCount(saveCount);
            if (this.mIsLockActive) {
                radius = 0.121323526f * (float)this.mHeight;
                centerX = 0.46348315f * (float)this.mWidth;
                centerY = 0.44485295f * (float)this.mHeight;
                canvas.drawCircle(centerX, centerY, radius, this.mBluePaint);
                radius = 0.067647055f * (float)this.mHeight;
                centerX = 0.46348315f * (float)this.mWidth;
                centerY = 0.44485295f * (float)this.mHeight;
                canvas.drawCircle(centerX, centerY, radius, this.mWhitePaint);
                left = 0.41011235f * (float)this.mWidth;
                top = 0.45588234f * (float)this.mHeight;
                right = 0.51123595f * (float)this.mWidth;
                bottom = 0.5882353f * (float)this.mHeight;
                canvas.drawRect(left, top, right, bottom, this.mWhitePaint);
            } else {
                radius = 0.121323526f * (float)this.mHeight;
                centerX = 0.46348315f * (float)this.mWidth;
                centerY = 0.44485295f * (float)this.mHeight;
                canvas.drawCircle(centerX, centerY, radius, this.mOrangePaint);
                radius = 0.067647055f * (float)this.mHeight;
                centerX = 0.46348315f * (float)this.mWidth;
                centerY = 0.44485295f * (float)this.mHeight;
                canvas.drawCircle(centerX, centerY, radius, this.mWhitePaint);
                left = 0.41011235f * (float)this.mWidth;
                top = 0.45588234f * (float)this.mHeight;
                right = 0.51123595f * (float)this.mWidth;
                bottom = 0.5882353f * (float)this.mHeight;
                canvas.drawRect(left, top, right, bottom, this.mWhitePaint);
                centerX = 0.55898875f * (float)this.mWidth;
                centerY = 0.44485295f * (float)this.mHeight;
                saveCount = canvas.save();
                canvas.rotate(-45.0f, centerX, centerY);
                canvas.drawRect(this.mLockOpenRectF, this.mWhitePaint);
                canvas.restoreToCount(saveCount);
            }
            radius = 0.02247191f * (float)this.mWidth;
            canvas.drawRoundRect(this.mRectF, radius, radius, this.mBluePaint);
            radius = 0.033088237f * (float)this.mHeight;
            centerX = 0.46348315f * (float)this.mWidth;
            centerY = 0.55514705f * (float)this.mHeight;
            canvas.drawCircle(centerX, centerY, radius, this.mWhitePaint);
            left = 0.4550562f * (float)this.mWidth;
            top = 0.5735294f * (float)this.mHeight;
            right = 0.47191012f * (float)this.mWidth;
            bottom = 0.6397059f * (float)this.mHeight;
            canvas.drawRect(left, top, right, bottom, this.mWhitePaint);
        } else {
            this.loadImage();
        }
    }

    public void setIsLockActive(boolean isLockActive) {
        this.mIsLockStateChanged = true;
        this.mIsLockActive = isLockActive;
        this.invalidate();
    }

    public static interface ParentalLockButtonListener {
        public void onClickStarted();

        public void onClickEnd();
    }
}

