/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.api.ui_views;

import android.animation.Animator;
import android.content.Context;
import android.graphics.Point;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import com.kidoz.sdk.api.general.EventMessage;
import com.kidoz.sdk.api.general.animations.GenAnimator;
import com.kidoz.sdk.api.general.enums.WidgetType;
import com.kidoz.sdk.api.general.utils.Utils;
import com.kidoz.sdk.api.ui_views.custom_drawables.VideoUnitDrawable;
import com.kidoz.sdk.api.ui_views.parental_lock.AssetView;
import java.io.File;
import org.greenrobot.eventbus.EventBus;
import org.greenrobot.eventbus.Subscribe;

public class KidozButton
extends RelativeLayout {
    public static final String TAG = KidozButton.class.getSimpleName();
    private final float BUTTON_SIZE_RATIO = 0.2f;
    private AssetView mAssetView;
    private KidozButtonListener mKidozButtonListener;
    private WidgetType mWidgetType;
    private boolean mIsButtonReady;
    private boolean mIsAlreadySentButtonReady;

    public KidozButton(Context context) {
        super(context);
        this.initView();
    }

    public KidozButton(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView();
    }

    public KidozButton(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initView();
    }

    public void setKidozButtonListener(KidozButtonListener kidozButtonListener) {
        this.mKidozButtonListener = kidozButtonListener;
        if (this.mKidozButtonListener != null && !this.mIsAlreadySentButtonReady && this.mIsButtonReady) {
            this.mIsAlreadySentButtonReady = true;
            this.mKidozButtonListener.onButtonReady();
        }
    }

    public void setWidgetType(WidgetType widgetType) {
        this.mWidgetType = widgetType;
        this.loadAssetView();
    }

    private void initView() {
        this.setVisibility(4);
        Point point = Utils.getScreenSize(this.getContext());
        int size = (int)((float)Math.min(point.x, point.y) * 0.2f);
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(size, size);
        this.initRootView(params);
        this.initAssetView(params);
        this.loadAssetView();
    }

    private void initRootView(RelativeLayout.LayoutParams params) {
        this.setLayoutParams((ViewGroup.LayoutParams)params);
        this.setOnClickListener(new View.OnClickListener(){

            public void onClick(final View view) {
                view.setClickable(false);
                GenAnimator.clickItemAnimation((View)KidozButton.this, 70, new GenAnimator.ViewAnimationListener(){

                    @Override
                    public void onAnimationEnd() {
                        view.setClickable(true);
                        KidozButton.this.mKidozButtonListener.onClick();
                    }

                    @Override
                    public void onAnimationStart() {
                    }
                });
            }
        });
    }

    private void initAssetView(RelativeLayout.LayoutParams params) {
        this.mAssetView = new AssetView(this.getContext());
        this.mAssetView.setScaleType(ImageView.ScaleType.FIT_CENTER);
        this.addView((View)this.mAssetView, (ViewGroup.LayoutParams)params);
    }

    private void loadAssetView() {
        this.setVisibility(4);
        File assetFile = null;
        if (this.mWidgetType != null) {
            switch (this.mWidgetType) {
                default: 
            }
        }
        if (assetFile != null) {
            this.mAssetView.loadAsset(assetFile, new VideoUnitDrawable(), new AssetView.IOnAssetLoadedListener(){

                @Override
                public void onAssetLoaded(boolean successful) {
                    GenAnimator.playGrowAnimation((View)KidozButton.this, 350L, 0L, null, new Animator.AnimatorListener(){

                        public void onAnimationStart(Animator animation) {
                            KidozButton.this.setVisibility(0);
                            KidozButton.this.requestFocus();
                            KidozButton.this.bringToFront();
                        }

                        public void onAnimationEnd(Animator animation) {
                            KidozButton.this.requestFocus();
                            KidozButton.this.bringToFront();
                            KidozButton.this.mIsButtonReady = true;
                            if (KidozButton.this.mKidozButtonListener != null && !KidozButton.this.mIsAlreadySentButtonReady) {
                                KidozButton.this.mIsAlreadySentButtonReady = true;
                                KidozButton.this.mKidozButtonListener.onButtonReady();
                            }
                        }

                        public void onAnimationCancel(Animator animation) {
                        }

                        public void onAnimationRepeat(Animator animation) {
                        }
                    });
                }
            });
        } else if (!EventBus.getDefault().isRegistered((Object)this)) {
            EventBus.getDefault().register((Object)this);
        }
    }

    @Subscribe
    public void onHandleEvent(EventMessage event) {
        if (event.getMessageType() == EventMessage.MessageType.VIDEO_UNIT_BUTTON_READY) {
            this.loadAssetView();
            if (EventBus.getDefault().isRegistered((Object)this)) {
                EventBus.getDefault().unregister((Object)this);
            }
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (EventBus.getDefault().isRegistered((Object)this)) {
            EventBus.getDefault().unregister((Object)this);
        }
    }

    public static interface KidozButtonListener {
        public void onClick();

        public void onButtonReady();
    }
}

