/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.api.server_connect;

import android.annotation.SuppressLint;
import android.content.ContentValues;
import android.content.Context;
import android.net.Uri;
import com.kidoz.sdk.api.general.utils.SDKLogger;
import com.kidoz.sdk.api.server_connect.StreamToStringConverter;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.CookieHandler;
import java.net.CookieManager;
import java.net.CookiePolicy;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Iterator;
import java.util.Set;

@SuppressLint(value={"NewApi"})
public class BaseConnectionClient {
    protected static String mPublicherId = null;
    protected static String mSecurityToken = null;
    protected static final String HTTP_SCHEME = "https://";
    protected static String DOMAIN = "sdk.kidoz.net";
    protected static final String MAIN_API = "/api/sdk";
    protected static final String KIDOZ_ANALITYCS_SERVER_URL = "analytics.kidoz.net/parents/KidozRestMobile.php";
    protected static final String SDK_API_URL = "sdk-api.kidoz.net/api/";
    protected static String WATERFALL_URL = "/api/waterfall";
    protected static String WATERFALL_DOMAIN = null;
    protected static final String TAG = BaseConnectionClient.class.getSimpleName();

    public static void updateDomain(String domain) {
        if (domain != null && !domain.equals("")) {
            DOMAIN = domain;
        }
    }

    public static void updateWaterfallDomain(String domain) {
        if (domain != null && !domain.equals("")) {
            WATERFALL_DOMAIN = domain;
        }
    }

    protected static void initConnectionClient(Context context) {
        BaseConnectionClient.initCookieManager();
    }

    private static void initCookieManager() {
        CookieManager cookieManager = new CookieManager();
        cookieManager.setCookiePolicy(CookiePolicy.ACCEPT_ALL);
        CookieHandler.setDefault(cookieManager);
    }

    public static String makePostConnection(String url, ContentValues contentValues) {
        String response = null;
        if (url.startsWith("http://")) {
            return response;
        }
        try {
            URL mUrl = new URL(url);
            HttpURLConnection httpConnection = (HttpURLConnection)mUrl.openConnection();
            httpConnection.setRequestMethod("POST");
            httpConnection.setChunkedStreamingMode(0);
            httpConnection.setUseCaches(false);
            httpConnection.setAllowUserInteraction(false);
            httpConnection.setConnectTimeout(10000);
            httpConnection.setReadTimeout(10000);
            httpConnection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            httpConnection.setDoInput(true);
            httpConnection.setDoOutput(true);
            BufferedOutputStream os = new BufferedOutputStream(httpConnection.getOutputStream());
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)os, "UTF-8"));
            writer.write(BaseConnectionClient.getPostDataString(contentValues));
            writer.flush();
            writer.close();
            os.close();
            httpConnection.connect();
            int responseCode = httpConnection.getResponseCode();
            if (responseCode == 200) {
                response = StreamToStringConverter.readStream(new BufferedInputStream(httpConnection.getInputStream()), null, false);
            }
            httpConnection.disconnect();
        }
        catch (IOException e) {
            SDKLogger.printErrorLog(" \n IO Exception POST request! \n" + e.getMessage());
        }
        return response;
    }

    private static String getPostDataString(ContentValues contentValues) throws UnsupportedEncodingException {
        StringBuilder result = new StringBuilder();
        boolean first = true;
        Set set = contentValues.keySet();
        for (String val : set) {
            if (first) {
                first = false;
            } else {
                result.append("&");
            }
            result.append(val);
            result.append("=");
            result.append(contentValues.getAsString(val));
        }
        return result.toString();
    }

    public static String makeGetConnection(String url, ContentValues contentValues) {
        String response = null;
        if (url.startsWith("http://")) {
            return response;
        }
        StringBuilder sb = new StringBuilder(url);
        if (contentValues != null && contentValues.size() > 0) {
            String val;
            sb.append("?");
            Set set = contentValues.keySet();
            Iterator iter = set.iterator();
            if (iter.hasNext()) {
                val = (String)iter.next();
                sb.append(val).append("=").append(Uri.encode((String)contentValues.getAsString(val)));
            }
            while (iter.hasNext()) {
                val = (String)iter.next();
                sb.append("&");
                sb.append(val).append("=").append(Uri.encode((String)contentValues.getAsString(val)));
            }
        }
        try {
            URL mUrl = new URL(sb.toString());
            HttpURLConnection httpConnection = (HttpURLConnection)mUrl.openConnection();
            httpConnection.setRequestMethod("GET");
            httpConnection.setRequestProperty("Content-length", "0");
            httpConnection.setChunkedStreamingMode(0);
            httpConnection.setUseCaches(false);
            httpConnection.setAllowUserInteraction(false);
            httpConnection.setConnectTimeout(10000);
            httpConnection.setReadTimeout(10000);
            httpConnection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            httpConnection.setRequestProperty("Access-Key", mPublicherId + "::" + mSecurityToken);
            httpConnection.connect();
            int responseCode = httpConnection.getResponseCode();
            if (responseCode == 200) {
                response = StreamToStringConverter.readStream(new BufferedInputStream(httpConnection.getInputStream()), null, false);
            }
            httpConnection.disconnect();
        }
        catch (IOException e) {
            SDKLogger.printErrorLog(" \n IO Exception GET request! \n" + e.getMessage());
        }
        return response;
    }

    public static boolean downloadAndSaveFile(String fileURL, File destinationFile) {
        boolean result = false;
        try {
            if (fileURL != null && fileURL.startsWith("http://")) {
                return result;
            }
            SDKLogger.printDebugLog(TAG, "Downloading file url: " + fileURL);
            URL mUrl = new URL(fileURL);
            HttpURLConnection httpConnection = (HttpURLConnection)mUrl.openConnection();
            httpConnection.setRequestMethod("GET");
            httpConnection.setRequestProperty("Content-length", "0");
            httpConnection.setChunkedStreamingMode(0);
            httpConnection.setUseCaches(false);
            httpConnection.setAllowUserInteraction(false);
            httpConnection.setConnectTimeout(10000);
            httpConnection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            httpConnection.setRequestProperty("Access-Key", mPublicherId + "::" + mSecurityToken);
            httpConnection.setReadTimeout(10000);
            httpConnection.connect();
            int responseCode = httpConnection.getResponseCode();
            if (responseCode == 200) {
                int len;
                BufferedInputStream bufferedInputStream = new BufferedInputStream(httpConnection.getInputStream());
                FileOutputStream outputStream = new FileOutputStream(destinationFile);
                byte[] buf = new byte[1024];
                while ((len = bufferedInputStream.read(buf)) > 0) {
                    outputStream.write(buf, 0, len);
                }
                outputStream.close();
                bufferedInputStream.close();
                result = true;
            }
            httpConnection.disconnect();
        }
        catch (Exception ex) {
            SDKLogger.printDebugLog(TAG, "Error when trying download file: " + ex.getMessage());
        }
        return result;
    }

    public static void makeAsyncGet(final String url, final ContentValues contentValues) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                BaseConnectionClient.makeGetConnection(url, contentValues);
            }
        }).start();
    }

    public static interface IOnImageRequestCallback {
        public void onImageRecieved(InputStream var1) throws IOException;
    }

    protected static enum CONNECTION_TYPE {
        POST,
        GET;

    }
}

