/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.api.receivers;

import android.app.Activity;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Build;
import com.kidoz.events.EventManager;
import com.kidoz.sdk.api.general.database.DatabaseManager;
import com.kidoz.sdk.api.general.utils.ConstantDef;
import com.kidoz.sdk.api.general.utils.PropertiesObj;
import com.kidoz.sdk.api.general.utils.SDKLogger;
import com.kidoz.sdk.api.structure.IsEventRecord;

public class SdkReceiver
extends BroadcastReceiver {
    private final String TAG = SdkReceiver.class.getSimpleName();
    public boolean isRegistered;

    public void onReceive(final Context context, final Intent intent) {
        final BroadcastReceiver.PendingResult result = this.goAsync();
        Thread thread = new Thread(){

            @Override
            public void run() {
                try {
                    String packageName;
                    String action;
                    if (intent != null && (action = intent.getAction()) != null && action.equalsIgnoreCase("android.intent.action.PACKAGE_ADDED") && intent.getData() != null && (packageName = intent.getData().getSchemeSpecificPart()) != null) {
                        if (context != null && context instanceof Activity) {
                            if (Build.VERSION.SDK_INT >= 17 && ((Activity)context).isDestroyed()) {
                                return;
                            }
                            if (((Activity)context).isFinishing()) {
                                return;
                            }
                        }
                        SDKLogger.printWarningLog("--------------------+++++++  INSTALL RECEIVER LAUNCHED ++++++ ------------------");
                        SdkReceiver.this.updateInstallEvent(context, packageName);
                    }
                }
                catch (Exception exception) {
                }
                finally {
                    result.finish();
                }
            }
        };
        thread.start();
    }

    public IntentFilter getIntentFilter() {
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("android.intent.action.PACKAGE_ADDED");
        intentFilter.addDataScheme("package");
        return intentFilter;
    }

    public void unRegister(Context context) {
        try {
            if (this.isRegistered) {
                context.unregisterReceiver((BroadcastReceiver)this);
            }
        }
        finally {
            this.isRegistered = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Intent register(Context context, IntentFilter filter) {
        try {
            Intent intent = !this.isRegistered ? context.registerReceiver((BroadcastReceiver)this, filter) : null;
            return intent;
        }
        finally {
            this.isRegistered = true;
        }
    }

    private void updateInstallEvent(Context context, String packageName) {
        IsEventRecord record;
        DatabaseManager databaseManager;
        int MAX_ACCEPTABLE_INSTALL_INTERVAL = 86400000;
        PropertiesObj appConfig = DatabaseManager.getInstance(context).getConfigTable().loadAppProperties();
        if (appConfig != null) {
            MAX_ACCEPTABLE_INSTALL_INTERVAL = appConfig.getGPSMaxTimeToWaitForInstall() * 60 * 1000;
        }
        if ((databaseManager = DatabaseManager.getInstance(context)) != null && (record = databaseManager.getIsEventTable().getRecord(packageName)) != null) {
            long setTime = -1L;
            try {
                setTime = Long.parseLong(record.getTimeStamp());
            }
            catch (NumberFormatException e) {
                setTime = -1L;
            }
            if (setTime != -1L && System.currentTimeMillis() - setTime < (long)MAX_ACCEPTABLE_INSTALL_INTERVAL) {
                EventManager.getInstance(context).logSponsoredContentInstallEvent(context, record.getWidgetType(), record.getStyleId(), record.getPackageName(), record.getAdvertiserId(), record.getPackageName(), record.getPositionIndex());
                if (ConstantDef.DGM) {
                    SDKLogger.printWarningLog("!!!!!!!! SEND ANALYTICS EVENT OF APPLICATION INSTALLED !!!!!!!");
                    SDKLogger.printWarningLog("\ngetPackageName : " + record.getPackageName());
                    SDKLogger.printWarningLog("\ngetTimeStamp : " + record.getTimeStamp());
                    SDKLogger.printWarningLog("\ngetItemType : " + record.getContentType());
                    SDKLogger.printWarningLog("\ngetLocationInFeed : " + record.getPositionIndex());
                    SDKLogger.printWarningLog("\ngetApppName : " + record.getName());
                    SDKLogger.printWarningLog("\ngetAdvertiser ID : " + record.getAdvertiserId());
                    SDKLogger.printWarningLog("\ngetWidgetType : " + record.getWidgetType());
                    SDKLogger.printWarningLog("\ngetStyleId : " + record.getStyleId());
                }
            }
            databaseManager.getIsEventTable().deleteRecord(packageName);
        }
    }
}

