/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.api.general.utils;

import android.content.Context;
import android.content.SharedPreferences;
import com.kidoz.sdk.api.general.utils.EncoderUtils;
import com.kidoz.sdk.api.general.utils.SDKLogger;
import com.kidoz.sdk.api.general.utils.StorageLife;

public class SdkCookieManager {
    private static final String APP_STORAGE = "app";
    private static final String SESSION_STORAGE = "session";
    private static final String WIDGET_STORAGE = "widget";
    public static final String TAG = SdkCookieManager.class.getSimpleName();
    private static SdkCookieManager instance = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SdkCookieManager getInstance() {
        if (instance == null) {
            Class<SdkCookieManager> clazz = SdkCookieManager.class;
            synchronized (SdkCookieManager.class) {
                if (instance == null) {
                    instance = new SdkCookieManager();
                }
                // ** MonitorExit[var0] (shouldn't be in output)
                return instance;
            }
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveData(Context context, String widgetType, String site, String key, String value, StorageLife lifeTime) {
        Class<SdkCookieManager> clazz = SdkCookieManager.class;
        synchronized (SdkCookieManager.class) {
            try {
                String hash = EncoderUtils.SHA1(site + key);
                String prefernce = SdkCookieManager.getSharedPreferenceName(widgetType, lifeTime);
                SharedPreferences sharedpreferences = context.getSharedPreferences(prefernce, 0);
                SharedPreferences.Editor editor = sharedpreferences.edit();
                editor.putString(hash, value);
                editor.apply();
            }
            catch (Exception ex) {
                SDKLogger.printErrorLog(TAG, "Error when trying to save data to cookie \n" + ex.getMessage());
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String loadData(Context context, String widgetType, String site, String key) {
        Class<SdkCookieManager> clazz = SdkCookieManager.class;
        synchronized (SdkCookieManager.class) {
            try {
                String hash = EncoderUtils.SHA1(site + key);
                String preference = SdkCookieManager.getSharedPreferenceName(widgetType, StorageLife.WIDGET);
                SharedPreferences sharedpreferences = context.getSharedPreferences(preference, 0);
                String value = sharedpreferences.getString(hash, null);
                if (value == null && (value = (sharedpreferences = context.getSharedPreferences(preference = SdkCookieManager.getSharedPreferenceName(widgetType, StorageLife.SESSION), 0)).getString(hash, null)) == null) {
                    preference = SdkCookieManager.getSharedPreferenceName(widgetType, StorageLife.APP);
                    sharedpreferences = context.getSharedPreferences(preference, 0);
                    value = sharedpreferences.getString(hash, null);
                }
                // ** MonitorExit[var4_4] (shouldn't be in output)
                return value;
            }
            catch (Exception ex) {
                SDKLogger.printErrorLog(TAG, "Error when trying to load data to cookie \n" + ex.getMessage());
                // ** MonitorExit[var4_4] (shouldn't be in output)
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void resetStorage(Context context, String widgetType, StorageLife lifeTime) {
        Class<SdkCookieManager> clazz = SdkCookieManager.class;
        synchronized (SdkCookieManager.class) {
            try {
                String prefernce = SdkCookieManager.getSharedPreferenceName(widgetType, lifeTime);
                SharedPreferences sharedpreferences = context.getSharedPreferences(prefernce, 0);
                SharedPreferences.Editor editor = sharedpreferences.edit();
                editor.clear();
                editor.apply();
            }
            catch (Exception ex) {
                SDKLogger.printErrorLog(TAG, "Error when trying to reset  cookie \n" + ex.getMessage());
            }
            return;
        }
    }

    private static String getSharedPreferenceName(String widgetType, StorageLife lifeTime) {
        String fileName = null;
        switch (lifeTime) {
            case APP: {
                fileName = APP_STORAGE;
                break;
            }
            case SESSION: {
                fileName = SESSION_STORAGE;
                break;
            }
            case WIDGET: {
                fileName = widgetType + WIDGET_STORAGE;
            }
        }
        return fileName;
    }
}

