/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.api.general.utils;

import android.text.TextUtils;
import com.kidoz.sdk.api.general.utils.SDKLogger;

public class KidozUrl {
    private static final String TAG = "KidozUrl";
    private static final String EMPTY_BASE_URL_WARNING = "baseUrl is empty, should probably not be the case.";
    private static final String PUBLISHER_ID_FORMAT = "&publisher_id=%s";
    private static final String AUTH_TOKEN_FORMAT = "&auth_token=%s";
    private static final String PACKAGE_ID_FORMAT = "&package_id=%s";
    private static final String SDK_VERSION_FORMAT = "&sdk_version=%s";
    private static final String ACTUAL_SDK_VERSION_FORMAT = "&actual_sdk_version=%s";
    private static final String OS_VERSION_FORMAT = "&os_version=%s";
    private static final String OS_TYPE_FORMAT = "&os_type=%s";
    private static final String EXTENSION_TYPE_FORMAT = "&extension_type=%s";
    private static final String APP_VERSION_CODE_FORMAT = "&app_version_code=%s";
    private static final String APP_VERSION_NAME_FORMAT = "&app_version_name=%s";
    private static final String DEVICE_TYPE_FORMAT = "&device_type=%s";
    private static final String DEVICE_LANG_FORMAT = "&device_lang=%s";
    private static final String WEBVIEW_VERSION_FORMAT = "&webview_version=%s";
    private static final String DEVICE_HASH_FORMAT = "&device_hash=%s";
    private static final String GID_FORMAT = "&gid=%s";
    private static final String RESOLUTION_HEIGHT_FORMAT = "&resolution_height=%s";
    private static final String RESOLUTION_WIDTH_FORMAT = "&resolution_width=%s";
    private static final String SCREEN_SIZE_FORMAT = "&screen_size=%s";
    private static final String DPI_FORMAT = "&dpi=%s";
    private static final String SCREEN_CATEGORY_FORMAT = "&screen_category=%s";
    private static final String MANUFACTURER_FORMAT = "&manufacturer=%s";
    private static final String MODEL_FORMAT = "&model=%s";
    private static final String WIFI_MODE_FORMAT = "&wifi_mode=%s";
    private static final String CARRIER_NAME_FORMAT = "&carrier_name=%s";
    private static final String NETWORK_TYPE_FORMAT = "&network_type=%s";
    private static final String WIDGET_TYPE_FORMAT = "&widget_type=%s";
    private static final String OOO_CACHE_BUSTER_FORMAT = "&cb=%s";
    private static final String STYLE_ID_FORMAT = "&style_id=%s";
    private static final String APP_SESSION_ID_FORMAT = "&appSessionID=%s";
    private String mBaseUrl;
    private String mPublisherId;
    private String mAuthToken;
    private String mPackageId;
    private String mSdkVersion;
    private String mActualSdkVersion;
    private String mOsVersion;
    private String mOsType;
    private String mExtensionType;
    private String mAppVersionCode;
    private String mAppVersionName;
    private String mDeviceType;
    private String mDeviceLang;
    private String mWebviewVersion;
    private String mDeviceHash;
    private String mGid;
    private String mResolutionHeight;
    private String mResolutionWidth;
    private String mScreenSize;
    private String mDpi;
    private String mScreenCategory;
    private String mManufacturer;
    private String mModel;
    private String mWifiMode;
    private String mCarrierName;
    private String mNetworkType;
    private String mFinalUrlString;
    private String mWidgetType;
    private String mCachBuster;
    private String mStyleId;
    private String mAppSessionId;

    private KidozUrl(Builder builder) {
        this.mBaseUrl = builder.mBaseUrl;
        this.mPublisherId = builder.mPublisherId;
        this.mAuthToken = builder.mAuthToken;
        this.mPackageId = builder.mPackageId;
        this.mSdkVersion = builder.mSdkVersion;
        this.mActualSdkVersion = builder.mActualSdkVersion;
        this.mOsVersion = builder.mOsVersion;
        this.mOsType = builder.mOsType;
        this.mExtensionType = builder.mExtensionType;
        this.mAppVersionCode = builder.mAppVersionCode;
        this.mAppVersionName = builder.mAppVersionName;
        this.mDeviceType = builder.mDeviceType;
        this.mDeviceLang = builder.mDeviceLang;
        this.mWebviewVersion = builder.mWebviewVersion;
        this.mDeviceHash = builder.mDeviceHash;
        this.mGid = builder.mGid;
        this.mResolutionHeight = builder.mResolutionHeight;
        this.mResolutionWidth = builder.mResolutionWidth;
        this.mScreenSize = builder.mScreenSize;
        this.mDpi = builder.mDpi;
        this.mScreenCategory = builder.mScreenCategory;
        this.mManufacturer = builder.mManufacturer;
        this.mModel = builder.mModel;
        this.mWifiMode = builder.mWifiMode;
        this.mCarrierName = builder.mCarrierName;
        this.mNetworkType = builder.mNetworkType;
        this.mWidgetType = builder.mWidgetType;
        this.mCachBuster = builder.mCachBuster;
        this.mStyleId = builder.mStyleId;
        this.mAppSessionId = builder.mAppSessionId;
        this.buildFinalUrlString();
    }

    private void buildFinalUrlString() {
        StringBuilder stringBuilder = new StringBuilder(this.mBaseUrl);
        stringBuilder.append(this.getFormat(PUBLISHER_ID_FORMAT, this.mPublisherId));
        stringBuilder.append(this.getFormat(AUTH_TOKEN_FORMAT, this.mAuthToken));
        stringBuilder.append(this.getFormat(PACKAGE_ID_FORMAT, this.mPackageId));
        stringBuilder.append(this.getFormat(SDK_VERSION_FORMAT, this.mSdkVersion));
        stringBuilder.append(this.getFormat(ACTUAL_SDK_VERSION_FORMAT, this.mActualSdkVersion));
        stringBuilder.append(this.getFormat(OS_VERSION_FORMAT, this.mOsVersion));
        stringBuilder.append(this.getFormat(OS_TYPE_FORMAT, this.mOsType));
        stringBuilder.append(this.getFormat(EXTENSION_TYPE_FORMAT, this.mExtensionType));
        stringBuilder.append(this.getFormat(APP_VERSION_CODE_FORMAT, this.mAppVersionCode));
        stringBuilder.append(this.getFormat(APP_VERSION_NAME_FORMAT, this.mAppVersionName));
        stringBuilder.append(this.getFormat(DEVICE_TYPE_FORMAT, this.mDeviceType));
        stringBuilder.append(this.getFormat(DEVICE_LANG_FORMAT, this.mDeviceLang));
        stringBuilder.append(this.getFormat(WEBVIEW_VERSION_FORMAT, this.mWebviewVersion));
        stringBuilder.append(this.getFormat(DEVICE_HASH_FORMAT, this.mDeviceHash));
        stringBuilder.append(this.getFormat(GID_FORMAT, this.mGid));
        stringBuilder.append(this.getFormat(RESOLUTION_HEIGHT_FORMAT, this.mResolutionHeight));
        stringBuilder.append(this.getFormat(RESOLUTION_WIDTH_FORMAT, this.mResolutionWidth));
        stringBuilder.append(this.getFormat(SCREEN_SIZE_FORMAT, this.mScreenSize));
        stringBuilder.append(this.getFormat(DPI_FORMAT, this.mDpi));
        stringBuilder.append(this.getFormat(SCREEN_CATEGORY_FORMAT, this.mScreenCategory));
        stringBuilder.append(this.getFormat(MANUFACTURER_FORMAT, this.mManufacturer));
        stringBuilder.append(this.getFormat(MODEL_FORMAT, this.mModel));
        stringBuilder.append(this.getFormat(WIFI_MODE_FORMAT, this.mWifiMode));
        stringBuilder.append(this.getFormat(CARRIER_NAME_FORMAT, this.mCarrierName));
        stringBuilder.append(this.getFormat(NETWORK_TYPE_FORMAT, this.mNetworkType));
        stringBuilder.append(this.getFormat(WIDGET_TYPE_FORMAT, this.mWidgetType));
        stringBuilder.append(this.getFormat(OOO_CACHE_BUSTER_FORMAT, this.mCachBuster));
        stringBuilder.append(this.getFormat(STYLE_ID_FORMAT, this.mStyleId));
        stringBuilder.append(this.getFormat(APP_SESSION_ID_FORMAT, this.mAppSessionId));
        this.mFinalUrlString = stringBuilder.toString();
    }

    private String getFormat(String formatBase, String value) {
        if (TextUtils.isEmpty((CharSequence)formatBase) || TextUtils.isEmpty((CharSequence)value)) {
            return "";
        }
        return String.format(formatBase, value);
    }

    public String toString() {
        return this.mFinalUrlString;
    }

    public static class Builder {
        private String mBaseUrl;
        private String mPublisherId;
        private String mAuthToken;
        private String mPackageId;
        private String mSdkVersion;
        private String mActualSdkVersion;
        private String mOsVersion;
        private String mOsType;
        private String mExtensionType;
        private String mAppVersionCode;
        private String mAppVersionName;
        private String mDeviceType;
        private String mDeviceLang;
        private String mWebviewVersion;
        private String mDeviceHash;
        private String mGid;
        private String mResolutionHeight;
        private String mResolutionWidth;
        private String mScreenSize;
        private String mDpi;
        private String mScreenCategory;
        private String mManufacturer;
        private String mModel;
        private String mWifiMode;
        private String mCarrierName;
        private String mNetworkType;
        private String mWidgetType;
        private String mCachBuster;
        private String mStyleId;
        private String mAppSessionId;

        public Builder(String baseUrl) {
            if (TextUtils.isEmpty((CharSequence)baseUrl)) {
                this.mBaseUrl = "";
                SDKLogger.printWarningLog(KidozUrl.TAG, KidozUrl.EMPTY_BASE_URL_WARNING);
                return;
            }
            this.mBaseUrl = baseUrl;
        }

        public Builder setPublisherId(String publisherId) {
            this.mPublisherId = publisherId;
            return this;
        }

        public Builder setAuthToken(String authToken) {
            this.mAuthToken = authToken;
            return this;
        }

        public Builder setPackageId(String packageId) {
            this.mPackageId = packageId;
            return this;
        }

        public Builder setSdkVersion(String sdkVersion) {
            this.mSdkVersion = sdkVersion;
            return this;
        }

        public Builder setActualSdkVersion(String actualSdkVersion) {
            this.mActualSdkVersion = actualSdkVersion;
            return this;
        }

        public Builder setOsVersion(int osVersion) {
            this.mOsVersion = String.valueOf(osVersion);
            return this;
        }

        public Builder setOsType(String osType) {
            this.mOsType = osType;
            return this;
        }

        public Builder setExtensionType(int extensionType) {
            this.mExtensionType = String.valueOf(extensionType);
            return this;
        }

        public Builder setAppVersionCode(String appVersionCode) {
            this.mAppVersionCode = appVersionCode;
            return this;
        }

        public Builder setAppVersionName(String appVersionName) {
            this.mAppVersionName = appVersionName;
            return this;
        }

        public Builder setDeviceType(String deviceType) {
            this.mDeviceType = deviceType;
            return this;
        }

        public Builder setDeviceLang(String deviceLang) {
            this.mDeviceLang = deviceLang;
            return this;
        }

        public Builder setWebviewVersion(String webviewVersion) {
            this.mWebviewVersion = webviewVersion;
            return this;
        }

        public Builder setDeviceHash(String deviceHash) {
            this.mDeviceHash = deviceHash;
            return this;
        }

        public Builder setGid(String gid) {
            this.mGid = gid;
            return this;
        }

        public Builder setResolutionHeight(int resolutionHeight) {
            this.mResolutionHeight = String.valueOf(resolutionHeight);
            return this;
        }

        public Builder setResolutionWidth(int resolutionWidth) {
            this.mResolutionWidth = String.valueOf(resolutionWidth);
            return this;
        }

        public Builder setScreenSize(double screenSize) {
            this.mScreenSize = String.valueOf(screenSize);
            return this;
        }

        public Builder setDpi(float dpi) {
            this.mDpi = String.valueOf(dpi);
            return this;
        }

        public Builder setScreenCategory(int screenCategory) {
            this.mScreenCategory = String.valueOf(screenCategory);
            return this;
        }

        public Builder setManufacturer(String manufacturer) {
            this.mManufacturer = manufacturer;
            return this;
        }

        public Builder setModel(String model) {
            this.mModel = model;
            return this;
        }

        public Builder setWifiMode(String wifiMode) {
            this.mWifiMode = wifiMode;
            return this;
        }

        public Builder setCarrierName(String carrierName) {
            this.mCarrierName = carrierName;
            return this;
        }

        public Builder setNetworkType(String networkType) {
            this.mNetworkType = networkType;
            return this;
        }

        public Builder setWidgetType(String widgetType) {
            this.mWidgetType = widgetType;
            return this;
        }

        public Builder setCacheBuster(String cacheBuster) {
            this.mCachBuster = cacheBuster;
            return this;
        }

        public Builder setStyleId(int styleId) {
            this.mStyleId = String.valueOf(styleId);
            return this;
        }

        public Builder setAppSessionId(long appSessionId) {
            this.mAppSessionId = String.valueOf(appSessionId);
            return this;
        }

        public KidozUrl build() {
            return new KidozUrl(this);
        }
    }
}

