/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.api.general;

import android.app.ActivityManager;
import android.content.ComponentName;
import android.graphics.Rect;
import android.os.Build;
import android.view.View;
import android.view.ViewTreeObserver;
import com.kidoz.sdk.api.general.IViewVisibilityEventListener;
import java.util.List;

public class ViewVisibilityEventListener {
    private View mView;
    private ViewTreeObserver mViewTreeObserver;
    private IViewVisibilityEventListener mIViewVisibilityEventListener;
    private ViewTreeObserver.OnWindowAttachListener mOnWindowAttachListener;
    private ViewTreeObserver.OnWindowFocusChangeListener mOnWindowFocusChangeListener;
    private ViewState mViewState = ViewState.UNKNOWN;

    private void initOnWindowAttachListener(ViewTreeObserver viewTreeObserver) {
        if (Build.VERSION.SDK_INT >= 18) {
            this.mOnWindowAttachListener = null;
            this.mOnWindowAttachListener = new ViewTreeObserver.OnWindowAttachListener(){

                public void onWindowAttached() {
                    if (ViewVisibilityEventListener.this.mViewState == ViewState.UNKNOWN || ViewVisibilityEventListener.this.mViewState == ViewState.NOT_VISIBLE) {
                        ViewVisibilityEventListener.this.mViewState = ViewState.VISIBLE;
                        if (ViewVisibilityEventListener.this.mIViewVisibilityEventListener != null) {
                            ViewVisibilityEventListener.this.mIViewVisibilityEventListener.onViewBecameVisible(true);
                        }
                    }
                }

                public void onWindowDetached() {
                    if (ViewVisibilityEventListener.this.mViewState == ViewState.UNKNOWN || ViewVisibilityEventListener.this.mViewState == ViewState.VISIBLE) {
                        ViewVisibilityEventListener.this.mViewState = ViewState.NOT_VISIBLE;
                        if (ViewVisibilityEventListener.this.mIViewVisibilityEventListener != null) {
                            ViewVisibilityEventListener.this.mIViewVisibilityEventListener.onViewBecameVisible(false);
                        }
                    }
                }
            };
            viewTreeObserver.addOnWindowAttachListener(this.mOnWindowAttachListener);
        }
    }

    private void initOnWindowFocusChangeListener(ViewTreeObserver viewTreeObserver) {
        if (Build.VERSION.SDK_INT >= 18) {
            this.mOnWindowFocusChangeListener = null;
            this.mOnWindowFocusChangeListener = new ViewTreeObserver.OnWindowFocusChangeListener(){

                public void onWindowFocusChanged(boolean hasFocus) {
                    if (!hasFocus) {
                        if (ViewVisibilityEventListener.this.mViewState == ViewState.UNKNOWN || ViewVisibilityEventListener.this.mViewState == ViewState.VISIBLE) {
                            ViewVisibilityEventListener.this.mViewState = ViewState.NOT_VISIBLE;
                            if (ViewVisibilityEventListener.this.mIViewVisibilityEventListener != null) {
                                ViewVisibilityEventListener.this.mIViewVisibilityEventListener.onViewBecameVisible(false);
                            }
                        }
                    } else if (ViewVisibilityEventListener.this.mViewState == ViewState.UNKNOWN || ViewVisibilityEventListener.this.mViewState == ViewState.NOT_VISIBLE) {
                        ViewVisibilityEventListener.this.mViewState = ViewState.VISIBLE;
                        if (ViewVisibilityEventListener.this.mIViewVisibilityEventListener != null) {
                            ViewVisibilityEventListener.this.mIViewVisibilityEventListener.onViewBecameVisible(true);
                        }
                    }
                }
            };
            viewTreeObserver.addOnWindowFocusChangeListener(this.mOnWindowFocusChangeListener);
        }
    }

    public ViewVisibilityEventListener(View view) {
        this.mView = view;
        this.mViewTreeObserver = view.getViewTreeObserver();
        this.initialiseListeners();
    }

    public void setViewVisibilityEventListener(IViewVisibilityEventListener iViewVisibilityEventListener) {
        this.mIViewVisibilityEventListener = iViewVisibilityEventListener;
    }

    private void initWithViewTreeObserver(ViewTreeObserver viewTreeObserver) {
        this.initOnWindowFocusChangeListener(viewTreeObserver);
        this.initOnWindowAttachListener(viewTreeObserver);
    }

    private void removeViewTreeObserver(ViewTreeObserver viewTreeObserver) {
        if (Build.VERSION.SDK_INT >= 18) {
            if (this.mOnWindowAttachListener != null) {
                viewTreeObserver.removeOnWindowAttachListener(this.mOnWindowAttachListener);
            }
            if (this.mOnWindowFocusChangeListener != null) {
                viewTreeObserver.removeOnWindowFocusChangeListener(this.mOnWindowFocusChangeListener);
            }
        }
    }

    private void initialiseListeners() {
        if (Build.VERSION.SDK_INT >= 18) {
            this.mView.addOnAttachStateChangeListener(new View.OnAttachStateChangeListener(){

                public void onViewAttachedToWindow(View v) {
                    ViewVisibilityEventListener.this.mViewTreeObserver = ViewVisibilityEventListener.this.mView.getViewTreeObserver();
                    ViewVisibilityEventListener.this.initWithViewTreeObserver(ViewVisibilityEventListener.this.mViewTreeObserver);
                    if (ViewVisibilityEventListener.this.mViewState == ViewState.UNKNOWN || ViewVisibilityEventListener.this.mViewState == ViewState.NOT_VISIBLE) {
                        ViewVisibilityEventListener.this.mViewState = ViewState.VISIBLE;
                        if (ViewVisibilityEventListener.this.mIViewVisibilityEventListener != null) {
                            ViewVisibilityEventListener.this.mIViewVisibilityEventListener.onViewBecameVisible(true);
                        }
                    }
                }

                public void onViewDetachedFromWindow(View v) {
                    if (ViewVisibilityEventListener.this.mViewState == ViewState.UNKNOWN || ViewVisibilityEventListener.this.mViewState == ViewState.VISIBLE) {
                        ViewVisibilityEventListener.this.mViewState = ViewState.NOT_VISIBLE;
                        if (ViewVisibilityEventListener.this.mIViewVisibilityEventListener != null) {
                            ViewVisibilityEventListener.this.mIViewVisibilityEventListener.onViewBecameVisible(false);
                        }
                    }
                    ViewVisibilityEventListener.this.removeViewTreeObserver(ViewVisibilityEventListener.this.mViewTreeObserver);
                }
            });
        }
    }

    public void invalidate() {
        if (this.isApplicationBroughtToBackground(this.mView)) {
            if (this.mViewState == ViewState.UNKNOWN || this.mViewState == ViewState.VISIBLE) {
                this.mViewState = ViewState.NOT_VISIBLE;
                if (this.mIViewVisibilityEventListener != null) {
                    this.mIViewVisibilityEventListener.onViewBecameVisible(false);
                }
            }
        } else if ((this.mViewState == ViewState.UNKNOWN || this.mViewState == ViewState.NOT_VISIBLE) && this.isVisible(this.mView)) {
            this.mViewState = ViewState.VISIBLE;
            if (this.mIViewVisibilityEventListener != null) {
                this.mIViewVisibilityEventListener.onViewBecameVisible(true);
            }
        }
    }

    private boolean isVisible(View view) {
        if (view == null) {
            return false;
        }
        if (!view.isShown()) {
            return false;
        }
        Rect actualPosition = new Rect();
        view.getGlobalVisibleRect(actualPosition);
        Rect screen = new Rect(0, 0, view.getWidth(), view.getHeight());
        return actualPosition.intersect(screen);
    }

    private boolean isApplicationBroughtToBackground(View view) {
        ComponentName topActivity;
        ActivityManager am = (ActivityManager)view.getContext().getSystemService("activity");
        List tasks = am.getRunningTasks(1);
        return !tasks.isEmpty() && !(topActivity = ((ActivityManager.RunningTaskInfo)tasks.get((int)0)).topActivity).getPackageName().equals(view.getContext().getPackageName());
    }

    public static enum ViewState {
        UNKNOWN,
        NOT_VISIBLE,
        VISIBLE;

    }
}

