/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.events;

import com.kidoz.events.Event;
import com.kidoz.sdk.api.general.utils.SDKLogger;
import com.kidoz.sdk.api.server_connect.ResponseStatus;
import com.kidoz.sdk.api.server_connect.ResultData;
import java.util.ArrayList;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class EventBulk {
    public static final int SUCCESS = 1000;
    private static final String TAG = EventBulk.class.getSimpleName();
    private static final String KEY_DEVICE_PARAMS = "DeviceParams";
    private static final String KEY_EVENT_PARAMS = "EventParams";
    private static final String KEY_ENTRIES = "Entries";
    private JSONObject mDeviceParamsJSONObject;
    private ArrayList<Event> mEventArrayList;

    public void setDeviceParamsJSONObject(JSONObject deviceParamsJSONObject) {
        this.mDeviceParamsJSONObject = deviceParamsJSONObject;
    }

    public void setEventArrayList(ArrayList<Event> eventArrayList) {
        this.mEventArrayList = eventArrayList;
    }

    private synchronized String convertToJson() {
        String result = null;
        if (this.mDeviceParamsJSONObject != null && this.mEventArrayList != null && this.mEventArrayList.size() > 0) {
            try {
                JSONObject jSONObject = new JSONObject();
                jSONObject.put(KEY_DEVICE_PARAMS, (Object)this.mDeviceParamsJSONObject);
                JSONArray jSONArray = new JSONArray();
                for (Event nextKidozEvent : this.mEventArrayList) {
                    JSONObject nextJsonObject = new JSONObject();
                    nextJsonObject.put(KEY_EVENT_PARAMS, (Object)nextKidozEvent.getJSONObject());
                    jSONArray.put((Object)nextJsonObject);
                }
                jSONObject.put(KEY_ENTRIES, (Object)jSONArray);
                result = jSONObject.toString();
            }
            catch (Exception ex) {
                SDKLogger.printErrorLog(TAG, "Error when trying to create JSONObject from Bulk : " + ex.getMessage());
            }
        }
        return result;
    }

    public String toString() {
        return this.convertToJson();
    }

    public static ResultData<Boolean> parseResultSuccsessStatus(String data) {
        ResultData<Boolean> result = new ResultData<Boolean>();
        if (data != null) {
            ResponseStatus responseStatus = EventBulk.parseResponseStatus(data);
            result.setResponseStatus(responseStatus);
            if (result.getResponseStatus().getErrorCode() != null && result.getResponseStatus().getErrorCode().equals(String.valueOf(1000))) {
                result.setData(true);
            } else {
                result.setData(false);
            }
        }
        return result;
    }

    protected static ResponseStatus parseResponseStatus(String data) {
        ResponseStatus responseStatus = new ResponseStatus();
        if (data != null) {
            try {
                JSONObject object;
                JSONArray jsonArray = new JSONArray(data);
                if (jsonArray.length() > 0 && (object = jsonArray.getJSONObject(0)) != null) {
                    if (!object.isNull("success")) {
                        responseStatus.setIsSuccessful(object.getBoolean("success"));
                    }
                    if (object.has("messageCode") && !object.isNull("messageCode")) {
                        responseStatus.setErrorCode(object.getString("messageCode"));
                    } else if (object.has("errorMessage") && !object.isNull("errorMessage")) {
                        responseStatus.setErrorCode(object.getString("errorMessage"));
                    }
                }
            }
            catch (JSONException ex) {
                SDKLogger.printErrorLog("Error parsing response status: " + ex.getMessage());
                return new ResponseStatus();
            }
        }
        return responseStatus;
    }
}

