/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.api.server_connect;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.app.Activity;
import android.content.ContentValues;
import android.content.Context;
import android.os.AsyncTask;
import android.os.Build;
import com.kidoz.sdk.api.general.utils.PropertiesObj;
import com.kidoz.sdk.api.general.utils.SDKLogger;
import com.kidoz.sdk.api.server_connect.ApiResultCallback;
import com.kidoz.sdk.api.server_connect.BaseConnectionClient;
import com.kidoz.sdk.api.server_connect.ResponseStatus;
import com.kidoz.sdk.api.server_connect.ResultData;
import com.kidoz.sdk.api.server_connect.SdkRequestType;
import com.kidoz.sdk.api.structure.ContentData;
import java.util.HashMap;
import org.json.JSONObject;

@SuppressLint(value={"NewApi"})
class BaseAPIManager
extends BaseConnectionClient {
    private static final String TAG = BaseAPIManager.class.getSimpleName();
    private HashMap<SdkRequestType, RequestAsyncTask> runningTaskList = new HashMap();

    BaseAPIManager() {
    }

    @TargetApi(value=11)
    protected void startServerConnection(Context context, String serverUrl, BaseConnectionClient.CONNECTION_TYPE type, SdkRequestType requestType, ContentValues contentValues, int numOfReconnecsOnFail, ApiResultCallback<?> resultCallback, boolean devLog, boolean removePrevRequest) {
        if (removePrevRequest) {
            try {
                if (this.runningTaskList.containsKey((Object)requestType) && this.runningTaskList.get((Object)requestType) != null) {
                    RequestAsyncTask task = this.runningTaskList.get((Object)requestType);
                    if (task.getStatus() != AsyncTask.Status.FINISHED) {
                        task.cancel(true);
                    } else {
                        this.runningTaskList.remove((Object)requestType);
                    }
                }
            }
            catch (Exception ex) {
                SDKLogger.printErrorLog(TAG, " \n Unable to finish Running Request asyncTask ! \n\n " + ex.getMessage());
            }
        }
        RequestAsyncTask requestAsyncTask = new RequestAsyncTask(context, serverUrl, type, requestType, contentValues, numOfReconnecsOnFail, resultCallback, devLog);
        this.runningTaskList.put(requestType, requestAsyncTask);
        if (Build.VERSION.SDK_INT < 11) {
            requestAsyncTask.execute(new Void[0]);
        } else {
            requestAsyncTask.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new Void[0]);
        }
    }

    private ResultData<?> parseWebServiceResponse(Context context, SdkRequestType sdkRequestType, String dataResponce, boolean devLog) {
        ResultData<ContentData> webServiceResult = null;
        if (sdkRequestType != null && context != null) {
            switch (sdkRequestType) {
                case GET_COUNTRY_CODE: {
                    try {
                        ResponseStatus responseStatus = new ResponseStatus(dataResponce);
                        ResultData<String> resultData = new ResultData<String>();
                        resultData.setResponseStatus(responseStatus);
                        if (responseStatus.getIsSuccessful()) {
                            JSONObject jSONObject = new JSONObject(dataResponce);
                            JSONObject countryCodeJson = jSONObject.optJSONObject("data");
                            resultData.setData(countryCodeJson.optString("country_code"));
                        }
                        webServiceResult = resultData;
                    }
                    catch (Exception ex) {
                        SDKLogger.printErrorLog(TAG, "Error when trying to parse GET_COUNTRY_CODE: " + ex.getMessage());
                    }
                    break;
                }
                case LOAD_SDK_CONTENT: 
                case LOAD_WATERFALL: {
                    ContentData contentData = new ContentData();
                    contentData.decodeResponse(dataResponce);
                    ResultData<ContentData> resultData = new ResultData<ContentData>();
                    resultData.setData(contentData);
                    webServiceResult = resultData;
                    break;
                }
                case VALIDATE_SDK: {
                    try {
                        ResponseStatus responseStatus = new ResponseStatus(dataResponce);
                        ResultData<PropertiesObj> resultData = new ResultData<PropertiesObj>();
                        resultData.setResponseStatus(responseStatus);
                        if (responseStatus.getIsSuccessful()) {
                            JSONObject jSONObject = new JSONObject(dataResponce);
                            PropertiesObj propertiesObj = new PropertiesObj(jSONObject.optJSONObject("data"));
                            resultData.setData(propertiesObj);
                        }
                        webServiceResult = resultData;
                        break;
                    }
                    catch (Exception ex) {
                        SDKLogger.printErrorLog(TAG, "Error when trying to parse validate SDK: " + ex.getMessage());
                    }
                }
            }
        }
        return webServiceResult;
    }

    class RequestAsyncTask
    extends AsyncTask<Void, Void, ResultData<?>> {
        private BaseConnectionClient.CONNECTION_TYPE restRequestType = BaseConnectionClient.CONNECTION_TYPE.POST;
        private ApiResultCallback<?> mResultCallback;
        private int numOfReconnectionsOnFail = 0;
        private SdkRequestType sdkRequestType;
        private ContentValues mContentValues;
        private Context mContext;
        private boolean mDeveloperLogging = false;
        private String mServerUrl;

        public RequestAsyncTask(Context context, String serverUrl, BaseConnectionClient.CONNECTION_TYPE type, SdkRequestType requestType, ContentValues contentValues, int numOfReconnecsOnFail, ApiResultCallback<?> resultCallback, boolean devLog) {
            this.mContext = context;
            this.restRequestType = type;
            this.sdkRequestType = requestType;
            this.mContentValues = contentValues;
            this.mResultCallback = resultCallback;
            this.numOfReconnectionsOnFail = numOfReconnecsOnFail;
            this.mDeveloperLogging = devLog;
            this.mServerUrl = serverUrl;
        }

        protected ResultData<?> doInBackground(Void ... params) {
            String dataResponce = null;
            ResultData webServiceResult = null;
            int mReconnectionTries = 0;
            if (!this.isCancelled()) {
                while (mReconnectionTries <= this.numOfReconnectionsOnFail) {
                    block21: {
                        if (this.mContext != null && this.mContext instanceof Activity) {
                            if (Build.VERSION.SDK_INT >= 17 && ((Activity)this.mContext).isDestroyed()) {
                                return null;
                            }
                            if (((Activity)this.mContext).isFinishing()) {
                                return null;
                            }
                        }
                        ++mReconnectionTries;
                        if (this.isCancelled()) break;
                        try {
                            if (this.restRequestType == BaseConnectionClient.CONNECTION_TYPE.POST) {
                                dataResponce = BaseConnectionClient.makePostConnection(this.mServerUrl, this.mContentValues);
                            } else if (this.restRequestType == BaseConnectionClient.CONNECTION_TYPE.GET) {
                                dataResponce = BaseConnectionClient.makeGetConnection(this.mServerUrl, this.mContentValues);
                            }
                        }
                        catch (Exception e) {
                            if (this.sdkRequestType == null) break block21;
                            SDKLogger.printErrorLog(" \n IO Exception On [" + this.sdkRequestType.name() + "] request! \n" + e.getMessage());
                        }
                    }
                    if (this.isCancelled() || dataResponce != null) break;
                    try {
                        if (this.isCancelled()) break;
                        Thread.sleep(300 * mReconnectionTries * 2);
                    }
                    catch (Exception e) {
                        // empty catch block
                        break;
                    }
                }
            }
            if (this.sdkRequestType != null) {
                if (this.restRequestType == BaseConnectionClient.CONNECTION_TYPE.POST) {
                    SDKLogger.printPostRequestDebugLog(this.mServerUrl, this.mContentValues, this.sdkRequestType.name());
                } else if (this.restRequestType == BaseConnectionClient.CONNECTION_TYPE.GET) {
                    SDKLogger.printGetRequestDebugLog(this.mServerUrl, this.mContentValues, this.sdkRequestType.name());
                }
                SDKLogger.printResponse(dataResponce, this.restRequestType.name(), this.sdkRequestType.name());
            }
            if (this.isCancelled()) {
                return null;
            }
            if (dataResponce != null) {
                if (!this.isCancelled() && this.mContext != null) {
                    try {
                        webServiceResult = BaseAPIManager.this.parseWebServiceResponse(this.mContext, this.sdkRequestType, dataResponce, this.mDeveloperLogging);
                    }
                    catch (Exception ex) {
                        SDKLogger.printErrorLog(TAG, "Error when trying to parse service response: " + ex.getMessage());
                    }
                }
                return webServiceResult;
            }
            return null;
        }

        protected void onPostExecute(ResultData<?> result) {
            if (this.mContext != null && this.mContext instanceof Activity) {
                if (Build.VERSION.SDK_INT >= 17 && ((Activity)this.mContext).isDestroyed()) {
                    return;
                }
                if (((Activity)this.mContext).isFinishing()) {
                    return;
                }
            }
            if (!this.isCancelled()) {
                if (result == null) {
                    if (this.mResultCallback != null) {
                        this.mResultCallback.onFailed();
                    }
                } else if (this.mResultCallback != null) {
                    this.mResultCallback.onServerResult(result);
                }
            }
            BaseAPIManager.this.runningTaskList.remove((Object)this.sdkRequestType);
        }

        protected void onCancelled() {
            super.onCancelled();
            if (this.sdkRequestType != null && BaseAPIManager.this.runningTaskList != null) {
                BaseAPIManager.this.runningTaskList.remove((Object)this.sdkRequestType);
            }
        }
    }
}

