/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.api.general.utils;

import android.app.Activity;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Point;
import android.os.Build;
import android.os.PowerManager;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.Window;
import android.view.WindowManager;
import com.kidoz.sdk.api.general.utils.SDKLogger;

public final class ScreenUtils {
    private static final String TAG = ScreenUtils.class.getSimpleName();

    public static boolean getIsScreenOff(Context context) {
        WindowManager windowManager;
        Display display;
        PowerManager powerManager;
        boolean result = false;
        result = Build.VERSION.SDK_INT < 20 ? !(powerManager = (PowerManager)context.getSystemService("power")).isScreenOn() : (display = (windowManager = (WindowManager)context.getSystemService("window")).getDefaultDisplay()).getState() == 1;
        return result;
    }

    public static double getDeviceScreenSizeInInches(Context context) {
        WindowManager windowManager = (WindowManager)context.getSystemService("window");
        Display display = windowManager.getDefaultDisplay();
        DisplayMetrics displayMetrics = new DisplayMetrics();
        display.getMetrics(displayMetrics);
        int mWidthPixels = displayMetrics.widthPixels;
        int mHeightPixels = displayMetrics.heightPixels;
        if (Build.VERSION.SDK_INT >= 14 && Build.VERSION.SDK_INT < 17) {
            try {
                mWidthPixels = (Integer)Display.class.getMethod("getRawWidth", new Class[0]).invoke((Object)display, new Object[0]);
                mHeightPixels = (Integer)Display.class.getMethod("getRawHeight", new Class[0]).invoke((Object)display, new Object[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (Build.VERSION.SDK_INT >= 17) {
            try {
                Point realSize = new Point();
                Display.class.getMethod("getRealSize", Point.class).invoke((Object)display, realSize);
                mWidthPixels = realSize.x;
                mHeightPixels = realSize.y;
            }
            catch (Exception realSize) {
                // empty catch block
            }
        }
        DisplayMetrics dm = new DisplayMetrics();
        windowManager.getDefaultDisplay().getMetrics(dm);
        double x = Math.pow((float)mWidthPixels / dm.xdpi, 2.0);
        double y = Math.pow((float)mHeightPixels / dm.ydpi, 2.0);
        double screenInches = Math.sqrt(x + y);
        return (double)Math.round(screenInches * 10.0) / 10.0;
    }

    public static Point getScreenSize(Context context) {
        int NULL_SIZE = -1;
        Point size = new Point();
        WindowManager windowManager = (WindowManager)context.getSystemService("window");
        Display display = windowManager.getDefaultDisplay();
        if (Build.VERSION.SDK_INT >= 19) {
            display.getRealSize(size);
        } else {
            size.x = display.getWidth();
            size.y = display.getHeight();
        }
        if (size == null) {
            size.x = -1;
            size.y = -1;
        }
        return size;
    }

    public static int getScreenSize(Context context, boolean isWidth) {
        int result = 0;
        WindowManager windowManager = (WindowManager)context.getSystemService("window");
        Display display = windowManager.getDefaultDisplay();
        if (isWidth) {
            if (Build.VERSION.SDK_INT >= 19) {
                Point point = new Point();
                display.getRealSize(point);
                result = point.x;
            } else {
                result = display.getWidth();
            }
        } else if (Build.VERSION.SDK_INT >= 19) {
            Point point = new Point();
            display.getRealSize(point);
            result = point.y;
        } else {
            result = display.getHeight();
        }
        return result;
    }

    public static void hideNavigationAndStatusBar(Window window) {
        if (window != null) {
            if (Build.VERSION.SDK_INT < 16) {
                window.setFlags(1024, 1024);
            } else if (Build.VERSION.SDK_INT >= 16 && Build.VERSION.SDK_INT < 19) {
                window.getDecorView().setSystemUiVisibility(0);
                window.getDecorView().setSystemUiVisibility(4);
            }
            if (Build.VERSION.SDK_INT >= 19) {
                int flags = 5894;
                window.getDecorView().setSystemUiVisibility(0);
                window.getDecorView().setSystemUiVisibility(5894);
            }
        }
    }

    public static void hideNavigationBar(Window window) {
        if (window != null) {
            if (Build.VERSION.SDK_INT < 16) {
                window.setFlags(1024, 1024);
            } else if (Build.VERSION.SDK_INT >= 16 && Build.VERSION.SDK_INT < 19) {
                window.getDecorView().setSystemUiVisibility(0);
                window.getDecorView().setSystemUiVisibility(4);
            }
            if (Build.VERSION.SDK_INT >= 19) {
                int flags = 5380;
                window.getDecorView().setSystemUiVisibility(0);
                window.getDecorView().setSystemUiVisibility(5380);
            }
        }
    }

    public static void showNavigationAndStatusBar(Window window) {
        if (window != null) {
            if (Build.VERSION.SDK_INT < 16) {
                window.clearFlags(1024);
            } else if (Build.VERSION.SDK_INT >= 16 && Build.VERSION.SDK_INT < 19) {
                window.getDecorView().setSystemUiVisibility(0);
            }
            if (Build.VERSION.SDK_INT >= 19) {
                window.getDecorView().setSystemUiVisibility(0);
            }
        }
    }

    public static boolean getIsTablet(Context context) {
        boolean result = true;
        if (context != null && (context.getResources().getConfiguration().screenLayout & 0xF) == 2) {
            result = false;
        }
        return result;
    }

    public static int getScreenOrientation(Activity activity) {
        if (activity == null) {
            return 0;
        }
        return activity.getResources().getConfiguration().orientation;
    }

    public static void setScreenOrientation(Activity activity, int orientation) {
        if (activity != null && (orientation == 1 || orientation == 0 || orientation == 4)) {
            activity.setRequestedOrientation(orientation);
        }
    }

    public static float getScaleFactor(Context context) {
        float result = 1.0f;
        if (context != null) {
            result = context.getResources().getDisplayMetrics().density;
            result /= 3.0f;
            if ((context.getResources().getConfiguration().screenLayout & 0xF) == 3) {
                result *= 1.25f;
            } else if ((context.getResources().getConfiguration().screenLayout & 0xF) == 4) {
                result *= 1.5f;
            }
        }
        SDKLogger.printDebugLog(TAG, ">>>>Scale factor = " + String.valueOf(result));
        return result;
    }

    public static float getTextScale(Context context) {
        float result = 1.0f;
        if ((context.getResources().getConfiguration().screenLayout & 0xF) == 3) {
            result = 2.0f;
        } else if ((context.getResources().getConfiguration().screenLayout & 0xF) == 4) {
            result = 2.5f;
        }
        return result;
    }

    public static int[] getScaledDimension(int srcWidth, int srcHeight, int dstWidth, int dstHeight) {
        int[] result = new int[2];
        float widthScale = (float)dstWidth / (float)srcWidth;
        float heightScale = (float)dstHeight / (float)srcHeight;
        float scale = Math.min(widthScale, heightScale);
        result[0] = Math.round((float)srcWidth * scale);
        result[1] = Math.round((float)srcHeight * scale);
        return result;
    }

    public static int getStatusBarHeight(Context context) {
        int result = 0;
        int resourceId = context.getResources().getIdentifier("status_bar_height", "dimen", "android");
        if (resourceId > 0) {
            result = context.getResources().getDimensionPixelSize(resourceId);
        }
        return result;
    }

    public static int getNavigationBarHeight(Context context) {
        int result = 0;
        int resourceId = context.getResources().getIdentifier("navigation_bar_height", "dimen", "android");
        if (resourceId > 0) {
            result = context.getResources().getDimensionPixelSize(resourceId);
        }
        return result;
    }

    public static int getScreenCategory(Context context) {
        return context.getResources().getConfiguration().screenLayout & 0xF;
    }

    public static float getScreenDpi(Context context) {
        return context.getResources().getDisplayMetrics().density;
    }

    public static float convertDpToPixel(float dp) {
        DisplayMetrics metrics = Resources.getSystem().getDisplayMetrics();
        float px = dp * ((float)metrics.densityDpi / 160.0f);
        return px;
    }

    public static float convertPixelsToDp(float px) {
        DisplayMetrics metrics = Resources.getSystem().getDisplayMetrics();
        float dp = px / ((float)metrics.densityDpi / 160.0f);
        return dp;
    }
}

