/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.api.general.assets_handling;

import android.app.Activity;
import android.content.Context;
import android.os.AsyncTask;
import android.os.Build;
import com.kidoz.sdk.api.general.assets_handling.StyleParser;
import com.kidoz.sdk.api.general.database.DatabaseManager;
import com.kidoz.sdk.api.general.utils.PropertiesObj;
import com.kidoz.sdk.api.general.utils.SDKLogger;
import com.kidoz.sdk.api.general.utils.SdkDeviceUtils;
import com.kidoz.sdk.api.general.utils.Utils;
import com.kidoz.sdk.api.server_connect.BaseConnectionClient;
import java.io.File;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class AssetUtil {
    private static final String TAG = AssetUtil.class.getSimpleName();
    private static final String PANEL_FAMILY_ASSETS = "panelFamily";
    private static final String INTERSTITIAL_ASSETS = "interstitial";
    private static final String BANNER_ASSETS = "banner";
    private static final String GLOBAL_STYLE_PARAMS = "globalStyleParams";

    public static boolean parseAssets(Context context, String dataResponse) {
        boolean result = false;
        if (context != null && dataResponse != null) {
            try {
                JSONObject rootObject = new JSONObject(dataResponse);
                if (rootObject.has(GLOBAL_STYLE_PARAMS)) {
                    result = StyleParser.parseGlobalStyleData(context, rootObject.getJSONObject(GLOBAL_STYLE_PARAMS));
                } else if (rootObject.has(PANEL_FAMILY_ASSETS)) {
                    result = StyleParser.parseFamilyPanelData(context, rootObject.getJSONObject(PANEL_FAMILY_ASSETS));
                } else if (rootObject.has(INTERSTITIAL_ASSETS)) {
                    result = StyleParser.parseInterstitialData(context, rootObject.getJSONObject(INTERSTITIAL_ASSETS));
                } else if (rootObject.has(BANNER_ASSETS)) {
                    result = StyleParser.parseBannerData(context, rootObject.getJSONObject(BANNER_ASSETS));
                }
            }
            catch (Exception ex) {
                SDKLogger.printErrorLog(TAG, "Error when trying to parse assets: " + ex.getMessage());
            }
        }
        return result;
    }

    private static String createAssetFileName(String assetURL) {
        String result = null;
        if (assetURL != null) {
            result = assetURL.substring(assetURL.lastIndexOf("/") + 1, assetURL.length());
        }
        return result;
    }

    private static String createAssetFileName2(String assetURL) {
        String result = null;
        if (assetURL != null) {
            result = assetURL.replace("/", "");
            result = result + assetURL.substring(assetURL.lastIndexOf("/") + 1, assetURL.length());
        }
        return result;
    }

    public static boolean createAssetFile(Context context, String assetURL) {
        boolean result = true;
        if (assetURL != null && !assetURL.equals("")) {
            String fileName = AssetUtil.createAssetFileName(assetURL);
            File storageLocation = SdkDeviceUtils.getInnerStoragePathIfPosible(context);
            File newFile = new File(storageLocation, fileName);
            if (!newFile.exists()) {
                result = BaseConnectionClient.downloadAndSaveFile(assetURL, newFile);
            }
        }
        return result;
    }

    public static boolean createAssetFile2(Context context, String assetURL) {
        boolean result = true;
        if (assetURL != null && !assetURL.equals("")) {
            String fileName = AssetUtil.createAssetFileName2(assetURL);
            File storageLocation = SdkDeviceUtils.getInnerStoragePathIfPosible(context);
            File newFile = new File(storageLocation, fileName);
            if (!newFile.exists()) {
                result = BaseConnectionClient.downloadAndSaveFile(assetURL, newFile);
            }
        }
        return result;
    }

    public static void deleteAssetFile(Context context, String assetURL) {
        if (assetURL != null) {
            String fileName = AssetUtil.createAssetFileName(assetURL);
            File storageLocation = SdkDeviceUtils.getInnerStoragePathIfPosible(context);
            File fileToDelete = new File(storageLocation, fileName);
            if (fileToDelete.exists()) {
                fileToDelete.delete();
            }
        }
    }

    public static void deleteAssetFile2(Context context, String assetURL) {
        if (assetURL != null) {
            String fileName = AssetUtil.createAssetFileName2(assetURL);
            File storageLocation = SdkDeviceUtils.getInnerStoragePathIfPosible(context);
            File fileToDelete = new File(storageLocation, fileName);
            if (fileToDelete.exists()) {
                fileToDelete.delete();
            }
        }
    }

    public static File getAssetFile(Context context, String assetURL) {
        File result = null;
        try {
            if (assetURL != null) {
                String fileName = AssetUtil.createAssetFileName(assetURL);
                File storageLocation = SdkDeviceUtils.getInnerStoragePathIfPosible(context);
                if (!assetURL.equals("") && !(result = new File(storageLocation, fileName)).exists()) {
                    result = null;
                }
            }
        }
        catch (Exception ex) {
            SDKLogger.printErrorLog(ex.getLocalizedMessage());
        }
        return result;
    }

    public static File getAssetFile2(Context context, String assetURL) {
        File result = null;
        try {
            if (assetURL != null) {
                String fileName = AssetUtil.createAssetFileName2(assetURL);
                File storageLocation = SdkDeviceUtils.getInnerStoragePathIfPosible(context);
                if (!assetURL.equals("") && !(result = new File(storageLocation, fileName)).exists()) {
                    result = null;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public static boolean loadAsset(Context context, JSONObject oldProperties, JSONObject newProperties, String assetKey) throws JSONException {
        boolean result = false;
        ArrayList<String> imgList = AssetUtil.generateAssetFileImageList(newProperties, assetKey);
        if (!imgList.isEmpty()) {
            for (int i = 0; i < imgList.size(); ++i) {
                if (oldProperties != null) {
                    result = true;
                    String oldAssetURL = oldProperties.optString(assetKey);
                    File oldFile = AssetUtil.getAssetFile(context, oldAssetURL);
                    if (oldAssetURL == null || !oldAssetURL.equals(imgList.get(i)) || oldFile == null || !oldFile.exists() || oldFile.length() == 0L) {
                        if (oldAssetURL != null && !oldAssetURL.equals("") && oldFile != null && oldFile.exists()) {
                            AssetUtil.deleteAssetFile(context, oldAssetURL);
                        }
                        result = AssetUtil.createAssetFile(context, imgList.get(i));
                    }
                } else {
                    result = AssetUtil.createAssetFile(context, imgList.get(i));
                }
                if (!result) continue;
                newProperties.put(assetKey, (Object)imgList.get(i));
                break;
            }
        }
        return result;
    }

    public static ArrayList<String> generateAssetFileImageList(JSONObject jsonObject, String key) {
        JSONArray jsonArray;
        ArrayList<String> list = new ArrayList<String>();
        String link = jsonObject.optString(key);
        if (jsonObject.has(key + "Arr") && (jsonArray = jsonObject.optJSONArray(key + "Arr")) != null && jsonArray.length() > 0 && link != null) {
            String stripedLink = link.substring(0, link.lastIndexOf(".") + 1);
            for (int i = 0; i < jsonArray.length(); ++i) {
                String suffix = jsonArray.optString(i, "");
                if (suffix.equals("webp") || suffix.equals("webP") || suffix.equals("WEBP")) {
                    if (!Utils.isWebViewSupportWebP()) continue;
                    list.add(stripedLink + suffix);
                    continue;
                }
                list.add(stripedLink + suffix);
            }
        }
        if (list.isEmpty()) {
            list.add(link);
        }
        return list;
    }

    public static void parseStyleAsync(Context context, ParserAsyncTask.StyleType type, ParserAsyncTask.IOnStyleParseListener listener) {
        ParserAsyncTask task = new ParserAsyncTask(context, type, listener);
        if (Build.VERSION.SDK_INT < 11) {
            task.execute(new Void[0]);
        } else {
            task.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new Void[0]);
        }
    }

    public static class ParserAsyncTask
    extends AsyncTask<Void, Void, Boolean> {
        private WeakReference<Context> mContextRef;
        private StyleType mType;
        private IOnStyleParseListener mStyleParseListener;

        public ParserAsyncTask(Context context, StyleType type, IOnStyleParseListener resultCallback) {
            this.mContextRef = new WeakReference<Context>(context);
            this.mType = type;
            this.mStyleParseListener = resultCallback;
        }

        protected Boolean doInBackground(Void ... params) {
            boolean res = false;
            if (this.mContextRef != null && this.mContextRef.get() != null) {
                if (this.mContextRef != null && this.mContextRef.get() instanceof Activity) {
                    if (Build.VERSION.SDK_INT >= 17 && ((Activity)this.mContextRef.get()).isDestroyed()) {
                        return null;
                    }
                    if (((Activity)this.mContextRef.get()).isFinishing()) {
                        return null;
                    }
                }
                String data = null;
                PropertiesObj appConfig = DatabaseManager.getInstance((Context)this.mContextRef.get()).getConfigTable().loadAppProperties();
                if (appConfig != null) {
                    switch (this.mType) {
                        case GLOBAL_PARAMS_STYLE: {
                            data = appConfig.getGlobalPropertiesStyle();
                            break;
                        }
                        case INTERSTITIAL_STYLE: {
                            data = appConfig.getInterstitialViewStyle();
                            break;
                        }
                        case BANNER_STYLE: {
                            data = appConfig.getBannerViewStyle();
                            break;
                        }
                        case PANEL_STYLE: {
                            data = appConfig.getPanelViewStyle();
                            break;
                        }
                        case FLEXI_STYLE: {
                            data = appConfig.getFlexiViewStyle();
                            break;
                        }
                        case FEED_STYLE: {
                            data = appConfig.getFeedViewStyle();
                        }
                    }
                }
                if (data != null && this.mContextRef != null && this.mContextRef.get() != null) {
                    if (this.mContextRef.get() != null && this.mContextRef.get() instanceof Activity && (((Activity)this.mContextRef.get()).isFinishing() || ((Activity)this.mContextRef.get()).isDestroyed())) {
                        return res;
                    }
                    res = AssetUtil.parseAssets((Context)this.mContextRef.get(), data);
                }
            }
            return res;
        }

        protected void onPostExecute(Boolean result) {
            if (this.mContextRef.get() != null && this.mContextRef.get() instanceof Activity && (((Activity)this.mContextRef.get()).isFinishing() || ((Activity)this.mContextRef.get()).isDestroyed())) {
                return;
            }
            if (this.mStyleParseListener != null) {
                this.mStyleParseListener.onParseFinished(result);
            }
        }

        protected void onCancelled() {
            super.onCancelled();
        }

        public static interface IOnStyleParseListener {
            public void onParseFinished(boolean var1);
        }

        public static enum StyleType {
            PANEL_STYLE,
            FEED_STYLE,
            FLEXI_STYLE,
            INTERSTITIAL_STYLE,
            GLOBAL_PARAMS_STYLE,
            BANNER_STYLE;

        }
    }
}

