/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.api.ui_views.video_unit;

import android.content.Context;
import android.content.Intent;
import android.os.Looper;
import com.kidoz.sdk.api.KidozSDK;
import com.kidoz.sdk.api.fullscreen_video_layer.FullScreenVideoEnabledWebView;
import com.kidoz.sdk.api.general.EventMessage;
import com.kidoz.sdk.api.general.utils.Utils;
import com.kidoz.sdk.api.ui_views.video_unit.VideoUnitActivity;
import org.greenrobot.eventbus.EventBus;
import org.greenrobot.eventbus.Subscribe;

public class VideoUnit {
    public static final String TAG = VideoUnit.class.getSimpleName();
    private Context mContext;
    private FullScreenVideoEnabledWebView sWebViewInstance;
    private VideoUnitListener mVideoUnitListener;
    private Utils.StaticHandler mStaticHandler = new Utils.StaticHandler(Looper.getMainLooper());
    public static boolean misLoaded = false;

    public VideoUnit(Context context) {
        this.mContext = context;
        misLoaded = false;
        if (this.sWebViewInstance == null) {
            this.sWebViewInstance = new FullScreenVideoEnabledWebView(this.mContext);
        }
        if (!this.getIsReady() && !EventBus.getDefault().isRegistered((Object)this)) {
            EventBus.getDefault().register((Object)this);
        }
    }

    public void setVideoUnitListener(VideoUnitListener videoUnitListener) {
        this.mVideoUnitListener = videoUnitListener;
        if (this.getIsReady() && this.mVideoUnitListener != null) {
            this.mStaticHandler.post(new Runnable(){

                @Override
                public void run() {
                    VideoUnit.this.mVideoUnitListener.onReady();
                }
            });
        }
    }

    public boolean getIsReady() {
        return KidozSDK.isInitialised();
    }

    public void show() {
        Intent intent = new Intent(this.mContext, VideoUnitActivity.class);
        intent.putExtra("isLoaded", misLoaded);
        intent.addFlags(0x30020000);
        VideoUnitActivity.mWebView = this.sWebViewInstance;
        VideoUnitActivity.sVideoUnitListener = this.mVideoUnitListener;
        this.mContext.startActivity(intent);
    }

    @Subscribe
    public void onHandleEvent(EventMessage event) {
        if (event.getMessageType() == EventMessage.MessageType.INIT_SDK) {
            if (EventBus.getDefault().isRegistered((Object)this)) {
                EventBus.getDefault().unregister((Object)this);
            }
            if (this.mVideoUnitListener != null) {
                this.mStaticHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        VideoUnit.this.mVideoUnitListener.onReady();
                    }
                });
            }
        }
    }

    public static interface VideoUnitListener {
        public void onReady();

        public void onOpen();

        public void onClose();
    }
}

