/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.api.ui_views.new_panel_view;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.RectF;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.View;

public class PanelShapeHandle
extends View {
    private Path mMainShapePath;
    private Paint mPaint;
    private int mPanelColor;
    private int mViewWidth;
    private int mViewHeight;

    public PanelShapeHandle(Context context, int panelColor) {
        super(context);
        this.mPanelColor = panelColor;
        this.init();
    }

    public PanelShapeHandle(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public PanelShapeHandle(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    public PanelShapeHandle(Context context, @Nullable AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init();
    }

    private void init() {
        this.setWillNotDraw(false);
        this.setLayerType(2, null);
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        this.mViewWidth = this.getWidth();
        this.mViewHeight = this.getHeight();
        this.layout();
    }

    private void layout() {
        this.initShapePaint();
        this.initMainShapePath();
    }

    private void initMainShapePath() {
        float rectTop = 0.0f;
        float rectRight = this.mViewWidth;
        float rectLeft = 0.0f;
        float rectBottom = this.mViewHeight;
        RectF rightFacingRect = new RectF(0.0f, 0.0f, rectRight, rectBottom);
        this.mMainShapePath = new Path();
        this.mMainShapePath.moveTo(0.0f, 0.0f);
        this.mMainShapePath.arcTo(rightFacingRect, -90.0f, 90.0f);
        this.mMainShapePath.lineTo((float)this.mViewWidth, (float)this.mViewHeight);
        this.mMainShapePath.lineTo(0.0f, (float)this.mViewHeight);
        this.mMainShapePath.close();
    }

    private void initShapePaint() {
        this.mPaint = new Paint();
        this.mPaint.setColor(this.mPanelColor);
    }

    protected void onDraw(Canvas canvas) {
        canvas.drawPath(this.mMainShapePath, this.mPaint);
        super.onDraw(canvas);
    }
}

