/*
 * Decompiled with CFR 0.152.
 */
package com.kidoz.sdk.api.ui_views.new_kidoz_banner;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.content.res.Configuration;
import android.graphics.Point;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.widget.RelativeLayout;
import com.kidoz.sdk.api.general.enums.WidgetType;
import com.kidoz.sdk.api.general.utils.SDKLogger;
import com.kidoz.sdk.api.general.utils.Utils;
import com.kidoz.sdk.api.ui_views.html_view.HtmlViewWrapper;
import com.kidoz.sdk.api.ui_views.kidoz_banner.KidozBannerListener;
import com.kidoz.sdk.api.ui_views.new_kidoz_banner.BANNER_POSITION;
import com.kidoz.sdk.api.ui_views.new_kidoz_banner.KidozBannerPresenter;

public class KidozBannerView
extends RelativeLayout {
    private static final String TAG = KidozBannerView.class.getSimpleName();
    private static final String ACTIVITY_CONTEXT_REQUIRED = "KidozBanner | Kidoz requires Activity context to show a banner.";
    private static final String ERROR_REQUESTED_LOAD_EMPTY_URL = "KidozBanner | Kidoz banner requested to load empty url.";
    private static final String VIEW_HIERARCHY_MODE_WITHOUT_FLAG = "Unable to add overlay banner. If you're trying to add this banner to your view hierarchy, please call setLayoutWithoutShowing() first.";
    private static final float BANNER_RATIO = 6.4f;
    private static final int BANNER_BACKGROUND_COLOR = 0;
    private HtmlViewWrapper mHtmlViewWrapper;
    private Activity mActivity;
    private KidozBannerPresenter mKidozBannerPresenter;
    private BANNER_POSITION mBannerPosition;
    private boolean mLayoutWithoutShowing;

    public KidozBannerView(Context context) {
        super(context);
        this.init(context);
    }

    public KidozBannerView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    public KidozBannerView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context);
    }

    @SuppressLint(value={"NewApi"})
    public KidozBannerView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init(context);
    }

    private void init(Context context) {
        if (!(context instanceof Activity)) {
            SDKLogger.printErrorLog(ACTIVITY_CONTEXT_REQUIRED);
            return;
        }
        this.mActivity = (Activity)context;
        this.mLayoutWithoutShowing = false;
        this.createBannerPresenter();
        this.createBannerWebView();
        this.mKidozBannerPresenter.init();
    }

    public synchronized void load() {
        this.mKidozBannerPresenter.load(this.mHtmlViewWrapper);
    }

    public synchronized void show() {
        this.mKidozBannerPresenter.show(this.mHtmlViewWrapper);
    }

    public synchronized void hide() {
        this.hideInternal();
        this.mKidozBannerPresenter.developerCalledHide(this.mHtmlViewWrapper);
    }

    public synchronized void setKidozBannerListener(KidozBannerListener kidozBannerListener) {
        this.mKidozBannerPresenter.setBannerListener(kidozBannerListener);
    }

    public synchronized void setBannerPosition(BANNER_POSITION bannerPosition) {
        this.mBannerPosition = bannerPosition;
        this.setHtmlViewWrapperLPs();
    }

    public void setLayoutWithoutShowing() {
        this.mLayoutWithoutShowing = true;
    }

    protected void hideInternal() {
        SDKLogger.printDebugLog("KidozBannerPresenter | hideInternal() 0");
        if (!this.mLayoutWithoutShowing) {
            SDKLogger.printDebugLog("KidozBannerPresenter | hideInternal() 1");
            ViewParent parentView = this.getParent();
            if (parentView != null) {
                SDKLogger.printDebugLog("KidozBannerPresenter | hideInternal() 2");
                ((ViewGroup)parentView).removeView((View)this);
            }
        }
    }

    protected void nativeShow() {
        SDKLogger.printDebugLog("KidozBannerPresenter | nativeShow() 0");
        if (!this.mLayoutWithoutShowing) {
            SDKLogger.printDebugLog("KidozBannerPresenter | nativeShow() 1");
            try {
                SDKLogger.printDebugLog("KidozBannerPresenter | nativeShow() 2");
                ViewGroup.LayoutParams generalBannerLPs = new ViewGroup.LayoutParams(-1, -1);
                this.mActivity.addContentView((View)this, generalBannerLPs);
            }
            catch (IllegalStateException ise) {
                SDKLogger.printDebugLog("KidozBannerPresenter | nativeShow() 3");
                SDKLogger.printErrorLog(TAG, VIEW_HIERARCHY_MODE_WITHOUT_FLAG);
            }
        }
        this.layout();
    }

    private void layout() {
        this.removeAllViews();
        this.addView((View)this.mHtmlViewWrapper);
        this.mKidozBannerPresenter.notifyViewAdded();
    }

    private void setBannerBackground() {
        this.mHtmlViewWrapper.setBackgroundColor(0);
    }

    private void createBannerWebView() {
        this.mHtmlViewWrapper = new HtmlViewWrapper((Context)this.mActivity, true);
        this.mHtmlViewWrapper.setInFocusActivityContext((Context)this.mActivity);
        this.mHtmlViewWrapper.setAllowJSResize(true);
        this.setHtmlViewWrapperLPs();
        this.mHtmlViewWrapper.setHtmlWebViewListener(this.mKidozBannerPresenter.getHtmlWebViewInterface());
        this.setBannerBackground();
    }

    private void setHtmlViewWrapperLPs() {
        RelativeLayout.LayoutParams bannerWebViewLayoutParams;
        Point bannerDimensions = this.getBannerDimensions();
        int width = bannerDimensions.x;
        int height = bannerDimensions.y;
        if ((RelativeLayout.LayoutParams)this.mHtmlViewWrapper.getLayoutParams() != null) {
            bannerWebViewLayoutParams = (RelativeLayout.LayoutParams)this.mHtmlViewWrapper.getLayoutParams();
            bannerWebViewLayoutParams.addRule(10, 0);
            bannerWebViewLayoutParams.addRule(12, 0);
            bannerWebViewLayoutParams.addRule(15, 0);
            bannerWebViewLayoutParams.addRule(9, 0);
            bannerWebViewLayoutParams.addRule(11, 0);
        } else {
            bannerWebViewLayoutParams = new RelativeLayout.LayoutParams(width, height);
        }
        bannerWebViewLayoutParams.addRule(14);
        if (this.mBannerPosition != null) {
            switch (this.mBannerPosition) {
                case TOP: {
                    bannerWebViewLayoutParams.addRule(10);
                    break;
                }
                case BOTTOM: {
                    bannerWebViewLayoutParams.addRule(12);
                    break;
                }
                case CENTER: {
                    bannerWebViewLayoutParams.addRule(15);
                    break;
                }
                case TOP_CENTER: {
                    bannerWebViewLayoutParams.addRule(10);
                    break;
                }
                case BOTTOM_CENTER: {
                    bannerWebViewLayoutParams.addRule(12);
                    break;
                }
                case TOP_LEFT: {
                    bannerWebViewLayoutParams.addRule(10);
                    bannerWebViewLayoutParams.addRule(9);
                    break;
                }
                case TOP_RIGHT: {
                    bannerWebViewLayoutParams.addRule(10);
                    bannerWebViewLayoutParams.addRule(11);
                    break;
                }
                case BOTTOM_LEFT: {
                    bannerWebViewLayoutParams.addRule(12);
                    bannerWebViewLayoutParams.addRule(9);
                    break;
                }
                case BOTTOM_RIGHT: {
                    bannerWebViewLayoutParams.addRule(12);
                    bannerWebViewLayoutParams.addRule(11);
                }
            }
        }
        this.mHtmlViewWrapper.setLayoutParams((ViewGroup.LayoutParams)bannerWebViewLayoutParams);
    }

    private Point getBannerDimensions() {
        Point screenSize = Utils.getScreenSizeTemp((Context)this.mActivity, true);
        int width = Math.min(screenSize.x, screenSize.y);
        int height = (int)((float)width / 6.4f);
        return new Point(width, height);
    }

    private void createBannerPresenter() {
        this.mKidozBannerPresenter = new KidozBannerPresenter(this);
    }

    public Activity getActivity() {
        return this.mActivity;
    }

    public void startBannerWebLogic(String url) {
        if (TextUtils.isEmpty((CharSequence)url)) {
            SDKLogger.printErrorLog(ERROR_REQUESTED_LOAD_EMPTY_URL);
            return;
        }
        this.mHtmlViewWrapper.setWidgetType(WidgetType.WIDGET_TYPE_BANNER.getStringValue());
        this.mHtmlViewWrapper.loadHtml(url);
    }

    public void invokeUrlInWebView(String url, HtmlViewWrapper.BannerInvokeUrlInterface bannerInvokeUrlInterface) {
        this.mHtmlViewWrapper.invokeUrl(url, bannerInvokeUrlInterface);
    }

    protected void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        this.layout();
    }
}

